#!/bin/bash

if [ "$1" == "listar" ]; then

if [ -f "/etc/init.d/WowzaMediaServer" ]; then
/etc/init.d/WowzaMediaServer stop
fi

if [ -f "/usr/sbin/nginx" ]; then
systemctl stop nginx
fi

ps aux | grep sc_serv | grep -v grep | cut -d / -f 8 | cut -d . -f 1 > /home/streaming/lista-ligar-sc.txt
ps aux | grep icecast | grep -v grep | cut -d / -f 9 | cut -d . -f 1 > /home/streaming/lista-ligar-ic.txt

fi

if [ "$1" == "reiniciar" ]; then

cd /etc/letsencrypt/archive

for dominio in `find . -maxdepth 1 -type d | awk -F"./" '{print $2}'`;
do

if [ -d "/etc/letsencrypt/archive/${dominio}" ]; then

cat /etc/letsencrypt/live/${dominio}/fullchain.pem /etc/letsencrypt/live/${dominio}/privkey.pem > /home/streaming/icecast/${dominio}.pem

fi

done

/bin/ps aux | /bin/grep 'sc_serv' | /bin/awk '{ print $2;}' | /usr/bin/xargs /bin/kill -9
/bin/ps aux | /bin/grep 'icecast' | grep -v certbot | /bin/awk '{ print $2;}' | /usr/bin/xargs /bin/kill -9

for porta_sc in `cat /home/streaming/lista-ligar-sc.txt`;
do

/home/streaming/sc_serv daemon /home/streaming/configs/${porta_sc}.conf

echo
echo "[ShoutCast] Ligando porta ${porta_sc}"

done

for porta_ic in `cat /home/streaming/lista-ligar-ic.txt`;
do

/home/streaming/icecast/icecast -b -c /home/streaming/configs/${porta_ic}.conf

echo
echo "[IceCast] Ligando porta ${porta_ic}"

done

rm -f /home/streaming/lista-ligar-sc.txt /home/streaming/lista-ligar-ic.txt

systemctl reload httpd

if [ -f "/etc/init.d/WowzaMediaServer" ]; then
/etc/init.d/WowzaMediaServer start
fi

if [ -f "/usr/sbin/nginx" ]; then
systemctl start nginx
fi

fi
