<?php
require_once("/home/painel/public_html/admin/inc/conecta.php");
require_once("/home/painel/public_html/admin/inc/classe.ssh.php");
require_once("/home/painel/public_html/admin/inc/funcoes.php");

$dados_config = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM configuracoes"));

parse_str($argv[1],$opcoes);

list($inicial,$final) = explode("-",$opcoes["registros"]);

$sql = mysqli_query($conexao,"SELECT * FROM streamings where status = '1' AND (relay = 'sim' AND relay_monitorar = 'sim') ORDER by porta ASC LIMIT ".$inicial.", ".$final."");
while ($dados_stm = mysqli_fetch_array($sql)) {

$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

// Verifica se foi configurado o IP e porta do streaming remoto
if(!empty($dados_stm["relay_ip"]) && !empty($dados_stm["relay_porta"])) {

// Verifica o status do relay, se esta ligado
if($dados_stm["tipo_servidor"] == "icecast") {
$status_conexao_transmissao = status_streaming_transmissao_icecast($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"]);
} else {
$status_conexao_transmissao = status_streaming_transmissao($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"]);
}

// Se relay no estiver ligado, ento reinicia o streaming
if($status_conexao_transmissao != "relay") {

// Conexo SSH
$ssh = new SSH();
$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

// Desliga o Streaming
$ssh->executar("/bin/kill -TERM `cat /home/streaming/configs/".$dados_stm["porta"].".pid`;echo OK");

$total_multipoint = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."'"));

if($dados_stm["tipo_servidor"] == "icecast") {

$servidor = dominio_servidor($conexao,$dados_servidor["nome"]);
$porta_dj_icecast = $dados_stm["porta"]+1;
$icecast_publico = ($dados_stm["publicserver"] == "always") ? 1 : 0;

$config_streaming .= "<icecast>\n";
$config_streaming .= "<location>Streaming</location>\n";
$config_streaming .= "<admin>no-reply@localhost</admin>\n";

$config_streaming .= "<limits>\n";
$config_streaming .= "<clients>".$dados_stm["ouvintes"]."</clients>\n";
$config_streaming .= "<sources>3</sources>\n";
$config_streaming .= "<threadpool>5</threadpool>\n";
$config_streaming .= "<queue-size>524288</queue-size>\n";
$config_streaming .= "<client-timeout>30</client-timeout>\n";
$config_streaming .= "<header-timeout>15</header-timeout>\n";
$config_streaming .= "<source-timeout>10</source-timeout>\n";
$config_streaming .= "<burst-on-connect>1</burst-on-connect>\n";
$config_streaming .= "<burst-size>65535</burst-size>\n";
$config_streaming .= "</limits>\n";

$config_streaming .= "<authentication>\n";
$config_streaming .= "<source-password>".$dados_stm["senha"]."</source-password>\n";
$config_streaming .= "<relay-password>".$dados_stm["senha"]."</relay-password>\n";
$config_streaming .= "<admin-user>admin</admin-user>\n";
$config_streaming .= "<admin-password>".$dados_stm["senha_admin"]."</admin-password>\n";
$config_streaming .= "</authentication>\n";

$config_streaming .= "<directory>\n";
$config_streaming .= "<yp-url-timeout>15</yp-url-timeout>\n";
$config_streaming .= "<yp-url>http://dir.xiph.org/cgi-bin/yp-cgi</yp-url>\n";
$config_streaming .= "</directory>\n";

$config_streaming .= "<hostname>".$servidor."</hostname>\n";
$config_streaming .= "<listen-socket>\n";
$config_streaming .= "<port>".$dados_stm["porta"]."</port>\n";
$config_streaming .= "<ssl>1</ssl>\n";
$config_streaming .= "</listen-socket>\n";
$config_streaming .= "<listen-socket>\n";
$config_streaming .= "<port>".$porta_dj_icecast."</port>\n";
$config_streaming .= "</listen-socket>\n";
$config_streaming .= "<bind-address>0.0.0.0</bind-address>\n";
$config_streaming .= "<fileserve>1</fileserve>\n";

if($total_multipoint > 0) {

$sql_multipoint = mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."' ORDER by id ASC");
while ($dados_ponto = mysqli_fetch_array($sql_multipoint)) {

$config_streaming_multipoint .= "streamid_".$dados_ponto["id"]."=".$dados_ponto["id"]."\n";
$config_streaming_multipoint .= "streampath_".$dados_ponto["id"]."=".$dados_ponto["ponto"]."\n";
$config_streaming_multipoint .= "streammaxuser_".$dados_ponto["id"]."=".$dados_ponto["ouvintes"]."\n\n";

$config_streaming .= "<mount>\n";
$config_streaming .= "<mount-name>".$dados_ponto["ponto"]."</mount-name>\n";
$config_streaming .= "<max-listeners>".$dados_ponto["ouvintes"]."</max-listeners>\n";
$config_streaming .= "<public>".$icecast_publico."</public>\n";
$config_streaming .= "</mount>\n";

}

} else {

$config_streaming .= "<mount>\n";
$config_streaming .= "<mount-name>/stream</mount-name>\n";
$config_streaming .= "<public>".$icecast_publico."</public>\n";
$config_streaming .= "</mount>\n";

}

$config_streaming .= "<paths>\n";
$config_streaming .= "<basedir>/home/streaming/</basedir>\n";
$config_streaming .= "<logdir>/home/streaming/logs</logdir>\n";
$config_streaming .= "<webroot>/home/streaming/icecast/web</webroot>\n";
$config_streaming .= "<adminroot>/home/streaming/icecast/admin</adminroot>\n";
$config_streaming .= "<pidfile>/home/streaming/configs/".$dados_stm["porta"].".pid</pidfile>\n";
$config_streaming .= "<deny-ip>/home/streaming/configs/".$dados_stm["porta"].".deny</deny-ip>\n";
$config_streaming .= "<alias source='/' dest='/status.xsl'></alias>\n";
$config_streaming .= "<ssl-certificate>/home/streaming/icecast/".strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"].".pem</ssl-certificate>\n";
$config_streaming .= "</paths>\n";

$relay_ponto = ($dados_stm["relay_ponto"]) ? $dados_stm["relay_ponto"] : "/stream";

$config_streaming .= "<relay>\n";
$config_streaming .= "<server>".$dados_stm["relay_ip"]."</server>\n";
$config_streaming .= "<port>".$dados_stm["relay_porta"]."</port>\n";
$config_streaming .= "<mount>".$relay_ponto."</mount>\n";
$config_streaming .= "</relay>\n";

$config_streaming .= "<logging>\n";
$config_streaming .= "<accesslog>log-".$dados_stm["porta"].".log</accesslog>\n";
$config_streaming .= "<errorlog>log-".$dados_stm["porta"].".log</errorlog>\n";
$config_streaming .= "<playlistlog>log-".$dados_stm["porta"].".log</playlistlog>\n";
$config_streaming .= "<loglevel>3</loglevel>\n";
$config_streaming .= "</logging>\n";

$config_streaming .= "<security>\n";
$config_streaming .= "<chroot>0</chroot>\n";
$config_streaming .= "<changeowner>\n";
$config_streaming .= "<user>streaming</user>\n";
$config_streaming .= "<group>streaming</group>\n";
$config_streaming .= "</changeowner>\n";
$config_streaming .= "</security>\n";
$config_streaming .= "</icecast>\n";

$config_streaming = gerar_conf_streaming($dados_stm["porta"],$config_streaming);

$ssh->enviar_arquivo("/home/painel/public_html/temp/".$config_streaming."","/home/streaming/configs/".$config_streaming."",0777);

unlink("/home/painel/public_html/temp/".$config_streaming."");

$ssh->executar("ulimit -n 300000;/home/streaming/icecast/icecast -b -c /home/streaming/configs/".$config_streaming." > /dev/null & echo $!");

echo "[".$dados_stm["porta"]."][IceCast][Relay] Streaming reiniciado.\n";

} else {

if($total_multipoint > 0) {

$sql_multipoint = mysqli_query($conexao,"SELECT * FROM multipoint where codigo_stm = '".$dados_stm["codigo"]."' ORDER by id ASC");
while ($dados_ponto = mysqli_fetch_array($sql_multipoint)) {

$config_streaming_multipoint .= "streamid_".$dados_ponto["id"]."=".$dados_ponto["id"]."\n";
$config_streaming_multipoint .= "streampath_".$dados_ponto["id"]."=".$dados_ponto["ponto"]."\n";
$config_streaming_multipoint .= "streammaxuser_".$dados_ponto["id"]."=".$dados_ponto["ouvintes"]."\n\n";

}
}

$senha_admin = ($dados_stm["senha_admin"]) ? $dados_stm["senha_admin"] : microtime();

$config_streaming = ";DADOS GERAIS\n";

if($total_multipoint == 0) {
$config_streaming .= "streamid=1\n";
}

$config_streaming .= "portbase=".$dados_stm["porta"]."\n";
$config_streaming .= "maxuser=".$dados_stm["ouvintes"]."\n";
$config_streaming .= "adminpassword=".$senha_admin."\n";
$config_streaming .= "password=".$dados_stm["senha"]."\n";
$config_streaming .= "srcip=any\n";
$config_streaming .= "destip=any\n";
$config_streaming .= "yport=80\n";
$config_streaming .= "namelookups=0\n";
$config_streaming .= "publicserver=".$dados_stm["publicserver"]."\n";
$config_streaming .= "allowrelay=".$dados_stm["allowrelay"]."\n";
$config_streaming .= "allowpublicrelay=1\n";
$config_streaming .= "metainterval=32768\n";
$config_streaming .= ";LOGS\n";
$config_streaming .= "logfile=/home/streaming/logs/log-".$dados_stm["porta"].".log\n";
$config_streaming .= "banfile=/home/streaming/configs/".$dados_stm["porta"].".ban\n";
$config_streaming .= "flashpolicyfile=/home/streaming/configs/crossdomain.xml\n";
$config_streaming .= "w3cenable=0\n";
$config_streaming .= "logclients=0\n";
$config_streaming .= "showlastsongs=".$dados_stm["showlastsongs"]."\n";
$config_streaming .= ";SSL\n";
$config_streaming .= "sslcertificatefile=/etc/letsencrypt/live/".strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"]."/fullchain.pem\n";
$config_streaming .= "sslcertificatekeyfile=/etc/letsencrypt/live/".strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"]."/privkey.pem\n";

$config_streaming .= ";RELAY\n";
$config_streaming .= "streamrelayurl=http://".$dados_stm["relay_ip"].":".$dados_stm["relay_porta"]."\n";
$config_streaming .= "relayreconnecttime=1\n";

if($total_multipoint > 0) {
$config_streaming .= "\n;MULTI POINT\n";
$config_streaming .= $config_streaming_multipoint;
}

$config_streaming = gerar_conf_streaming($dados_stm["porta"],$config_streaming);

$ssh->enviar_arquivo("/home/painel/public_html/temp/".$config_streaming."","/home/streaming/configs/".$config_streaming."",0777);

unlink("/home/painel/public_html/temp/".$config_streaming."");

$ssh->executar("ulimit -n 300000;/home/streaming/sc_serv daemon /home/streaming/configs/".$config_streaming." > /dev/null & echo $!");

echo "[".$dados_stm["porta"]."][ShoutCast][Relay] Streaming reiniciado.\n";

}

}

}

}
?>