/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.WMSTimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WMSFIFOWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WMSWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSCondVar;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSCondition;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

class WMSFIFOCondVar
extends WMSCondVar
implements WMSCondition,
Serializable {
    private static final WMSWaitQueue.QueuedSync sync = new WMSWaitQueue.QueuedSync(){

        public boolean recheck(WMSWaitQueue.WaitNode waitNode) {
            return false;
        }

        public void takeOver(WMSWaitQueue.WaitNode waitNode) {
        }
    };
    private final WMSWaitQueue wq = new WMSFIFOWaitQueue();

    WMSFIFOCondVar(WMSCondVar.ExclusiveLock exclusiveLock) {
        super(exclusiveLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitUninterruptibly() {
        int n;
        int n2 = this.lock.getHoldCount();
        if (n2 == 0) {
            throw new IllegalMonitorStateException();
        }
        WMSWaitQueue.WaitNode waitNode = new WMSWaitQueue.WaitNode();
        this.wq.insert(waitNode);
        for (n = n2; n > 0; --n) {
            this.lock.unlock();
        }
        try {
            waitNode.doWaitUninterruptibly(sync);
        }
        finally {
            for (n = n2; n > 0; --n) {
                this.lock.lock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        int n;
        int n2 = this.lock.getHoldCount();
        if (n2 == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WMSWaitQueue.WaitNode waitNode = new WMSWaitQueue.WaitNode();
        this.wq.insert(waitNode);
        for (n = n2; n > 0; --n) {
            this.lock.unlock();
        }
        try {
            waitNode.doWait(sync);
        }
        finally {
            for (n = n2; n > 0; --n) {
                this.lock.lock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long l, WMSTimeUnit wMSTimeUnit) throws InterruptedException {
        int n;
        int n2 = this.lock.getHoldCount();
        if (n2 == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long l2 = wMSTimeUnit.toNanos(l);
        WMSWaitQueue.WaitNode waitNode = new WMSWaitQueue.WaitNode();
        this.wq.insert(waitNode);
        boolean bl = false;
        for (n = n2; n > 0; --n) {
            this.lock.unlock();
        }
        try {
            bl = waitNode.doTimedWait(sync, l2);
        }
        finally {
            for (n = n2; n > 0; --n) {
                this.lock.lock();
            }
        }
        return bl;
    }

    public boolean awaitUntil(Date date) throws InterruptedException {
        if (date == null) {
            throw new NullPointerException();
        }
        long l = date.getTime();
        long l2 = System.currentTimeMillis();
        long l3 = l - l2;
        return this.await(l3, WMSTimeUnit.MILLISECONDS);
    }

    public void signal() {
        WMSWaitQueue.WaitNode waitNode;
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        do {
            if ((waitNode = this.wq.extract()) != null) continue;
            return;
        } while (!waitNode.signal(sync));
    }

    public void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        WMSWaitQueue.WaitNode waitNode;
        while ((waitNode = this.wq.extract()) != null) {
            waitNode.signal(sync);
        }
        return;
    }

    protected boolean hasWaiters() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.hasNodes();
    }

    protected int getWaitQueueLength() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.getLength();
    }

    protected Collection getWaitingThreads() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.getWaitingThreads();
    }
}

