/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.net.SocketAddress;
import java.util.ArrayList;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionRecycler;
import org.apache.mina.util.ExpirationListener;
import org.apache.mina.util.ExpiringMap;

public class ExpiringSessionRecycler
implements IoSessionRecycler {
    private ExpiringMap sessionMap;
    private ExpiringMap.Expirer mapExpirer;

    public ExpiringSessionRecycler() {
        this(60);
    }

    public ExpiringSessionRecycler(int n) {
        this(n, 1);
    }

    public ExpiringSessionRecycler(int n, int n2) {
        this.sessionMap = new ExpiringMap(n, n2);
        this.mapExpirer = this.sessionMap.getExpirer();
        this.sessionMap.addExpirationListener(new DefaultExpirationListener());
    }

    public void put(IoSession ioSession) {
        this.mapExpirer.startExpiringIfNotStarted();
        Object object = this.generateKey(ioSession);
        if (!this.sessionMap.containsKey(object)) {
            this.sessionMap.put(object, ioSession);
        }
    }

    public IoSession recycle(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return (IoSession)this.sessionMap.get(this.generateKey(socketAddress, socketAddress2));
    }

    public void remove(IoSession ioSession) {
        this.sessionMap.remove(this.generateKey(ioSession));
    }

    public void stopExpiring() {
        this.mapExpirer.stopExpiring();
    }

    public int getExpirationInterval() {
        return this.sessionMap.getExpirationInterval();
    }

    public int getTimeToLive() {
        return this.sessionMap.getTimeToLive();
    }

    public void setExpirationInterval(int n) {
        this.sessionMap.setExpirationInterval(n);
    }

    public void setTimeToLive(int n) {
        this.sessionMap.setTimeToLive(n);
    }

    private Object generateKey(IoSession ioSession) {
        return this.generateKey(ioSession.getLocalAddress(), ioSession.getRemoteAddress());
    }

    private Object generateKey(SocketAddress socketAddress, SocketAddress socketAddress2) {
        ArrayList<SocketAddress> arrayList = new ArrayList<SocketAddress>(2);
        arrayList.add(socketAddress2);
        arrayList.add(socketAddress);
        return arrayList;
    }

    private class DefaultExpirationListener
    implements ExpirationListener {
        private DefaultExpirationListener() {
        }

        public void expired(Object object) {
            IoSession ioSession = (IoSession)object;
            ioSession.close();
        }
    }
}

