/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

public class TrafficMask {
    public static final TrafficMask NONE = new TrafficMask(0, "none");
    public static final TrafficMask READ = new TrafficMask(1, "read");
    public static final TrafficMask WRITE = new TrafficMask(4, "write");
    public static final TrafficMask ALL = new TrafficMask(5, "all");
    private final int interestOps;
    private final String name;

    public static TrafficMask getInstance(int n) {
        boolean bl;
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = bl = (n & 4) != 0;
        if (bl2) {
            if (bl) {
                return ALL;
            }
            return READ;
        }
        if (bl) {
            return WRITE;
        }
        return NONE;
    }

    private TrafficMask(int n, String string) {
        this.interestOps = n;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return (this.interestOps & 1) != 0;
    }

    public boolean isWritable() {
        return (this.interestOps & 4) != 0;
    }

    public int getInterestOps() {
        return this.interestOps;
    }

    public TrafficMask and(TrafficMask trafficMask) {
        return TrafficMask.getInstance(this.interestOps & trafficMask.interestOps);
    }

    public TrafficMask or(TrafficMask trafficMask) {
        return TrafficMask.getInstance(this.interestOps | trafficMask.interestOps);
    }

    public TrafficMask not() {
        return TrafficMask.getInstance(~this.interestOps);
    }

    public TrafficMask xor(TrafficMask trafficMask) {
        return TrafficMask.getInstance(this.interestOps ^ trafficMask.interestOps);
    }

    public String toString() {
        return this.name;
    }
}

