/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.lang.reflect.Method;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.ExecutorThreadModel;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.ThreadModel;

public abstract class BaseIoServiceConfig
implements IoServiceConfig,
Cloneable {
    public static String threadModelName = "AnonymousIoService";
    private IoFilterChainBuilder filterChainBuilder = new DefaultIoFilterChainBuilder();
    private ThreadModel defaultThreadModel = null;
    private ThreadModel threadModel = this.defaultThreadModel = ExecutorThreadModel.getInstance(threadModelName);

    public IoFilterChainBuilder getFilterChainBuilder() {
        return this.filterChainBuilder;
    }

    public void setFilterChainBuilder(IoFilterChainBuilder ioFilterChainBuilder) {
        if (ioFilterChainBuilder == null) {
            ioFilterChainBuilder = new DefaultIoFilterChainBuilder();
        }
        this.filterChainBuilder = ioFilterChainBuilder;
    }

    public DefaultIoFilterChainBuilder getFilterChain() {
        if (this.filterChainBuilder instanceof DefaultIoFilterChainBuilder) {
            return (DefaultIoFilterChainBuilder)this.filterChainBuilder;
        }
        throw new IllegalStateException("Current filter chain builder is not a DefaultIoFilterChainBuilder.");
    }

    public ThreadModel getThreadModel() {
        return this.threadModel;
    }

    public void setThreadModel(ThreadModel threadModel) {
        if (threadModel == null) {
            threadModel = this.defaultThreadModel;
        }
        this.threadModel = threadModel;
    }

    public Object clone() {
        BaseIoServiceConfig baseIoServiceConfig;
        try {
            baseIoServiceConfig = (BaseIoServiceConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (InternalError)new InternalError().initCause(cloneNotSupportedException);
        }
        try {
            Method method = this.filterChainBuilder.getClass().getMethod("clone", null);
            if (method.isAccessible()) {
                baseIoServiceConfig.filterChainBuilder = (IoFilterChainBuilder)method.invoke((Object)this.filterChainBuilder, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baseIoServiceConfig;
    }
}

