/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.SessionLog;

public class BlacklistFilter
extends IoFilterAdapter {
    private final Set blacklist = new HashSet();

    public void setBlacklist(InetAddress[] inetAddressArray) {
        if (inetAddressArray == null) {
            throw new NullPointerException("addresses");
        }
        this.blacklist.clear();
        for (int i = 0; i < inetAddressArray.length; ++i) {
            InetAddress inetAddress = inetAddressArray[i];
            this.block(inetAddress, "addresses[" + i + ']');
        }
    }

    public void setBlacklist(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("addresses");
        }
        InetAddress[] inetAddressArray = new InetAddress[collection.size()];
        try {
            this.setBlacklist(collection.toArray(inetAddressArray));
        }
        catch (ArrayStoreException arrayStoreException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Collection of addresses must contain only InetAddress instances.");
            illegalArgumentException.initCause(arrayStoreException);
            throw illegalArgumentException;
        }
    }

    public synchronized void block(InetAddress inetAddress, String string) {
        if (inetAddress == null) {
            throw new NullPointerException(string);
        }
        this.blacklist.add(inetAddress);
    }

    public synchronized void block(InetAddress inetAddress) {
        this.block(inetAddress, "address");
    }

    public synchronized void unblock(InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new NullPointerException("address");
        }
        this.blacklist.remove(inetAddress);
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession ioSession) {
        if (!this.isBlocked(ioSession)) {
            nextFilter.sessionCreated(ioSession);
        } else {
            this.blockSession(ioSession);
        }
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        if (!this.isBlocked(ioSession)) {
            nextFilter.sessionOpened(ioSession);
        } else {
            this.blockSession(ioSession);
        }
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession ioSession) throws Exception {
        if (!this.isBlocked(ioSession)) {
            nextFilter.sessionClosed(ioSession);
        } else {
            this.blockSession(ioSession);
        }
    }

    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession ioSession, IdleStatus idleStatus) throws Exception {
        if (!this.isBlocked(ioSession)) {
            nextFilter.sessionIdle(ioSession, idleStatus);
        } else {
            this.blockSession(ioSession);
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) {
        if (!this.isBlocked(ioSession)) {
            nextFilter.messageReceived(ioSession, object);
        } else {
            this.blockSession(ioSession);
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession ioSession, Object object) throws Exception {
        if (!this.isBlocked(ioSession)) {
            nextFilter.messageSent(ioSession, object);
        } else {
            this.blockSession(ioSession);
        }
    }

    private void blockSession(IoSession ioSession) {
        SessionLog.info(ioSession, "Remote address in the blacklist; closing.");
        ioSession.close();
    }

    private boolean isBlocked(IoSession ioSession) {
        SocketAddress socketAddress = ioSession.getRemoteAddress();
        return socketAddress instanceof InetSocketAddress && this.blacklist.contains(((InetSocketAddress)socketAddress).getAddress());
    }
}

