/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public class AvailablePortFinder {
    public static final int MIN_PORT_NUMBER = 1;
    public static final int MAX_PORT_NUMBER = 49151;

    private AvailablePortFinder() {
    }

    public static Set getAvailablePorts() {
        return AvailablePortFinder.getAvailablePorts(1, 49151);
    }

    public static int getNextAvailable() {
        return AvailablePortFinder.getNextAvailable(1);
    }

    public static int getNextAvailable(int n) {
        if (n < 1 || n > 49151) {
            throw new IllegalArgumentException("Invalid start port: " + n);
        }
        for (int i = n; i <= 49151; ++i) {
            if (!AvailablePortFinder.available(i)) continue;
            return i;
        }
        throw new NoSuchElementException("Could not find an available port above " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int n) {
        if (n < 1 || n > 49151) {
            throw new IllegalArgumentException("Invalid start port: " + n);
        }
        ServerSocket serverSocket = null;
        DatagramSocket datagramSocket = null;
        try {
            serverSocket = new ServerSocket(n);
            serverSocket.setReuseAddress(true);
            datagramSocket = new DatagramSocket(n);
            datagramSocket.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAvailablePorts(int n, int n2) {
        if (n < 1 || n2 > 49151 || n > n2) {
            throw new IllegalArgumentException("Invalid port range: " + n + " ~ " + n2);
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = n; i <= n2; ++i) {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(i);
                treeSet.add(new Integer(i));
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            finally {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return treeSet;
    }
}

