/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;

public class CategoryNodeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -6046702673278595048L;
    public static final Color FATAL_CHILDREN = new Color(189, 113, 0);
    protected JCheckBox _checkBox = new JCheckBox();
    protected JPanel _panel = new JPanel();
    protected static ImageIcon _sat = null;

    public CategoryNodeRenderer() {
        this._panel.setBackground(UIManager.getColor("Tree.textBackground"));
        if (_sat == null) {
            String string = "/org/apache/log4j/lf5/viewer/images/channelexplorer_satellite.gif";
            URL uRL = this.getClass().getResource(string);
            _sat = new ImageIcon(uRL);
        }
        this.setOpaque(false);
        this._checkBox.setOpaque(false);
        this._panel.setOpaque(false);
        this._panel.setLayout(new FlowLayout(0, 0, 0));
        this._panel.add(this._checkBox);
        this._panel.add(this);
        this.setOpenIcon(_sat);
        this.setClosedIcon(_sat);
        this.setLeafIcon(_sat);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        CategoryNode categoryNode = (CategoryNode)object;
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (n == 0) {
            this._checkBox.setVisible(false);
        } else {
            this._checkBox.setVisible(true);
            this._checkBox.setSelected(categoryNode.isSelected());
        }
        String string = this.buildToolTip(categoryNode);
        this._panel.setToolTipText(string);
        if (categoryNode.hasFatalChildren()) {
            this.setForeground(FATAL_CHILDREN);
        }
        if (categoryNode.hasFatalRecords()) {
            this.setForeground(Color.red);
        }
        return this._panel;
    }

    public Dimension getCheckBoxOffset() {
        return new Dimension(0, 0);
    }

    protected String buildToolTip(CategoryNode categoryNode) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(categoryNode.getTitle()).append(" contains a total of ");
        stringBuffer.append(categoryNode.getTotalNumberOfRecords());
        stringBuffer.append(" LogRecords.");
        stringBuffer.append(" Right-click for more info.");
        return stringBuffer.toString();
    }
}

