/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.util.SystemUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.authentication.IAuthenticateUsernamePasswordProvider;
import com.wowza.wms.authentication.file.AuthenticationPasswordFiles;
import com.wowza.wms.client.IClient;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.util.AuthenticationUtils;
import com.wowza.wms.vhost.IVHost;
import java.io.File;
import java.util.HashMap;

public class ModuleOnConnectAuthenticate
extends ModuleBase {
    public static final String AUTHPASSWORDFILEPATH = "${com.wowza.wms.context.VHostConfigHome}/conf/connect.password";
    private File passwordFile = null;
    private String usernamePasswordProviderClass = null;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        ModuleOnConnectAuthenticate.getLogger().info("ModuleOnConnectAuthenticate started");
        WMSProperties wMSProperties = iApplicationInstance.getProperties();
        String string = wMSProperties.getPropertyStr("rtmpAuthenticateFile", AUTHPASSWORDFILEPATH);
        this.usernamePasswordProviderClass = wMSProperties.getPropertyStr("usernamePasswordProviderClass", this.usernamePasswordProviderClass);
        if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            IVHost iVHost = iApplicationInstance.getVHost();
            hashMap.put("com.wowza.wms.context.VHost", iVHost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iVHost.getHomePath());
            hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
            hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
            string = SystemUtils.expandEnvironmentVariables((String)string, hashMap);
            this.passwordFile = new File(string);
        }
        if (this.passwordFile != null) {
            ModuleOnConnectAuthenticate.getLogger().info("ModuleOnConnectAuthenticate: Authorization password file: " + this.passwordFile.getAbsolutePath());
        }
        if (this.usernamePasswordProviderClass != null) {
            ModuleOnConnectAuthenticate.getLogger().info("ModuleOnConnectAuthenticate: Authorization password class: " + this.usernamePasswordProviderClass);
        }
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = false;
        String string = iClient.getFlashVer();
        ModuleOnConnectAuthenticate.getLogger().info("Flashver: " + string);
        try {
            String string2 = iClient.getAppInstance().getProperties().getPropertyStr("AllowEncoder");
            Boolean bl2 = string.startsWith(string2);
            if (bl2.booleanValue()) {
                iClient.acceptConnection();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = null;
        String string4 = null;
        try {
            if (aMFDataList.size() > 4) {
                string3 = aMFDataList.getString(3);
                string4 = aMFDataList.getString(4);
                if (string3 != null && string4 != null) {
                    IAuthenticateUsernamePasswordProvider iAuthenticateUsernamePasswordProvider = null;
                    if (this.usernamePasswordProviderClass != null) {
                        iAuthenticateUsernamePasswordProvider = AuthenticationUtils.createUsernamePasswordProvider((String)this.usernamePasswordProviderClass);
                    } else if (this.passwordFile != null) {
                        iAuthenticateUsernamePasswordProvider = AuthenticationPasswordFiles.getInstance().getPasswordFile(this.passwordFile);
                    }
                    if (iAuthenticateUsernamePasswordProvider != null) {
                        iAuthenticateUsernamePasswordProvider.setClient(iClient);
                        String string5 = iAuthenticateUsernamePasswordProvider.getPassword(string3);
                        if (string5 != null && string5.equals(string4)) {
                            bl = true;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            ModuleOnConnectAuthenticate.getLogger().error("ModuleOnConnectAuthenticate.onConnect: " + exception.toString());
            bl = false;
        }
        ModuleOnConnectAuthenticate.getLogger().info("ModuleOnConnectAuthenticate Authenticated: " + bl);
        if (!bl) {
            iClient.rejectConnection("Authentication Failed[" + iClient.getClientId() + "]: " + string3);
        } else {
            iClient.acceptConnection();
        }
    }
}

