/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;

public class ModuleOverridePlayBlackListIP
extends ModuleBase {
    private String[] ipList = null;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.ipList = iApplicationInstance.getProperties().getPropertyStr("IpList").toLowerCase().split(",");
    }

    public void play(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleOverridePlayBlackListIP.getLogger().info("Overriding Play");
        boolean bl = false;
        try {
            String string = iClient.getIp();
            for (int i = 0; i < this.ipList.length; ++i) {
                if (!string.equalsIgnoreCase(this.ipList[i].trim())) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            ModuleOverridePlayBlackListIP.getLogger().info("Client Rejected. IP: " + iClient.getIp());
            ModuleOverridePlayBlackListIP.sendClientOnStatusError((IClient)iClient, (String)"NetStream.Play.Failed", (String)"The client IP was rejected");
        } else {
            ModuleCore.play((IClient)iClient, (RequestFunction)requestFunction, (AMFDataList)aMFDataList);
        }
    }

    public void onHTTPSessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        boolean bl = true;
        String string = iHTTPStreamerSession.getIpAddress();
        boolean bl2 = false;
        try {
            for (int i = 0; i < this.ipList.length; ++i) {
                if (!string.equalsIgnoreCase(this.ipList[i].trim())) continue;
                bl2 = true;
                break;
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (bl2) {
            iHTTPStreamerSession.rejectSession();
            ModuleOverridePlayBlackListIP.getLogger().info("HTTP Client Rejected. IP: " + string);
        }
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        boolean bl = true;
        String string = rTPSession.getIp();
        boolean bl2 = false;
        try {
            for (int i = 0; i < this.ipList.length; ++i) {
                if (!string.equalsIgnoreCase(this.ipList[i].trim())) continue;
                bl2 = true;
                break;
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (bl2) {
            rTPSession.rejectSession();
            ModuleOverridePlayBlackListIP.getLogger().info("RTSP Client Rejected. IP: " + string);
        }
    }
}

