/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.model.HTTPStreamerSessionBase;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerApplicationContext;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.smoothstreaming.file.HTTPStreamerSmoothStreamerIndexFile;
import com.wowza.wms.httpstreamer.smoothstreaming.file.HTTPStreamerSmoothStreamerIndexPlaylist;
import com.wowza.wms.httpstreamer.smoothstreaming.file.IHTTPStreamerSmoothStreamerIndex;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.SmoothStreamerFragmentId;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingLivePlaylist;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HTTPStreamerSessionSmoothStreamer
extends HTTPStreamerSessionBase {
    private Map<String, IHTTPStreamerSmoothStreamerIndex> indexes = new HashMap<String, IHTTPStreamerSmoothStreamerIndex>();
    private SmoothStreamingLivePlaylist livePlaylist = null;

    public HTTPStreamerSessionSmoothStreamer() {
        this.connectionHolder.setConnectionType(3);
        this.setSessionProtocol(0);
        this.setSessionTimeout(50000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllIndexes() {
        ArrayList<IHTTPStreamerSmoothStreamerIndex> arrayList = new ArrayList<IHTTPStreamerSmoothStreamerIndex>();
        Map<String, IHTTPStreamerSmoothStreamerIndex> map = this.indexes;
        synchronized (map) {
            arrayList.addAll(this.indexes.values());
            this.indexes.clear();
        }
        for (IHTTPStreamerSmoothStreamerIndex iHTTPStreamerSmoothStreamerIndex : arrayList) {
            iHTTPStreamerSmoothStreamerIndex.close();
        }
    }

    public void shutdown() {
        this.closeAllIndexes();
        super.shutdown();
        if (this.isValidated()) {
            this.updateLoggingValues();
            WMSLoggerFactory.getLoggerObj((IApplicationInstance)this.getAppInstance()).info(null, null, "smoothstreaming", "disconnect", 200, this.getSessionId());
            this.clearLoggingValues();
        }
    }

    public boolean containsIndex(String string) {
        return this.indexes.containsKey(string);
    }

    public IHTTPStreamerSmoothStreamerIndex getIndex(IHTTPStreamerSession iHTTPStreamerSession, IHTTPStreamerApplicationContext iHTTPStreamerApplicationContext, String string, String string2) {
        IApplicationInstance iApplicationInstance = iHTTPStreamerApplicationContext.getAppInstance();
        IHTTPStreamerSmoothStreamerIndex iHTTPStreamerSmoothStreamerIndex = null;
        iHTTPStreamerSmoothStreamerIndex = this.indexes.get(string2);
        if (iHTTPStreamerSmoothStreamerIndex == null) {
            boolean bl = false;
            try {
                iHTTPStreamerSmoothStreamerIndex = string.toLowerCase().equals("smil") ? new HTTPStreamerSmoothStreamerIndexPlaylist() : new HTTPStreamerSmoothStreamerIndexFile();
                iHTTPStreamerSmoothStreamerIndex.init(iHTTPStreamerSession, iHTTPStreamerApplicationContext, string, string2);
                iHTTPStreamerSmoothStreamerIndex.open();
                iHTTPStreamerSmoothStreamerIndex.indexFile();
                this.indexes.put(string2, iHTTPStreamerSmoothStreamerIndex);
                bl = true;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerSessionSmoothStreamer.class).warn("HTTPStreamerSessionSmoothStreamer.getIndex: " + exception.toString());
                exception.printStackTrace();
            }
            if (!bl) {
                try {
                    if (iHTTPStreamerSmoothStreamerIndex != null) {
                        iHTTPStreamerSmoothStreamerIndex.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iHTTPStreamerSmoothStreamerIndex = null;
            }
        }
        return iHTTPStreamerSmoothStreamerIndex;
    }

    public void updateLoggingValues() {
        super.updateLoggingValues();
        WMSLoggerFactory.putGlobalLogValue((String)"c-proto", (Object)"http (smooth)");
    }

    public void clearLoggingValues() {
        super.clearLoggingValues();
    }

    public SmoothStreamingLivePlaylist getLivePlaylist() {
        return this.livePlaylist;
    }

    public void setLivePlaylist(SmoothStreamingLivePlaylist smoothStreamingLivePlaylist) {
        this.livePlaylist = smoothStreamingLivePlaylist;
    }

    public void logLiveFragment(SmoothStreamerFragmentId smoothStreamerFragmentId, RTPPacketFragmentList rTPPacketFragmentList) {
        if (rTPPacketFragmentList != null) {
            // empty if block
        }
    }

    public void logVODFragment(SmoothStreamerFragmentId smoothStreamerFragmentId, RTPPacketFragmentList rTPPacketFragmentList) {
        if (rTPPacketFragmentList != null) {
            // empty if block
        }
    }
}

