/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.drm.playready.PlayReadyKeyInfo;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentHeader;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoAudio;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoVideo;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaPacket;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingRepeaterHolderSerialized;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.List;

public class SmoothStreamingRepeaterHolder {
    public static final int REPEATER_STARTFRAGMENT = 1;
    public static final int REPEATER_ADDFRAGMENTMEDIAPACKET = 2;
    public static final int REPEATER_SETFRAGMENTHEADER = 3;
    public static final int REPEATER_ENDFRAGMENT = 4;
    public static final int REPEATER_CLEARFRAGMENT = 5;
    public static final int REPEATER_PLAYREADYKEYINFO = 6;
    public static final int REPEATER_MSG = 100;
    private int type = 0;
    private int repeaterType = 0;
    private long sequence = -1L;
    private long fragmentId = -1L;
    private long startTime = 0L;
    private String repeaterMessage = null;
    private long endTime = 0L;
    private SmoothStreamingMediaPacket mediaPacket = null;
    private SmoothStreamingMediaInfoAudio mediaInfoAudio = null;
    private SmoothStreamingMediaInfoVideo mediaInfoVideo = null;
    private SmoothStreamingFragmentHeader fragmentHeader = null;
    private PlayReadyKeyInfo playReadyKeyInfo = null;

    public static SmoothStreamingRepeaterHolder createRepeaterMessage(String string) {
        SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
        smoothStreamingRepeaterHolder.setRepeaterType(100);
        smoothStreamingRepeaterHolder.setRepeaterMessage(string);
        return smoothStreamingRepeaterHolder;
    }

    public static SmoothStreamingRepeaterHolder deserialize(byte[] byArray, int n, int n2) {
        SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder;
        block19: {
            smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
            try {
                if (n2 < 4) break block19;
                int n3 = 0;
                int n4 = BufferUtils.byteArrayToInt((byte[])byArray, (int)(n + n3), (int)4);
                if (n4 > n2 - (n3 += 4)) {
                    WMSLoggerFactory.getLogger(SmoothStreamingRepeaterHolder.class).error("SmoothStreamingRepeaterHolder.deserialize: Bad header size: " + n4 + ":" + n2);
                    break block19;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n + n3, n4);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                n3 += n4;
                byte by = dataInputStream.readByte();
                smoothStreamingRepeaterHolder.type = dataInputStream.readByte();
                smoothStreamingRepeaterHolder.repeaterType = dataInputStream.readByte();
                smoothStreamingRepeaterHolder.sequence = dataInputStream.readLong();
                smoothStreamingRepeaterHolder.fragmentId = dataInputStream.readLong();
                smoothStreamingRepeaterHolder.startTime = dataInputStream.readLong();
                switch (smoothStreamingRepeaterHolder.repeaterType) {
                    case 5: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        smoothStreamingRepeaterHolder.mediaPacket = new SmoothStreamingMediaPacket();
                        smoothStreamingRepeaterHolder.mediaPacket.setTimecode(dataInputStream.readLong());
                        smoothStreamingRepeaterHolder.mediaPacket.setFrameType(dataInputStream.readByte());
                        smoothStreamingRepeaterHolder.mediaPacket.setType(dataInputStream.readByte());
                        smoothStreamingRepeaterHolder.mediaPacket.getFragmentList().addPacketFragment(new RTPPacketFragment(byArray, n + n3, n2 - n3));
                        break;
                    }
                    case 3: {
                        short s;
                        short s2 = dataInputStream.readShort();
                        if (s2 > 0) {
                            byte[] byArray2 = new byte[s2];
                            dataInputStream.read(byArray2);
                            smoothStreamingRepeaterHolder.mediaInfoAudio = SmoothStreamingMediaInfoAudio.deserialize(byArray2, 0, byArray2.length);
                        }
                        if ((s = dataInputStream.readShort()) > 0) {
                            byte[] byArray3 = new byte[s];
                            dataInputStream.read(byArray3);
                            smoothStreamingRepeaterHolder.mediaInfoVideo = SmoothStreamingMediaInfoVideo.deserialize(byArray3, 0, byArray3.length);
                        }
                        smoothStreamingRepeaterHolder.fragmentHeader = new SmoothStreamingFragmentHeader();
                        smoothStreamingRepeaterHolder.fragmentHeader.setHeaderData(new RTPPacketFragment(byArray, n + n3, n2 - n3));
                        break;
                    }
                    case 4: {
                        smoothStreamingRepeaterHolder.endTime = dataInputStream.readLong();
                        break;
                    }
                    case 100: {
                        smoothStreamingRepeaterHolder.repeaterMessage = dataInputStream.readUTF();
                        break;
                    }
                    case 6: {
                        String string = null;
                        byte[] byArray4 = null;
                        byte[] byArray5 = null;
                        try {
                            short s;
                            short s3;
                            string = dataInputStream.readUTF();
                            if (string != null && string.length() <= 0) {
                                string = null;
                            }
                            if ((s3 = dataInputStream.readShort()) > 0) {
                                byArray4 = new byte[s3];
                                dataInputStream.read(byArray4);
                            }
                            if ((s = dataInputStream.readShort()) > 0) {
                                byArray5 = new byte[s];
                                dataInputStream.read(byArray5);
                            }
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(SmoothStreamingRepeaterHolder.class).error("SmoothStreamingRepeaterHolder.serialize.playReadyKeyInfo: " + exception.toString());
                        }
                        smoothStreamingRepeaterHolder.playReadyKeyInfo = new PlayReadyKeyInfo();
                        smoothStreamingRepeaterHolder.playReadyKeyInfo.setLicenseURL(string);
                        smoothStreamingRepeaterHolder.playReadyKeyInfo.setKeyId(byArray4);
                        smoothStreamingRepeaterHolder.playReadyKeyInfo.setChecksum(byArray5);
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(SmoothStreamingRepeaterHolder.class).error("SmoothStreamingRepeaterHolder.serialize: " + exception.toString());
            }
        }
        return smoothStreamingRepeaterHolder;
    }

    public SmoothStreamingRepeaterHolderSerialized serialize() {
        SmoothStreamingRepeaterHolderSerialized smoothStreamingRepeaterHolderSerialized = new SmoothStreamingRepeaterHolderSerialized();
        smoothStreamingRepeaterHolderSerialized.timecode = this.getTimecode();
        smoothStreamingRepeaterHolderSerialized.type = 9;
        try {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeByte(this.type);
            dataOutputStream.writeByte(this.repeaterType);
            dataOutputStream.writeLong(this.sequence);
            dataOutputStream.writeLong(this.fragmentId);
            dataOutputStream.writeLong(this.startTime);
            switch (this.repeaterType) {
                case 5: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    dataOutputStream.writeLong(this.mediaPacket.getTimecode());
                    dataOutputStream.writeByte(this.mediaPacket.getFrameType());
                    dataOutputStream.writeByte(this.mediaPacket.getType());
                    object = this.mediaPacket.getFragmentList();
                    List list = object.getFragments();
                    if (list.size() == 1) {
                        RTPPacketFragment rTPPacketFragment = (RTPPacketFragment)list.get(0);
                        smoothStreamingRepeaterHolderSerialized.data = rTPPacketFragment.getBuffer();
                        smoothStreamingRepeaterHolderSerialized.doffset = rTPPacketFragment.getOffset();
                        smoothStreamingRepeaterHolderSerialized.dlen = rTPPacketFragment.getLen();
                        break;
                    }
                    if (list.size() <= 1) break;
                    int n = object.size();
                    byte[] byArray = new byte[n];
                    int n2 = 0;
                    for (RTPPacketFragment rTPPacketFragment : list) {
                        System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, n2, rTPPacketFragment.getLen());
                        n2 += rTPPacketFragment.getLen();
                    }
                    smoothStreamingRepeaterHolderSerialized.data = byArray;
                    smoothStreamingRepeaterHolderSerialized.doffset = 0;
                    smoothStreamingRepeaterHolderSerialized.dlen = byArray.length;
                    break;
                }
                case 3: {
                    byte[] byArray = null;
                    byte[] byArray2 = null;
                    if (this.mediaInfoAudio != null) {
                        byArray = this.mediaInfoAudio.serialize();
                    }
                    if (this.mediaInfoVideo != null) {
                        byArray2 = this.mediaInfoVideo.serialize();
                    }
                    if (byArray != null) {
                        dataOutputStream.writeShort(byArray.length);
                        dataOutputStream.write(byArray);
                    } else {
                        dataOutputStream.writeShort(0);
                    }
                    if (byArray2 != null) {
                        dataOutputStream.writeShort(byArray2.length);
                        dataOutputStream.write(byArray2);
                    } else {
                        dataOutputStream.writeShort(0);
                    }
                    RTPPacketFragment rTPPacketFragment = this.fragmentHeader.getHeaderData();
                    if (rTPPacketFragment.getLen() <= 0) break;
                    smoothStreamingRepeaterHolderSerialized.data = rTPPacketFragment.getBuffer();
                    smoothStreamingRepeaterHolderSerialized.doffset = rTPPacketFragment.getOffset();
                    smoothStreamingRepeaterHolderSerialized.dlen = rTPPacketFragment.getLen();
                    break;
                }
                case 4: {
                    dataOutputStream.writeLong(this.endTime);
                    break;
                }
                case 100: {
                    dataOutputStream.writeUTF(this.repeaterMessage);
                    break;
                }
                case 6: {
                    String string = null;
                    byte[] byArray = null;
                    byte[] byArray3 = null;
                    if (this.playReadyKeyInfo != null) {
                        string = this.playReadyKeyInfo.getLicenseURL();
                        byArray = this.playReadyKeyInfo.getKeyId();
                        byArray3 = this.playReadyKeyInfo.getChecksum();
                    }
                    if (string == null) {
                        string = "";
                    }
                    dataOutputStream.writeUTF(string);
                    if (byArray != null) {
                        dataOutputStream.writeShort(byArray.length);
                        dataOutputStream.write(byArray);
                    } else {
                        dataOutputStream.writeShort(0);
                    }
                    if (byArray3 != null) {
                        dataOutputStream.writeShort(byArray3.length);
                        dataOutputStream.write(byArray3);
                        break;
                    }
                    dataOutputStream.writeShort(0);
                }
            }
            object = byteArrayOutputStream.toByteArray();
            int n = ((byte[])object).length;
            BufferUtils.intToByteArray((int)(n - 4), (byte[])object, (int)0, (int)4);
            smoothStreamingRepeaterHolderSerialized.header = object;
            smoothStreamingRepeaterHolderSerialized.hoffset = 0;
            smoothStreamingRepeaterHolderSerialized.hlen = n;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SmoothStreamingRepeaterHolder.class).error("SmoothStreamingRepeaterHolder.serialize: " + exception.toString());
            exception.printStackTrace();
        }
        return smoothStreamingRepeaterHolderSerialized;
    }

    public int getRepeaterType() {
        return this.repeaterType;
    }

    public void setRepeaterType(int n) {
        this.repeaterType = n;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public long getTimecode() {
        return this.startTime / 10000L;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public SmoothStreamingMediaPacket getMediaPacket() {
        return this.mediaPacket;
    }

    public void setMediaPacket(SmoothStreamingMediaPacket smoothStreamingMediaPacket) {
        this.mediaPacket = smoothStreamingMediaPacket;
    }

    public SmoothStreamingMediaInfoAudio getMediaInfoAudio() {
        return this.mediaInfoAudio;
    }

    public void setMediaInfoAudio(SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio) {
        this.mediaInfoAudio = smoothStreamingMediaInfoAudio;
    }

    public SmoothStreamingMediaInfoVideo getMediaInfoVideo() {
        return this.mediaInfoVideo;
    }

    public void setMediaInfoVideo(SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo) {
        this.mediaInfoVideo = smoothStreamingMediaInfoVideo;
    }

    public SmoothStreamingFragmentHeader getFragmentHeader() {
        return this.fragmentHeader;
    }

    public void setFragmentHeader(SmoothStreamingFragmentHeader smoothStreamingFragmentHeader) {
        this.fragmentHeader = smoothStreamingFragmentHeader;
    }

    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long l) {
        this.sequence = l;
    }

    public long getFragmentId() {
        return this.fragmentId;
    }

    public void setFragmentId(long l) {
        this.fragmentId = l;
    }

    public String getRepeaterMessage() {
        return this.repeaterMessage;
    }

    public void setRepeaterMessage(String string) {
        this.repeaterMessage = string;
    }

    public PlayReadyKeyInfo getPlayReadyKeyInfo() {
        return this.playReadyKeyInfo;
    }

    public void setPlayReadyKeyInfo(PlayReadyKeyInfo playReadyKeyInfo) {
        this.playReadyKeyInfo = playReadyKeyInfo;
    }
}

