/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediareader.flv;

import com.wowza.io.IRandomAccessReader;
import com.wowza.io.IRandomAccessWriter;
import com.wowza.io.RandomAccessReaderFactory;
import com.wowza.io.ScheduledRandomAccessReaderWrapper;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.util.IFasterByteArrayWriteControl;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.flv.FLVStreamPosition;
import com.wowza.wms.mediareader.flv.MediaReaderFLVNodeData;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.FastPlaySettings;
import com.wowza.wms.stream.IMediaIndexItem;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderStreamPosition;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaIndexCacheSingleton;
import com.wowza.wms.stream.MediaReaderItem;
import com.wowza.wms.stream.PlaylistSeekResult;
import com.wowza.wms.stream.file.MediaStreamIndex;
import com.wowza.wms.stream.file.PlaylistCursor;
import com.wowza.wms.stream.file.PlaylistReaderWriteResults;
import com.wowza.wms.stream.file.PlaylistWriteControl;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaReaderFLV
implements IMediaReader {
    protected static final int HEADER_TYPE = 0;
    protected static final int HEADER_SIZE = 1;
    protected static final int HEADER_TC = 2;
    protected static final int SEEK_KEYFRAMEMAX = 10000;
    protected IRandomAccessReader fileStream = null;
    protected ScheduledRandomAccessReaderWrapper fileReader = null;
    protected List metaData = null;
    protected int metaDataSize = 0;
    protected MediaReaderFLVNodeData nodeData = null;
    protected byte[] chunkHeaderBuffer = null;
    protected byte[] chunkWorkBuffer = null;
    protected int[] chunkHeaderValues = null;
    protected boolean errorReported = false;
    protected IMediaStream stream = null;
    protected Object lock = new Object();
    protected String mediaReaderType = "flv";
    protected String mediaReaderExt = "flv";
    protected MediaReaderItem mediaReaderItem = null;
    protected long saveLastVideoPos = 0L;
    protected long saveLastAudioPos = 0L;
    protected long saveLastBroadcastPos = 0L;
    protected int saveLastVideoSize = 0;
    protected int saveLastAudioSize = 0;
    protected int saveLastBroadcastSize = 0;
    protected String basePath = "";
    protected String mediaName = "";
    protected String mediaExtension = "";
    protected long duration = -1L;
    protected SortedMap<Long, Long> seekMap = new TreeMap<Long, Long>();
    protected SortedMap<Long, Long> keyframeMap = new TreeMap<Long, Long>();
    protected int seekBufferSize = 24576;
    protected long seekLargestFrame = 512000L;
    protected IRandomAccessWriter directWriter = null;
    protected long firstPacketLoc = 13L;
    protected byte firstPacketType = (byte)8;
    protected int readAheadSize = 65536;
    protected int readAheadTrigger = this.readAheadSize / 2;
    protected String randomAccessReaderClass = "com.wowza.io.DirectRandomAccessReader";
    protected IApplicationInstance appInstance = null;
    protected boolean bufferSeekIO = false;
    protected byte[] videoCodecConfig = null;
    protected byte[] audioCodecConfig = null;
    protected int seekKeyFrameSearchWindow = 10000;

    public MediaReaderFLV() {
        this.chunkHeaderBuffer = new byte[13];
        this.chunkHeaderValues = new int[5];
    }

    protected MediaReaderFLVNodeData getNodeData() {
        if (this.nodeData == null) {
            this.nodeData = new MediaReaderFLVNodeData();
        }
        return this.nodeData;
    }

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.appInstance = iApplicationInstance;
        this.stream = iMediaStream;
        this.lock = iMediaStream == null ? this.lock : iMediaStream;
        this.mediaReaderType = string.toLowerCase();
        this.mediaReaderExt = string;
        this.basePath = string2;
        this.mediaName = string3;
        this.mediaExtension = this.mediaReaderItem.getFileExtension();
        this.fileStream = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
        this.fileReader = new ScheduledRandomAccessReaderWrapper(this.stream, this.fileStream, this.readAheadSize, this.readAheadTrigger);
        this.directWriter = this.fileReader;
        iApplicationInstance.notifyMediaReaderInit((IMediaReader)this, iMediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.fileStream.isOpen()) {
                this.close();
            }
            boolean bl = false;
            try {
                this.fileStream.open();
                this.fileReader.open();
                this.errorReported = false;
                this.saveLastVideoPos = 0L;
                this.saveLastAudioPos = 0L;
                this.saveLastBroadcastPos = 0L;
                this.duration = -1L;
                this.firstPacketLoc = 13L;
                this.firstPacketType = (byte)8;
                bl = true;
            }
            catch (Exception exception) {
                if (!this.errorReported) {
                    WMSLoggerFactory.getLogger(MediaReaderFLV.class).log(Level.WARN, "open: " + exception.toString(), null, "server", "comment", 404, string2);
                }
                this.errorReported = true;
            }
            if (this.fileReader != null) {
                this.appInstance.notifyMediaReaderOpen((IMediaReader)this, this.stream);
                boolean bl2 = this.readMetadata((IRandomAccessReader)this.fileReader);
                this.readCodecConfig((IRandomAccessReader)this.fileReader);
                this.appInstance.notifyMediaReaderExtractMetaData((IMediaReader)this, this.stream);
                if (bl && !bl2) {
                    WMSLoggerFactory.getLogger(MediaReaderFLV.class).warn("MediaReaderFLV.open: Metadata appears to be bad: " + (this.stream == null ? "unknown" : this.stream.getName()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.fileReader != null) {
                    this.fileReader.close();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("close: " + exception.toString());
            }
            try {
                if (this.fileStream != null) {
                    this.fileStream.close();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("close: " + exception.toString());
            }
            this.seekMap.clear();
            this.keyframeMap.clear();
            this.metaData = null;
            this.metaDataSize = 0;
            this.saveLastVideoPos = 0L;
            this.saveLastAudioPos = 0L;
            this.saveLastBroadcastPos = 0L;
            this.duration = -1L;
            this.firstPacketLoc = 13L;
            this.firstPacketType = (byte)8;
        }
        this.appInstance.notifyMediaReaderClose((IMediaReader)this, this.stream);
    }

    public void setProperties(WMSProperties wMSProperties) {
        this.seekBufferSize = wMSProperties.getPropertyInt("flvSeekBufferSize", this.seekBufferSize);
        this.readAheadSize = wMSProperties.getPropertyInt("flvReadAheadSize", this.readAheadSize);
        this.readAheadTrigger = this.readAheadSize / 2;
        this.readAheadTrigger = wMSProperties.getPropertyInt("flvReadAheadTrigger", this.readAheadTrigger);
        this.randomAccessReaderClass = wMSProperties.getPropertyStr("randomAccessReaderClass", this.randomAccessReaderClass);
        this.bufferSeekIO = wMSProperties.getPropertyBoolean("bufferSeekIO", this.bufferSeekIO);
        this.seekKeyFrameSearchWindow = wMSProperties.getPropertyInt("seekKeyFrameSearchWindow", this.seekKeyFrameSearchWindow);
        if (WMSLoggerFactory.getLogger(MediaReaderFLV.class).isDebugEnabled()) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).debug("MediaReaderFLV.flvReadAheadSize: " + this.readAheadSize);
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).debug("MediaReaderFLV.flvReadAheadTrigger: " + this.readAheadTrigger);
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).debug("MediaReaderFLV.flvSeekBufferSize: " + this.seekBufferSize);
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).debug("MediaReaderFLV.randomAccessReaderClass: " + this.randomAccessReaderClass);
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).debug("MediaReaderFLV.bufferSeekIO: " + this.bufferSeekIO);
        }
    }

    public void setMediaReaderItem(MediaReaderItem mediaReaderItem) {
        this.mediaReaderItem = mediaReaderItem;
    }

    public boolean isOpen() {
        if (this.fileStream != null) {
            return this.fileStream.isOpen();
        }
        return false;
    }

    protected void indexFileExpand(MediaReaderFLVNodeData mediaReaderFLVNodeData, IRandomAccessReader iRandomAccessReader, long l) {
        this.indexFile(mediaReaderFLVNodeData, iRandomAccessReader, (int)(l / 1000L));
    }

    protected void indexFile(MediaReaderFLVNodeData mediaReaderFLVNodeData, IRandomAccessReader iRandomAccessReader, int n) {
        MediaStreamIndex mediaStreamIndex = mediaReaderFLVNodeData.getMediaStreamIndex();
        if (mediaStreamIndex.isHitEnd()) {
            return;
        }
        if (n != -1 && mediaStreamIndex.getLength() > n) {
            return;
        }
        try {
            int n2;
            if (n != -1) {
                n2 = n + 1;
                mediaStreamIndex.indexFileIncSize(n2);
            } else {
                n2 = mediaStreamIndex.getLength();
                mediaStreamIndex.indexFileIncSize(n2 += 500);
            }
            long l = 13L;
            int n3 = 0;
            if (mediaStreamIndex.getLength() > 0) {
                n3 = mediaStreamIndex.getLength() - 1;
                l = mediaStreamIndex.get(n3);
                ++n3;
            }
            iRandomAccessReader.seek(l);
            long l2 = iRandomAccessReader.length();
            byte[] byArray = new byte[8];
            boolean bl = false;
            long l3 = l;
            long l4 = 0L;
            while (true) {
                long l5 = l3;
                l3 = l;
                int n4 = iRandomAccessReader.read(byArray, 0, 7);
                if (n4 != 7) {
                    bl = true;
                    break;
                }
                l4 = l3;
                l += (long)n4;
                int n5 = byArray[0] & 0xFF;
                int n6 = byArray[1] & 0xFF;
                n6 <<= 8;
                n6 |= byArray[2] & 0xFF;
                n6 <<= 8;
                n6 |= byArray[3] & 0xFF;
                int n7 = byArray[4] & 0xFF;
                n7 <<= 8;
                n7 |= byArray[5] & 0xFF;
                n7 <<= 8;
                n7 |= byArray[6] & 0xFF;
                if (n6 > 0 && (n5 == 8 || n5 == 9)) {
                    while (n7 > n3 * 1000) {
                        mediaStreamIndex.indexFileSet(n3, l5);
                        ++n3;
                    }
                }
                if ((l += (long)(n6 + 8)) >= l2) {
                    bl = true;
                    break;
                }
                if (n != -1 && n3 > n) break;
                iRandomAccessReader.seek(l);
            }
            if (bl) {
                if (l4 > 0L) {
                    mediaStreamIndex.indexFileSet(mediaStreamIndex.getLength(), l4);
                }
                mediaStreamIndex.setHitEnd(true);
            }
            mediaStreamIndex.indexFileShrink();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int sendVideoTrakData(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, long l) {
        int n2 = 0;
        if (this.videoCodecConfig != null) {
            int n3 = playlistCursor.getWriteControl().getChunkSize();
            this.checkWorkBuffer(n3);
            int[] nArray = new int[5];
            nArray[1] = this.videoCodecConfig.length;
            nArray[2] = n;
            nArray[0] = 9;
            int n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, this.videoCodecConfig);
            n2 += n4;
            lArray[2] = lArray[2] + (long)n4;
            lArray[3] = lArray[3] + 1L;
        }
        return n2;
    }

    public int sendAudioTrakData(int n, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2, long l) {
        int n2 = 0;
        if (this.audioCodecConfig != null) {
            int n3 = playlistCursor.getWriteControl().getChunkSize();
            this.checkWorkBuffer(n3);
            int[] nArray = new int[5];
            nArray[1] = this.audioCodecConfig.length;
            nArray[2] = n;
            nArray[0] = 8;
            int n4 = this.directOutputBuf(nArray, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3, this.audioCodecConfig);
            n2 += n4;
            lArray[0] = lArray[0] + (long)n4;
            lArray[1] = lArray[1] + 1L;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readCodecConfig(IRandomAccessReader iRandomAccessReader) {
        long l = iRandomAccessReader.getFilePointer();
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            byte[] byArray = new byte[13];
            int[] nArray = new int[5];
            this.videoCodecConfig = null;
            this.audioCodecConfig = null;
            while (true) {
                boolean bl = false;
                this.readChunkHeader(iRandomAccessReader, byArray, nArray);
                if (nArray[0] == 127) {
                    return;
                }
                if (nArray[1] >= 2) {
                    int n4;
                    ++n;
                    switch (nArray[0]) {
                        case 8: {
                            ++n3;
                            break;
                        }
                        case 9: {
                            ++n2;
                        }
                    }
                    if (nArray[0] == 8) {
                        n4 = FLVUtils.getAudioCodec((int)nArray[3]);
                        if (n4 == 10 && nArray[1] >= 2 && nArray[4] == 0) {
                            this.audioCodecConfig = new byte[nArray[1]];
                            iRandomAccessReader.read(this.audioCodecConfig, 0, this.audioCodecConfig.length);
                            bl = true;
                        }
                    } else if (nArray[0] == 9 && (n4 = FLVUtils.getVideoCodec((int)nArray[3])) == 7) {
                        if (nArray[4] != 1) {
                            --n2;
                        }
                        if (nArray[4] == 0) {
                            this.videoCodecConfig = new byte[nArray[1]];
                            iRandomAccessReader.read(this.videoCodecConfig, 0, this.videoCodecConfig.length);
                            bl = true;
                        }
                    }
                }
                this.skipPacket(nArray, bl, true, 1);
                if (n >= 10) return;
                if (n2 <= 0 && this.videoCodecConfig == null) continue;
                if (n3 > 0) return;
                if (this.audioCodecConfig != null) return;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.readCodecConfig: " + exception.toString());
            return;
        }
        finally {
            iRandomAccessReader.seek(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean readMetadata(IRandomAccessReader iRandomAccessReader) {
        this.firstPacketLoc = 13L;
        this.firstPacketType = (byte)8;
        boolean bl = true;
        if (iRandomAccessReader == null) return bl;
        try {
            byte[] byArray;
            long l;
            boolean bl2;
            boolean bl3;
            int[] nArray;
            byte[] byArray2;
            block21: {
                int n;
                block20: {
                    block22: {
                        iRandomAccessReader.setDirecton(1);
                        iRandomAccessReader.seek(13L);
                        this.metaData = null;
                        this.metaDataSize = 0;
                        byArray2 = new byte[13];
                        nArray = new int[5];
                        bl3 = false;
                        bl2 = false;
                        l = iRandomAccessReader.getFilePointer();
                        this.readChunkHeader(iRandomAccessReader, byArray2, nArray);
                        if (nArray[0] != 18 && nArray[0] != 15) break block22;
                        bl2 = true;
                        byArray = new byte[nArray[1]];
                        iRandomAccessReader.read(byArray, 0, byArray.length);
                        iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() + 4L);
                        if (this.metaData == null) {
                            this.metaData = new ArrayList();
                        }
                        this.metaData.add(ByteBuffer.wrap(byArray));
                        this.metaDataSize += 11 + nArray[1] + 4;
                        if (!bl3) {
                            try {
                                AMFDataList aMFDataList;
                                int n2 = 0;
                                if (nArray[0] == 15 && byArray.length > 0 && byArray[0] == 0) {
                                    n2 = 1;
                                }
                                if ((aMFDataList = new AMFDataList(byArray, n2, byArray.length - n2)).size() > 1) {
                                    int n3;
                                    AMFDataObj aMFDataObj;
                                    if (aMFDataList.get(1).getType() != 8) break block20;
                                    AMFDataMixedArray aMFDataMixedArray = (AMFDataMixedArray)aMFDataList.get(1);
                                    if (aMFDataMixedArray.containsKey("duration")) {
                                        double d = aMFDataMixedArray.getDouble("duration");
                                        this.duration = Math.round(d * 1000.0);
                                        bl3 = true;
                                    }
                                    if (!aMFDataMixedArray.containsKey("keyframes") || (aMFDataObj = (AMFDataObj)aMFDataMixedArray.get("keyframes")) == null || !aMFDataObj.containsKey("filepositions") || !aMFDataObj.containsKey("times")) break block20;
                                    AMFDataArray aMFDataArray = (AMFDataArray)aMFDataObj.get("filepositions");
                                    AMFDataArray aMFDataArray2 = (AMFDataArray)aMFDataObj.get("times");
                                    if (aMFDataArray != null && aMFDataArray2 != null && (n3 = aMFDataArray.size()) == (n = aMFDataArray2.size())) {
                                        for (int i = 0; i < n3; ++i) {
                                            long l2 = Math.round(aMFDataArray2.getDouble(i) * 1000.0);
                                            long l3 = aMFDataArray.getLong(i);
                                            this.keyframeMap.put(new Long(l2), new Long(l3));
                                            this.seekMap.put(new Long(l2), new Long(l3));
                                        }
                                    }
                                    break block20;
                                }
                                bl = false;
                                break block20;
                            }
                            catch (Exception exception) {
                                WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.readMetadata: getDuration: " + exception.toString());
                            }
                        }
                        break block20;
                    }
                    iRandomAccessReader.seek(l);
                    bl = false;
                }
                if (!bl3) {
                    l = iRandomAccessReader.getFilePointer();
                    try {
                        long l4 = iRandomAccessReader.length();
                        if (l4 <= 17L) break block21;
                        iRandomAccessReader.seek(l4 - 4L);
                        byte[] byArray3 = new byte[4];
                        iRandomAccessReader.read(byArray3, 0, 4);
                        int n4 = BufferUtils.byteArrayToInt((byte[])byArray3, (int)0, (int)4);
                        if (n4 <= 0 || (long)n4 >= l4 - 13L) break block21;
                        iRandomAccessReader.seek(l4 - (long)(n4 + 4));
                        iRandomAccessReader.read(byArray3, 0, 1);
                        iRandomAccessReader.read(byArray3, 0, 3);
                        long l5 = BufferUtils.byteArrayToInt((byte[])byArray3, (int)0, (int)3);
                        if (l5 + 11L == (long)n4) {
                            long l6 = iRandomAccessReader.getFilePointer();
                            iRandomAccessReader.seek(l4 - (long)(n4 + 4));
                            n = (int)l5 + 11 + 4;
                            byte[] byArray4 = new byte[n];
                            iRandomAccessReader.read(byArray4, 0, n);
                            iRandomAccessReader.seek(l6);
                            iRandomAccessReader.read(byArray3, 0, 3);
                            l6 = BufferUtils.byteArrayToInt((byte[])byArray3, (int)0, (int)3);
                            this.duration = l6 & 0xFFFFFFFFL;
                            bl3 = true;
                        }
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.readMetadata: getDuration: " + exception.toString());
                    }
                    finally {
                        iRandomAccessReader.seek(l);
                    }
                }
            }
            if (bl2) {
                l = iRandomAccessReader.getFilePointer();
                this.readChunkHeader(iRandomAccessReader, byArray2, nArray);
                iRandomAccessReader.seek(l);
                if (nArray[0] == 127) return bl;
                this.firstPacketLoc = l;
                this.firstPacketType = (byte)nArray[0];
                return bl;
            }
            if (!bl3) return bl;
            AMFDataList aMFDataList = new AMFDataList();
            AMFDataMixedArray aMFDataMixedArray = new AMFDataMixedArray();
            aMFDataMixedArray.put("duration", (AMFData)new AMFDataItem((double)this.duration / 1000.0));
            aMFDataList.add((AMFData)new AMFDataItem("onMetaData"));
            aMFDataList.add((AMFData)aMFDataMixedArray);
            byArray = aMFDataList.serialize();
            if (byArray == null) return bl;
            if (this.metaData == null) {
                this.metaData = new ArrayList();
            }
            this.metaData.add(ByteBuffer.wrap(byArray));
            return bl;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.readMetadata: " + exception.toString());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata() {
        Object object = this.lock;
        synchronized (object) {
            return this.metaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.fileReader != null) {
                    this.fileReader.seek(this.firstPacketLoc);
                    this.fileReader.setDirecton(1);
                    this.saveLastVideoPos = 0L;
                    this.saveLastAudioPos = 0L;
                    this.saveLastBroadcastPos = 0L;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.rewind: WMSPlaylistReader: rewind: " + exception.toString());
        }
    }

    protected long readInt(IRandomAccessReader iRandomAccessReader) {
        long l = 0L;
        byte[] byArray = new byte[4];
        int n = iRandomAccessReader.read(byArray, 0, 4);
        if (n == 4) {
            l |= (long)(byArray[0] & 0xFF);
            l <<= 8;
            l |= (long)(byArray[1] & 0xFF);
            l <<= 8;
            l |= (long)(byArray[2] & 0xFF);
            l <<= 8;
            l |= (long)(byArray[3] & 0xFF);
        }
        return l;
    }

    protected boolean skipPacket(int[] nArray, boolean bl, boolean bl2, int n) {
        boolean bl3 = true;
        try {
            if (n > 0) {
                int n2 = 4;
                if (!bl) {
                    n2 += nArray[1];
                }
                if (!bl2) {
                    n2 += 11;
                }
                this.fileReader.seek(this.fileReader.getFilePointer() + (long)n2);
            } else {
                int n3 = 4;
                if (bl) {
                    n3 += nArray[1];
                }
                if (bl2) {
                    n3 += 11;
                }
                this.fileReader.seek(this.fileReader.getFilePointer() - (long)n3);
                long l = this.readInt((IRandomAccessReader)this.fileReader);
                if (l > 0L) {
                    this.fileReader.seek(this.fileReader.getFilePointer() - (l + 4L));
                } else {
                    bl3 = false;
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.skipPacket: " + exception.toString());
            bl3 = false;
        }
        return bl3;
    }

    protected boolean readPacketHeader(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray) {
        try {
            int n = iRandomAccessReader.read(byArray, 0, 7);
            if (n < 7) {
                return false;
            }
            nArray[0] = byArray[0] & 0xFF;
            nArray[1] = byArray[1] & 0xFF;
            nArray[1] = nArray[1] << 8;
            nArray[1] = nArray[1] | byArray[2] & 0xFF;
            nArray[1] = nArray[1] << 8;
            nArray[1] = nArray[1] | byArray[3] & 0xFF;
            nArray[2] = byArray[7] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[4] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[5] & 0xFF;
            nArray[2] = nArray[2] << 8;
            nArray[2] = nArray[2] | byArray[6] & 0xFF;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected PlaylistSeekResult seekExact(IRandomAccessReader iRandomAccessReader, long l, byte[] byArray, int[] nArray, long l2) {
        return this.seekExactDown(iRandomAccessReader, l, byArray, nArray, l2);
    }

    protected PlaylistSeekResult seekExactUpOrDown(IRandomAccessReader iRandomAccessReader, long l, byte[] byArray, int[] nArray, long l2) {
        PlaylistSeekResult playlistSeekResult = null;
        try {
            long l3 = iRandomAccessReader.getFilePointer();
            this.readPacketHeader(iRandomAccessReader, byArray, nArray);
            long l4 = (long)nArray[2] & 0xFFFFFFFFL;
            iRandomAccessReader.seek(l3);
            playlistSeekResult = l4 <= l ? this.seekExactDown(iRandomAccessReader, l, byArray, nArray, l2) : this.seekExactUp(iRandomAccessReader, l, byArray, nArray, l2);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.seekExactUpOrDown: " + exception.toString());
        }
        return playlistSeekResult;
    }

    protected PlaylistSeekResult seekExactUp(IRandomAccessReader iRandomAccessReader, long l, byte[] byArray, int[] nArray, long l2) {
        PlaylistSeekResult playlistSeekResult = null;
        try {
            long l3;
            long l4 = l3 = iRandomAccessReader.getFilePointer();
            while (true) {
                long l5 = l4;
                l4 = l3;
                if (this.readPacketHeader(iRandomAccessReader, byArray, nArray)) {
                    long l6;
                    if (!(nArray[1] <= 0 || nArray[0] != 8 && nArray[0] != 9 || (l6 = (long)nArray[2] & 0xFFFFFFFFL) > l && (l3 += 7L) - 7L + 4L >= 13L)) {
                        iRandomAccessReader.seek(l5);
                        playlistSeekResult = new PlaylistSeekResult(0L);
                        playlistSeekResult.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(l4), (long)nArray[2], nArray[0], 0);
                    } else if ((l3 -= 11L) >= 13L) {
                        iRandomAccessReader.seek(l3);
                        l6 = this.readInt(iRandomAccessReader);
                        if (l6 > 0L && (l3 -= l6) >= 13L) {
                            iRandomAccessReader.seek(l3);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.seekExactUp: " + exception.toString());
        }
        return playlistSeekResult;
    }

    protected PlaylistSeekResult seekExactDown(IRandomAccessReader iRandomAccessReader, long l, byte[] byArray, int[] nArray, long l2) {
        PlaylistSeekResult playlistSeekResult = null;
        try {
            long l3;
            long l4 = l3 = iRandomAccessReader.getFilePointer();
            while (true) {
                long l5 = l4;
                l4 = l3;
                if (this.readPacketHeader(iRandomAccessReader, byArray, nArray)) {
                    long l6;
                    int n = 8;
                    if (!(nArray[1] <= 0 || nArray[0] != 8 && nArray[0] != 9 || (l6 = (long)nArray[2] & 0xFFFFFFFFL) < l && (l3 += 7L) + (long)nArray[1] + (long)n < l2)) {
                        iRandomAccessReader.seek(l5);
                        playlistSeekResult = new PlaylistSeekResult(0L);
                        playlistSeekResult.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(l4), (long)nArray[2], nArray[0], 0);
                    } else if ((l3 += (long)(nArray[1] + n)) < l2) {
                        iRandomAccessReader.seek(l3);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.seekExactDown: " + exception.toString());
        }
        return playlistSeekResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PlaylistSeekResult seekKeyDown(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray, long l) {
        PlaylistSeekResult playlistSeekResult = null;
        try {
            long l2;
            long l3 = l2 = iRandomAccessReader.getFilePointer();
            long l4 = -1L;
            while (true) {
                long l5 = l3;
                l3 = l2;
                if (!this.readPacketHeader(iRandomAccessReader, byArray, nArray)) return playlistSeekResult;
                l2 += 7L;
                int n = 8;
                if (nArray[1] > 0 && (nArray[0] == 8 || nArray[0] == 9)) {
                    if (nArray[0] == 9) {
                        iRandomAccessReader.seek(l2 + 4L);
                        iRandomAccessReader.read(byArray, 0, 2);
                        if (FLVUtils.isVideoKeyFrame((byte[])byArray)) {
                            iRandomAccessReader.seek(l3);
                            playlistSeekResult = new PlaylistSeekResult(0L);
                            long l6 = (long)nArray[2] & 0xFFFFFFFFL;
                            playlistSeekResult.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(l3), l6, nArray[0], 1);
                            return playlistSeekResult;
                        }
                    }
                    if (l4 == -1L) {
                        l4 = nArray[2];
                    }
                    if ((long)nArray[2] > l4 + (long)this.seekKeyFrameSearchWindow) {
                        iRandomAccessReader.seek(l3);
                        return playlistSeekResult;
                    }
                }
                if ((l2 += (long)(nArray[1] + n)) >= l) return playlistSeekResult;
                iRandomAccessReader.seek(l2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.seekKeyDown: " + exception.toString());
        }
        return playlistSeekResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PlaylistSeekResult seekKeyUp(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray, long l) {
        PlaylistSeekResult playlistSeekResult = null;
        try {
            long l2;
            long l3 = l2 = iRandomAccessReader.getFilePointer();
            long l4 = -1L;
            while (true) {
                long l5;
                long l6 = l3;
                l3 = l2;
                if (!this.readPacketHeader(iRandomAccessReader, byArray, nArray)) return playlistSeekResult;
                l2 += 7L;
                if (nArray[1] > 0 && (nArray[0] == 8 || nArray[0] == 9)) {
                    if (nArray[0] == 9) {
                        iRandomAccessReader.seek(l2 + 4L);
                        iRandomAccessReader.read(byArray, 0, 2);
                        if (FLVUtils.isVideoKeyFrame((byte[])byArray)) {
                            iRandomAccessReader.seek(l3);
                            playlistSeekResult = new PlaylistSeekResult(0L);
                            l5 = (long)nArray[2] & 0xFFFFFFFFL;
                            playlistSeekResult.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(l3), l5, nArray[0], 1);
                            return playlistSeekResult;
                        }
                    }
                    if (l4 == -1L) {
                        l4 = nArray[2];
                    }
                    if (l4 > (long)this.seekKeyFrameSearchWindow && (l5 = (long)nArray[2] & 0xFFFFFFFFL) < l4 - (long)this.seekKeyFrameSearchWindow) {
                        iRandomAccessReader.seek(l3);
                        return playlistSeekResult;
                    }
                }
                if ((l2 -= 11L) < 13L) return playlistSeekResult;
                iRandomAccessReader.seek(l2);
                l5 = this.readInt(iRandomAccessReader);
                if (l5 <= 0L || (l2 -= l5) < 13L) return playlistSeekResult;
                iRandomAccessReader.seek(l2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.seekKeyUp: " + exception.toString());
        }
        return playlistSeekResult;
    }

    protected PlaylistSeekResult seekGoodUp(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray, long l) {
        PlaylistSeekResult playlistSeekResult = null;
        try {
            long l2;
            long l3 = l2 = iRandomAccessReader.getFilePointer();
            while (true) {
                long l4 = l3;
                l3 = l2;
                if (this.readPacketHeader(iRandomAccessReader, byArray, nArray)) {
                    long l5;
                    l2 += 7L;
                    if (nArray[1] > 0 && (nArray[0] == 9 || nArray[0] == 8)) {
                        iRandomAccessReader.seek(l3);
                        playlistSeekResult = new PlaylistSeekResult(0L);
                        l5 = (long)nArray[2] & 0xFFFFFFFFL;
                        playlistSeekResult.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(l3), l5, nArray[0], 0);
                    } else if ((l2 -= 11L) >= 13L) {
                        iRandomAccessReader.seek(l2);
                        l5 = this.readInt(iRandomAccessReader);
                        if (l5 > 0L && (l2 -= l5) >= 13L) {
                            iRandomAccessReader.seek(l2);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.seekGoodUp: " + exception.toString());
        }
        return playlistSeekResult;
    }

    public long resultsToFilePos(PlaylistSeekResult playlistSeekResult) {
        return playlistSeekResult.getStreamPos() == null ? -1L : ((FLVStreamPosition)playlistSeekResult.getStreamPos()).getFilePos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlaylistSeekResult seek(long l, int n) {
        IRandomAccessReader iRandomAccessReader;
        IRandomAccessReader iRandomAccessReader2;
        PlaylistSeekResult playlistSeekResult;
        block64: {
            if (!this.fileStream.exists()) {
                return null;
            }
            playlistSeekResult = null;
            iRandomAccessReader2 = null;
            iRandomAccessReader = null;
            if (l <= 0L) {
                playlistSeekResult = new PlaylistSeekResult(0L);
                playlistSeekResult.setResults((IMediaReaderStreamPosition)new FLVStreamPosition(this.firstPacketLoc), 0L, (int)this.firstPacketType, 0);
                return playlistSeekResult;
            }
            long l2 = System.currentTimeMillis();
            try {
                long l3;
                SortedMap<Long, Long> sortedMap;
                Object object;
                if (this.bufferSeekIO) {
                    iRandomAccessReader2 = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                    iRandomAccessReader = new ScheduledRandomAccessReaderWrapper(this.stream, iRandomAccessReader2, this.readAheadSize, this.readAheadTrigger);
                    iRandomAccessReader2.open();
                    iRandomAccessReader.open();
                } else {
                    iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                    iRandomAccessReader.open();
                }
                byte[] byArray = new byte[13];
                int[] nArray = new int[5];
                long l4 = iRandomAccessReader.length();
                long l5 = -1L;
                long l6 = -1L;
                if (this.keyframeMap.size() > 0) {
                    object = new Long(l);
                    long l7 = 0L;
                    if (n == 1) {
                        sortedMap = this.keyframeMap.headMap((Long)object);
                        if (!sortedMap.isEmpty()) {
                            l7 = sortedMap.lastKey();
                            l5 = (Long)sortedMap.get(sortedMap.lastKey());
                        }
                    } else if (n == 3) {
                        SortedMap<Long, Long> sortedMap2;
                        long l8 = -1L;
                        long l9 = 0L;
                        long l10 = -1L;
                        long l11 = 0L;
                        SortedMap<Long, Long> sortedMap3 = this.keyframeMap.headMap((Long)object);
                        if (!sortedMap3.isEmpty()) {
                            l8 = sortedMap3.lastKey();
                            l9 = (Long)sortedMap3.get(sortedMap3.lastKey());
                        }
                        if (!(sortedMap2 = this.keyframeMap.tailMap((Long)object)).isEmpty()) {
                            l10 = sortedMap2.firstKey();
                            l11 = (Long)sortedMap2.get(sortedMap2.firstKey());
                        }
                        if (l8 >= 0L && l10 >= 0L) {
                            long l12 = Math.abs(l8 - l);
                            long l13 = Math.abs(l10 - l);
                            if (l13 <= l12) {
                                l7 = l10;
                                l5 = l11;
                            } else {
                                l7 = l8;
                                l5 = l9;
                            }
                        } else if (l8 >= 0L) {
                            l7 = l8;
                            l5 = l9;
                        } else if (l10 >= 0L) {
                            l7 = l10;
                            l5 = l11;
                        }
                    } else {
                        SortedMap<Long, Long> sortedMap4 = this.keyframeMap.tailMap((Long)object);
                        if (!sortedMap4.isEmpty()) {
                            l7 = sortedMap4.firstKey();
                            l5 = (Long)sortedMap4.get(sortedMap4.firstKey());
                        }
                    }
                    if (l5 >= 0L) {
                        if (n == 2 || n == 1 || n == 3) {
                            l6 = l5;
                            playlistSeekResult = new PlaylistSeekResult(0L);
                            sortedMap = new FLVStreamPosition(l5);
                            playlistSeekResult.setResults((IMediaReaderStreamPosition)sortedMap, l7, 9, 1);
                            playlistSeekResult.setVideoStreamPos((IMediaReaderStreamPosition)sortedMap);
                            playlistSeekResult.setResultVideoTimecode(l7);
                            l3 = l5;
                            iRandomAccessReader.seek(l5);
                            PlaylistSeekResult playlistSeekResult2 = this.seekExactUpOrDown(iRandomAccessReader, l, byArray, nArray, l4);
                            iRandomAccessReader.seek(l3);
                            if (playlistSeekResult2 != null) {
                                l6 = this.resultsToFilePos(playlistSeekResult2);
                                playlistSeekResult.setResultTimecode(playlistSeekResult2.getResultTimecode());
                            }
                        } else {
                            iRandomAccessReader.seek(l5);
                            playlistSeekResult = this.seekExactUpOrDown(iRandomAccessReader, l, byArray, nArray, l4);
                        }
                    }
                }
                if ((l5 == -1L || playlistSeekResult == null) && this.duration > 0L && (l5 = this.findClosestPacket(iRandomAccessReader, l, this.duration, this.seekMap, this.metaDataSize, (byte[])(object = (Object)new byte[this.seekBufferSize]), byArray, nArray)) >= 0L) {
                    iRandomAccessReader.seek(l5);
                    playlistSeekResult = this.seekExactUpOrDown(iRandomAccessReader, l, byArray, nArray, l4);
                }
                if (l5 == -1L || playlistSeekResult == null) {
                    object = this.getNodeData();
                    synchronized (object) {
                        if (!this.nodeData.isHitEnd()) {
                            int n2 = this.nodeData.getExtent();
                            this.indexFileExpand(this.nodeData, iRandomAccessReader, l);
                            if (n2 != this.nodeData.getExtent()) {
                                MediaIndexCacheSingleton.getInstance().addPending(this.mediaReaderType, (IRandomAccessReader)this.fileReader, (IMediaIndexItem)this.nodeData);
                            }
                        }
                        l5 = this.nodeData.getMediaStreamIndex().indexFileGet(l);
                        this.nodeData.touch();
                    }
                    if (l5 == -1L) break block64;
                    iRandomAccessReader.seek(l5);
                    playlistSeekResult = this.seekExact(iRandomAccessReader, l, byArray, nArray, l4);
                }
                if (l6 == -1L) {
                    switch (n) {
                        case 4: {
                            if (playlistSeekResult == null) break;
                            l6 = this.resultsToFilePos(playlistSeekResult);
                            break;
                        }
                        case 2: {
                            if (playlistSeekResult == null) break;
                            l6 = this.resultsToFilePos(playlistSeekResult);
                            object = this.seekKeyDown(iRandomAccessReader, byArray, nArray, l4);
                            if (object == null) break;
                            playlistSeekResult.setVideoStreamPos(object.getStreamPos());
                            playlistSeekResult.setResultVideoTimecode(object.getResultTimecode());
                            break;
                        }
                        case 1: {
                            if (playlistSeekResult == null) break;
                            l6 = this.resultsToFilePos(playlistSeekResult);
                            object = this.seekKeyUp(iRandomAccessReader, byArray, nArray, l4);
                            if (object == null) break;
                            playlistSeekResult.setVideoStreamPos(object.getStreamPos());
                            playlistSeekResult.setResultVideoTimecode(object.getResultTimecode());
                            break;
                        }
                        case 3: {
                            if (playlistSeekResult == null) break;
                            l6 = this.resultsToFilePos(playlistSeekResult);
                            long l14 = iRandomAccessReader.getFilePointer();
                            PlaylistSeekResult playlistSeekResult3 = this.seekKeyUp(iRandomAccessReader, byArray, nArray, l4);
                            iRandomAccessReader.seek(l14);
                            sortedMap = this.seekKeyDown(iRandomAccessReader, byArray, nArray, l4);
                            if (playlistSeekResult3 != null && sortedMap != null) {
                                l3 = Math.abs(playlistSeekResult3.getResultTimecode() - l);
                                long l15 = Math.abs(sortedMap.getResultTimecode() - l);
                                if (l15 <= l3) {
                                    playlistSeekResult.setVideoStreamPos(sortedMap.getStreamPos());
                                    playlistSeekResult.setResultVideoTimecode(sortedMap.getResultTimecode());
                                    break;
                                }
                                playlistSeekResult.setVideoStreamPos(playlistSeekResult3.getStreamPos());
                                playlistSeekResult.setResultVideoTimecode(playlistSeekResult3.getResultTimecode());
                                break;
                            }
                            if (playlistSeekResult3 != null) {
                                playlistSeekResult.setVideoStreamPos(playlistSeekResult3.getStreamPos());
                                playlistSeekResult.setResultVideoTimecode(playlistSeekResult3.getResultTimecode());
                                break;
                            }
                            if (sortedMap == null) break;
                            playlistSeekResult.setVideoStreamPos(sortedMap.getStreamPos());
                            playlistSeekResult.setResultVideoTimecode(sortedMap.getResultTimecode());
                        }
                    }
                }
                if (playlistSeekResult == null) {
                    MediaReaderFLVNodeData mediaReaderFLVNodeData = this.getNodeData();
                    synchronized (mediaReaderFLVNodeData) {
                        if (!this.nodeData.isHitEnd()) {
                            this.indexFileExpand(this.nodeData, iRandomAccessReader, -1L);
                            MediaIndexCacheSingleton.getInstance().addPending(this.mediaReaderType, (IRandomAccessReader)this.fileReader, (IMediaIndexItem)this.nodeData);
                        }
                        l5 = this.nodeData.getMediaStreamIndex().indexFileLast();
                        this.nodeData.touch();
                    }
                    if (l5 != -1L) {
                        iRandomAccessReader.seek(l5);
                        if (n == 4) {
                            playlistSeekResult = this.seekGoodUp(iRandomAccessReader, byArray, nArray, l4);
                            if (playlistSeekResult != null) {
                                l6 = this.resultsToFilePos(playlistSeekResult);
                            }
                        } else {
                            playlistSeekResult = this.seekKeyUp(iRandomAccessReader, byArray, nArray, l4);
                            if (playlistSeekResult == null) {
                                playlistSeekResult = this.seekGoodUp(iRandomAccessReader, byArray, nArray, l4);
                                if (playlistSeekResult != null) {
                                    l6 = this.resultsToFilePos(playlistSeekResult);
                                }
                            } else {
                                l6 = this.resultsToFilePos(playlistSeekResult);
                            }
                        }
                    }
                }
                if (playlistSeekResult != null) {
                    FLVStreamPosition fLVStreamPosition = new FLVStreamPosition(l6 != -1L ? l6 : iRandomAccessReader.getFilePointer());
                    playlistSeekResult.setStreamPos((IMediaReaderStreamPosition)fLVStreamPosition);
                    playlistSeekResult.setSearchTimecode(l);
                }
                iRandomAccessReader.close();
                iRandomAccessReader = null;
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.seek: " + exception.toString());
                exception.printStackTrace();
            }
        }
        try {
            if (iRandomAccessReader != null) {
                iRandomAccessReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        iRandomAccessReader = null;
        try {
            if (iRandomAccessReader2 != null) {
                iRandomAccessReader2.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        iRandomAccessReader2 = null;
        return playlistSeekResult;
    }

    public IMediaReaderStreamPosition getStreamPosition() {
        FLVStreamPosition fLVStreamPosition = new FLVStreamPosition();
        try {
            if (this.fileReader != null) {
                fLVStreamPosition.setFilePos(this.fileReader.getFilePointer());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.getFilePointer: " + exception.toString());
        }
        return fLVStreamPosition;
    }

    public void setStreamPosition(IMediaReaderStreamPosition iMediaReaderStreamPosition) {
        try {
            if (this.fileReader != null) {
                this.fileReader.seek(((FLVStreamPosition)iMediaReaderStreamPosition).getFilePos());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.getFilePointer: " + exception.toString());
        }
    }

    public void startPlayback() {
    }

    public int writeGeneratedKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        return this.writeGeneratedKeyFrame(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
    }

    public int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        if (fastPlaySettings != null) {
            return this.writePacketsFastPlay(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, fastPlaySettings, bl);
        }
        return this.writePackets(iMediaStream, outputStream, aMFObj, aMFObj2, aMFObj3, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl);
    }

    protected void checkWorkBuffer(int n) {
        boolean bl = false;
        if (this.chunkWorkBuffer == null) {
            bl = true;
        } else if (this.chunkWorkBuffer.length < n) {
            bl = true;
        }
        if (bl) {
            this.chunkWorkBuffer = new byte[n];
        }
    }

    public int rewriteLastPacket(int n, long l, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, long[] lArray, FastPlaySettings fastPlaySettings) {
        int n2 = 0;
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        switch (n) {
            case 9: {
                if (this.saveLastVideoPos == 0L) break;
                this.fileReader.seek(this.saveLastVideoPos);
                this.chunkHeaderValues[0] = n;
                this.chunkHeaderValues[1] = this.saveLastVideoSize;
                this.chunkHeaderValues[2] = (int)(l & 0xFFFFFFFFL);
                int n4 = this.directOutput((IRandomAccessReader)this.fileReader, this.chunkHeaderValues, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3);
                n2 += n4;
                lArray[2] = lArray[2] + (long)n4;
                lArray[3] = lArray[3] + 1L;
                break;
            }
            case 8: {
                if (this.saveLastAudioPos == 0L) break;
                this.fileReader.seek(this.saveLastAudioPos);
                this.chunkHeaderValues[0] = n;
                this.chunkHeaderValues[1] = this.saveLastAudioSize;
                this.chunkHeaderValues[2] = (int)(l & 0xFFFFFFFFL);
                int n5 = this.directOutput((IRandomAccessReader)this.fileReader, this.chunkHeaderValues, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3);
                n2 += n5;
                lArray[0] = lArray[0] + (long)n5;
                lArray[1] = lArray[1] + 1L;
                break;
            }
            case 15: 
            case 18: {
                if (this.saveLastBroadcastPos == 0L) break;
                this.fileReader.seek(this.saveLastAudioPos);
                this.chunkHeaderValues[0] = n;
                this.chunkHeaderValues[1] = this.saveLastBroadcastSize;
                this.chunkHeaderValues[2] = (int)(l & 0xFFFFFFFFL);
                int n6 = this.directOutput((IRandomAccessReader)this.fileReader, this.chunkHeaderValues, bl, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n3);
                n2 += n6;
                lArray[4] = lArray[4] + (long)n6;
                lArray[5] = lArray[5] + 1L;
                break;
            }
        }
        return n2;
    }

    protected boolean isEnhancedSeekCapable(IMediaStream iMediaStream) {
        IClient iClient = iMediaStream.getClient();
        if (iClient != null) {
            int[] nArray = new int[]{9, 0, 0, 0};
            return iClient.testFlashVersion(nArray) >= 0;
        }
        return false;
    }

    protected int writeEnhancedCmd(IMediaStream iMediaStream, OutputStream outputStream, int n) {
        int n2 = 0;
        IClient iClient = iMediaStream.getClient();
        if (iClient == null) {
            return 0;
        }
        IFasterByteArrayWriteControl iFasterByteArrayWriteControl = outputStream instanceof IFasterByteArrayWriteControl ? (IFasterByteArrayWriteControl)outputStream : null;
        try {
            int n3 = iMediaStream.getSrc();
            int n4 = 1;
            byte[] byArray = new byte[]{84, (byte)(0xFF & n)};
            ResponseFunction responseFunction = new ResponseFunction(iClient);
            responseFunction.createEnhancedSeekMessage(byArray, n3, n4);
            if (iFasterByteArrayWriteControl != null) {
                iFasterByteArrayWriteControl.writeControl(iMediaStream.getSrc(), true, n == 0 ? 1 : 2, null);
            }
            n2 += responseFunction.write(outputStream, ((Client)iClient).getSendChunkSize());
            if (iFasterByteArrayWriteControl != null) {
                iFasterByteArrayWriteControl.writeControl(iMediaStream.getSrc(), false, n == 0 ? 1 : 2, null);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.enhancedCmd: " + exception.toString());
        }
        return n2;
    }

    protected int writeChunkSizeCmd(OutputStream outputStream, int n) {
        int n2 = 0;
        byte[] byArray = new byte[]{2, 0, 0, 0, 0, 0, 4, 1, 0, 0, 0, 0, (byte)(0xFF & n >> 24), (byte)(0xFF & n >> 16), (byte)(0xFF & n >> 8), (byte)(0xFF & n >> 0)};
        try {
            outputStream.write(byArray);
            n2 += byArray.length;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.writeChunkSizeCmd: error sending chunk size: " + exception.toString());
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeGeneratedKeyFrame(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        long l = playlistCursor.getSeekStartStreamPos() == null ? -1L : ((FLVStreamPosition)playlistCursor.getSeekStartStreamPos()).getFilePos();
        int n4 = playlistCursor.getSeekTarget();
        long l2 = playlistCursor.getForceVideoTC();
        playlistCursor.setForceVideoTC(-1L);
        boolean bl2 = this.isEnhancedSeekCapable(iMediaStream);
        int n5 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n5);
        this.fileReader.setDirecton(1);
        boolean bl3 = true;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (playlistCursor.isBreakLoop()) {
                    break;
                }
                this.readChunkHeader((IRandomAccessReader)this.fileReader, this.chunkHeaderBuffer, this.chunkHeaderValues);
                if (this.chunkHeaderValues[0] == 127) {
                    playlistReaderWriteResults.setHitEnd(true);
                    break;
                }
                if ((long)this.chunkHeaderValues[1] > this.seekLargestFrame) {
                    this.seekLargestFrame = this.chunkHeaderValues[1];
                }
                boolean bl4 = false;
                long l3 = 0L;
                long l4 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                switch (this.chunkHeaderValues[0]) {
                    case 9: {
                        if (!iMediaStream.isReceiveVideo()) break;
                        boolean bl5 = playlistCursor.isSendAbsVideoTC();
                        if (bl5) {
                            this.chunkHeaderValues[2] = (int)(l2 + playlistCursor.getStartTCOffset());
                            l4 = l2;
                            playlistCursor.setSendAbsVideoTC(false);
                        } else {
                            this.chunkHeaderValues[2] = 0;
                        }
                        playlistCursor.setLastVideoTC(l4);
                        playlistCursor.incVideoPacketCount();
                        l3 = l4;
                        this.saveLastVideoPos = this.fileReader.getFilePointer();
                        this.saveLastVideoSize = this.chunkHeaderValues[1];
                        if (bl) {
                            this.chunkHeaderValues[2] = 0;
                        }
                        if (n4 == 4 && bl3) {
                            if (bl2) {
                                n += this.writeEnhancedCmd(iMediaStream, outputStream, 0);
                            }
                            bl3 = false;
                        }
                        int n6 = this.directOutput((IRandomAccessReader)this.fileReader, this.chunkHeaderValues, bl5, iMediaStream.getSrc(), outputStream, aMFObj2, this.chunkWorkBuffer, n5);
                        n += n6;
                        bl4 = true;
                        playlistReaderWriteResults.incVideoPackets();
                        playlistReaderWriteResults.setLastTC(l3);
                        lArray[2] = lArray[2] + (long)n6;
                        lArray[3] = lArray[3] + 1L;
                        ++n3;
                        if (n4 == 4) break;
                        n6 = this.rewriteLastPacket(9, 0L, false, iMediaStream, outputStream, aMFObj2, playlistCursor, lArray, null);
                        n += n6;
                        playlistReaderWriteResults.incVideoPackets();
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 15: 
                    case 18: {
                        break;
                    }
                }
                ++n2;
                this.skipPacket(this.chunkHeaderValues, bl4, true, 1);
                if (n4 != 4) {
                    break;
                }
                long l5 = this.fileReader.getFilePointer();
                if (l5 >= l) {
                    break;
                }
            }
        }
        if (n4 == 4) {
            if (!bl3 && bl2) {
                n += this.writeEnhancedCmd(iMediaStream, outputStream, 1);
            }
            n += this.writeChunkSizeCmd(outputStream, n5);
        }
        playlistReaderWriteResults.setTotalSize(n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writePackets(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl) {
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        long l = playlistWriteControl.getMaxTC();
        int n3 = 0;
        int n4 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n4);
        this.fileReader.setDirecton(1);
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (playlistCursor.isBreakLoop()) {
                    break;
                }
                long l2 = this.fileReader.getFilePointer();
                this.readChunkHeader((IRandomAccessReader)this.fileReader, this.chunkHeaderBuffer, this.chunkHeaderValues);
                if (this.chunkHeaderValues[0] == 127) {
                    playlistReaderWriteResults.setHitEnd(true);
                    break;
                }
                if ((long)this.chunkHeaderValues[1] > this.seekLargestFrame) {
                    this.seekLargestFrame = this.chunkHeaderValues[1];
                }
                boolean bl5 = false;
                long l3 = 0L;
                long l4 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                if (l > 0L && l4 >= l) {
                    this.fileReader.seek(l2);
                    break;
                }
                switch (this.chunkHeaderValues[0]) {
                    case 9: {
                        int n5;
                        int n6;
                        if (!iMediaStream.isReceiveVideo()) break;
                        if (playlistCursor.isWaitForKeyFrame()) {
                            if (!FLVUtils.isVideoKeyFrame((int[])this.chunkHeaderValues)) break;
                            playlistCursor.setWaitForKeyFrame(false);
                        }
                        boolean bl6 = playlistCursor.isSendAbsVideoTC();
                        if (playlistCursor.isSendAbsVideoTC()) {
                            long l5 = playlistCursor.getForceVideoTC();
                            if (l5 >= 0L) {
                                this.chunkHeaderValues[2] = (int)(l5 + playlistCursor.getStartTCOffset());
                                l4 = l5;
                            } else {
                                this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + playlistCursor.getStartTCOffset());
                            }
                            if (this.chunkHeaderValues[2] < 0) break;
                            playlistCursor.setForceVideoTC(-1L);
                            playlistCursor.setSendAbsVideoTC(false);
                        } else {
                            this.chunkHeaderValues[2] = (int)(l4 - playlistCursor.getLastVideoTC() & 0xFFFFFFFFL);
                        }
                        boolean bl7 = playlistWriteControl.testVideoFrame(this.chunkHeaderValues[3]);
                        if (this.chunkHeaderValues[2] >= 0 && bl7) {
                            playlistCursor.setLastVideoTC(l4);
                            playlistCursor.incVideoPacketCount();
                            l3 = l4;
                            this.saveLastVideoPos = this.fileReader.getFilePointer();
                            this.saveLastVideoSize = this.chunkHeaderValues[1];
                            if (bl) {
                                this.chunkHeaderValues[2] = 0;
                            }
                            if ((long)n3 != playlistCursor.getVideoSampleDesc()) {
                                n6 = playlistCursor.compareAndSetVideoCodecConfig(this.videoCodecConfig);
                                if (n6 == 0 && (n5 = this.sendVideoTrakData(this.chunkHeaderValues[2], bl6, iMediaStream, outputStream, aMFObj2, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl, n3)) > 0) {
                                    bl6 = false;
                                    this.chunkHeaderValues[2] = 0;
                                }
                                playlistCursor.setVideoSampleDesc((long)n3);
                            }
                            n6 = this.directOutput((IRandomAccessReader)this.fileReader, this.chunkHeaderValues, bl6, iMediaStream.getSrc(), outputStream, aMFObj2, this.chunkWorkBuffer, n4);
                            n += n6;
                            bl5 = true;
                            playlistReaderWriteResults.incVideoPackets();
                            bl2 = true;
                            bl3 = true;
                            lArray[2] = lArray[2] + (long)n6;
                            lArray[3] = lArray[3] + 1L;
                            if (!bl6) break;
                            n6 = this.rewriteLastPacket(9, 0L, false, iMediaStream, outputStream, aMFObj2, playlistCursor, lArray, null);
                            n += n6;
                            playlistReaderWriteResults.incVideoPackets();
                            break;
                        }
                        if (bl7) break;
                        lArray[6] = lArray[6] + (long)this.chunkHeaderValues[1];
                        lArray[7] = lArray[7] + 1L;
                        break;
                    }
                    case 8: {
                        int n7;
                        int n5;
                        if (!iMediaStream.isReceiveAudio() || playlistWriteControl.isSkipAudio() || playlistWriteControl.isAudioFilter()) break;
                        int n6 = playlistCursor.isSendAbsAudioTC();
                        if (playlistCursor.isSendAbsAudioTC()) {
                            this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + playlistCursor.getStartTCOffset());
                            if (this.chunkHeaderValues[2] < 0) break;
                            playlistCursor.setSendAbsAudioTC(false);
                        } else {
                            this.chunkHeaderValues[2] = (int)(l4 - playlistCursor.getLastAudioTC() & 0xFFFFFFFFL);
                        }
                        if (this.chunkHeaderValues[2] < 0) break;
                        playlistCursor.setLastAudioTC(l4);
                        playlistCursor.incAudioPacketCount();
                        playlistCursor.setLastAudioWasZero(this.chunkHeaderValues[1] == 0);
                        l3 = l4;
                        this.saveLastAudioPos = this.fileReader.getFilePointer();
                        this.saveLastAudioSize = this.chunkHeaderValues[1];
                        if (bl) {
                            this.chunkHeaderValues[2] = 0;
                        }
                        if ((long)n3 != playlistCursor.getAudioSampleDesc()) {
                            n5 = playlistCursor.compareAndSetAudioCodecConfig(this.audioCodecConfig);
                            if (n5 == 0 && (n7 = this.sendAudioTrakData(this.chunkHeaderValues[2], n6 != 0, iMediaStream, outputStream, aMFObj, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl, n3)) > 0) {
                                n6 = 0;
                                this.chunkHeaderValues[2] = 0;
                            }
                            playlistCursor.setAudioSampleDesc((long)n3);
                        }
                        n5 = this.directOutput((IRandomAccessReader)this.fileReader, this.chunkHeaderValues, n6 != 0, iMediaStream.getSrc(), outputStream, aMFObj, this.chunkWorkBuffer, n4);
                        n += n5;
                        bl5 = true;
                        playlistReaderWriteResults.incAudioPackets();
                        bl2 = true;
                        bl4 = true;
                        lArray[0] = lArray[0] + (long)n5;
                        lArray[1] = lArray[1] + 1L;
                        break;
                    }
                    case 15: 
                    case 18: {
                        int n5 = playlistCursor.isSendAbsBroadcastTC();
                        if (playlistCursor.isSendAbsBroadcastTC()) {
                            this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + playlistCursor.getStartTCOffset());
                            if (this.chunkHeaderValues[2] < 0) break;
                            playlistCursor.setSendAbsBroadcastTC(false);
                        } else {
                            this.chunkHeaderValues[2] = (int)(l4 - playlistCursor.getLastBroadcastTC() & 0xFFFFFFFFL);
                        }
                        playlistCursor.setLastBroadcastTC(l4);
                        playlistCursor.incDataPacketCount();
                        l3 = l4;
                        this.saveLastBroadcastPos = this.fileReader.getFilePointer();
                        this.saveLastBroadcastSize = this.chunkHeaderValues[1];
                        if (bl) {
                            this.chunkHeaderValues[2] = 0;
                        }
                        int n7 = this.directOutput((IRandomAccessReader)this.fileReader, this.chunkHeaderValues, n5 != 0, iMediaStream.getSrc(), outputStream, aMFObj3, this.chunkWorkBuffer, n4);
                        n += n7;
                        lArray[4] = lArray[4] + (long)n7;
                        lArray[5] = lArray[5] + 1L;
                        bl5 = true;
                        break;
                    }
                }
                playlistReaderWriteResults.setLastTC(l4);
                ++n2;
                this.skipPacket(this.chunkHeaderValues, bl5, true, 1);
                if (l == 0L) {
                    if (bl3 || n2 > 20) {
                        break;
                    }
                } else if (l4 >= l) {
                    break;
                }
            }
        }
        playlistReaderWriteResults.setTotalSize(n);
        return n;
    }

    protected int writeGeneratedKeyFrameFastPlay(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        int n = 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writePacketsFastPlay(IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, AMFObj aMFObj2, AMFObj aMFObj3, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings, boolean bl) {
        int n = 0;
        double d = fastPlaySettings.getMultiplier();
        int n2 = fastPlaySettings.getDirection();
        long l = Math.round(1000.0 / (double)fastPlaySettings.getFps());
        long l2 = fastPlaySettings.getStartTC();
        this.fileReader.setDirecton(n2);
        if (n2 < 0) {
            playlistCursor.setVideoCanDFrame(false);
            playlistCursor.setVideoCanPFrame(false);
        }
        int n3 = playlistCursor.getWriteControl().getChunkSize();
        this.checkWorkBuffer(n3);
        long l3 = 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        long l4 = playlistWriteControl.getMaxTC();
        int n4 = 0;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                int n5;
                if (playlistCursor.isBreakLoop()) {
                    break;
                }
                long l5 = this.fileReader.getFilePointer();
                this.readChunkHeader((IRandomAccessReader)this.fileReader, this.chunkHeaderBuffer, this.chunkHeaderValues);
                if (this.chunkHeaderValues[0] == 127) {
                    playlistReaderWriteResults.setHitEnd(true);
                    break;
                }
                boolean bl5 = false;
                if ((long)this.chunkHeaderValues[1] > this.seekLargestFrame) {
                    this.seekLargestFrame = this.chunkHeaderValues[1];
                }
                long l6 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                switch (this.chunkHeaderValues[0]) {
                    case 9: {
                        long l7;
                        long l8;
                        n5 = FLVUtils.getFrameType((int)this.chunkHeaderValues[3]);
                        if (playlistCursor.isWaitForKeyFrame()) {
                            if (!FLVUtils.isVideoKeyFrame((int[])this.chunkHeaderValues)) break;
                            playlistCursor.setWaitForKeyFrame(false);
                        }
                        boolean bl6 = true;
                        boolean bl7 = playlistCursor.isSendAbsVideoTC();
                        boolean bl8 = playlistCursor.isSendAbsVideoTC();
                        if (bl7) {
                            l8 = playlistCursor.getForceVideoTC();
                            if (l8 >= 0L) {
                                this.chunkHeaderValues[2] = (int)(l8 + playlistCursor.getStartTCOffset());
                                l6 = l8;
                            } else {
                                this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + playlistCursor.getStartTCOffset());
                            }
                            if (this.chunkHeaderValues[2] < 0) break;
                            playlistCursor.setForceVideoTC(-1L);
                            playlistCursor.setSendAbsVideoTC(false);
                            playlistCursor.setLastVideoFastTC(l6);
                        } else {
                            l8 = playlistCursor.getLastVideoFastTC() - l2;
                            l7 = Math.round((double)Math.abs(l2 - l6) / d);
                            long l9 = l7 - l8;
                            boolean bl9 = bl6 = d <= 1.0 || l9 > l - 3L;
                            if (bl6 && n5 == 2 && !playlistCursor.isVideoCanPFrame() || n5 == 3 && !playlistCursor.isVideoCanDFrame()) {
                                bl6 = false;
                            }
                            if (bl6) {
                                this.chunkHeaderValues[2] = (int)(l9 & 0xFFFFFFFFL);
                                playlistCursor.incLastVideoFastTC(l9);
                            }
                        }
                        if (bl6) {
                            playlistCursor.setLastVideoTC(l6);
                            playlistCursor.incVideoPacketCount();
                            l3 = l6;
                            this.saveLastVideoPos = this.fileReader.getFilePointer();
                            this.saveLastVideoSize = this.chunkHeaderValues[1];
                            if (bl) {
                                this.chunkHeaderValues[2] = 0;
                            }
                            if ((long)n4 != playlistCursor.getVideoSampleDesc()) {
                                int n6 = this.sendVideoTrakData(this.chunkHeaderValues[2], bl8, iMediaStream, outputStream, aMFObj2, playlistCursor, playlistWriteControl, playlistReaderWriteResults, lArray, bl, n4);
                                if (n6 > 0) {
                                    bl8 = false;
                                    this.chunkHeaderValues[2] = 0;
                                }
                                playlistCursor.setVideoSampleDesc((long)n4);
                            }
                            int n7 = this.directOutput((IRandomAccessReader)this.fileReader, this.chunkHeaderValues, bl8, iMediaStream.getSrc(), outputStream, aMFObj2, this.chunkWorkBuffer, n3);
                            n += n7;
                            bl2 = true;
                            bl3 = true;
                            bl5 = true;
                            lArray[2] = lArray[2] + (long)n7;
                            lArray[3] = lArray[3] + 1L;
                            playlistReaderWriteResults.incVideoPackets();
                            if (bl8) {
                                n7 = this.rewriteLastPacket(9, 0L, false, iMediaStream, outputStream, aMFObj2, playlistCursor, lArray, fastPlaySettings);
                                n += n7;
                                playlistReaderWriteResults.incVideoPackets();
                            }
                            if (n2 <= 0) break;
                            playlistCursor.setVideoCanPFrame(true);
                            if (!FLVUtils.isVideoKeyFrame((int[])this.chunkHeaderValues)) break;
                            playlistCursor.setVideoCanDFrame(true);
                            break;
                        }
                        if (n2 <= 0) break;
                        playlistCursor.setVideoCanPFrame(false);
                        if (!FLVUtils.isVideoKeyFrame((int[])this.chunkHeaderValues)) break;
                        playlistCursor.setVideoCanDFrame(false);
                        break;
                    }
                    case 8: {
                        boolean bl10 = playlistCursor.isSendAbsAudioTC();
                        if (playlistCursor.isSendAbsAudioTC()) {
                            this.chunkHeaderValues[2] = (int)((long)this.chunkHeaderValues[2] + playlistCursor.getStartTCOffset());
                            if (this.chunkHeaderValues[2] < 0) break;
                            playlistCursor.setSendAbsAudioTC(false);
                            break;
                        }
                        this.chunkHeaderValues[2] = (int)(l6 - playlistCursor.getLastAudioTC() & 0xFFFFFFFFL);
                        break;
                    }
                    case 15: 
                    case 18: {
                        boolean bl11 = true;
                        long l7 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                        if ((l7 += playlistCursor.getStartTCOffset()) < 0L) break;
                        this.chunkHeaderValues[2] = (int)(playlistCursor.calcTCAdj(l7) & 0xFFFFFFFFL);
                        this.saveLastBroadcastPos = this.fileReader.getFilePointer();
                        this.saveLastBroadcastSize = this.chunkHeaderValues[1];
                        if (bl) {
                            this.chunkHeaderValues[2] = 0;
                        }
                        int n8 = this.directOutput((IRandomAccessReader)this.fileReader, this.chunkHeaderValues, bl11, iMediaStream.getSrc(), outputStream, aMFObj3, this.chunkWorkBuffer, n3);
                        n += n8;
                        playlistCursor.setLastBroadcastTC(l6);
                        playlistCursor.incDataPacketCount();
                        l3 = l6;
                        lArray[4] = lArray[4] + (long)n8;
                        lArray[5] = lArray[5] + 1L;
                        bl5 = true;
                        break;
                    }
                }
                playlistReaderWriteResults.setLastTC(l6);
                n5 = this.skipPacket(this.chunkHeaderValues, bl5, true, n2) ? 1 : 0;
                if (n5 == 0) {
                    playlistReaderWriteResults.setHitEnd(true);
                    break;
                }
                if (bl2 && (l4 == 0L || playlistCursor.calcTCAdj(l6) >= l4)) {
                    break;
                }
            }
        }
        playlistReaderWriteResults.setTotalSize(n);
        return n;
    }

    protected long findClosestPacket(IRandomAccessReader iRandomAccessReader, long l, long l2, SortedMap<Long, Long> sortedMap, int n, byte[] byArray, byte[] byArray2, int[] nArray) {
        long l3;
        long l4 = -1L;
        long l5 = iRandomAccessReader.length();
        long l6 = l5 - (l3 = (long)(13 + n));
        if (l6 < 0x300000L) {
            return -1L;
        }
        if (l2 <= 0L) {
            return -1L;
        }
        if (l < 0L) {
            l = 0L;
        }
        if (l > l2) {
            l = l2;
        }
        Long l7 = new Long(l);
        long l8 = 0L;
        long l9 = l3;
        SortedMap<Long, Long> sortedMap2 = sortedMap.headMap(l7);
        if (!sortedMap2.isEmpty()) {
            l8 = sortedMap2.lastKey();
            l9 = (Long)sortedMap2.get(sortedMap2.lastKey());
        }
        long l10 = l2;
        long l11 = l5;
        SortedMap<Long, Long> sortedMap3 = sortedMap.tailMap(l7);
        if (!sortedMap3.isEmpty()) {
            l10 = sortedMap3.firstKey();
            l11 = (Long)sortedMap3.get(sortedMap3.firstKey());
        }
        boolean bl = l10 - l8 > 1000L;
        double d = (double)(l - l8) / (double)(l10 - l8);
        double d2 = (double)l / (double)l2;
        long l12 = l9 + Math.round((double)(l11 - l9) * d);
        if (l12 + this.seekLargestFrame > l5) {
            l12 = l5 - this.seekLargestFrame;
        }
        int n2 = 14;
        block0: do {
            iRandomAccessReader.seek(l12);
            iRandomAccessReader.read(byArray, 0, byArray.length);
            for (int i = 0; i < byArray.length - n2; ++i) {
                Long l13;
                long l14;
                long l15;
                if (byArray[i] != 8 && byArray[i] != 9 && byArray[i] != 18 && byArray[i] != 15) continue;
                int n3 = 0;
                n3 = byArray[i + 1] & 0xFF;
                n3 <<= 8;
                n3 |= byArray[i + 2] & 0xFF;
                n3 <<= 8;
                if ((n3 |= byArray[i + 3] & 0xFF) < 0 || (long)n3 > this.seekLargestFrame || (l15 = l12 + (long)i + 11L + (long)n3) + 4L > l5) continue;
                iRandomAccessReader.seek(l15);
                iRandomAccessReader.read(byArray2, 0, 4);
                int n4 = 0;
                n4 = byArray2[0] & 0xFF;
                n4 <<= 8;
                n4 |= byArray2[1] & 0xFF;
                n4 <<= 8;
                n4 |= byArray2[2] & 0xFF;
                n4 <<= 8;
                if ((n4 |= byArray2[3] & 0xFF) != n3 + 11) continue;
                l15 = l12 + (long)i;
                boolean bl2 = false;
                iRandomAccessReader.seek(l15 + (long)n4 + 4L);
                if (d2 < 0.5) {
                    this.readChunkHeader(iRandomAccessReader, byArray2, nArray);
                } else {
                    MediaReaderFLV.readPrevChunkHeader(iRandomAccessReader, byArray2, nArray);
                }
                if (nArray[0] != 127 && (l14 = iRandomAccessReader.getFilePointer()) + (long)nArray[1] + 4L <= l5) {
                    iRandomAccessReader.seek(l14 + (long)nArray[1]);
                    iRandomAccessReader.read(byArray2, 0, 4);
                    int n5 = 0;
                    n5 = byArray2[0] & 0xFF;
                    n5 <<= 8;
                    n5 |= byArray2[1] & 0xFF;
                    n5 <<= 8;
                    n5 |= byArray2[2] & 0xFF;
                    n5 <<= 8;
                    boolean bl3 = bl2 = nArray[1] + 11 == (n5 |= byArray2[3] & 0xFF);
                }
                if (!bl2) continue;
                l4 = l12 + (long)i;
                l14 = 0L;
                l14 |= (long)(byArray[i + 7] & 0xFF);
                l14 <<= 8;
                l14 |= (long)(byArray[i + 4] & 0xFF);
                l14 <<= 8;
                l14 |= (long)(byArray[i + 5] & 0xFF);
                l14 <<= 8;
                if (!bl || sortedMap.containsKey(l13 = new Long(l14 |= (long)(byArray[i + 6] & 0xFF)))) continue block0;
                sortedMap.put(new Long(l14), new Long(l4));
                continue block0;
            }
        } while (l4 == -1L && (l12 += (long)(byArray.length - n2)) + (long)byArray.length <= l5);
        return l4;
    }

    protected void readChunkHeader(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray) {
        nArray[0] = 127;
        if (iRandomAccessReader == null) {
            return;
        }
        long l = 0L;
        try {
            l = iRandomAccessReader.getFilePointer();
            int n = 13;
            int n2 = iRandomAccessReader.read(byArray, 0, n);
            if (n2 == n) {
                nArray[0] = byArray[0] & 0xFF;
                nArray[1] = byArray[1] & 0xFF;
                nArray[1] = nArray[1] << 8;
                nArray[1] = nArray[1] | byArray[2] & 0xFF;
                nArray[1] = nArray[1] << 8;
                nArray[1] = nArray[1] | byArray[3] & 0xFF;
                nArray[2] = byArray[7] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[4] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[5] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[6] & 0xFF;
                nArray[3] = byArray[11];
                nArray[4] = byArray[12];
            }
            iRandomAccessReader.seek(l + 11L);
        }
        catch (Exception exception) {
            nArray[0] = 127;
        }
    }

    public static void readPrevChunkHeader(IRandomAccessReader iRandomAccessReader, byte[] byArray, int[] nArray) {
        nArray[0] = 127;
        if (iRandomAccessReader == null) {
            return;
        }
        try {
            iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() - 4L);
            iRandomAccessReader.read(byArray, 0, 4);
            int n = BufferUtils.byteArrayToInt((byte[])byArray, (int)0, (int)4, (boolean)false);
            if (n > 0) {
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() - (long)(n + 4));
                iRandomAccessReader.read(byArray, 0, 13);
                nArray[0] = byArray[0] & 0xFF;
                nArray[1] = byArray[1] & 0xFF;
                nArray[1] = nArray[1] << 8;
                nArray[1] = nArray[1] | byArray[2] & 0xFF;
                nArray[1] = nArray[1] << 8;
                nArray[1] = nArray[1] | byArray[3] & 0xFF;
                nArray[2] = byArray[7] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[4] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[5] & 0xFF;
                nArray[2] = nArray[2] << 8;
                nArray[2] = nArray[2] | byArray[6] & 0xFF;
                nArray[3] = byArray[11] & 0xFF;
                nArray[4] = byArray[12] & 0xFF;
                iRandomAccessReader.seek(iRandomAccessReader.getFilePointer() - 2L);
            }
        }
        catch (Exception exception) {
            nArray[0] = 127;
        }
    }

    protected AMFPacket createPacket(IRandomAccessReader iRandomAccessReader, int[] nArray) {
        int n = nArray[1];
        int n2 = nArray[0];
        AMFPacket aMFPacket = new AMFPacket(n2, 0, n);
        try {
            byte[] byArray = aMFPacket.getData();
            int n3 = iRandomAccessReader.read(byArray, 0, n);
            if (n3 != byArray.length) {
                WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.createPacket: problem reading input file: " + n3 + ":" + n);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.createPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return aMFPacket;
    }

    protected int directOutput(IRandomAccessReader iRandomAccessReader, int[] nArray, boolean bl, int n, OutputStream outputStream, AMFObj aMFObj, byte[] byArray, int n2) {
        int n3 = 0;
        IFasterByteArrayWriteControl iFasterByteArrayWriteControl = outputStream instanceof IFasterByteArrayWriteControl ? (IFasterByteArrayWriteControl)outputStream : null;
        try {
            int n4;
            int n5;
            long l = (long)nArray[2] & 0xFFFFFFFFL;
            int n6 = nArray[1];
            int n7 = nArray[0];
            if (iFasterByteArrayWriteControl != null) {
                iFasterByteArrayWriteControl.writeControl(n, true, 3, null);
            }
            int n8 = aMFObj.getId();
            boolean bl2 = aMFObj.isNew();
            boolean bl3 = bl2 | bl;
            aMFObj.setNew(false);
            int n9 = 1;
            byArray[0] = (byte)(0xFF & n8);
            if (bl3 || aMFObj.getSrc() != n) {
                byArray[8] = (byte)(0xFF & n);
                byArray[9] = (byte)(0xFF & n >> 8);
                byArray[10] = (byte)(0xFF & n >> 16);
                byArray[11] = (byte)(0xFF & n >> 24);
                aMFObj.setSrc(n);
                n9 += 4;
                bl3 = true;
            }
            if (bl3 || aMFObj.getSize() != n6) {
                byArray[4] = (byte)(0xFF & n6 >> 16);
                byArray[5] = (byte)(0xFF & n6 >> 8);
                byArray[6] = (byte)(0xFF & n6);
                byArray[7] = (byte)n7;
                aMFObj.setSize(n6);
                aMFObj.setType(n7);
                n9 += 4;
                bl3 = true;
            }
            boolean bl4 = false;
            if (bl3 || aMFObj.getTimecode() != l) {
                if (l >= 0xFFFFFFL) {
                    byArray[1] = -1;
                    byArray[2] = -1;
                    byArray[3] = -1;
                    bl4 = true;
                } else {
                    byArray[1] = (byte)(0xFFL & l >> 16);
                    byArray[2] = (byte)(0xFFL & l >> 8);
                    byArray[3] = (byte)(0xFFL & l);
                }
                aMFObj.setTimecode(l);
                n9 += 3;
                bl3 = true;
            }
            if (n8 >= 64) {
                n5 = n8 - 64;
                n4 = n5 > 255 ? 3 : 2;
                byte[] byArray2 = new byte[n4];
                switch (n9) {
                    case 12: {
                        byArray2[0] = (byte)(0 + (n4 - 2));
                        break;
                    }
                    case 8: {
                        byArray2[0] = (byte)(64 + (n4 - 2));
                        break;
                    }
                    case 4: {
                        byArray2[0] = (byte)(128 + (n4 - 2));
                        break;
                    }
                    case 1: {
                        byArray2[0] = (byte)(192 + (n4 - 2));
                    }
                }
                byArray2[1] = (byte)(0xFF & n5);
                if (n4 == 3) {
                    byArray2[2] = (byte)(0xFF & n5 >> 8);
                }
                outputStream.write(byArray2, 0, n4);
                outputStream.write(byArray, 1, n9 - 1);
                n3 += n9 + 1;
            } else {
                switch (n9) {
                    case 12: {
                        break;
                    }
                    case 8: {
                        byArray[0] = (byte)(byArray[0] | 0x40);
                        break;
                    }
                    case 4: {
                        byArray[0] = (byte)(byArray[0] | 0x80);
                        break;
                    }
                    case 1: {
                        byArray[0] = (byte)(byArray[0] | 0xC0);
                    }
                }
                outputStream.write(byArray, 0, n9);
                n3 += n9;
            }
            if (bl4) {
                byArray[0] = (byte)(0xFFL & l >> 24);
                byArray[1] = (byte)(0xFFL & l >> 16);
                byArray[2] = (byte)(0xFFL & l >> 8);
                byArray[3] = (byte)(0xFFL & l);
                outputStream.write(byArray, 0, 4);
                n3 = 4;
            }
            if (n6 > 0) {
                if (!bl4 && this.directWriter != null) {
                    n3 += this.directWriter.write((IFasterByteArrayOutputStream)outputStream, 0, n6, n8, n2);
                } else {
                    n5 = n6;
                    n4 = 0;
                    int n10 = 0;
                    do {
                        int n11;
                        if (n4 > 0) {
                            if (n8 >= 64) {
                                n11 = n8 - 64;
                                int n12 = n11 > 255 ? 3 : 2;
                                byArray[0] = (byte)(192 + (n12 - 2));
                                byArray[1] = (byte)(0xFF & n11);
                                if (n12 == 3) {
                                    byArray[2] = (byte)(0xFF & n11 >> 8);
                                }
                                outputStream.write(byArray, 0, n12);
                                n3 += n12;
                            } else {
                                byArray[0] = (byte)(0xFF & n8 | 0xC0);
                                outputStream.write(byArray, 0, 1);
                                ++n3;
                            }
                            if (bl4) {
                                byArray[0] = (byte)(0xFFL & l >> 24);
                                byArray[1] = (byte)(0xFFL & l >> 16);
                                byArray[2] = (byte)(0xFFL & l >> 8);
                                byArray[3] = (byte)(0xFFL & l);
                                outputStream.write(byArray, 0, 4);
                                n3 = 4;
                            }
                        }
                        if ((n10 = n2) > n5 - n4) {
                            n10 = n5 - n4;
                        }
                        try {
                            n11 = iRandomAccessReader.read(byArray, 0, n10);
                            if (n11 != n10) {
                                WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("problem reading input file: " + n11 + ":" + n10);
                            }
                            outputStream.write(byArray, 0, n10);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.directOutput: Problem reading input file: " + exception.toString());
                        }
                        n3 += n10;
                    } while ((n4 += n10) != n5);
                }
            }
            if (iFasterByteArrayWriteControl != null) {
                iFasterByteArrayWriteControl.writeControl(n, false, 3, null);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.directOutput: " + exception.toString());
            exception.printStackTrace();
        }
        return n3;
    }

    protected int directOutputBuf(int[] nArray, boolean bl, int n, OutputStream outputStream, AMFObj aMFObj, byte[] byArray, int n2, byte[] byArray2) {
        int n3 = 0;
        IFasterByteArrayWriteControl iFasterByteArrayWriteControl = outputStream instanceof IFasterByteArrayWriteControl ? (IFasterByteArrayWriteControl)outputStream : null;
        try {
            int n4;
            int n5;
            long l = (long)nArray[2] & 0xFFFFFFFFL;
            int n6 = nArray[1];
            int n7 = nArray[0];
            if (iFasterByteArrayWriteControl != null) {
                iFasterByteArrayWriteControl.writeControl(n, true, 3, null);
            }
            int n8 = aMFObj.getId();
            boolean bl2 = aMFObj.isNew();
            boolean bl3 = bl2 | bl;
            aMFObj.setNew(false);
            int n9 = 1;
            byArray[0] = (byte)(0xFF & n8);
            if (bl3 || aMFObj.getSrc() != n) {
                byArray[8] = (byte)(0xFF & n);
                byArray[9] = (byte)(0xFF & n >> 8);
                byArray[10] = (byte)(0xFF & n >> 16);
                byArray[11] = (byte)(0xFF & n >> 24);
                aMFObj.setSrc(n);
                n9 += 4;
                bl3 = true;
            }
            if (bl3 || aMFObj.getSize() != n6) {
                byArray[4] = (byte)(0xFF & n6 >> 16);
                byArray[5] = (byte)(0xFF & n6 >> 8);
                byArray[6] = (byte)(0xFF & n6);
                byArray[7] = (byte)n7;
                aMFObj.setSize(n6);
                aMFObj.setType(n7);
                n9 += 4;
                bl3 = true;
            }
            boolean bl4 = false;
            if (bl3 || aMFObj.getTimecode() != l) {
                if (l >= 0xFFFFFFL) {
                    byArray[1] = -1;
                    byArray[2] = -1;
                    byArray[3] = -1;
                    bl4 = true;
                } else {
                    byArray[1] = (byte)(0xFFL & l >> 16);
                    byArray[2] = (byte)(0xFFL & l >> 8);
                    byArray[3] = (byte)(0xFFL & l);
                }
                aMFObj.setTimecode(l);
                n9 += 3;
                bl3 = true;
            }
            if (n8 >= 64) {
                n5 = n8 - 64;
                n4 = n5 > 255 ? 3 : 2;
                byte[] byArray3 = new byte[n4];
                switch (n9) {
                    case 12: {
                        byArray3[0] = (byte)(0 + (n4 - 2));
                        break;
                    }
                    case 8: {
                        byArray3[0] = (byte)(64 + (n4 - 2));
                        break;
                    }
                    case 4: {
                        byArray3[0] = (byte)(128 + (n4 - 2));
                        break;
                    }
                    case 1: {
                        byArray3[0] = (byte)(192 + (n4 - 2));
                    }
                }
                byArray3[1] = (byte)(0xFF & n5);
                if (n4 == 3) {
                    byArray3[2] = (byte)(0xFF & n5 >> 8);
                }
                outputStream.write(byArray3, 0, n4);
                outputStream.write(byArray, 1, n9 - 1);
                n3 += n9 + 1;
            } else {
                switch (n9) {
                    case 12: {
                        break;
                    }
                    case 8: {
                        byArray[0] = (byte)(byArray[0] | 0x40);
                        break;
                    }
                    case 4: {
                        byArray[0] = (byte)(byArray[0] | 0x80);
                        break;
                    }
                    case 1: {
                        byArray[0] = (byte)(byArray[0] | 0xC0);
                    }
                }
                outputStream.write(byArray, 0, n9);
                n3 += n9;
            }
            if (bl4) {
                byArray[0] = (byte)(0xFFL & l >> 24);
                byArray[1] = (byte)(0xFFL & l >> 16);
                byArray[2] = (byte)(0xFFL & l >> 8);
                byArray[3] = (byte)(0xFFL & l);
                outputStream.write(byArray, 0, 4);
                n3 = 4;
            }
            if (n6 > 0) {
                n5 = n6;
                n4 = 0;
                int n10 = 0;
                do {
                    if (n4 > 0) {
                        if (n8 >= 64) {
                            int n11 = n8 - 64;
                            int n12 = n11 > 255 ? 3 : 2;
                            byArray[0] = (byte)(192 + (n12 - 2));
                            byArray[1] = (byte)(0xFF & n11);
                            if (n12 == 3) {
                                byArray[2] = (byte)(0xFF & n11 >> 8);
                            }
                            outputStream.write(byArray, 0, n12);
                            n3 += n12;
                        } else {
                            byArray[0] = (byte)(0xFF & n8 | 0xC0);
                            outputStream.write(byArray, 0, 1);
                            ++n3;
                        }
                        if (bl4) {
                            byArray[0] = (byte)(0xFFL & l >> 24);
                            byArray[1] = (byte)(0xFFL & l >> 16);
                            byArray[2] = (byte)(0xFFL & l >> 8);
                            byArray[3] = (byte)(0xFFL & l);
                            outputStream.write(byArray, 0, 4);
                            n3 = 4;
                        }
                    }
                    if ((n10 = n2) > n5 - n4) {
                        n10 = n5 - n4;
                    }
                    try {
                        outputStream.write(byArray2, n4, n10);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.directOutputBuf: problem reading input file: " + exception.toString());
                    }
                    n3 += n10;
                } while ((n4 += n10) != n5);
            }
            if (iFasterByteArrayWriteControl != null) {
                iFasterByteArrayWriteControl.writeControl(n, false, 3, null);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaReaderFLV.class).error("MediaReaderFLV.directOutputBuf: " + exception.toString());
            exception.printStackTrace();
        }
        return n3;
    }

    public long getDuration() {
        if (this.duration == -1L) {
            IRandomAccessReader iRandomAccessReader = null;
            try {
                iRandomAccessReader = RandomAccessReaderFactory.createInstance((IApplicationInstance)this.appInstance, (String)this.randomAccessReaderClass, (String)this.basePath, (String)this.mediaName, (String)this.mediaExtension, (IMediaStream)this.stream);
                iRandomAccessReader.open();
                this.readMetadata(iRandomAccessReader);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (iRandomAccessReader != null) {
                try {
                    iRandomAccessReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            iRandomAccessReader = null;
        }
        return this.duration == -1L ? 0L : this.duration;
    }

    public long getLength() {
        return this.fileReader != null ? this.fileReader.length() : 0L;
    }

    public String getPath() {
        return this.fileReader.getPath();
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public MediaReaderItem getMediaReaderItem() {
        return this.mediaReaderItem;
    }

    public int sendZeroLengthPacket(int n, int n2, boolean bl, IMediaStream iMediaStream, OutputStream outputStream, AMFObj aMFObj, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, boolean bl2) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writePackets(List<AMFPacket> list, PlaylistCursor playlistCursor, PlaylistWriteControl playlistWriteControl, PlaylistReaderWriteResults playlistReaderWriteResults, long[] lArray, FastPlaySettings fastPlaySettings) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        long l = playlistWriteControl.getMaxTC();
        int n3 = 0;
        this.fileReader.setDirecton(1);
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (playlistCursor.isBreakLoop()) {
                    break;
                }
                long l2 = this.fileReader.getFilePointer();
                this.readChunkHeader((IRandomAccessReader)this.fileReader, this.chunkHeaderBuffer, this.chunkHeaderValues);
                if (this.chunkHeaderValues[0] == 127) {
                    playlistReaderWriteResults.setHitEnd(true);
                    break;
                }
                long l3 = (long)this.chunkHeaderValues[2] & 0xFFFFFFFFL;
                if (l > 0L && l3 > l) {
                    this.fileReader.seek(l2);
                    break;
                }
                if ((long)this.chunkHeaderValues[1] > this.seekLargestFrame) {
                    this.seekLargestFrame = this.chunkHeaderValues[1];
                }
                boolean bl2 = false;
                switch (this.chunkHeaderValues[0]) {
                    case 9: {
                        int n4;
                        boolean bl3;
                        if (!this.stream.isReceiveVideo()) break;
                        if (playlistCursor.isWaitForKeyFrame()) {
                            if (!FLVUtils.isVideoKeyFrame((int[])this.chunkHeaderValues)) break;
                            playlistCursor.setWaitForKeyFrame(false);
                        }
                        if (bl3 = playlistWriteControl.testVideoFrame(this.chunkHeaderValues[3])) {
                            playlistCursor.setLastVideoTC(l3);
                            playlistCursor.incVideoPacketCount();
                            this.saveLastVideoPos = this.fileReader.getFilePointer();
                            this.saveLastVideoSize = this.chunkHeaderValues[1];
                            if ((long)n3 != playlistCursor.getVideoSampleDesc()) {
                                boolean bl4 = playlistCursor.compareAndSetVideoCodecConfig(this.videoCodecConfig);
                                if (!bl4 && this.audioCodecConfig != null && this.videoCodecConfig != null) {
                                    AMFPacket aMFPacket = new AMFPacket(9, 0, this.videoCodecConfig.length);
                                    aMFPacket.addData(this.videoCodecConfig, 0, this.videoCodecConfig.length);
                                    aMFPacket.setAbsTimecode(l3);
                                    list.add(aMFPacket);
                                    int n5 = aMFPacket.getSize();
                                    n += n5;
                                    playlistReaderWriteResults.incVideoPackets();
                                    lArray[2] = lArray[2] + (long)n5;
                                    lArray[3] = lArray[3] + 1L;
                                }
                                playlistCursor.setVideoSampleDesc((long)n3);
                            }
                            AMFPacket aMFPacket = this.createPacket((IRandomAccessReader)this.fileReader, this.chunkHeaderValues);
                            aMFPacket.setAbsTimecode(l3);
                            list.add(aMFPacket);
                            n4 = aMFPacket.getSize();
                            n += n4;
                            bl2 = true;
                            playlistReaderWriteResults.incVideoPackets();
                            bl = true;
                            lArray[2] = lArray[2] + (long)n4;
                            lArray[3] = lArray[3] + 1L;
                            break;
                        }
                        if (bl3) break;
                        lArray[6] = lArray[6] + (long)this.chunkHeaderValues[1];
                        lArray[7] = lArray[7] + 1L;
                        break;
                    }
                    case 8: {
                        int n4;
                        boolean bl3;
                        if (!this.stream.isReceiveAudio() || playlistWriteControl.isSkipAudio() || playlistWriteControl.isAudioFilter()) break;
                        playlistCursor.setLastAudioTC(l3);
                        playlistCursor.incAudioPacketCount();
                        playlistCursor.setLastAudioWasZero(this.chunkHeaderValues[1] == 0);
                        this.saveLastAudioPos = this.fileReader.getFilePointer();
                        this.saveLastAudioSize = this.chunkHeaderValues[1];
                        if ((long)n3 != playlistCursor.getAudioSampleDesc()) {
                            bl3 = playlistCursor.compareAndSetAudioCodecConfig(this.audioCodecConfig);
                            if (!bl3 && this.audioCodecConfig != null) {
                                AMFPacket aMFPacket = new AMFPacket(8, 0, this.audioCodecConfig.length);
                                aMFPacket.addData(this.audioCodecConfig, 0, this.audioCodecConfig.length);
                                aMFPacket.setAbsTimecode(l3);
                                list.add(aMFPacket);
                                n4 = aMFPacket.getSize();
                                n += n4;
                                playlistReaderWriteResults.incAudioPackets();
                                lArray[0] = lArray[0] + (long)n4;
                                lArray[1] = lArray[1] + 1L;
                            }
                            playlistCursor.setAudioSampleDesc((long)n3);
                        }
                        AMFPacket aMFPacket = this.createPacket((IRandomAccessReader)this.fileReader, this.chunkHeaderValues);
                        aMFPacket.setAbsTimecode(l3);
                        list.add(aMFPacket);
                        int n6 = aMFPacket.getSize();
                        n += n6;
                        bl2 = true;
                        playlistReaderWriteResults.incAudioPackets();
                        lArray[0] = lArray[0] + (long)n6;
                        lArray[1] = lArray[1] + 1L;
                        break;
                    }
                    case 15: 
                    case 18: {
                        playlistCursor.setLastBroadcastTC(l3);
                        playlistCursor.incDataPacketCount();
                        this.saveLastBroadcastPos = this.fileReader.getFilePointer();
                        this.saveLastBroadcastSize = this.chunkHeaderValues[1];
                        AMFPacket aMFPacket = this.createPacket((IRandomAccessReader)this.fileReader, this.chunkHeaderValues);
                        aMFPacket.setAbsTimecode(l3);
                        list.add(aMFPacket);
                        int n7 = aMFPacket.getSize();
                        n += n7;
                        lArray[4] = lArray[4] + (long)n7;
                        lArray[5] = lArray[5] + 1L;
                        bl2 = true;
                        break;
                    }
                }
                playlistReaderWriteResults.setLastTC(l3);
                ++n2;
                this.skipPacket(this.chunkHeaderValues, bl2, true, 1);
                if (l == 0L) {
                    if (bl || n2 > 20) {
                        break;
                    }
                } else if (l3 > l) {
                    break;
                }
            }
        }
        playlistReaderWriteResults.setTotalSize(n);
        return n;
    }
}

