/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.LiveStreamPacketizerSanJose;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.SanJoseRepeaterHolderSerialized;
import com.wowza.wms.httpstreamer.sanjosestreaming.livestreampacketizer.SanJoseTSHolder;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class SanJoseRepeaterHolder {
    public static final int REPEATER_START = 1;
    public static final int REPEATER_END = 2;
    public static final int REPEATER_TS = 3;
    public static final int REPEATER_RESET = 4;
    public static final int REPEATER_SETCODECINFOVIDEO = 5;
    public static final int REPEATER_SETCODECINFOAUDIO = 6;
    public static final int REPEATER_METADATA = 7;
    public static final int REPEATER_MSG = 100;
    private int chunkId = 0;
    private int streamMode = 0;
    private int videoCodec = 0;
    private int audioCodec = 0;
    private long timecode = 0L;
    private SanJoseTSHolder holder = null;
    private long sequence = 0L;
    private int repeaterType = 0;
    private String encUrl = "";
    private byte[] encRepeaterBytes = null;
    private String repeaterMessage = null;
    private MediaCodecInfoVideo codecInfoVideo = null;
    private MediaCodecInfoAudio codecInfoAudio = null;

    public SanJoseRepeaterHolder() {
    }

    public SanJoseRepeaterHolder(long l, int n, int n2, int n3, int n4, String string, long l2, byte[] byArray) {
        this.sequence = l;
        this.chunkId = n;
        this.streamMode = n2;
        this.videoCodec = n3;
        this.audioCodec = n4;
        this.encUrl = string;
        this.timecode = l2;
        this.encRepeaterBytes = byArray;
        this.repeaterType = 1;
    }

    public SanJoseRepeaterHolder(long l, int n, long l2) {
        this.sequence = l;
        this.chunkId = n;
        this.timecode = l2;
        this.repeaterType = 2;
    }

    public SanJoseRepeaterHolder(long l, int n, SanJoseTSHolder sanJoseTSHolder) {
        this.sequence = l;
        this.chunkId = n;
        this.holder = sanJoseTSHolder;
        this.timecode = sanJoseTSHolder.getTimecode();
        this.repeaterType = 3;
    }

    public SanJoseRepeaterHolder(long l) {
        this.sequence = l;
        this.repeaterType = 4;
    }

    public static String repeaterTypeToString(int n) {
        String string = "REPEATER_UNKNOWN";
        switch (n) {
            case 1: {
                string = "REPEATER_START";
                break;
            }
            case 2: {
                string = "REPEATER_END";
                break;
            }
            case 3: {
                string = "REPEATER_TS";
                break;
            }
            case 4: {
                string = "REPEATER_RESET";
                break;
            }
            case 5: {
                string = "REPEATER_SETCODECINFOVIDEO";
                break;
            }
            case 6: {
                string = "REPEATER_SETCODECINFOAUDIO";
                break;
            }
            case 7: {
                string = "REPEATER_METADATA";
                break;
            }
            case 100: {
                string = "REPEATER_MSG";
            }
        }
        return string;
    }

    public static SanJoseRepeaterHolder deserialize(byte[] byArray, int n, int n2) {
        SanJoseRepeaterHolder sanJoseRepeaterHolder = new SanJoseRepeaterHolder();
        int n3 = -1;
        try {
            if (n2 >= 4) {
                int n4 = 0;
                int n5 = BufferUtils.byteArrayToInt((byte[])byArray, (int)(n + n4), (int)2);
                if (n5 > n2 - (n4 += 2)) {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("SanJoseRepeaterHolder.deserialize: Bad header size: " + n5 + ":" + n2);
                } else {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n + n4, n5);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    n4 += n5;
                    byte by = dataInputStream.readByte();
                    byte by2 = dataInputStream.readByte();
                    n3 = by2;
                    sanJoseRepeaterHolder.repeaterType = by2;
                    sanJoseRepeaterHolder.timecode = dataInputStream.readLong();
                    sanJoseRepeaterHolder.sequence = dataInputStream.readLong();
                    sanJoseRepeaterHolder.chunkId = dataInputStream.readInt();
                    switch (sanJoseRepeaterHolder.repeaterType) {
                        case 1: {
                            sanJoseRepeaterHolder.streamMode = dataInputStream.readInt();
                            sanJoseRepeaterHolder.videoCodec = dataInputStream.readInt();
                            sanJoseRepeaterHolder.audioCodec = dataInputStream.readInt();
                            sanJoseRepeaterHolder.encUrl = dataInputStream.readUTF();
                            short s = dataInputStream.readShort();
                            if (s <= 0) break;
                            sanJoseRepeaterHolder.encRepeaterBytes = new byte[s];
                            dataInputStream.read(sanJoseRepeaterHolder.encRepeaterBytes);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 5: {
                            sanJoseRepeaterHolder.codecInfoVideo = new MediaCodecInfoVideo();
                            int n6 = dataInputStream.readInt();
                            if (n6 <= 0) break;
                            byte[] byArray2 = new byte[n6];
                            dataInputStream.read(byArray2);
                            sanJoseRepeaterHolder.codecInfoVideo.deserialize(byArray2, 0, n6);
                            break;
                        }
                        case 6: {
                            sanJoseRepeaterHolder.codecInfoAudio = new MediaCodecInfoAudio();
                            int n7 = dataInputStream.readInt();
                            if (n7 <= 0) break;
                            byte[] byArray3 = new byte[n7];
                            dataInputStream.read(byArray3);
                            sanJoseRepeaterHolder.codecInfoAudio.deserialize(byArray3, 0, n7);
                            break;
                        }
                        case 3: 
                        case 7: {
                            byte by3 = dataInputStream.readByte();
                            int n8 = dataInputStream.readInt();
                            byte by4 = dataInputStream.readByte();
                            boolean bl = dataInputStream.readByte() != 0;
                            sanJoseRepeaterHolder.holder = new SanJoseTSHolder(by3, by4, byArray, n + n4, n2 - n4, sanJoseRepeaterHolder.timecode);
                            sanJoseRepeaterHolder.holder.setKey(bl);
                            sanJoseRepeaterHolder.holder.setDuration(n8);
                            break;
                        }
                        case 100: {
                            sanJoseRepeaterHolder.repeaterMessage = dataInputStream.readUTF();
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("SanJoseRepeaterHolder.deserialize: " + exception.toString());
            sanJoseRepeaterHolder = null;
        }
        return sanJoseRepeaterHolder;
    }

    public static SanJoseRepeaterHolder createRepeaterMessage(String string) {
        SanJoseRepeaterHolder sanJoseRepeaterHolder = new SanJoseRepeaterHolder();
        sanJoseRepeaterHolder.setRepeaterType(100);
        sanJoseRepeaterHolder.setRepeaterMessage(string);
        return sanJoseRepeaterHolder;
    }

    public SanJoseRepeaterHolderSerialized serialize() {
        SanJoseRepeaterHolderSerialized sanJoseRepeaterHolderSerialized = new SanJoseRepeaterHolderSerialized();
        sanJoseRepeaterHolderSerialized.timecode = this.timecode;
        sanJoseRepeaterHolderSerialized.type = this.repeaterType;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeByte(this.repeaterType);
            dataOutputStream.writeLong(this.timecode);
            dataOutputStream.writeLong(this.sequence);
            dataOutputStream.writeInt(this.chunkId);
            switch (this.repeaterType) {
                case 1: {
                    sanJoseRepeaterHolderSerialized.type = 9;
                    dataOutputStream.writeInt(this.streamMode);
                    dataOutputStream.writeInt(this.videoCodec);
                    dataOutputStream.writeInt(this.audioCodec);
                    dataOutputStream.writeUTF(this.encUrl);
                    if (this.encRepeaterBytes != null) {
                        dataOutputStream.writeShort(this.encRepeaterBytes.length);
                        dataOutputStream.write(this.encRepeaterBytes);
                        break;
                    }
                    dataOutputStream.writeShort(0);
                    break;
                }
                case 2: {
                    sanJoseRepeaterHolderSerialized.type = 9;
                    break;
                }
                case 5: {
                    byte[] byArray;
                    int n;
                    sanJoseRepeaterHolderSerialized.type = 9;
                    if (this.codecInfoVideo != null) {
                        n = this.codecInfoVideo.getSerializeSize();
                        dataOutputStream.writeInt(n);
                        byArray = new byte[n];
                        this.codecInfoVideo.serialize(byArray, 0);
                        dataOutputStream.write(byArray);
                        break;
                    }
                    dataOutputStream.writeInt(0);
                    break;
                }
                case 6: {
                    byte[] byArray;
                    int n;
                    sanJoseRepeaterHolderSerialized.type = 9;
                    if (this.codecInfoAudio != null) {
                        n = this.codecInfoAudio.getSerializeSize();
                        dataOutputStream.writeInt(n);
                        byArray = new byte[n];
                        this.codecInfoAudio.serialize(byArray, 0);
                        dataOutputStream.write(byArray);
                        break;
                    }
                    dataOutputStream.writeInt(0);
                    break;
                }
                case 3: 
                case 7: {
                    sanJoseRepeaterHolderSerialized.type = 9;
                    dataOutputStream.writeByte(this.holder.getType());
                    dataOutputStream.writeInt(this.holder.getDuration());
                    dataOutputStream.writeByte(this.holder.getCodec());
                    dataOutputStream.writeByte(this.holder.isKey() ? 1 : 0);
                    sanJoseRepeaterHolderSerialized.data = this.holder.getBlock();
                    sanJoseRepeaterHolderSerialized.doffset = this.holder.getOffset();
                    sanJoseRepeaterHolderSerialized.dlen = this.holder.getLen();
                    break;
                }
                case 100: {
                    dataOutputStream.writeUTF(this.repeaterMessage);
                    break;
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n = byArray.length;
            BufferUtils.intToByteArray((int)(n - 2), (byte[])byArray, (int)0, (int)2);
            sanJoseRepeaterHolderSerialized.header = byArray;
            sanJoseRepeaterHolderSerialized.hoffset = 0;
            sanJoseRepeaterHolderSerialized.hlen = n;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSanJose.class).error("SanJoseRepeaterHolder.serialize: " + exception.toString());
        }
        return sanJoseRepeaterHolderSerialized;
    }

    public int getChunkId() {
        return this.chunkId;
    }

    public void setChunkId(int n) {
        this.chunkId = n;
    }

    public int getStreamMode() {
        return this.streamMode;
    }

    public void setStreamMode(int n) {
        this.streamMode = n;
    }

    public int getVideoCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(int n) {
        this.videoCodec = n;
    }

    public int getAudioCodec() {
        return this.audioCodec;
    }

    public void setAudioCodec(int n) {
        this.audioCodec = n;
    }

    public long getTimecode() {
        return this.timecode;
    }

    public void setTimecode(long l) {
        this.timecode = l;
    }

    public SanJoseTSHolder getHolder() {
        return this.holder;
    }

    public void setHolder(SanJoseTSHolder sanJoseTSHolder) {
        this.holder = sanJoseTSHolder;
    }

    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long l) {
        this.sequence = l;
    }

    public int getRepeaterType() {
        return this.repeaterType;
    }

    public void setRepeaterType(int n) {
        this.repeaterType = n;
    }

    public String getEncUrl() {
        return this.encUrl;
    }

    public void setEncUrl(String string) {
        this.encUrl = string;
    }

    public byte[] getEncRepeaterBytes() {
        return this.encRepeaterBytes;
    }

    public void setEncRepeaterBytes(byte[] byArray) {
        this.encRepeaterBytes = byArray;
    }

    public String getRepeaterMessage() {
        return this.repeaterMessage;
    }

    public void setRepeaterMessage(String string) {
        this.repeaterMessage = string;
    }

    public MediaCodecInfoVideo getCodecInfoVideo() {
        return this.codecInfoVideo;
    }

    public void setCodecInfoVideo(MediaCodecInfoVideo mediaCodecInfoVideo) {
        this.codecInfoVideo = mediaCodecInfoVideo;
    }

    public MediaCodecInfoAudio getCodecInfoAudio() {
        return this.codecInfoAudio;
    }

    public void setCodecInfoAudio(MediaCodecInfoAudio mediaCodecInfoAudio) {
        this.codecInfoAudio = mediaCodecInfoAudio;
    }
}

