/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.CommonPrefixEntry;
import com.amazon.s3.ListEntry;
import com.amazon.s3.Owner;
import com.amazon.s3.Response;
import com.amazon.s3.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SimpleTimeZone;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ListBucketResponse
extends Response {
    public String name = null;
    public String prefix = null;
    public String marker = null;
    public String delimiter = null;
    public int maxKeys = 0;
    public boolean isTruncated = false;
    public String nextMarker = null;
    public List entries = null;
    public List commonPrefixEntries = null;

    public ListBucketResponse(HttpURLConnection httpURLConnection) throws IOException {
        super(httpURLConnection);
        if (httpURLConnection.getResponseCode() < 400) {
            try {
                XMLReader xMLReader = Utils.createXMLReader();
                ListBucketHandler listBucketHandler = new ListBucketHandler();
                xMLReader.setContentHandler(listBucketHandler);
                xMLReader.setErrorHandler(listBucketHandler);
                xMLReader.parse(new InputSource(httpURLConnection.getInputStream()));
                this.name = listBucketHandler.getName();
                this.prefix = listBucketHandler.getPrefix();
                this.marker = listBucketHandler.getMarker();
                this.delimiter = listBucketHandler.getDelimiter();
                this.maxKeys = listBucketHandler.getMaxKeys();
                this.isTruncated = listBucketHandler.getIsTruncated();
                this.nextMarker = listBucketHandler.getNextMarker();
                this.entries = listBucketHandler.getKeyEntries();
                this.commonPrefixEntries = listBucketHandler.getCommonPrefixEntries();
            }
            catch (SAXException sAXException) {
                throw new RuntimeException("Unexpected error parsing ListBucket xml", sAXException);
            }
        }
    }

    class ListBucketHandler
    extends DefaultHandler {
        private String name = null;
        private String prefix = null;
        private String marker = null;
        private String delimiter = null;
        private int maxKeys = 0;
        private boolean isTruncated = false;
        private String nextMarker = null;
        private boolean isEchoedPrefix = false;
        private List keyEntries = new ArrayList();
        private ListEntry keyEntry = null;
        private List commonPrefixEntries = new ArrayList();
        private CommonPrefixEntry commonPrefixEntry = null;
        private StringBuffer currText = null;
        private SimpleDateFormat iso8601Parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

        public ListBucketHandler() {
            this.iso8601Parser.setTimeZone(new SimpleTimeZone(0, "GMT"));
            this.currText = new StringBuffer();
        }

        public void startDocument() {
            this.isEchoedPrefix = true;
        }

        public void endDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string2.equals("Contents")) {
                this.keyEntry = new ListEntry();
            } else if (string2.equals("Owner")) {
                this.keyEntry.owner = new Owner();
            } else if (string2.equals("CommonPrefixes")) {
                this.commonPrefixEntry = new CommonPrefixEntry();
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (string2.equals("Name")) {
                this.name = this.currText.toString();
            } else if (string2.equals("Prefix") && this.isEchoedPrefix) {
                this.prefix = this.currText.toString();
                this.isEchoedPrefix = false;
            } else if (string2.equals("Marker")) {
                this.marker = this.currText.toString();
            } else if (string2.equals("MaxKeys")) {
                this.maxKeys = Integer.parseInt(this.currText.toString());
            } else if (string2.equals("Delimiter")) {
                this.delimiter = this.currText.toString();
            } else if (string2.equals("IsTruncated")) {
                this.isTruncated = Boolean.valueOf(this.currText.toString());
            } else if (string2.equals("NextMarker")) {
                this.nextMarker = this.currText.toString();
            } else if (string2.equals("Contents")) {
                this.keyEntries.add(this.keyEntry);
            } else if (string2.equals("Key")) {
                this.keyEntry.key = this.currText.toString();
            } else if (string2.equals("LastModified")) {
                try {
                    this.keyEntry.lastModified = this.iso8601Parser.parse(this.currText.toString());
                }
                catch (ParseException parseException) {
                    throw new RuntimeException("Unexpected date format in list bucket output", parseException);
                }
            } else if (string2.equals("ETag")) {
                this.keyEntry.eTag = this.currText.toString();
            } else if (string2.equals("Size")) {
                this.keyEntry.size = Long.parseLong(this.currText.toString());
            } else if (string2.equals("StorageClass")) {
                this.keyEntry.storageClass = this.currText.toString();
            } else if (string2.equals("ID")) {
                this.keyEntry.owner.id = this.currText.toString();
            } else if (string2.equals("DisplayName")) {
                this.keyEntry.owner.displayName = this.currText.toString();
            } else if (string2.equals("CommonPrefixes")) {
                this.commonPrefixEntries.add(this.commonPrefixEntry);
            } else if (string2.equals("Prefix")) {
                this.commonPrefixEntry.prefix = this.currText.toString();
            }
            if (this.currText.length() != 0) {
                this.currText = new StringBuffer();
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            this.currText.append(cArray, n, n2);
        }

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getMarker() {
            return this.marker;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public int getMaxKeys() {
            return this.maxKeys;
        }

        public boolean getIsTruncated() {
            return this.isTruncated;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public List getKeyEntries() {
            return this.keyEntries;
        }

        public List getCommonPrefixEntries() {
            return this.commonPrefixEntries;
        }
    }
}

