/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.util.IBandwidthThrottler;

public class BandwidthThrottlerTokenBased
extends Thread
implements IBandwidthThrottler {
    private static final int THROUGHPUT = 0;
    private static final int RATECOUNT = 1;
    private long rate = 0L;
    private long maxBucketSize = 0L;
    private int fillFrequency = 100;
    private long bucketSize = 0L;
    private long total = 0L;
    private Object lock = new Object();
    private boolean quit = false;
    private boolean running = true;
    private long rateWindow = 2000L;
    private long[] lastRateValue = new long[1];
    private long[] lastRateValue2 = new long[1];
    private long[] lastRateTime = new long[1];
    private long[] lastRateTime2 = new long[1];
    private boolean bucketEmpty = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getByteAllocation(long l) {
        long l2 = l;
        Object object = this.lock;
        synchronized (object) {
            if (this.rate > 0L) {
                if (l2 > this.bucketSize) {
                    l2 = this.bucketSize;
                }
                this.bucketSize -= l2;
                this.total += l2;
            }
        }
        return l2;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void quit() {
        this.quit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTokens(long l) {
        Object object = this.lock;
        synchronized (object) {
            if (this.rate > 0L) {
                this.bucketSize += this.rate * l / 1000L;
                if (this.bucketSize > this.maxBucketSize) {
                    this.bucketSize = this.maxBucketSize;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = -1L;
        this.bucketSize = this.maxBucketSize;
        while (true) {
            try {
                long l2 = System.currentTimeMillis();
                if (l != -1L) {
                    this.addTokens(l2 - l);
                }
                l = l2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.fillFrequency);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BandwidthThrottlerTokenBased bandwidthThrottlerTokenBased = this;
            synchronized (bandwidthThrottlerTokenBased) {
                if (this.quit) {
                    this.running = false;
                    break;
                }
            }
        }
    }

    private long computeRate(int n, long l) {
        long l2 = 0L;
        long l3 = System.currentTimeMillis();
        if (this.lastRateTime[n] == -1L) {
            this.lastRateTime[n] = l3;
            this.lastRateValue[n] = l;
        } else {
            long l4 = l3 - this.lastRateTime[n];
            if (l4 > 0L) {
                l2 = Math.round((double)(l - this.lastRateValue[n]) * 1000.0 / (double)l4);
            }
            if (this.lastRateTime2[n] == -1L) {
                if (l3 - this.lastRateTime[n] > this.rateWindow) {
                    this.lastRateTime2[n] = l3;
                    this.lastRateValue2[n] = l;
                }
            } else if (l3 - this.lastRateTime2[n] > this.rateWindow) {
                this.lastRateTime[n] = this.lastRateTime2[n];
                this.lastRateValue[n] = this.lastRateValue2[n];
                this.lastRateTime2[n] = -1L;
                this.lastRateValue2[n] = 0L;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getThroughput() {
        double d = 0.0;
        Object object = this.lock;
        synchronized (object) {
            d = this.computeRate(0, this.total);
        }
        return d;
    }

    public long getRate() {
        return this.rate;
    }

    public void setRate(long l) {
        this.rate = l;
    }

    public long getMaxBucketSize() {
        return this.maxBucketSize;
    }

    public void setMaxBucketSize(long l) {
        this.maxBucketSize = l;
    }

    public long getBucketSize() {
        return this.bucketSize;
    }

    public int getFillFrequency() {
        return this.fillFrequency;
    }

    public void setFillFrequency(int n) {
        this.fillFrequency = n;
    }
}

