/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.io.IRandomAccessReader;
import com.wowza.util.BufferUtils;
import java.util.SortedMap;
import java.util.TreeMap;

public class FastTypeBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    protected byte[] data = null;
    protected int entrySize = 4;
    protected int dataSize = 4;
    protected int totalSize = -1;
    protected long randomAccessReaderStartPos = -1L;
    protected IRandomAccessReader randomAccessReader = null;
    protected int bufferSize = 16384;
    protected int entriesPerBuffer = 0;
    protected int currChunk = -1;
    protected SortedMap searchIndex = null;

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
        this.totalSize = byArray.length;
    }

    public int getEntrySize() {
        return this.entrySize;
    }

    public void setEntrySize(int n) {
        this.entrySize = n;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int n) {
        this.dataSize = n;
    }

    public long getLong(int n) {
        return this.getLong(n, 0);
    }

    public long getLong(int n, int n2) {
        if (this.data != null) {
            if (this.randomAccessReader != null) {
                n = this.populateBuffer(n);
            }
            return BufferUtils.byteArrayToLong(this.data, n * this.entrySize + n2 * this.dataSize, this.dataSize);
        }
        return 0L;
    }

    public int getInt(int n) {
        return this.getInt(n, 0);
    }

    public int getInt(int n, int n2) {
        if (this.data != null) {
            if (this.randomAccessReader != null) {
                n = this.populateBuffer(n);
            }
            return BufferUtils.byteArrayToInt(this.data, n * this.entrySize + n2 * this.dataSize, this.dataSize);
        }
        return 0;
    }

    public long getRandomAccessReaderStartPos() {
        return this.randomAccessReaderStartPos;
    }

    public void setRandomAccessReaderStartPos(long l) {
        this.randomAccessReaderStartPos = l;
    }

    public int length() {
        return this.totalSize / this.entrySize;
    }

    public int binarySearchInt(int n) {
        return this.binarySearchInt(n, 0);
    }

    public int binarySearchInt(int n, int n2) {
        int n3 = this.length();
        int n4 = 0;
        int n5 = n3 - 1;
        int n6 = 0;
        if (this.searchIndex != null) {
            SortedMap sortedMap = this.searchIndex.tailMap(new Integer(n));
            if (!sortedMap.isEmpty()) {
                Integer n7 = sortedMap.firstKey();
                n6 = (Integer)sortedMap.get(n7);
                this.populateBuffer(n6);
                n5 = this.entriesPerBuffer - 1;
                if (n6 + n5 > n3) {
                    n5 = n3 - n6 - 1;
                }
            } else {
                return -(n3 + 1);
            }
        }
        while (n4 <= n5) {
            int n8 = (n4 + n5) / 2;
            int n9 = BufferUtils.byteArrayToInt(this.data, n8 * this.entrySize + n2 * this.dataSize, this.dataSize);
            if (n < n9) {
                n5 = n8 - 1;
                if (n5 >= n4) continue;
                return -(n6 + n8 + 1);
            }
            if (n > n9) {
                n4 = n8 + 1;
                if (n4 <= n5) continue;
                return -(n6 + n8 + 2);
            }
            return n6 + n8;
        }
        return -1;
    }

    public int binarySearchLong(long l) {
        return this.binarySearchLong(l, 0);
    }

    public int binarySearchLong(long l, int n) {
        int n2 = this.length();
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = 0;
        if (this.searchIndex != null) {
            SortedMap sortedMap = this.searchIndex.tailMap(new Long(l));
            if (!sortedMap.isEmpty()) {
                Long l2 = sortedMap.firstKey();
                n5 = (Integer)sortedMap.get(l2);
                this.populateBuffer(n5);
                n4 = this.entriesPerBuffer - 1;
                if (n5 + n4 > n2) {
                    n4 = n2 - n5 - 1;
                }
            } else {
                return -(n2 + 1);
            }
        }
        while (n3 <= n4) {
            int n6 = (n3 + n4) / 2;
            long l3 = BufferUtils.byteArrayToLong(this.data, n6 * this.entrySize + n * this.dataSize, this.dataSize);
            if (l < l3) {
                n4 = n6 - 1;
                if (n4 >= n3) continue;
                return -(n5 + n6 + 1);
            }
            if (l > l3) {
                n3 = n6 + 1;
                if (n3 <= n4) continue;
                return -(n5 + n6 + 2);
            }
            return n5 + n6;
        }
        return -1;
    }

    public IRandomAccessReader getRandomAccessReader() {
        return this.randomAccessReader;
    }

    public void setRandomAccessReader(IRandomAccessReader iRandomAccessReader) {
        this.randomAccessReader = iRandomAccessReader;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public void generateIntIndex() {
        this.generateIntIndex(0);
    }

    public void generateIntIndex(int n) {
        this.searchIndex = new TreeMap();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.length();
        do {
            int n5;
            if (n3 + (n5 = this.entriesPerBuffer - 1) >= n4) {
                n5 = n4 - n3 - 1;
            }
            this.randomAccessReader.seek(this.randomAccessReaderStartPos + (long)n2 + (long)(n5 * this.entrySize));
            this.randomAccessReader.read(this.data, 0, this.entrySize);
            int n6 = BufferUtils.byteArrayToInt(this.data, n * this.dataSize, this.dataSize);
            this.searchIndex.put(new Integer(n6), new Integer(n3));
            n3 += this.entriesPerBuffer;
        } while ((n2 += this.bufferSize) < this.totalSize);
    }

    public void generateLongIndex() {
        this.generateLongIndex(0);
    }

    public void generateLongIndex(int n) {
        this.searchIndex = new TreeMap();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.length();
        do {
            int n5;
            if (n3 + (n5 = this.entriesPerBuffer - 1) >= n4) {
                n5 = n4 - n3 - 1;
            }
            this.randomAccessReader.seek(this.randomAccessReaderStartPos + (long)n2 + (long)(n5 * this.entrySize));
            this.randomAccessReader.read(this.data, 0, this.entrySize);
            long l = BufferUtils.byteArrayToLong(this.data, n * this.dataSize, this.dataSize);
            this.searchIndex.put(new Long(l), new Integer(n3));
            n3 += this.entriesPerBuffer;
        } while ((n2 += this.bufferSize) < this.totalSize);
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int n) {
        this.totalSize = n;
    }

    public int populateBuffer(int n) {
        int n2 = n;
        if (this.randomAccessReader != null) {
            int n3 = n / this.entriesPerBuffer;
            n2 = n % this.entriesPerBuffer;
            if (this.currChunk != n3) {
                this.randomAccessReader.seek(this.randomAccessReaderStartPos + (long)(n3 * this.data.length));
                int n4 = this.data.length;
                if (n3 * this.data.length + n4 > this.totalSize) {
                    n4 = this.totalSize - n3 * this.data.length;
                }
                this.randomAccessReader.read(this.data, 0, n4);
                this.currChunk = n3;
            }
        }
        return n2;
    }

    public void allocateBuffer() {
        int n = this.bufferSize / this.entrySize * this.entrySize;
        this.data = new byte[n];
        this.entriesPerBuffer = n / this.entrySize;
    }
}

