/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.admin;

import com.wowza.util.URLUtils;
import com.wowza.wms.admin.AdminAgent;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.IMediaCasterNotify;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.modeler.Registry;

public class AdminMediaCasterListener
implements IMediaCasterNotify {
    public static final String MEDIACASTERLISTENER_OBJECTNAME = "mediaCasters=MediaCasters,mediaCaster=";
    public static final String MEDIACASTERLISTENER_FILTERNAME = "MediaCaster";
    private AdminAgent adminAgent = null;
    private IVHost vhost = null;
    private IApplication application = null;
    private IApplicationInstance applicationInstance = null;
    private boolean isActive = true;
    private Map mediaCasterStreams = new HashMap();

    public AdminMediaCasterListener(AdminAgent adminAgent, IVHost iVHost, IApplication iApplication, IApplicationInstance iApplicationInstance) {
        this.adminAgent = adminAgent;
        this.vhost = iVHost;
        this.application = iApplication;
        this.applicationInstance = iApplicationInstance;
        this.isActive = Server.getInstance().getAdminInterfaceObjectList().contains(MEDIACASTERLISTENER_FILTERNAME.toLowerCase());
    }

    private String getObjectName(IMediaCaster iMediaCaster) {
        return "WowzaMediaServerPro:vHosts=VHosts,vHostName=" + this.vhost.getName() + "," + "applications=Applications,applicationName=" + this.application.getName() + "," + "applicationInstances=ApplicationInstances,applicationInstanceName=" + this.applicationInstance.getName() + "," + MEDIACASTERLISTENER_OBJECTNAME + URLUtils.encodeValue(iMediaCaster.getMediaCasterId());
    }

    public void onMediaCasterCreate(IMediaCaster iMediaCaster) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).registerComponent((Object)iMediaCaster, this.getObjectName(iMediaCaster) + ",name=MediaCaster", iMediaCaster.getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iMediaCaster.getMediaCasterStreamItem(), this.getObjectName(iMediaCaster) + ",name=MediaCasterStreamItem", iMediaCaster.getMediaCasterStreamItem().getClass().getName());
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminMediaCasterListener.class).error("onMediaCasterDestroy: " + exception.toString());
        }
    }

    public void onMediaCasterDestroy(IMediaCaster iMediaCaster) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iMediaCaster) + ",name=MediaCaster");
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iMediaCaster) + ",name=MediaCasterStreamItem");
                IMediaStream iMediaStream = (IMediaStream)this.mediaCasterStreams.remove(iMediaCaster);
                if (iMediaStream != null) {
                    Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iMediaCaster) + ",name=Stream");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminMediaCasterListener.class).error("onMediaCasterDestroy: " + exception.toString());
        }
    }

    public void onRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
    }

    public void onSetSourceStream(IMediaCaster iMediaCaster, IMediaStream iMediaStream) {
        try {
            if (this.isActive) {
                IMediaStream iMediaStream2 = (IMediaStream)this.mediaCasterStreams.remove(iMediaCaster);
                if (iMediaStream2 != null) {
                    Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(iMediaCaster) + ",name=Stream");
                }
                if (iMediaStream != null) {
                    Registry.getRegistry(null, null).registerComponent((Object)iMediaStream, this.getObjectName(iMediaCaster) + ",name=Stream", iMediaStream.getClass().getName());
                    this.mediaCasterStreams.put(iMediaCaster, iMediaStream);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminMediaCasterListener.class).error("onSetSourceStream: " + exception.toString());
        }
    }

    public void onUnRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
    }
}

