/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.admin;

import com.wowza.wms.admin.AdminAgent;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.IModuleNotify;
import com.wowza.wms.module.ModuleItem;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import org.apache.commons.modeler.Registry;

public class AdminModuleListener
implements IModuleNotify {
    public static final String MODULE_OBJECTNAME = "modules=Modules,module=";
    public static final String MODULE_FILTERNAME = "Module";
    private AdminAgent adminAgent = null;
    private IVHost vhost = null;
    private IApplication application = null;
    private IApplicationInstance applicationInstance = null;
    private boolean isActive = true;

    public AdminModuleListener(AdminAgent adminAgent, IVHost iVHost, IApplication iApplication, IApplicationInstance iApplicationInstance) {
        this.adminAgent = adminAgent;
        this.vhost = iVHost;
        this.application = iApplication;
        this.applicationInstance = iApplicationInstance;
        this.isActive = Server.getInstance().getAdminInterfaceObjectList().contains(MODULE_FILTERNAME.toLowerCase());
    }

    private String getObjectName(ModuleItem moduleItem) {
        return "WowzaMediaServerPro:vHosts=VHosts,vHostName=" + this.vhost.getName() + "," + "applications=Applications,applicationName=" + this.application.getName() + "," + "applicationInstances=ApplicationInstances,applicationInstanceName=" + this.applicationInstance.getName() + "," + MODULE_OBJECTNAME + moduleItem.getName();
    }

    public void onModuleLoad(ModuleItem moduleItem) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).registerComponent((Object)moduleItem, this.getObjectName(moduleItem) + ",name=Module", moduleItem.getClass().getName());
                Object object = moduleItem.getInstance();
                if (object != null) {
                    Registry.getRegistry(null, null).registerComponent(object, this.getObjectName(moduleItem) + ",name=Instance", object.getClass().getName());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminModuleListener.class).error("onModuleLoad: " + exception.toString());
        }
    }

    public void onModuleUnload(ModuleItem moduleItem) {
        try {
            if (this.isActive) {
                Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(moduleItem) + ",name=Module");
                Object object = moduleItem.getInstance();
                if (object != null) {
                    Registry.getRegistry(null, null).unregisterComponent(this.getObjectName(moduleItem) + ",name=Instance");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminModuleListener.class).error("onModuleUnload: " + exception.toString());
        }
    }
}

