/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.wms.amf.AMFDataContextDeserialize;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.util.Date;

public class AMF3Utils {
    public static Date deserializeDate(ByteBuffer byteBuffer) {
        double d = new Double(byteBuffer.getDouble());
        Date date = new Date();
        date.setTime((long)d);
        return date;
    }

    public static int serializeDate(DataOutputStream dataOutputStream, Date date) {
        try {
            double d = date.getTime();
            dataOutputStream.write(1);
            dataOutputStream.writeDouble(d);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMF3Utils.class).error("AMF3Utils.serializeDate: " + exception.toString());
            exception.printStackTrace();
        }
        return 9;
    }

    public static int deserializeInt(ByteBuffer byteBuffer) {
        int n = 0;
        try {
            for (int i = 0; i < 4; ++i) {
                byte by = byteBuffer.get();
                boolean bl = false;
                if (i < 3) {
                    n <<= 7;
                    bl = (by & 0x80) == 128;
                    by = (byte)(by & 0x7F);
                } else {
                    n <<= 8;
                }
                n |= by & 0xFF;
                if (!bl) break;
            }
            if ((n & 0x10000000) == 0x10000000) {
                n |= 0xF0000000;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMF3Utils.class).error("AMF3Utils.deserializeInt: " + exception.toString());
            exception.printStackTrace();
        }
        return n;
    }

    public static int serializeInt(DataOutputStream dataOutputStream, int n) {
        int n2 = 1;
        try {
            if (n == 0) {
                dataOutputStream.write(0);
            } else if (n > 0) {
                if ((n & 0xFFE00000) != 0) {
                    n2 = 4;
                    byte[] byArray = new byte[4];
                    byArray[0] = (byte)(n >> 22 & 0x7F);
                    byArray[0] = (byte)(byArray[0] | 0x80);
                    byArray[1] = (byte)(n >> 15 & 0x7F);
                    byArray[1] = (byte)(byArray[1] | 0x80);
                    byArray[2] = (byte)(n >> 8 & 0x7F);
                    byArray[2] = (byte)(byArray[2] | 0x80);
                    byArray[3] = (byte)(n & 0xFF);
                    dataOutputStream.write(byArray);
                } else if ((n & 0xFFFFC000) != 0) {
                    n2 = 3;
                    byte[] byArray = new byte[3];
                    byArray[0] = (byte)(n >> 14 & 0x7F);
                    byArray[0] = (byte)(byArray[0] | 0x80);
                    byArray[1] = (byte)(n >> 7 & 0x7F);
                    byArray[1] = (byte)(byArray[1] | 0x80);
                    byArray[2] = (byte)(n & 0x7F);
                    dataOutputStream.write(byArray);
                } else if ((n & 0xFFFFFF80) != 0) {
                    n2 = 2;
                    dataOutputStream.write((byte)(n >> 7) & 0x7F | 0x80);
                    dataOutputStream.write(n & 0x7F);
                } else {
                    dataOutputStream.write(n & 0x7F);
                }
            } else if (n < 0) {
                n2 = 4;
                byte[] byArray = new byte[4];
                byArray[0] = (byte)(n >> 22 & 0x7F);
                byArray[0] = (byte)(byArray[0] | 0x80);
                byArray[1] = (byte)(n >> 15 & 0x7F);
                byArray[1] = (byte)(byArray[1] | 0x80);
                byArray[2] = (byte)(n >> 8 & 0x7F);
                byArray[2] = (byte)(byArray[2] | 0x80);
                byArray[3] = (byte)(n & 0xFF);
                dataOutputStream.write(byArray);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMF3Utils.class).error("AMF3Utils.serializeInt: " + exception.toString());
            exception.printStackTrace();
        }
        return n2;
    }

    public static String deserializeString(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) throws IOException {
        String string = null;
        int n = AMF3Utils.deserializeInt(byteBuffer);
        if ((n & 1) == 0) {
            string = aMFDataContextDeserialize.getString(n >>= 1);
            return string;
        }
        if ((n >>= 1) > 0) {
            string = AMF3Utils.deserializeString(byteBuffer, n);
            aMFDataContextDeserialize.addString(string);
        } else {
            string = "";
        }
        return string;
    }

    public static String deserializeString(ByteBuffer byteBuffer) throws IOException {
        int n = AMF3Utils.deserializeInt(byteBuffer);
        if (n > 0) {
            return AMF3Utils.deserializeString(byteBuffer, n);
        }
        return "";
    }

    public static String deserializeString(ByteBuffer byteBuffer, int n) throws IOException {
        if (n > 0) {
            int n2;
            int n3;
            byte[] byArray = new byte[n];
            char[] cArray = new char[n];
            int n4 = 0;
            byteBuffer.get(byArray, 0, n);
            for (n3 = 0; n3 < n && (n2 = byArray[n3] & 0xFF) <= 127; ++n3) {
                cArray[n4++] = (char)n2;
            }
            block6: while (n3 < n) {
                n2 = byArray[n3] & 0xFF;
                switch (n2 >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++n3;
                        cArray[n4++] = (char)n2;
                        continue block6;
                    }
                    case 12: 
                    case 13: {
                        if ((n3 += 2) > n) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte by = byArray[n3 - 1];
                        if ((by & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + n3);
                        }
                        cArray[n4++] = (char)((n2 & 0x1F) << 6 | by & 0x3F);
                        continue block6;
                    }
                    case 14: {
                        if ((n3 += 3) > n) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte by = byArray[n3 - 2];
                        byte by2 = byArray[n3 - 1];
                        if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (n3 - 1));
                        }
                        cArray[n4++] = (char)((n2 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                        continue block6;
                    }
                }
                throw new UTFDataFormatException("malformed input around byte " + n3);
            }
            return new String(cArray, 0, n4);
        }
        return "";
    }

    public static void serializeZeroLengthString(DataOutputStream dataOutputStream) {
        AMF3Utils.serializeInt(dataOutputStream, 1);
    }

    public static int serializeStringNoLength(DataOutputStream dataOutputStream, String string) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + n2 + " bytes");
        }
        byte[] byArray = null;
        byArray = new byte[n2];
        int n4 = 0;
        for (n4 = 0; n4 < n && (c = string.charAt(n4)) >= '\u0001' && c <= '\u007f'; ++n4) {
            byArray[n3++] = (byte)c;
        }
        while (n4 < n) {
            c = string.charAt(n4);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++n4;
        }
        dataOutputStream.write(byArray, 0, n2);
        return n2;
    }

    public static int serializeString(DataOutputStream dataOutputStream, String string) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + n2 + " bytes");
        }
        byte[] byArray = null;
        byArray = new byte[n2];
        int n4 = (n2 << 1) + 1;
        int n5 = AMF3Utils.serializeInt(dataOutputStream, n4);
        int n6 = 0;
        for (n6 = 0; n6 < n && (c = string.charAt(n6)) >= '\u0001' && c <= '\u007f'; ++n6) {
            byArray[n3++] = (byte)c;
        }
        while (n6 < n) {
            c = string.charAt(n6);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++n6;
        }
        dataOutputStream.write(byArray, 0, n2);
        return n2 + n5;
    }
}

