/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.wms.amf.AMF3Utils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataContextDeserialize;
import com.wowza.wms.amf.AMFDataContextSerialize;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class AMFDataArray
extends AMFData {
    private List children = new ArrayList();

    public AMFDataArray() {
        this.type = 10;
    }

    public AMFDataArray(byte[] byArray) {
        this.type = 10;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.deserialize(byteBuffer);
    }

    public AMFDataArray(byte[] byArray, int n, int n2) {
        this.type = 10;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        this.deserialize(byteBuffer);
    }

    public AMFDataArray(ByteBuffer byteBuffer) {
        this.type = 10;
        this.deserialize(byteBuffer);
    }

    public AMFDataArray(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        this.type = 10;
        this.deserialize(byteBuffer, aMFDataContextDeserialize);
    }

    public AMFData remove(int n) {
        try {
            return (AMFData)this.children.remove(n);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataArray.class).error("remove: " + exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public int size() {
        return this.children.size();
    }

    public void add(AMFData aMFData) {
        this.children.add(aMFData);
    }

    public void add(String string) {
        this.children.add(new AMFDataItem(string));
    }

    public void add(double d) {
        this.children.add(new AMFDataItem(d));
    }

    public void add(int n) {
        this.children.add(new AMFDataItem(n));
    }

    public void add(long l) {
        this.children.add(new AMFDataItem(l));
    }

    public void add(Date date) {
        this.children.add(new AMFDataItem(date));
    }

    public void add(boolean bl) {
        this.children.add(new AMFDataItem(bl));
    }

    public void add(int n, AMFData aMFData) {
        this.children.add(n, aMFData);
    }

    public void add(int n, String string) {
        this.children.add(n, new AMFDataItem(string));
    }

    public void add(int n, double d) {
        this.children.add(n, new AMFDataItem(d));
    }

    public void add(int n, int n2) {
        this.children.add(n, new AMFDataItem(n2));
    }

    public void add(int n, long l) {
        this.children.add(n, new AMFDataItem(l));
    }

    public void add(int n, Date date) {
        this.children.add(n, new AMFDataItem(date));
    }

    public void add(int n, boolean bl) {
        this.children.add(n, new AMFDataItem(bl));
    }

    public void set(int n, AMFData aMFData) {
        this.children.set(n, aMFData);
    }

    public void set(int n, String string) {
        this.children.set(n, new AMFDataItem(string));
    }

    public void set(int n, double d) {
        this.children.set(n, new AMFDataItem(d));
    }

    public void set(int n, int n2) {
        this.children.set(n, new AMFDataItem(n2));
    }

    public void set(int n, long l) {
        this.children.set(n, new AMFDataItem(l));
    }

    public void set(int n, Date date) {
        this.children.set(n, new AMFDataItem(date));
    }

    public void set(int n, boolean bl) {
        this.children.set(n, new AMFDataItem(bl));
    }

    public AMFData get(int n) {
        try {
            return (AMFData)this.children.get(n);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataArray.class).error("get: " + exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public String getString(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.toString() : null;
    }

    public int getInt(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.intValue() : 0;
    }

    public long getLong(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.longValue() : 0L;
    }

    public short getShort(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.shortValue() : (short)0;
    }

    public byte getByte(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.byteValue() : (byte)0;
    }

    public boolean getBoolean(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.booleanValue() : false;
    }

    public Date getDate(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return (Date)(aMFDataItem != null ? (aMFDataItem.getType() == 11 ? aMFDataItem.getValue() : null) : null);
    }

    public AMFDataObj getObject(int n) {
        AMFDataObj aMFDataObj = (AMFDataObj)this.get(n);
        return aMFDataObj;
    }

    public double getDouble(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.doubleValue() : 0.0;
    }

    public float getFloat(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.floatValue() : 0.0f;
    }

    public void deserialize(ByteBuffer byteBuffer) {
        this.deserialize(byteBuffer, AMFData.createContextDeserialize());
    }

    public void deserialize(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        try {
            aMFDataContextDeserialize.addObject(this);
            int n = byteBuffer.getInt();
            for (int i = 0; i < n; ++i) {
                if (!byteBuffer.hasRemaining()) continue;
                AMFData aMFData = AMFData.deserializeInnerObject(byteBuffer, aMFDataContextDeserialize);
                if (aMFData != null) {
                    this.children.add(aMFData);
                    continue;
                }
                WMSLoggerFactory.getLogger(AMFDataArray.class).error("AMFDataArray.deserialize: no object");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataArray.class).error("AMFDataArray.deserialize[" + byteBuffer.capacity() + ":" + byteBuffer.position() + "]: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void serialize(DataOutputStream dataOutputStream) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(0));
    }

    public void serialize(DataOutputStream dataOutputStream, int n) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(n));
    }

    public void serialize(DataOutputStream dataOutputStream, AMFDataContextSerialize aMFDataContextSerialize) {
        try {
            if (!aMFDataContextSerialize.isAMF0()) {
                dataOutputStream.write(9);
                int n = aMFDataContextSerialize.getObjectReference(this);
                if (n >= 0) {
                    AMF3Utils.serializeInt(dataOutputStream, n <<= 1);
                } else {
                    int n2 = this.children.size();
                    n2 <<= 1;
                    AMF3Utils.serializeInt(dataOutputStream, n2 |= 1);
                    AMF3Utils.serializeZeroLengthString(dataOutputStream);
                    for (AMFData aMFData : this.children) {
                        aMFData.serialize(dataOutputStream, aMFDataContextSerialize);
                    }
                }
            } else {
                dataOutputStream.write(10);
                dataOutputStream.writeInt(this.children.size());
                for (AMFData aMFData : this.children) {
                    aMFData.serialize(dataOutputStream, aMFDataContextSerialize);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataArray.class).error("serialize: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public byte[] serialize() {
        return this.serialize(AMFData.createContextSerialize(0));
    }

    public byte[] serialize(int n) {
        return this.serialize(AMFData.createContextSerialize(n));
    }

    public byte[] serialize(AMFDataContextSerialize aMFDataContextSerialize) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(dataOutputStream, aMFDataContextSerialize);
        return byteArrayOutputStream.toByteArray();
    }

    public Object getValue() {
        return this.children;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Array: ");
        Iterator iterator = this.children.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            AMFData aMFData = (AMFData)iterator.next();
            if (n > 0) {
                stringBuffer.append(", ");
            }
            int n2 = aMFData.getType();
            switch (n2) {
                default: {
                    stringBuffer.append(n + ": " + aMFData.toString());
                    break;
                }
                case 2: 
                case 11: 
                case 15: 
                case 34: {
                    stringBuffer.append(n + ": \"" + aMFData.toString() + "\"");
                }
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

