/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.wms.amf.AMF3Utils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataContextDeserialize;
import com.wowza.wms.amf.AMFDataContextSerialize;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class AMFDataItem
extends AMFData {
    private Object value = null;

    public AMFDataItem() {
        this.type = 5;
        this.value = null;
    }

    public AMFDataItem(String string) {
        this.value = string;
        this.type = 2;
    }

    public AMFDataItem(int n) {
        this.value = new Double(n);
        this.type = 0;
    }

    public AMFDataItem(long l) {
        this.value = new Double(l);
        this.type = 0;
    }

    public AMFDataItem(double d) {
        this.value = new Double(d);
        this.type = 0;
    }

    public AMFDataItem(boolean bl) {
        this.value = new Boolean(bl);
        this.type = 1;
    }

    public AMFDataItem(Date date) {
        this.value = date;
        this.type = 11;
    }

    public AMFDataItem(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.deserialize(byteBuffer);
    }

    public AMFDataItem(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        this.deserialize(byteBuffer);
    }

    public AMFDataItem(ByteBuffer byteBuffer) {
        this.deserialize(byteBuffer);
    }

    public AMFDataItem(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        this.deserialize(byteBuffer, aMFDataContextDeserialize);
    }

    public long longValue() {
        if (this.value != null) {
            if (this.type == 0) {
                return ((Double)this.value).longValue();
            }
            if (this.type == 32) {
                return ((Integer)this.value).longValue();
            }
            if (this.type == 2) {
                return Long.parseLong((String)this.value);
            }
        }
        return 0L;
    }

    public int intValue() {
        if (this.value != null) {
            if (this.type == 0) {
                return ((Double)this.value).intValue();
            }
            if (this.type == 32) {
                return (Integer)this.value;
            }
            if (this.type == 2) {
                return Integer.parseInt((String)this.value);
            }
        }
        return 0;
    }

    public double doubleValue() {
        if (this.value != null) {
            if (this.type == 0) {
                return (Double)this.value;
            }
            if (this.type == 32) {
                return ((Integer)this.value).doubleValue();
            }
            if (this.type == 2) {
                return Double.parseDouble((String)this.value);
            }
        }
        return 0.0;
    }

    public float floatValue() {
        if (this.value != null) {
            if (this.type == 0) {
                return ((Double)this.value).floatValue();
            }
            if (this.type == 32) {
                return ((Integer)this.value).floatValue();
            }
            if (this.type == 2) {
                return Float.parseFloat((String)this.value);
            }
        }
        return 0.0f;
    }

    public short shortValue() {
        if (this.value != null) {
            if (this.type == 0) {
                return ((Double)this.value).shortValue();
            }
            if (this.type == 32) {
                return ((Integer)this.value).shortValue();
            }
            if (this.type == 2) {
                return Short.parseShort((String)this.value);
            }
        }
        return 0;
    }

    public byte byteValue() {
        if (this.value != null) {
            if (this.type == 0) {
                return ((Double)this.value).byteValue();
            }
            if (this.type == 32) {
                return ((Integer)this.value).byteValue();
            }
            if (this.type == 2) {
                return Byte.parseByte((String)this.value);
            }
        }
        return 0;
    }

    public Date dateValue() {
        if (this.value != null && this.type == 11) {
            return (Date)this.value;
        }
        return null;
    }

    public boolean booleanValue() {
        if (this.value != null) {
            if (this.type == 1) {
                return (Boolean)this.value;
            }
            if (this.type == 2) {
                return Boolean.parseBoolean((String)this.value);
            }
        }
        return false;
    }

    public void deserialize(ByteBuffer byteBuffer) {
        this.deserialize(byteBuffer, AMFData.createContextDeserialize());
    }

    public void deserialize(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        block28: {
            try {
                this.type = byteBuffer.get();
                if (!aMFDataContextDeserialize.isAMF0()) {
                    switch (this.type) {
                        default: {
                            this.type = 6;
                            this.value = null;
                            break;
                        }
                        case 1: {
                            this.type = 5;
                            this.value = null;
                            break;
                        }
                        case 2: {
                            this.type = 1;
                            this.value = new Boolean(false);
                            break;
                        }
                        case 3: {
                            this.type = 1;
                            this.value = new Boolean(true);
                            break;
                        }
                        case 4: {
                            this.type = 32;
                            int n = AMF3Utils.deserializeInt(byteBuffer);
                            this.value = new Integer(n);
                            break;
                        }
                        case 5: {
                            this.type = 0;
                            this.value = new Double(byteBuffer.getDouble());
                            break;
                        }
                        case 7: {
                            this.type = 15;
                            int n = AMF3Utils.deserializeInt(byteBuffer);
                            if ((n & 1) == 0) {
                                this.value = aMFDataContextDeserialize.getObject(n >>= 1);
                                break;
                            }
                            this.value = (n >>= 1) > 0 ? AMF3Utils.deserializeString(byteBuffer, n) : "";
                            aMFDataContextDeserialize.addObject(this.value);
                            break;
                        }
                        case 11: {
                            this.type = 34;
                            int n = AMF3Utils.deserializeInt(byteBuffer);
                            if ((n & 1) == 0) {
                                this.value = aMFDataContextDeserialize.getObject(n >>= 1);
                                break;
                            }
                            this.value = (n >>= 1) > 0 ? AMF3Utils.deserializeString(byteBuffer, n) : "";
                            aMFDataContextDeserialize.addObject(this.value);
                            break;
                        }
                        case 6: {
                            this.type = 2;
                            this.value = AMF3Utils.deserializeString(byteBuffer, aMFDataContextDeserialize);
                            break;
                        }
                        case 8: {
                            this.type = 11;
                            int n = AMF3Utils.deserializeInt(byteBuffer);
                            if ((n & 1) == 0) {
                                this.value = aMFDataContextDeserialize.getObject(n >>= 1);
                                break;
                            }
                            this.value = AMF3Utils.deserializeDate(byteBuffer);
                            aMFDataContextDeserialize.addObject(this.value);
                            break;
                        }
                    }
                } else {
                    switch (this.type) {
                        default: {
                            this.type = 6;
                            this.value = null;
                            break;
                        }
                        case -1: 
                        case 5: {
                            this.type = 5;
                            this.value = null;
                            break;
                        }
                        case 0: {
                            this.value = new Double(byteBuffer.getDouble());
                            break;
                        }
                        case 1: {
                            byte by = byteBuffer.get();
                            this.value = new Boolean(by != 0);
                            break;
                        }
                        case 2: {
                            int n = BufferUtils.getUnsignedShort(byteBuffer);
                            byte[] byArray = new byte[n];
                            byteBuffer.get(byArray);
                            this.value = new String(byArray, "UTF-8");
                            break;
                        }
                        case 12: {
                            this.type = 2;
                            int n = byteBuffer.getInt();
                            byte[] byArray = new byte[n];
                            byteBuffer.get(byArray);
                            this.value = new String(byArray, "UTF-8");
                            break;
                        }
                        case 15: {
                            int n = byteBuffer.getInt();
                            byte[] byArray = new byte[n];
                            byteBuffer.get(byArray);
                            this.value = new String(byArray, "UTF-8");
                            aMFDataContextDeserialize.addObject(this);
                            break;
                        }
                        case 11: {
                            long l = (long)byteBuffer.getDouble();
                            int n = byteBuffer.getShort() * 60000 * -1;
                            TimeZone timeZone = TimeZone.getDefault();
                            GregorianCalendar gregorianCalendar = new GregorianCalendar();
                            gregorianCalendar.setTime(new Date(l - (long)timeZone.getRawOffset() + (long)n));
                            TimeZone timeZone2 = ((Calendar)gregorianCalendar).getTimeZone();
                            if (timeZone2.inDaylightTime(gregorianCalendar.getTime())) {
                                gregorianCalendar.setTime(new Date(gregorianCalendar.getTime().getTime() - 3600000L));
                            }
                            this.value = gregorianCalendar.getTime();
                            aMFDataContextDeserialize.addObject(this);
                        }
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(AMFDataItem.class).error("constructor AMFDataObj(ByteBuffer)[" + byteBuffer.position() + ":" + byteBuffer.limit() + "]: " + exception.toString());
                if (!WMSLoggerFactory.getLogger(AMFDataItem.class).isDebugEnabled()) break block28;
                WMSLoggerFactory.getLogger(AMFDataItem.class).error("    data\n" + DebugUtils.formatBytes(byteBuffer.array()) + "\n\n");
                exception.printStackTrace();
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        String string = null;
        switch (this.type) {
            default: {
                string = "undefined";
                break;
            }
            case -1: 
            case 5: {
                string = "null";
                break;
            }
            case 32: {
                string = ((Integer)this.value).toString();
                break;
            }
            case 0: {
                string = ((Double)this.value).toString();
                break;
            }
            case 1: {
                string = ((Boolean)this.value).toString();
                break;
            }
            case 2: {
                string = ((String)this.value).toString();
                break;
            }
            case 11: {
                string = ((Date)this.value).toString();
                break;
            }
            case 15: {
                string = ((String)this.value).toString();
                break;
            }
            case 34: {
                string = ((String)this.value).toString();
            }
        }
        return string;
    }

    public void serialize(DataOutputStream dataOutputStream) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(0));
    }

    public void serialize(DataOutputStream dataOutputStream, int n) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(n));
    }

    public void serialize(DataOutputStream dataOutputStream, AMFDataContextSerialize aMFDataContextSerialize) {
        try {
            if (!aMFDataContextSerialize.isAMF0()) {
                switch (this.type) {
                    default: {
                        dataOutputStream.writeByte(0);
                        break;
                    }
                    case -1: {
                        dataOutputStream.writeByte(0);
                        break;
                    }
                    case 5: {
                        dataOutputStream.writeByte(1);
                        break;
                    }
                    case 0: {
                        dataOutputStream.writeByte(5);
                        dataOutputStream.writeDouble((Double)this.value);
                        break;
                    }
                    case 32: {
                        int n = (Integer)this.value;
                        if (n >= -268435456 && n <= 0xFFFFFFF) {
                            dataOutputStream.writeByte(4);
                            AMF3Utils.serializeInt(dataOutputStream, n);
                            break;
                        }
                        dataOutputStream.writeByte(5);
                        dataOutputStream.writeDouble(((Integer)this.value).doubleValue());
                        break;
                    }
                    case 1: {
                        dataOutputStream.writeByte((Boolean)this.value != false ? 3 : 2);
                        break;
                    }
                    case 15: {
                        dataOutputStream.write(7);
                        int n = aMFDataContextSerialize.getObjectReference(this.value);
                        if (n >= 0) {
                            AMF3Utils.serializeInt(dataOutputStream, n <<= 1);
                            break;
                        }
                        String string = (String)this.value;
                        if (string.length() > 0) {
                            AMF3Utils.serializeString(dataOutputStream, string);
                            break;
                        }
                        AMF3Utils.serializeZeroLengthString(dataOutputStream);
                        break;
                    }
                    case 34: {
                        dataOutputStream.write(11);
                        int n = aMFDataContextSerialize.getObjectReference(this.value);
                        if (n >= 0) {
                            AMF3Utils.serializeInt(dataOutputStream, n <<= 1);
                            break;
                        }
                        String string = (String)this.value;
                        if (string.length() > 0) {
                            AMF3Utils.serializeString(dataOutputStream, string);
                            break;
                        }
                        AMF3Utils.serializeZeroLengthString(dataOutputStream);
                        break;
                    }
                    case 2: {
                        dataOutputStream.write(6);
                        aMFDataContextSerialize.writeString(dataOutputStream, (String)this.value);
                        break;
                    }
                    case 11: {
                        dataOutputStream.write(8);
                        int n = aMFDataContextSerialize.getObjectReference(this.value);
                        if (n >= 0) {
                            AMF3Utils.serializeInt(dataOutputStream, n <<= 1);
                            break;
                        }
                        AMF3Utils.serializeDate(dataOutputStream, (Date)this.value);
                        break;
                    }
                }
            } else {
                switch (this.type) {
                    default: {
                        dataOutputStream.writeByte(5);
                        break;
                    }
                    case 0: {
                        dataOutputStream.writeByte(0);
                        dataOutputStream.writeDouble((Double)this.value);
                        break;
                    }
                    case 32: {
                        dataOutputStream.writeByte(0);
                        dataOutputStream.writeDouble(((Integer)this.value).doubleValue());
                        break;
                    }
                    case 1: {
                        dataOutputStream.writeByte(1);
                        dataOutputStream.writeBoolean((Boolean)this.value);
                        break;
                    }
                    case 15: {
                        dataOutputStream.writeByte(15);
                        dataOutputStream.writeInt(((String)this.value).length());
                        AMF3Utils.serializeStringNoLength(dataOutputStream, (String)this.value);
                        break;
                    }
                    case 2: {
                        if (((String)this.value).length() > Short.MAX_VALUE) {
                            dataOutputStream.writeByte(12);
                            dataOutputStream.writeInt(((String)this.value).length());
                            AMF3Utils.serializeStringNoLength(dataOutputStream, (String)this.value);
                            break;
                        }
                        dataOutputStream.writeByte(2);
                        dataOutputStream.writeUTF(this.value.toString());
                        break;
                    }
                    case 11: {
                        dataOutputStream.writeByte(11);
                        dataOutputStream.writeDouble(((Date)this.value).getTime());
                        TimeZone timeZone = TimeZone.getDefault();
                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                        gregorianCalendar.setTime((Date)this.value);
                        boolean bl = timeZone.inDaylightTime(gregorianCalendar.getTime());
                        int n = -TimeZone.getDefault().getRawOffset() - (bl ? 3600000 : 0);
                        dataOutputStream.writeShort(n / 60000);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataItem.class).error("serialize: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public byte[] serialize() {
        return this.serialize(AMFData.createContextSerialize(0));
    }

    public byte[] serialize(int n) {
        return this.serialize(AMFData.createContextSerialize(n));
    }

    public byte[] serialize(AMFDataContextSerialize aMFDataContextSerialize) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(dataOutputStream, aMFDataContextSerialize);
        return byteArrayOutputStream.toByteArray();
    }
}

