/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.util.DebugUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataContextDeserialize;
import com.wowza.wms.amf.AMFDataContextSerialize;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class AMFDataList
extends AMFData {
    private List children = new ArrayList();

    public AMFDataList() {
        this.type = 10;
    }

    public AMFDataList(byte[] byArray) {
        this.type = 10;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.deserialize(byteBuffer);
    }

    public AMFDataList(byte[] byArray, int n, int n2) {
        this.type = 10;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        this.deserialize(byteBuffer);
    }

    public AMFDataList(ByteBuffer byteBuffer) {
        this.type = 10;
        this.deserialize(byteBuffer);
    }

    public AMFDataList(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        this.type = 10;
        this.deserialize(byteBuffer, aMFDataContextDeserialize);
    }

    public AMFData remove(int n) {
        if (n < this.children.size()) {
            return (AMFData)this.children.remove(n);
        }
        return null;
    }

    public int size() {
        return this.children.size();
    }

    public void add(AMFData aMFData) {
        this.children.add(aMFData);
    }

    public void add(String string) {
        this.children.add(new AMFDataItem(string));
    }

    public void add(double d) {
        this.children.add(new AMFDataItem(d));
    }

    public void add(int n) {
        this.children.add(new AMFDataItem(n));
    }

    public void add(long l) {
        this.children.add(new AMFDataItem(l));
    }

    public void add(Date date) {
        this.children.add(new AMFDataItem(date));
    }

    public void add(boolean bl) {
        this.children.add(new AMFDataItem(bl));
    }

    public void add(int n, AMFData aMFData) {
        this.children.add(n, aMFData);
    }

    public void add(int n, String string) {
        this.children.add(n, new AMFDataItem(string));
    }

    public void add(int n, double d) {
        this.children.add(n, new AMFDataItem(d));
    }

    public void add(int n, int n2) {
        this.children.add(n, new AMFDataItem(n2));
    }

    public void add(int n, long l) {
        this.children.add(n, new AMFDataItem(l));
    }

    public void add(int n, Date date) {
        this.children.add(n, new AMFDataItem(date));
    }

    public void add(int n, boolean bl) {
        this.children.add(n, new AMFDataItem(bl));
    }

    public void set(int n, AMFData aMFData) {
        this.children.set(n, aMFData);
    }

    public void set(int n, String string) {
        this.children.set(n, new AMFDataItem(string));
    }

    public void set(int n, double d) {
        this.children.set(n, new AMFDataItem(d));
    }

    public void set(int n, int n2) {
        this.children.set(n, new AMFDataItem(n2));
    }

    public void set(int n, long l) {
        this.children.set(n, new AMFDataItem(l));
    }

    public void set(int n, Date date) {
        this.children.set(n, new AMFDataItem(date));
    }

    public void set(int n, boolean bl) {
        this.children.set(n, new AMFDataItem(bl));
    }

    public int getType(int n) {
        try {
            if (n < this.children.size()) {
                AMFData aMFData = (AMFData)this.children.get(n);
                return aMFData == null ? -1 : aMFData.getType();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataList.class).error("get: " + exception.toString());
            exception.printStackTrace();
        }
        return -1;
    }

    public AMFData get(int n) {
        try {
            if (n < this.children.size()) {
                return (AMFData)this.children.get(n);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataList.class).error("get: " + exception.toString());
            exception.printStackTrace();
        }
        return null;
    }

    public String getString(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.toString() : null;
    }

    public int getInt(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.intValue() : 0;
    }

    public long getLong(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.longValue() : 0L;
    }

    public double getDouble(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.doubleValue() : 0.0;
    }

    public float getFloat(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.floatValue() : 0.0f;
    }

    public short getShort(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.shortValue() : (short)0;
    }

    public byte getByte(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.byteValue() : (byte)0;
    }

    public boolean getBoolean(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.booleanValue() : false;
    }

    public Date getDate(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return (Date)(aMFDataItem != null ? (aMFDataItem.getType() == 11 ? aMFDataItem.getValue() : null) : null);
    }

    public AMFDataObj getObject(int n) {
        AMFDataObj aMFDataObj = (AMFDataObj)this.get(n);
        return aMFDataObj;
    }

    public void deserialize(ByteBuffer byteBuffer) {
        this.deserialize(byteBuffer, AMFData.createContextDeserialize());
    }

    public void deserialize(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        block5: {
            try {
                while (byteBuffer.hasRemaining()) {
                    AMFData aMFData = AMFData.deserializeInnerObject(byteBuffer, aMFDataContextDeserialize);
                    if (aMFData != null) {
                        this.children.add(aMFData);
                    } else {
                        WMSLoggerFactory.getLogger(AMFDataList.class).error("AMFDataList.deserialize: no object");
                    }
                    aMFDataContextDeserialize.setObjectEncoding(0);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(AMFDataItem.class).error("constructor AMFDataObj(DataList)[" + byteBuffer.position() + ":" + byteBuffer.limit() + "]: " + exception.toString());
                if (!WMSLoggerFactory.getLogger(AMFDataItem.class).isDebugEnabled()) break block5;
                WMSLoggerFactory.getLogger(AMFDataItem.class).error("    data\n" + DebugUtils.formatBytes(byteBuffer.array()) + "\n\n");
                exception.printStackTrace();
            }
        }
    }

    public void serialize(DataOutputStream dataOutputStream) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(0), null);
    }

    public void serialize(DataOutputStream dataOutputStream, int n) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(n), null);
    }

    public void serialize(DataOutputStream dataOutputStream, AMFDataContextSerialize aMFDataContextSerialize) {
        this.serialize(dataOutputStream, aMFDataContextSerialize, null);
    }

    public void serialize(DataOutputStream dataOutputStream, AMFDataContextSerialize aMFDataContextSerialize, byte[] byArray) {
        try {
            if (byArray != null) {
                dataOutputStream.write(byArray);
            }
            int n = aMFDataContextSerialize.getTargetEncoding();
            for (AMFData aMFData : this.children) {
                if (aMFDataContextSerialize.getObjectEncoding() < n && AMFDataList.triggerAMF3Switch(aMFData)) {
                    dataOutputStream.write(17);
                    aMFDataContextSerialize.setObjectEncoding(n);
                }
                aMFData.serialize(dataOutputStream, aMFDataContextSerialize);
                aMFDataContextSerialize.setObjectEncoding(0);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataList.class).error("serialize: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public byte[] serialize() {
        return this.serialize(AMFData.createContextSerialize(0));
    }

    public byte[] serialize(int n) {
        return this.serialize(AMFData.createContextSerialize(n));
    }

    public byte[] serialize(AMFDataContextSerialize aMFDataContextSerialize) {
        return this.serialize(aMFDataContextSerialize, null);
    }

    public byte[] serialize(AMFDataContextSerialize aMFDataContextSerialize, byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(dataOutputStream, aMFDataContextSerialize, byArray);
        return byteArrayOutputStream.toByteArray();
    }

    public Object getValue() {
        return this.children;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AMFDataList:\n");
        Iterator iterator = this.children.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            AMFData aMFData = (AMFData)iterator.next();
            if (aMFData.getType() == 3) {
                stringBuffer.append("[" + n + "] object\n" + aMFData.toString() + "\n");
            } else {
                stringBuffer.append("[" + n + "] " + aMFData.toString() + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

