/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.authentication;

import com.wowza.util.Base64;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.authentication.AuthenticationItem;
import com.wowza.wms.authentication.IAuthenticate;
import com.wowza.wms.authentication.IAuthenticateHTTPProvider;
import com.wowza.wms.authentication.IAuthenticateRTSP;
import com.wowza.wms.authentication.IAuthenticateUsernamePasswordProvider;
import com.wowza.wms.authentication.file.AuthenticationPasswordFile;
import com.wowza.wms.authentication.file.AuthenticationPasswordFiles;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.rtsp.RTSPResponseMessage;
import com.wowza.wms.rtsp.RTSPResponseMessages;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.util.AuthenticationUtils;
import com.wowza.wms.vhost.IVHost;
import java.io.File;
import java.util.HashMap;

public class AuthenticateBasic
implements IAuthenticate,
IAuthenticateRTSP,
IAuthenticateHTTPProvider {
    private AuthenticationItem authenticationItem = null;
    private boolean isAuthenticated = false;
    private String realm = null;
    private File passwordFile = null;
    private String usernamePasswordProviderClass = null;

    public void init(IApplicationInstance iApplicationInstance, AuthenticationItem authenticationItem) {
        this.authenticationItem = authenticationItem;
        this.realm = this.authenticationItem.getProperties().getPropertyStr("realm", this.realm);
        this.usernamePasswordProviderClass = this.authenticationItem.getProperties().getPropertyStr("usernamePasswordProviderClass", this.usernamePasswordProviderClass);
        String string = this.authenticationItem.getProperties().getPropertyStr("passwordFile", null);
        if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            IVHost iVHost = iApplicationInstance.getVHost();
            hashMap.put("com.wowza.wms.context.VHost", iVHost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iVHost.getHomePath());
            hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
            hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
            string = SystemUtils.expandEnvironmentVariables(string, hashMap);
            this.passwordFile = new File(string);
        }
    }

    public void init(IVHost iVHost, AuthenticationItem authenticationItem) {
        this.authenticationItem = authenticationItem;
        this.realm = this.authenticationItem.getProperties().getPropertyStr("realm", this.realm);
        String string = this.authenticationItem.getProperties().getPropertyStr("passwordFile", null);
        if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.wowza.wms.context.VHost", iVHost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iVHost.getHomePath());
            string = SystemUtils.expandEnvironmentVariables(string, hashMap);
            this.passwordFile = new File(string);
        }
    }

    private String getAuthString() {
        String string = "Basic";
        if (this.realm != null) {
            string = string + " realm=\"" + this.realm + "\"";
        }
        return string;
    }

    public boolean authenticateRTSP(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        Object object;
        Object object2;
        if (this.isAuthenticated) {
            return true;
        }
        boolean bl = false;
        String string = rTSPRequestMessage.getHeader("authorization");
        if (string != null) {
            if ((string = string.trim()).toLowerCase().startsWith("basic ")) {
                string = string.substring(6);
            }
            string = string.trim();
            object2 = Base64.decode(string);
            object = new String((byte[])object2);
            Object object3 = null;
            String string2 = null;
            int n = ((String)object).indexOf(":");
            if (n >= 0) {
                object3 = ((String)object).substring(0, n);
                string2 = ((String)object).substring(n + 1);
            } else {
                object3 = object;
            }
            IAuthenticateUsernamePasswordProvider iAuthenticateUsernamePasswordProvider = null;
            if (this.usernamePasswordProviderClass != null) {
                iAuthenticateUsernamePasswordProvider = AuthenticationUtils.createUsernamePasswordProvider(this.usernamePasswordProviderClass);
            } else if (this.passwordFile != null) {
                iAuthenticateUsernamePasswordProvider = AuthenticationPasswordFiles.getInstance().getPasswordFile(this.passwordFile);
            }
            if (iAuthenticateUsernamePasswordProvider != null) {
                iAuthenticateUsernamePasswordProvider.setRTPSession(rTPSession);
                if (object3 != null && string2 != null) {
                    String string3 = iAuthenticateUsernamePasswordProvider.getPassword((String)object3);
                    if (string3.equals(string2)) {
                        bl = true;
                        this.isAuthenticated = true;
                    }
                } else if (iAuthenticateUsernamePasswordProvider.userExists((String)object3) && iAuthenticateUsernamePasswordProvider.getPassword((String)object3) == null) {
                    bl = true;
                    this.isAuthenticated = true;
                }
            } else {
                WMSLoggerFactory.getLogger(AuthenticationPasswordFile.class).warn("AuthenticateBasic.authenticateRTSP: Password file not found: " + this.passwordFile);
            }
        }
        if (!bl) {
            object2 = new RTPRequestStatus();
            RTSPStatics.setStatus((RTPRequestStatus)object2, 401);
            object = new RTSPResponseMessage();
            ((RTSPResponseMessage)object).setResponseCode(((RTPRequestStatus)object2).getResponseCode());
            ((RTSPResponseMessage)object).setResponseMessage(((RTPRequestStatus)object2).getResponseMessage());
            ((RTSPResponseMessage)object).setHeader("WWW-Authenticate", this.getAuthString());
            ((RTSPResponseMessage)object).setCSeq(rTSPRequestMessage.getCSeq());
            ((RTSPResponseMessage)object).setSession(rTPSession.getSessionId());
            rTSPResponseMessages.addMessage((RTSPResponseMessage)object);
        }
        return bl;
    }

    public boolean authenticateHTTPProvider(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        boolean bl = false;
        String string = iHTTPRequest.getHeader("authorization");
        if (string != null) {
            if ((string = string.trim()).toLowerCase().startsWith("basic ")) {
                string = string.substring(6);
            }
            string = string.trim();
            byte[] byArray = Base64.decode(string);
            String string2 = new String(byArray);
            String string3 = null;
            String string4 = null;
            int n = string2.indexOf(":");
            if (n >= 0) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
            } else {
                string3 = string2;
            }
            IAuthenticateUsernamePasswordProvider iAuthenticateUsernamePasswordProvider = null;
            if (this.usernamePasswordProviderClass != null) {
                iAuthenticateUsernamePasswordProvider = AuthenticationUtils.createUsernamePasswordProvider(this.usernamePasswordProviderClass);
            } else if (this.passwordFile != null) {
                iAuthenticateUsernamePasswordProvider = AuthenticationPasswordFiles.getInstance().getPasswordFile(this.passwordFile);
            }
            if (iAuthenticateUsernamePasswordProvider != null) {
                iAuthenticateUsernamePasswordProvider.setVHost(iVHost);
                if (string3 != null && string4 != null) {
                    String string5 = iAuthenticateUsernamePasswordProvider.getPassword(string3);
                    if (string5.equals(string4)) {
                        bl = true;
                        this.isAuthenticated = true;
                    }
                } else if (iAuthenticateUsernamePasswordProvider.userExists(string3) && iAuthenticateUsernamePasswordProvider.getPassword(string3) == null) {
                    bl = true;
                    this.isAuthenticated = true;
                }
            } else {
                WMSLoggerFactory.getLogger(AuthenticationPasswordFile.class).warn("AuthenticateBasic.authenticateHTTPProvider: Password file not found: " + this.passwordFile);
            }
        }
        if (!bl) {
            iHTTPResponse.setResponseCode(401);
            iHTTPResponse.setHeader("WWW-Authenticate", this.getAuthString());
        }
        return bl;
    }
}

