/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.aac;

import com.wowza.wms.media.aac.AACFrame;

public class AACUtils {
    public static final int AAC_HEADER_SIZE = 7;
    public static final int[] AAC_SAMPLERATES = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350};
    public static final int[] AAC_CHANNELS = new int[]{0, 1, 2, 3, 4, 5, 6, 8};

    public static int sampleRateToIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < AAC_SAMPLERATES.length; ++i) {
            if (n != AAC_SAMPLERATES[i]) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public static int channelCountToIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < AAC_CHANNELS.length; ++i) {
            if (n != AAC_CHANNELS[i]) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public static int decodeFirstChunkAACP(byte[] byArray, int n, long l) {
        int n2 = n;
        int n3 = 0;
        while ((long)n3 < l - 7L) {
            AACFrame aACFrame;
            AACFrame aACFrame2 = AACUtils.decodeFrame(byArray, n3 + n);
            if (aACFrame2 != null && (long)(n3 + n + aACFrame2.getSize() + 7) < l && (aACFrame = AACUtils.decodeFrame(byArray, n3 + n + aACFrame2.getSize())) != null) {
                n2 = n3 + n;
                break;
            }
            ++n3;
        }
        return n2;
    }

    public static boolean compareFrameParams(byte[] byArray, long l, int n, int n2) {
        boolean bl;
        block1: {
            bl = false;
            int n3 = (int)l;
            if ((byArray[n3 + 0] & 0xFF) != 255 || (byArray[n3 + 1] & 0xF0) != 240) break block1;
            int n4 = byArray[n3 + 2] & 0x3C;
            int n5 = byArray[n3 + 2] & 1;
            n5 <<= 2;
            if (n == (n4 >>= 2) && n2 == (n5 += (byte)(byArray[n3 + 3] >> 6) & 3)) {
                bl = true;
            }
        }
        return bl;
    }

    public static void frameToDTSBuffer(AACFrame aACFrame, byte[] byArray, int n) {
        int n2 = aACFrame.getRateIndex();
        int n3 = aACFrame.getProfileObjectType();
        int n4 = aACFrame.getChannelIndex();
        int n5 = aACFrame.getSize();
        boolean bl = aACFrame.isErrorBitsAbsent();
        byArray[n + 0] = -1;
        byArray[n + 1] = (byte)(240 + (bl ? 1 : 0));
        byArray[n + 2] = (byte)((n3 - 1 & 3) << 6);
        int n6 = n + 2;
        byArray[n6] = (byte)(byArray[n6] + (byte)(n2 << 2 & 0x3C));
        int n7 = n + 2;
        byArray[n7] = (byte)(byArray[n7] + (byte)(n4 >> 2 & 1));
        byArray[n + 3] = (byte)((n4 & 3) << 6);
        byArray[n + 5] = (byte)((n5 & 7) << 5);
        byArray[n + 4] = (byte)((n5 >>= 3) & 0xFF);
        int n8 = n + 3;
        byArray[n8] = (byte)(byArray[n8] + (byte)((n5 >>= 8) & 3));
        int n9 = 2047;
        int n10 = n + 5;
        byArray[n10] = (byte)(byArray[n10] + (n9 >> 6));
        byArray[n + 6] = (byte)(n9 << 2 & 0xFF);
        int n11 = aACFrame.getRdb();
        int n12 = n + 6;
        byArray[n12] = (byte)(byArray[n12] + (byte)(n11 & 3));
    }

    public static AACFrame decodeFrame(byte[] byArray, long l) {
        AACFrame aACFrame;
        block3: {
            aACFrame = null;
            int n = (int)l;
            if ((byArray[n + 0] & 0xFF) != 255 || (byArray[n + 1] & 0xF0) != 240) break block3;
            int n2 = 0;
            int n3 = 0;
            boolean bl = (byArray[n + 1] & 1) == 1;
            int n4 = (byArray[n + 2] >> 6 & 3) + 1;
            int n5 = byArray[n + 2] & 0x3C;
            if ((n5 >>= 2) >= 0 && n5 < AAC_SAMPLERATES.length) {
                n2 = AAC_SAMPLERATES[n5];
                int n6 = byArray[n + 2] & 1;
                n6 <<= 2;
                if ((n6 += (byte)(byArray[n + 3] >> 6) & 3) >= 0 && n6 < AAC_CHANNELS.length) {
                    n3 = AAC_CHANNELS[n6];
                    int n7 = byArray[n + 3] & 3;
                    n7 <<= 8;
                    n7 += byArray[n + 4] & 0xFF;
                    n7 <<= 3;
                    if ((n7 += byArray[n + 5] >> 5 & 7) > 0) {
                        int n8 = byArray[n + 6] & 3;
                        aACFrame = new AACFrame();
                        aACFrame.setChannelIndex(n6);
                        aACFrame.setChannels(n3);
                        aACFrame.setRdb(n8);
                        aACFrame.setRateIndex(n5);
                        aACFrame.setSampleRate(n2);
                        aACFrame.setSize(n7);
                        aACFrame.setErrorBitsAbsent(bl);
                        aACFrame.setProfileObjectType(n4);
                    }
                }
            }
        }
        return aACFrame;
    }

    public static void encodeAACCodecConfig(AACFrame aACFrame, byte[] byArray, int n) {
        int n2 = aACFrame.getProfileObjectType();
        int n3 = aACFrame.getRateIndex();
        int n4 = aACFrame.getChannelIndex();
        byArray[n + 0] = (byte)(n2 << 3);
        int n5 = n + 0;
        byArray[n5] = (byte)(byArray[n5] + (byte)(n3 >> 1));
        byArray[n + 1] = (byte)(n3 << 7);
        int n6 = n + 1;
        byArray[n6] = (byte)(byArray[n6] + (byte)(n4 << 3));
    }

    public static String profileObjectTypeToString(int n) {
        String string = "Unknown[" + n + "]";
        switch (n) {
            case 0: {
                string = "NULL[0]";
                break;
            }
            case 1: {
                string = "Main";
                break;
            }
            case 2: {
                string = "LC";
                break;
            }
            case 3: {
                string = "SBR";
                break;
            }
            case 4: {
                string = "LongTermPrediction";
                break;
            }
            case 5: {
                string = "HE";
                break;
            }
            case 6: {
                string = "Scalable";
                break;
            }
            case 7: {
                string = "TwinVQ";
                break;
            }
            case 8: {
                string = "CELP";
                break;
            }
            case 9: {
                string = "HVXC";
                break;
            }
            case 10: {
                string = "Reserved[10]";
                break;
            }
            case 11: {
                string = "Reserved[11]";
                break;
            }
            case 12: {
                string = "TTSI";
                break;
            }
            case 13: {
                string = "Synthetic";
                break;
            }
            case 14: {
                string = "WavetableSynthesis";
                break;
            }
            case 15: {
                string = "GeneralMIDI";
                break;
            }
            case 16: {
                string = "AlgorithmicSynthesisAndAudioFX";
                break;
            }
            case 17: {
                string = "LowComplexityWithErrorRecovery";
                break;
            }
            case 18: {
                string = "Reserved[18]";
                break;
            }
            case 19: {
                string = "LongTermPredictionWithErrorRecover";
                break;
            }
            case 20: {
                string = "ScalableWithErrorRecovery";
                break;
            }
            case 21: {
                string = "TwinVQWithErrorRecovery";
                break;
            }
            case 22: {
                string = "BSACWithErrorRecovery";
                break;
            }
            case 23: {
                string = "LDWithErrorRecovery";
                break;
            }
            case 24: {
                string = "CELPWithErrorRecovery";
                break;
            }
            case 25: {
                string = "HXVCWithErrorRecovery";
                break;
            }
            case 26: {
                string = "HILNWithErrorRecovery";
                break;
            }
            case 27: {
                string = "ParametricWithErrorRecovery";
                break;
            }
            case 28: {
                string = "Reserved[28]";
                break;
            }
            case 29: {
                string = "Reserved[29]";
                break;
            }
            case 30: {
                string = "Reserved[30]";
                break;
            }
            case 31: {
                string = "Reserved[31]";
            }
        }
        return string;
    }

    public static AACFrame decodeAACCodecConfig(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xF8) >> 3;
        int n3 = (byArray[n] & 7) << 1;
        int n4 = (byArray[n + 1] & 0x7F) >> 3;
        int n5 = 0;
        int n6 = 0;
        if ((n3 += (byArray[n + 1] & 0x80) >> 7 & 1) >= 0 && n3 < AAC_SAMPLERATES.length) {
            n5 = AAC_SAMPLERATES[n3];
        }
        if (n4 >= 0 && n4 < AAC_CHANNELS.length) {
            n6 = AAC_CHANNELS[n4];
        }
        AACFrame aACFrame = null;
        aACFrame = new AACFrame();
        aACFrame.setProfileObjectType(n2);
        aACFrame.setChannelIndex(n4);
        aACFrame.setChannels(n6);
        aACFrame.setRateIndex(n3);
        aACFrame.setSampleRate(n5);
        return aACFrame;
    }

    public static byte[] codecConfigToWaveFormatEX(byte[] byArray, int n, int n2) {
        AACFrame aACFrame = AACUtils.decodeAACCodecConfig(byArray, n);
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        System.arraycopy(byArray, n, byArray2, n3, n2);
        return byArray2;
    }
}

