/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.mp3.model.idtags;

import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameBase;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameSynchronizedTextDescriptor;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID3V2FrameSynchronizedText
extends ID3V2FrameBase {
    public static final int CONTENTTYPE_OTHER = 0;
    public static final int CONTENTTYPE_LYRICS = 1;
    public static final int CONTENTTYPE_TRANSCRPTION = 2;
    public static final int CONTENTTYPE_MOVEMENT = 3;
    public static final int CONTENTTYPE_EVENTS = 4;
    public static final int CONTENTTYPE_CHORD = 5;
    public static final int CONTENTTYPE_TRIVIA = 6;
    public static final int CONTENTTYPE_URLWEBPAGES = 7;
    public static final int CONTENTTYPE_URLIMAGES = 8;
    public static final int TIMESTAMPFORMAT_MPEG = 1;
    public static final int TIMESTAMPFORMAT_MILLISECONDS = 2;
    private int textEncoding = 3;
    private String language = "eng";
    private byte timeStampFormat = (byte)2;
    private byte contentType = 0;
    private List<ID3V2FrameSynchronizedTextDescriptor> contentDescriptors = new ArrayList<ID3V2FrameSynchronizedTextDescriptor>();

    public ID3V2FrameSynchronizedText(String string, int n) {
        super(string, n);
    }

    public ID3V2FrameSynchronizedText() {
        super("SYLT", 0);
    }

    @Override
    public int serializeBody(byte[] byArray, int n) {
        int n2 = 0;
        try {
            byArray[n + n2] = (byte)(this.textEncoding & 0xFF);
            byte[] byArray2 = this.language.getBytes();
            System.arraycopy(byArray2, 0, byArray, n + ++n2, 3);
            byArray[n + (n2 += 3)] = (byte)(this.timeStampFormat & 0xFF);
            byArray[n + ++n2] = (byte)(this.contentType & 0xFF);
            ++n2;
            if (this.contentDescriptors.size() > 0) {
                for (ID3V2FrameSynchronizedTextDescriptor iD3V2FrameSynchronizedTextDescriptor : this.contentDescriptors) {
                    int n3 = ID3V2FrameSynchronizedText.serializeString(iD3V2FrameSynchronizedTextDescriptor.getValue(), byArray, n + n2);
                    BufferUtils.longToByteArray(iD3V2FrameSynchronizedTextDescriptor.getTimecode(), byArray, n + (n2 += n3), 4);
                    n2 += 4;
                }
            } else {
                byArray[n + n2] = 0;
                ++n2;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.serializeBody: " + exception.toString());
        }
        return n2;
    }

    private int getContentDescriptorSize() {
        int n = 0;
        if (this.contentDescriptors.size() > 0) {
            for (ID3V2FrameSynchronizedTextDescriptor iD3V2FrameSynchronizedTextDescriptor : this.contentDescriptors) {
                n += ID3V2FrameSynchronizedText.serializeStringLen(iD3V2FrameSynchronizedTextDescriptor.getValue());
                n += 4;
            }
        } else {
            ++n;
        }
        return n;
    }

    @Override
    public void deserializeBody(byte[] byArray, int n, int n2) {
        try {
            if (n + 1 < n2) {
                this.textEncoding = byArray[n] & 0xFF;
                if (++n + 3 < n2) {
                    this.language = BufferUtils.byteArrayToString(byArray, n, 3);
                    if ((n += 3) + 1 < n2) {
                        this.timeStampFormat = (byte)(byArray[n] & 0xFF);
                        if (++n + 1 < n2) {
                            String string;
                            this.contentType = (byte)(byArray[n] & 0xFF);
                            ++n;
                            this.contentDescriptors.clear();
                            while ((string = ID3V2FrameSynchronizedText.deserializeString(byArray, n, n2)) != null && string.length() > 0 && (n += string.length() + 1) + 4 < n2) {
                                long l = BufferUtils.byteArrayToLong(byArray, n, 4);
                                n += 4;
                                this.contentDescriptors.add(new ID3V2FrameSynchronizedTextDescriptor(l, string));
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.deserializeBody: " + exception.toString());
        }
    }

    @Override
    public int getBodySize() {
        return 6 + this.getContentDescriptorSize();
    }

    public int getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(int n) {
        this.textEncoding = n;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public byte getTimeStampFormat() {
        return this.timeStampFormat;
    }

    public void setTimeStampFormat(byte by) {
        this.timeStampFormat = by;
    }

    public byte getContentType() {
        return this.contentType;
    }

    public void setContentType(byte by) {
        this.contentType = by;
    }

    public List<ID3V2FrameSynchronizedTextDescriptor> getContentDescriptors() {
        return this.contentDescriptors;
    }

    public void addContentDescriptor(ID3V2FrameSynchronizedTextDescriptor iD3V2FrameSynchronizedTextDescriptor) {
        this.contentDescriptors.add(iD3V2FrameSynchronizedTextDescriptor);
    }

    public void addContentDescriptor(long l, String string) {
        this.contentDescriptors.add(new ID3V2FrameSynchronizedTextDescriptor(l, string));
    }
}

