/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster;

import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.IMediaCasterValidateMediaCaster;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.wowza.LiveMediaStreamReceiver;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.mina.common.IoSession;

public abstract class MediaCaster
implements IMediaCaster {
    public static boolean debugLog = false;
    protected IApplicationInstance appInstance = null;
    protected String mediaCasterId = "unknown";
    protected IMediaStream stream = null;
    protected String streamExt = "flv";
    protected MediaCasterItem mediaCasterDef = null;
    protected MediaCasterStreamItem mediaCasterStreamItem = null;
    protected WMSProperties properties = new WMSProperties();
    protected long connectLastAttempt = -1L;
    protected long connectLastSuccess = -1L;
    protected long connectLastForceReset = -1L;
    protected int streamTimeout = 0;
    protected long streamMissingTime = -1L;
    protected long streamLastSeq = -1L;
    protected int streamTimeoutReason = 0;
    protected long streamTimeoutLastTime = -1L;
    protected long streamTimeoutLastReset = -1L;
    protected boolean streamIsRunning = false;
    protected Object streamIsRunningLock = new Object();
    protected List<IoSession> sessions = new ArrayList<IoSession>();
    protected Object lock = new Object();
    protected int reconnectWaitTime = 3000;
    protected int mediaCasterType = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStreamTimeout() {
        Object object = this.lock;
        synchronized (object) {
            this.streamMissingTime = -1L;
            this.streamLastSeq = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionListDebug() {
        String string = "{";
        Object object = this.lock;
        synchronized (object) {
            Iterator<IoSession> iterator = this.sessions.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                IoSession ioSession = iterator.next();
                string = string + "[" + n + "]: " + ioSession.hashCode() + " ";
                ++n;
            }
        }
        string = string + "}";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrentSession(IoSession ioSession) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.sessions.size() > 0) {
                IoSession ioSession2 = this.sessions.get(this.sessions.size() - 1);
                boolean bl2 = bl = ioSession2 == ioSession;
                if (debugLog) {
                    WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("MediaCaster.isCurrentSession: " + ioSession.hashCode() + "|" + this.getSessionListDebug());
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSession getLastSession() {
        IoSession ioSession = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.sessions.size() > 0) {
                ioSession = this.sessions.get(this.sessions.size() - 1);
            }
        }
        return ioSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(IoSession ioSession) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.add(ioSession);
            if (debugLog) {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("MediaCaster.addSession: " + ioSession.hashCode() + "|" + this.getSessionListDebug());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(IoSession ioSession) {
        Object object = this.lock;
        synchronized (object) {
            this.sessions.remove(ioSession);
            if (debugLog) {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("MediaCaster.removeSession: " + ioSession.hashCode() + "|" + this.getSessionListDebug());
            }
        }
    }

    public void init(MediaCasterStreamItem mediaCasterStreamItem, MediaCasterItem mediaCasterItem, IApplicationInstance iApplicationInstance, String string, String string2) {
        this.mediaCasterStreamItem = mediaCasterStreamItem;
        this.mediaCasterDef = mediaCasterItem;
        this.mediaCasterId = string;
        this.appInstance = iApplicationInstance;
        this.streamExt = string2;
        WMSProperties.cloneProperties(mediaCasterItem.getProperties(), this.properties);
        WMSProperties.cloneProperties(iApplicationInstance.getMediaCasterProperties(), this.properties);
        this.reconnectWaitTime = this.properties.getPropertyInt("reconnectWaitTime", this.reconnectWaitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStreamRunning(boolean bl) {
        boolean bl2 = false;
        Object object = this.streamIsRunningLock;
        synchronized (object) {
            if (this.streamIsRunning != bl) {
                this.streamIsRunning = bl;
                bl2 = true;
            }
        }
        if (bl2 && (object = this.appInstance) != null) {
            if (bl) {
                ((ApplicationInstance)object).notifyMediaCasterStreamStart(this);
            } else {
                ((ApplicationInstance)object).notifyMediaCasterStreamStop(this);
            }
        }
    }

    public IVHost getVHost() {
        return this.appInstance != null ? this.appInstance.getVHost() : null;
    }

    public String getMediaCasterId() {
        return this.mediaCasterId;
    }

    public void setMediaCasterId(String string) {
        this.mediaCasterId = string;
    }

    public IMediaStream getStream() {
        return this.stream;
    }

    public void setStream(IMediaStream iMediaStream) {
        this.stream = iMediaStream;
        ((ApplicationInstance)this.appInstance).notifyMediaCasterSetSourceStream(this, iMediaStream);
    }

    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    public void setAppInstance(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
    }

    public MediaCasterItem getMediaCasterDef() {
        return this.mediaCasterDef;
    }

    public void setMediaCasterDef(MediaCasterItem mediaCasterItem) {
        this.mediaCasterDef = mediaCasterItem;
    }

    public int getIdleTimeout() {
        return this.mediaCasterDef.getConnectionTimeout();
    }

    public MediaCasterStreamItem getMediaCasterStreamItem() {
        return this.mediaCasterStreamItem;
    }

    public void forceReset() {
        WMSLoggerFactory.getLogger(MediaCaster.class).warn("MediaCaster.forceReset: not implemented for this MediaCaster type");
    }

    public boolean doWatchdog() {
        return false;
    }

    public WMSProperties getProperties() {
        return this.properties;
    }

    public String getStreamExt() {
        return this.streamExt;
    }

    public void setStreamExt(String string) {
        this.streamExt = string;
    }

    public int getStreamTimeout() {
        return this.streamTimeout;
    }

    public void setStreamTimeout(int n) {
        this.streamTimeout = n;
    }

    public long getStreamMissingTime() {
        return this.streamMissingTime;
    }

    public void setStreamMissingTime(long l) {
        this.streamMissingTime = l;
    }

    public long getStreamLastSeq() {
        return this.streamLastSeq;
    }

    public void setStreamLastSeq(long l) {
        this.streamLastSeq = l;
    }

    public int getStreamTimeoutReason() {
        return this.streamTimeoutReason;
    }

    public void setStreamTimeoutReason(int n) {
        this.streamTimeoutReason = n;
    }

    public long getStreamTimeoutLastTime() {
        return this.streamTimeoutLastTime;
    }

    public void setStreamTimeoutLastTime(long l) {
        this.streamTimeoutLastTime = l;
    }

    public long getStreamTimeoutLastReset() {
        return this.streamTimeoutLastReset;
    }

    public void setStreamTimeoutLastReset(long l) {
        this.streamTimeoutLastReset = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSession() {
        Object object = this.lock;
        synchronized (object) {
            return this.sessions.size() > 0;
        }
    }

    public boolean isStream() {
        return this.stream != null;
    }

    public long getConnectLastAttempt() {
        return this.connectLastAttempt;
    }

    public void setConnectLastAttempt(long l) {
        this.connectLastAttempt = l;
    }

    public long getConnectLastSuccess() {
        return this.connectLastSuccess;
    }

    public void setConnectLastSuccess(long l) {
        this.connectLastSuccess = l;
    }

    public long getConnectLastForceReset() {
        return this.connectLastForceReset;
    }

    public void setConnectLastForceReset(long l) {
        this.connectLastForceReset = l;
    }

    public boolean isStreamIsRunning() {
        return this.streamIsRunning;
    }

    public void setStreamIsRunning(boolean bl) {
        this.streamIsRunning = bl;
    }

    public Object getStreamIsRunningLock() {
        return this.streamIsRunningLock;
    }

    public int getReconnectWaitTime() {
        return this.reconnectWaitTime;
    }

    public void setReconnectWaitTime(int n) {
        this.reconnectWaitTime = n;
    }

    protected int getReconnectDelay(long l) {
        long l2;
        int n = 0;
        if (this.connectLastAttempt >= 0L && (l2 = l - this.connectLastAttempt) > 0L && l2 < (long)this.reconnectWaitTime) {
            n = (int)((long)this.reconnectWaitTime - l2);
        }
        return n;
    }

    public int getMediaCasterType() {
        return this.mediaCasterType;
    }

    public void setMediaCasterType(int n) {
        this.mediaCasterType = n;
    }

    protected boolean validateMediaCaster() {
        boolean bl;
        block0: {
            IMediaCasterValidateMediaCaster iMediaCasterValidateMediaCaster;
            bl = true;
            if (this.appInstance == null || (iMediaCasterValidateMediaCaster = this.appInstance.getMediaCasterValidator()) == null) break block0;
            bl = iMediaCasterValidateMediaCaster.onValidateMediaCaster(this.appInstance, this);
        }
        return bl;
    }

    protected boolean resetMediaCaster() {
        boolean bl;
        block0: {
            IMediaCasterValidateMediaCaster iMediaCasterValidateMediaCaster;
            bl = true;
            if (this.appInstance == null || (iMediaCasterValidateMediaCaster = this.appInstance.getMediaCasterValidator()) == null) break block0;
            bl = iMediaCasterValidateMediaCaster.onResetMediaCaster(this.appInstance, this);
        }
        return bl;
    }
}

