/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster;

import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.MediaCasterFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.stream.IMediaStreamPlay;
import java.util.ArrayList;
import java.util.List;

public class MediaCasterStreamItem {
    private String mediaCasterId = "";
    private String streamExt = "flv";
    private String liveStreamPacketizer = null;
    private String liveStreamRepeater = null;
    private MediaCasterItem mediaCasterDef = null;
    private MediaCasterStreamMap parent = null;
    private IMediaCaster mediaCaster = null;
    private boolean shutdownOnRelease = false;
    private boolean isValid = true;
    private List<IMediaStreamPlay> players = new ArrayList<IMediaStreamPlay>();
    private int lockCount = 0;
    private long removeTime = 0L;
    private Object lock = new Object();
    private long uniqueId = -1L;

    public MediaCasterStreamItem(long l) {
        this.uniqueId = l;
    }

    public Object getLock() {
        return this.lock;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.isValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValid(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.isValid = bl;
        }
    }

    public void init(String string, String string2, MediaCasterItem mediaCasterItem, MediaCasterStreamMap mediaCasterStreamMap, String string3, String string4) {
        this.mediaCasterId = string;
        this.streamExt = string2;
        this.mediaCasterDef = mediaCasterItem;
        this.parent = mediaCasterStreamMap;
        this.liveStreamPacketizer = string3;
        this.liveStreamRepeater = string4;
    }

    public String getMediaCasterId() {
        return this.mediaCasterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaCaster getMediaCaster() {
        IMediaCaster iMediaCaster = null;
        Object object = this.lock;
        synchronized (object) {
            iMediaCaster = this.mediaCaster;
        }
        return iMediaCaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMediaCaster checkMediaCaster(boolean bl) {
        IMediaCaster iMediaCaster = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.mediaCaster == null && bl) {
                this.mediaCaster = MediaCasterFactory.createMediaCaster(this, this.mediaCasterDef, this.parent.getApplicationInstance(), this.mediaCasterId, this.streamExt);
                ((ApplicationInstance)this.parent.getApplicationInstance()).notifyMediaCasterCreate(this.mediaCaster);
            }
            iMediaCaster = this.mediaCaster;
        }
        return iMediaCaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlayer(IMediaStreamPlay iMediaStreamPlay) {
        IMediaCaster iMediaCaster = this.checkMediaCaster(true);
        if (iMediaCaster == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.players.contains(iMediaStreamPlay)) {
                this.players.add(iMediaStreamPlay);
            }
        }
        iMediaCaster.registerPlayer(iMediaStreamPlay);
        ((ApplicationInstance)this.parent.getApplicationInstance()).notifyMediaCasterRegisterPlayer(iMediaCaster, iMediaStreamPlay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPlayer(IMediaStreamPlay iMediaStreamPlay) {
        IMediaCaster iMediaCaster = this.checkMediaCaster(false);
        if (iMediaCaster == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.players.contains(iMediaStreamPlay)) {
                this.players.remove(iMediaStreamPlay);
            }
            this.removeTime = System.currentTimeMillis();
        }
        iMediaCaster.unregisterPlayer(iMediaStreamPlay);
        ((ApplicationInstance)this.parent.getApplicationInstance()).notifyMediaCasterUnRegisterPlayer(iMediaCaster, iMediaStreamPlay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWatchdog() {
        IMediaCaster iMediaCaster = this.checkMediaCaster(false);
        if (iMediaCaster == null) {
            return false;
        }
        boolean bl = false;
        long l = System.currentTimeMillis();
        int n = this.mediaCasterDef.getKeepAliveTime();
        Object object = this.lock;
        synchronized (object) {
            if (this.lockCount == 0 && this.players.size() == 0 && n > 0 && this.removeTime > 0L && l - this.removeTime > (long)n) {
                bl = true;
                this.isValid = false;
            }
        }
        if (bl) {
            this.shutdown(false);
        } else {
            bl = iMediaCaster.doWatchdog();
        }
        return bl;
    }

    public void reset() {
        IMediaCaster iMediaCaster = this.checkMediaCaster(false);
        if (iMediaCaster == null) {
            return;
        }
        iMediaCaster.forceReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        IMediaCaster iMediaCaster = this.checkMediaCaster(false);
        if (iMediaCaster == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.isValid = false;
            this.players.clear();
        }
        try {
            iMediaCaster.shutdown(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((ApplicationInstance)this.parent.getApplicationInstance()).notifyMediaCasterDestroy(iMediaCaster);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerCount() {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            n = this.players.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLockCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.lockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireAndRelease() {
        Object object = this.lock;
        synchronized (object) {
            this.removeTime = System.currentTimeMillis();
        }
        this.checkMediaCaster(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() {
        Object object = this.lock;
        synchronized (object) {
            ++this.lockCount;
        }
        this.checkMediaCaster(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            --this.lockCount;
            this.removeTime = System.currentTimeMillis();
        }
    }

    public String getStreamExt() {
        return this.streamExt;
    }

    public void setStreamExt(String string) {
        this.streamExt = string;
    }

    public boolean isShutdownOnRelease() {
        return this.shutdownOnRelease;
    }

    public void setShutdownOnRelease(boolean bl) {
        this.shutdownOnRelease = bl;
    }

    public String getLiveStreamPacketizer() {
        return this.liveStreamPacketizer;
    }

    public void setLiveStreamPacketizer(String string) {
        this.liveStreamPacketizer = string;
    }

    public String getLiveStreamRepeater() {
        return this.liveStreamRepeater;
    }

    public void setLiveStreamRepeater(String string) {
        this.liveStreamRepeater = string;
    }
}

