/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.util.ModuleUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaCasterStreamManager {
    private MediaCasterStreamMap mediaCasterStreamMap = null;
    private Map<String, MediaCasterHolder> streams = new HashMap<String, MediaCasterHolder>();
    private Object lock = new Object();

    public MediaCasterStreamManager(MediaCasterStreamMap mediaCasterStreamMap) {
        this.mediaCasterStreamMap = mediaCasterStreamMap;
    }

    public String[] getStreamArray() {
        List<String> list = this.getStreamList();
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStreamList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.lock;
        synchronized (object) {
            arrayList.addAll(this.streams.keySet());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean streamExists(String string) {
        boolean bl = false;
        String string2 = "flv";
        String string3 = "";
        String[] stringArray = ModuleUtils.decodeStreamExtension(string, string2);
        string = stringArray[0];
        string2 = stringArray[1];
        boolean bl2 = string.indexOf("://") >= 0;
        int n = string.indexOf("?");
        if (!bl2 && n >= 0) {
            string3 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        Object object = this.lock;
        synchronized (object) {
            bl = this.streams.containsKey(string);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopStream(String string) {
        boolean bl = false;
        String string2 = "flv";
        String string3 = "";
        String[] stringArray = ModuleUtils.decodeStreamExtension(string, string2);
        string = stringArray[0];
        string2 = stringArray[1];
        boolean bl2 = string.indexOf("://") >= 0;
        int n = string.indexOf("?");
        if (!bl2 && n >= 0) {
            string3 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        MediaCasterHolder mediaCasterHolder = null;
        Object object = this.lock;
        synchronized (object) {
            mediaCasterHolder = this.streams.remove(string);
        }
        if (mediaCasterHolder != null) {
            try {
                this.mediaCasterStreamMap.release(mediaCasterHolder.mediaCasterStreamItem, true);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaCasterStreamManager.class).error("MediaCasterStreamManager.stopStream[" + string + "]: " + exception.toString());
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startStream(String string, String string2) {
        String[] stringArray;
        Object object;
        Object object2;
        boolean bl = false;
        MediaCasterStreamItem mediaCasterStreamItem = null;
        try {
            IApplicationInstance iApplicationInstance = this.mediaCasterStreamMap.getApplicationInstance();
            object2 = iApplicationInstance.getVHost();
            object = object2.getMediaCasterList();
            if (object != null) {
                stringArray = ((MediaCasterList)object).getMediaCasterDef(string2);
                if (stringArray == null) {
                    WMSLoggerFactory.getLogger(MediaCasterStreamManager.class).warn("MediaCasterStreamManager.startStream: mediaCasterType not found: " + string2);
                } else {
                    mediaCasterStreamItem = this.mediaCasterStreamMap.acquire(string, (MediaCasterItem)stringArray);
                    if (mediaCasterStreamItem == null) {
                        WMSLoggerFactory.getLogger(MediaCasterStreamManager.class).warn("MediaCasterStreamManager.startStream: Unknown error starting stream: " + string);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamManager.startStream[" + string + "][1]: " + exception.toString());
        }
        if (mediaCasterStreamItem != null) {
            boolean bl2 = false;
            object2 = "flv";
            object = "";
            stringArray = ModuleUtils.decodeStreamExtension(string, (String)object2);
            string = stringArray[0];
            object2 = stringArray[1];
            boolean bl3 = string.indexOf("://") >= 0;
            int n = string.indexOf("?");
            if (!bl3 && n >= 0) {
                object = string.substring(n + 1);
                string = string.substring(0, n);
            }
            Object object3 = this.lock;
            synchronized (object3) {
                if (!this.streams.containsKey(string)) {
                    this.streams.put(string, new MediaCasterHolder(mediaCasterStreamItem));
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
            if (bl2) {
                try {
                    this.mediaCasterStreamMap.release(mediaCasterStreamItem, false);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(MediaCasterStreamManager.class).error("MediaCasterStreamManager.startStream[" + string + "][2]: " + exception.toString());
                }
            }
        }
        return bl;
    }

    class MediaCasterHolder {
        MediaCasterStreamItem mediaCasterStreamItem = null;

        public MediaCasterHolder(MediaCasterStreamItem mediaCasterStreamItem) {
            this.mediaCasterStreamItem = mediaCasterStreamItem;
        }
    }
}

