/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.netconnection;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.netconnection.INetConnectionCallResult;
import com.wowza.wms.request.RequestFunction;
import java.util.HashMap;
import java.util.Map;

public class NetConnectionCallResults {
    public static final int RESULTINDEX_CLIENT2SERVER = 1;
    public static final int RESULTINDEX_SERVER2CLIENT = 120781448;
    private Map results = new HashMap();
    private int resultIndex = 120781448;

    public NetConnectionCallResults() {
        this.init(120781448);
    }

    public NetConnectionCallResults(int n) {
        this.init(n);
    }

    private void init(int n) {
        this.resultIndex = n;
    }

    public synchronized int add(INetConnectionCallResult iNetConnectionCallResult) {
        int n = this.resultIndex++;
        this.results.put(new Integer(n), iNetConnectionCallResult);
        WMSLoggerFactory.getLogger(NetConnectionCallResults.class).debug("NetConnectionCallResults: add: " + n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResult(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
        INetConnectionCallResult iNetConnectionCallResult = null;
        NetConnectionCallResults netConnectionCallResults = this;
        synchronized (netConnectionCallResults) {
            Integer n = new Integer(((Double)aMFDataList.get(1).getValue()).intValue());
            iNetConnectionCallResult = (INetConnectionCallResult)this.results.get(n);
            if (iNetConnectionCallResult != null) {
                this.results.remove(n);
                WMSLoggerFactory.getLogger(NetConnectionCallResults.class).debug("NetConnectionCallResults[" + iNetConnection.getNetConnectionId() + "]: remove: " + n);
            } else {
                WMSLoggerFactory.getLogger(NetConnectionCallResults.class).error("handleResult[" + iNetConnection.getNetConnectionId() + "]: can't find resultObj: " + n);
            }
        }
        if (iNetConnectionCallResult != null) {
            iNetConnectionCallResult.onResult(iNetConnection, requestFunction, aMFDataList);
        }
    }

    public int getResultIndex() {
        return this.resultIndex;
    }

    public void setResultIndex(int n) {
        this.resultIndex = n;
    }
}

