/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.request;

import com.wowza.util.BufferUtils;
import com.wowza.wms.client.Client;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.request.RC4;
import com.wowza.wms.request.RequestConnectHandshakeCrypto;
import com.wowza.wms.request.RequestConnectHandshakeCryptoSingleton;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class RequestConnectHandshake {
    public static byte[] serverHandshakeResponseKey = null;
    public static byte[] clientHandshakeSignKey = null;
    public static byte[] clientHandshakeResponseKey = null;
    public static final int HANDSHAKESIZE = 1536;
    public static final int DHKEYSIZE = 128;
    public static final String HANDSHAKESIZEHMACMETHOD = "HmacSHA256";
    public static final String DHMETHOD = "DH";
    public static String magicStrServer = null;
    public static String magicStrPlayer = null;
    public static String dhpKeyStr = null;
    private static BigInteger pHandshake = null;
    private static BigInteger gHandshake = null;
    public static final byte[] clientHandshakeRTMPFLASH10 = new byte[]{10, 108, -41, -93, 10, 0, 12, 2, -53, -106, 72, -26, -15, -107, 109, -47, 63, -80, -114, -45, -87, 71, 103, 36, -97, 108, 126, 1, -62, -20, -8, -106, 32, -43, -82, -49, -74, -59, 40, -77, 102, -101, -98, -111, -43, 50, -40, -33, -2, 26, -52, -57, -52, -122, 38, 95, 56, -5, -18, -48, -67, 126, -2, -60, 23, 40, -57, -75, 58, -106, 64, -79, -71, 16, 111, -72, 11, -31, -127, 78, 114, 102, 90, 124, -31, -46, 34, 59, -79, -25, 122, 72, -76, 116, 92, 42, 35, 20, 111, 58, 125, -44, 1, -101, 120, 87, 102, -53, -103, -67, 126, -128, -63, -94, 92, -14, 122, 58, -61, -59, 123, -58, -11, 27, 91, 27, -50, -46, 51, 85, 16, 8, 28, 107, -30, -125, 6, 49, -88, -82, 78, 57, 105, -125, -3, 92, -75, -15, -49, -3, -72, -127, 121, -12, -96, 8, -52, 22, 22, -93, -88, -75, 7, -7, -78, 8, 56, 4, -48, -93, -65, 122, 5, -33, -110, -49, 109, -127, 73, 9, 1, -82, 124, 118, -65, -3, 58, 115, -57, -52, -89, 119, -52, -104, -47, -37, -45, -62, -77, 45, 25, -36, 44, 83, 25, 45, 46, -51, 108, 34, -107, 36, -66, -82, 63, -36, -19, -120, 113, 54, 42, 107, 10, 68, 17, 120, 8, 23, -54, -110, 47, 62, 86, 105, 0, 56, 18, 114, 41, 99, -101, 42, -92, -22, 6, -45, 51, -8, -90, 63, 52, 33, -45, -5, -128, 83, 116, 4, -65, 38, -109, -126, 60, 106, -81, 62, -6, -1, -61, -84, 114, -42, 23, 109, 46, 106, -37, -11, 67, -44, -82, 74, 1, 26, -34, -65, 46, 73, -107, 2, -115, -64, 80, -16, 1, -57, -105, 42, -67, 41, 127, 10, -29, 36, 18, 0, -95, 111, 115, -118, 57, 47, -18, -11, 52, 10, -106, 59, 29, -92, 25, 70, -64, 59, -56, 39, -72, -115, 80, 61, 42, -19, 89, -113, -15, 18, -51, -119, 36, 41, -58, 122, 69, -86, 12, 7, 86, 14, -91, -7, -31, 23, 97, 102, -120, 68, 32, 46, -118, -75, -101, 51, -84, -68, -32, 33, 11, 47, -4, 83, 60, -33, -76, -100, 124, -90, 109, 18, -105, 104, -16, 27, -17, -14, -26, -50, -122, -92, 19, -39, -56, 80, 49, 61, 20, -54, -54, 125, 56, -81, 47, 56, -74, -119, 76, 73, -25, 113, 91, -98, 36, 8, 18, 78, -93, -91, 28, -14, 120, 22, 91, 102, 0, 65, 0, 84, 89, 46, -24, 114, 37, 50, 14, 81, -50, -31, 49, 5, 25, -124, -82, -88, 75, 85, 127, -6, -87, 57, 80, -77, 40, -79, -43, -76, -71, -56, -106, -84, -61, 21, -101, -105, 11, 115, 97, -29, 62, 61, -61, -104, 64, -32, -45, 60, -98, 15, -102, -13, 55, -76, 9, -65, 103, 4, 7, -115, -88, 103, 76, 78, 102, 55, 40, 61, 24, 30, 65, -90, -76, 68, -75, -78, 20, -5, 12, 123, 27, -20, -116, -52, -13, -46, 119, 23, -110, -52, 33, 63, -89, 94, -76, 112, 20, -35, 93, 86, -64, 54, -33, 105, -127, -88, 122, -30, -47, 45, 11, 40, -61, 30, -14, 57, -29, 64, 20, -79, -43, -79, -81, 21, -83, 107, 4, 69, 96, -54, 27, 42, -109, 76, 70, -89, -76, 55, -105, 121, 42, 100, 104, 101, 104, 50, 31, 111, -33, -85, -121, 122, 65, 109, 30, -85, -55, 93, 82, -88, 90, 79, -59, 21, -116, 49, -64, -81, 7, 35, -10, 43, 91, 113, -124, -54, -107, 85, 120, 73, -116, 35, -91, 88, 61, -76, 78, -80, -110, -72, -21, 17, -71, 7, 14, -115, -78, -68, 94, 3, -23, -107, 55, -41, -28, 11, 42, -88, -97, -12, 2, 102, 36, 99, -56, -55, -91, 80, 117, 18, -40, -104, 36, -85, 110, -32, -121, 64, 105, 48, -47, 44, 18, -65, 0, -25, 59, -23, 115, 73, -32, 114, 32, 23, 14, -86, -62, -23, -7, 82, 71, -89, 113, -25, 8, 45, 79, 118, -85, 3, 48, -87, 61, 27, 37, -96, 29, 78, 24, 77, -119, -16, 88, 38, 115, 36, -99, -32, -72, 16, 54, 28, -127, 44, -54, -45, -12, 117, 126, 0, 41, -101, -27, -37, -107, -38, 80, -123, -79, 29, -18, 82, -63, -91, 46, 80, -43, -13, -51, -88, 40, -22, 125, 124, 73, 89, -83, 100, -114, 99, -34, -37, 19, -66, -58, -15, -82, -50, 94, 25, -84, -61, 90, -23, -115, 81, -87, -100, 87, -127, -55, -8, 103, -43, -58, -85, -114, -113, -93, 76, -18, 66, 42, -104, -24, 33, -5, -81, -12, -72, -16, -103, -82, 111, -26, 114, -117, -8, 125, -91, -39, 13, 61, 42, 38, -3, -11, -86, 64, -33, 4, 60, -81, -59, -104, 53, -114, 77, -106, 10, -45, -97, -5, -88, -50, 95, 125, 79, 52, 33, 66, -7, -50, 122, 110, -125, 69, 87, 83, -35, -117, 61, -4, -58, 101, -124, 30, -120, -42, 68, -101, -13, -119, 42, -13, 111, -40, -121, -14, 55, -26, 60, -29, 5, -75, -3, -63, 126, -11, -57, -97, -37, -72, 71, -62, -89, -88, -52, -46, -101, 60, 80, 99, -31, -25, -18, -18, 46, -66, -8, -63, 18, -110, -2, -17, 123, -97, -35, 96, 101, -60, 3, -1, 77, 122, -70, -77, 53, 3, -38, -126, 123, 106, -106, 55, 113, 38, 50, 56, 45, -63, -67, -60, -97, 106, -1, -72, -56, -5, 66, 17, 86, 91, 68, -95, -44, 126, -92, -5, 92, 31, 23, 113, -46, -52, -89, 73, 88, 47, -28, 19, 33, 110, -37, -119, 32, 23, 105, -81, -127, 126, 66, -6, -50, 7, 124, 9, 40, -7, -116, -98, -45, 113, 46, -89, 109, 7, 7, 89, 57, -30, 104, 101, -113, 85, -97, -71, 117, -125, -125, -32, 123, 53, 104, -67, -2, 4, 114, -12, -25, 97, -51, -109, 3, -115, 84, 119, -45, 124, -15, -119, 57, -34, -77, 63, 31, 16, 41, -81, 21, -24, 30, -13, -104, 29, -75, -19, -103, 54, -116, -93, -107, 34, -128, -109, -75, 40, 68, -60, -102, 66, 58, -124, -5, -10, 113, 27, -83, -73, 33, -39, 91, 100, 103, -35, 39, -12, -125, -77, -118, -85, -42, 86, 59, -20, 31, 107, 26, 121, 115, 9, -40, 100, 126, 70, -119, -56, -54, 74, 88, -95, -36, 68, -71, -80, -52, -16, -1, 65, 102, -70, 105, -65, 78, -68, 102, 67, 29, -116, -75, -113, 113, -49, 53, 99, 77, 62, -13, -123, -109, 61, 113, -90, -124, 121, 79, 36, -75, -44, -102, -30, -4, 35, -4, -58, -105, -57, 91, 47, 70, -75, 107, 71, 47, -74, -35, 112, 104, 67, -56, -18, 117, 83, 55, -128, -2, -82, 37, -118, 124, 82, -118, 76, -29, 28, -52, 16, -10, 48, 66, -64, 86, -120, -85, 4, 108, -36, -48, -119, -97, -4, 109, 53, -124, 93, -107, 105, -109, 59, -26, 23, -4, 9, 49, -42, 87, -109, 107, 69, -76, 100, -90, 75, 76, 9, -52, 60, 90, 82, -108, 81, 32, -35, 91, -17, -33, -46, 106, -100, -91, 64, -66, -35, 102, 67, -15, 53, -69, -62, 16, -89, 28, 116, 48, 82, 81, -74, -11, 17, -12, -18, -20, -94, -8, -30, -98, 113, 30, -104, 88, -110, -121, 43, -26, -65, -96, 73, -2, 32, -46, -91, -86, -96, 75, 53, 12, 70, -61, 20, -84, 112, -71, 53, 30, 38, 72, 37, 18, -96, 54, -116, -86, 8, 105, -48, -121, 52, 39, 28, -117, -91, 35, -78, 121, -56, 91, 0, -76, 66, -10, 22, -52, 19, 113, 121, -14, 39, -66, -43, 99, -118, 60, 85, -72, 46, -121, -83, -127, 62, -55, -50, -105, 71, 26, -63, 13, 22, -26, 80, 118, 67, 18, -82, 96, 101, 109, 1, 73, -13, 110, 118, -90, -93, -124, -63, -76, -20, -57, 72, -50, -100, 83, -78, 65, 8, -113, 0, -101, 39, -95, -126, 20, -7, -55, -58, -124, 90, -97, -53, -12, -15, -23, -11, 118, -6, -2, -116, -112, 124, 111, -44, -109, -128, 109, -43, 49, 110, 88, -72, -121, 3, 89, -70, 121, -36, 90, 49, -45, -55, -90, -100, -28, 30, 24, 57, 8, -113, 92, 69, 60, 93, -13, -128, -61, -32, 108, 63, 44, -33, -80, -66, -125, 48, -70, 72, 125, -106, -107, 68, 121, -7, -5, 108, 64, -116, -24, -103, 48, -117, 126, 5, -49, 126, -111, 41, 125, -79, 8, 67, -124, 1, 26, -89, -57, 82, -128, -71, -59, 72, 91, 83, -50, -92, 88, -103, 89, 76, -5, -56, -64, 37, 84, 38, 47, 63, -63, -62, -81, -87, 59, -82, -49, -18, 19, 116, 6, -91, 82, 98, 45, -35, -117, -45, 44, 33, -43, 88, 78, 97, 32, -122, -29, 123, -32, -75, -17, 40, 106, -55, -67, 5, 98, -3, -55, -17, 36, -118, 95, 85, 105, -6, -39, 94, 72, 88, -74, -95, -7, -18, -89, -128, 115, 125, -107, 126, 78, 88, 2, -39, 16, 45, 127, -20, -78, -76, -69, -88, 67, 44, 125};
    public static final byte[] clientHandshakeRTMPFMS3 = new byte[]{5, -59, -48, -124, 3, 0, 1, 1, 66, 70, 91, -76, -23, 116, 43, 101, 50, -2, 30, 74, -56, 126, -81, 19, -105, 63, 64, 62, 97, -73, 90, -68, 22, -28, 21, -79, -37, -119, -18, 59, -10, -128, -47, 17, 46, -49, 7, 116, 9, 65, 87, -39, -79, 45, 107, 23, -69, 105, -9, 67, 111, -21, -123, -71, 112, 45, 29, -107, -13, 43, -92, 5, 77, 39, 58, 125, -99, 109, 8, 25, 125, 41, -3, -73, 90, 13, -9, 95, 46, -20, -102, 32, 37, -91, 82, 33, 14, 55, 39, 27, 55, 35, -7, -12, -67, -93, 57, 106, -116, -109, 35, -52, 48, -14, 122, 77, -96, -96, -87, 126, 82, 2, -2, 35, 91, 55, -84, 59, 101, -22, -78, -6, 94, -93, -74, -83, -1, 35, 119, 91, -1, -83, -88, 21, 26, -39, 24, 122, 18, 113, -36, 18, -67, -120, -8, -125, -10, 121, 98, -82, -126, 61, 39, 76, 8, -46, 21, 115, -101, 106, -28, 79, 60, -15, -99, -14, 46, 30, -96, 34, 26, 40, 79, -128, 104, -63, 50, 7, 122, 41, -78, 45, 100, -4, 100, 127, 18, -95, 118, 73, -73, 86, -88, -108, 40, -127, 45, 37, 19, -127, -107, -53, 45, 57, -74, -109, 111, 30, 8, -14, 17, -110, 55, -71, -73, 19, -119, 60, 76, -21, 97, 2, 14, -39, -43, 79, 101, 0, 2, 7, 40, -80, 29, 69, 83, -127, 113, 50, -36, -4, -60, -103, -80, -86, -38, 21, -17, -82, -106, -7, 105, 26, 76, -20, 57, 97, -112, -25, -124, 92, 125, -108, 96, 44, 60, -115, -84, 127, -10, 115, -10, 123, -87, 31, 50, 13, -111, -96, 110, 125, 84, -19, -91, 78, 51, 33, 24, 51, -92, -92, -72, 122, -81, -63, -102, -37, -53, -43, 87, -104, 8, -124, 12, -79, -44, 73, 62, -52, -123, 117, 37, -104, -66, 6, 114, 83, 66, 43, -56, -37, -7, -79, -120, -121, -76, 125, 103, -53, 4, -24, 79, 117, 31, 42, -49, 112, -73, -89, 42, 44, -24, 69, -82, -120, 33, 46, 8, 46, -14, -66, -67, 22, 109, 49, -35, -24, -30, 66, -4, 44, 46, 83, 85, -124, -76, 120, -77, 71, 6, 39, -49, -27, 53, -98, -13, -8, -98, 25, 49, -55, 107, 18, 116, 127, 59, -19, -36, -49, 84, 63, 56, 16, 94, -62, -42, 103, 89, -16, -116, -127, -75, -105, 60, 91, -103, 49, 116, -115, -86, -113, 0, 61, -60, 76, 6, 48, 71, -68, -82, 44, 84, -104, 55, 90, 120, -44, -127, -48, -23, -109, -55, 114, -34, -38, 64, -127, 26, -23, 123, 10, -52, -115, 99, 56, -99, -92, -114, 76, -128, 36, 109, -78, -95, -73, -120, -38, 126, -51, -56, 63, 123, -33, -14, -11, 0, -16, -35, -63, -61, -23, -12, 1, -53, 56, 10, -54, 12, -60, 51, -126, -48, 11, -33, -56, 107, -36, 56, 120, 1, 60, 6, 84, 98, 6, 73, -121, -45, -30, 33, 89, 18, -84, -104, 90, 85, -98, 73, -66, 59, 44, -99, -10, 34, -44, -9, -32, -119, -17, -24, -64, 43, 77, -104, -45, -49, -55, -51, -116, 15, 82, 94, 114, -69, -87, -24, 102, 66, 101, 78, 33, 56, -18, -58, -48, 24, 67, 24, -33, 14, 39, 43, -40, -126, -51, -42, -63, 15, -120, -91, -94, -14, -71, -108, 91, 103, -56, -17, 89, 92, 64, -56, 89, -71, -106, 35, 59, -14, 30, -109, -65, 90, -63, -114, -12, -115, -67, 36, 25, -42, 73, -66, -112, -32, -91, 60, -68, 7, 73, 102, 90, -98, -75, 105, -91, 9, 44, 32, 43, 34, 24, -7, 9, -120, -101, 88, -103, -33, -53, 5, -51, 18, 111, 43, 4, 4, -47, -16, 31, -63, 57, -40, 93, 17, -43, 79, -97, 10, 77, -50, 25, 82, 77, 116, 33, 127, 70, 95, -62, 83, 75, 55, -4, -59, 24, -111, -88, -53, 114, 126, 20, -128, 104, -11, -35, -128, 44, -74, 103, 14, -15, -17, -59, -92, 81, -41, -3, -18, 109, 47, 65, -38, -52, 125, -51, 5, -70, 120, 77, 108, 47, 33, -24, -60, -58, -15, 73, -104, -82, -24, 43, 97, -5, 73, -12, -93, 113, -48, -36, -40, -52, 47, -85, 4, 80, 98, 123, -112, -89, 114, -99, -55, -31, -111, -8, 62, 63, 115, 80, -118, -49, -36, 30, -35, 56, 82, -3, 72, -97, -90, 75, -68, 63, -36, 1, 97, -59, 2, 79, 85, -63, -76, 11, 76, -46, -97, 108, 24, 106, 114, -60, 114, 23, 21, -50, -120, -39, 69, 31, -100, 11, -128, -89, 87, 44, -42, 86, 92, 82, 16, -116, 28, 98, -124, 98, 95, 88, -54, -26, -92, 53, -126, 101, -41, -95, -37, -84, -56, -25, -76, 113, -89, 63, -34, 119, -111, 53, -26, 28, 41, 115, -10, 56, 80, 49, -60, -69, 80, -53, 84, -41, -118, 113, 27, 53, -93, 2, 94, 55, -7, -116, 17, -66, 4, -113, -108, 92, -128, -68, -108, -57, 121, -68, 83, 85, 97, -10, -61, -79, 19, -90, -94, -108, -78, 34, 32, -80, 103, -70, -93, 59, 69, -36, -8, 79, -124, -25, 77, -66, -70, 47, 61, 121, 71, 2, -48, -71, 127, 109, 48, 62, -79, -50, 59, -41, 60, 109, 55, -67, 49, -122, -96, 12, 23, -93, -16, -126, -20, -100, -86, -117, -97, -68, 88, 29, 99, 97, -47, 7, -2, 67, 0, -80, 17, 101, -62, -25, 24, 6, 99, -48, -28, 93, 63, 12, -79, 85, -42, -125, -90, 30, 74, -90, 60, -62, -110, -49, -26, -106, 16, 50, -120, -51, 4, 58, -20, 125, -44, -32, 97, -27, -96, 127, 82, 40, -59, -13, 11, -29, -23, -20, -42, 11, -26, 127, -85, -128, -93, 33, -118, 122, -100, 70, -19, 98, 106, 28, -94, -6, 93, -18, 118, 37, -28, -126, -124, 11, 13, -126, -43, 55, -79, -74, -27, 59, 69, 119, 96, 70, 52, -18, 3, 66, 104, 68, -24, -101, 104, -54, -78, -73, 96, 80, 104, 79, -97, -52, 26, 107, -10, -91, -32, 41, -15, 50, 19, -45, 105, 10, -125, -12, 15, -29, -74, 82, -91, 84, 82, 67, -30, 81, -103, -47, -33, 9, 17, 51, -55, -96, -96, -70, 91, 90, 122, -43, -22, -63, 102, -108, -72, -58, -68, 71, 53, 31, 57, 93, 33, -124, -37, 114, 5, 89, 77, 27, 95, 68, 41, 1, 48, -86, -4, 15, 66, -26, 7, -86, 58, -37, -79, -94, -89, -41, -121, -108, 52, 103, -17, -1, 7, -99, -107, -5, -39, 104, -14, -69, -23, 111, 62, 94, 2, -50, 4, 45, 99, -17, -81, 59, -92, -69, 16, 99, 17, 79, -121, -44, -50, -48, 107, 32, -74, 3, -55, 102, 58, -90, 51, 94, 51, 118, -127, 33, 122, -71, -28, -51, -24, 25, 88, -29, -119, -93, 118, 72, 85, -101, -67, -110, -35, 41, -119, 104, -56, -100, 28, -34, -77, 20, 27, 46, 37, -18, -32, -110, 80, 73, -72, 73, -41, 101, 118, -63, 26, 29, -74, 26, -28, 9, -81, -76, 25, -78, -24, 100, -119, -91, 108, -11, -56, 97, -43, 115, 74, 45, 86, -60, 54, -39, -19, 113, -68, -108, -30, -68, -28, -86, -25, 69, 63, -82, 35, 27, -98, 126, 6, 18, -92, 107, 120, 32, -104, -4, 50, -38, 30, 0, -124, -60, -51, -27, -73, -115, -6, -41, 0, 117, -14, -78, -106, 49, -57, 58, -54, 112, -91, 100, -48, 127, 20, 60, 51, -12, 67, 123, 102, -10, -89, 26, -79, 81, -74, -89, -85, 15, 29, 91, 82, 4, 101, -66, 44, -57, 120, 118, 27, -109, -38, 20, -63, -25, -63, -14, -85, 59, -84, -43, 64, 44, -66, 50, 48, -56, -31, -82, -52, 46, 116, 65, 40, -88, -50, 117, -99, -20, 50, 4, 17, 33, -60, -76, 11, -118, -58, -33, 66, 125, -51, 17, 80, -93, 87, -100, 95, -52, 45, 88, 100, -65, -70, -53, -127, -16, 95, 119, -95, 110, -4, 80, 68, 81, 75, 115, 5, 1, 43, -121, 104, -79, -56, 76, -52, -103, 40, 106, 42, 26, -32, 64, -115, 125, -115, 62, -62, 20, 100, 18, 6, 117, 119, -18, 41, -84, 23, -44, 51, 112, -82, 20, -88, 90, 3, 24, 74, 50, -81, -111, 2, -124, -86, 4, 123, -37, 61, -126, -81, 89, -37, 109, 22, -75, 71, -88, -127, 117, 124, -40, 118, 93, 14, 88, 97, -66, -126, 91, 80, -60, -71, -109, -62, 113, -24, -74, 32, 26, -93, -102, -78, -20, -26, 37, 97, -73, -19, 125, 3, -107, 121, 14, 112, -109, -106, 12, -53, 30, 12, 99, -56, -5, -23, 51, 30, 57, -10, 111, -88, -22, 17, -80, 65, -112, -119, 124, 63, 103, 11, 13, -45, -1, -66, -11, -17, 92, 75, -52, 7, -63, -85, -106, 36, 126, -58, 15, 86, 17, 7, -41, -115, 9, -79, 96, 108, 15, -32, 34, -74, 101, 97, 127, -101, 111, -82, -62, 65, 122, -97, -41, 11, -3, -90, 109, 109, 62, 45, -101, 30, 19};
    public static byte[] wowzaServerHandshake = new byte[]{123, 123, -116, -65, -110, 68, -92, 15, 71, -112, -33, 73, -78, 71, -100, -107, 102, -40, 59, -61, 112, -19, 36, -45, -102, -57, -22, -93, 73, -21, 88, -126, 28, -24, 47, 11, -118, 46, -20, -102, 50, 16, 24, -48, 18, 78, 0, -120, 10, 84, 74, -24, -72, -119, -60, 117, 61, -72, 73, 115, -86, -89, -5, 25, -94, -125, -36, -78, 72, 109, 85, 95, 88, 19, 123, 114, 69, -64, -123, -112, 57, 82, 73, 45, 18, 126, -104, -18, 13, -3, -82, 61, -30, 26, 43, 35, 49, -65, 113, 82, -55, -18, -112, 121, -100, 127, -27, 22, -65, 14, -26, -121, 90, -4, 121, 98, -108, 120, 80, -116, -3, -94, -2, -74, 15, -124, 94, 61, -107, 126, 102, -47, -36, -56, -6, 45, 37, -88, 76, -36, -22, 71, 28, 59, -70, -12, -26, -128, 103, 120, 49, 40, -120, 52, -8, -47, -123, 43, -10, 43, -69, 72, -97, 83, -91, -33, 95, -103, -33, 49, 125, 112, -94, 98, -9, 20, 9, 15, -99, -6, 74, 92, -1, 89, 42, 102, -81, 14, 73, -43, -105, -80, 54, 8, -86, -49, 28, -36, 97, -51, -8, 7, 34, 52, -72, 88, -69, 26, -37, -104, 18, 119, 13, -63, 25, 81, -26, -46, -67, -7, -105, 3, -73, 40, -69, 91, -127, -37, -116, 114, -13, -81, 100, 96, 5, 8, 112, 17, -37, -32, 40, 50, -1, 60, 23, 48, -26, 103, -65, -56, 63, 52, 93, 9, -13, -103, -91, 118, 57, -125, 20, -7, -90, -86, 90, -48, -67, 74, 2, 28, 21, -12, -52, 53, 38, -79, -31, -99, -31, 79, 62, 37, -18, -116, -67, -20, 52, -28, 113, -111, 56, 71, 41, 78, -55, 83, -42, 112, 57, -126, 28, 58, 125, -78, 8, -78, -43, -1, 121, 56, -13, 101, -14, 65, -25, -86, -113, 25, -73, 3, 67, -22, -36, -79, 18, 15, -125, -64, 21, 19, -39, 104, 94, -70, 60, -73, -1, -16, 27, 61, 0, -122, -38, 87, -20, -16, -8, -118, -36, -29, 96, -88, 96, 85, -78, 78, 107, 30, 122, 28, 27, -123, 13, -102, -35, -94, 19, -53, 58, -111, -11, 5, 44, -45, -46, -60, 63, -119, 125, -104, 100, -38, 31, -21, -78, 93, -103, 47, -93, 122, -83, 120, 48, -26, -88, -26, -96, -85, -28, -62, 36, 46, -10, -14, -57, -15, -59, -20, -122, 3, 30, 123, 25, -23, 40, -107, 71, -11, -127, -106, 125, 100, -123, -128, 94, 11, 86, 109, 38, 9, -42, -44, -113, -104, 45, -5, 46, 71, -88, -46, 94, 38, 11, -53, -94, 75, 75, 64, -46, -75, -101, -52, -109, -43, 81, -23, -11, -13, -25, -17, -33, 6, -47, -77, 46, -97, 75, 60, -46, 42, -40, 111, -25, -62, 127, -67, -39, 79, -65, -110, 41, -79, 29, -86, -50, 70, -79, -3, 8, 78, 115, -126, -82, 113, 106, 48, 25, 103, 68, 123, -70, -108, -102, -73, 71, 1, -98, -125, 77, -24, 26, -4, -59, -47, 7, -44, -17, -58, -103, -101, -18, 10, 100, -99, 110, -46, 125, 53, 76, 84, -9, 22, 0, 28, 15, 51, 39, -67, -7, -123, -63, 14, 86, -92, 69, -53, 127, 63, 10, 97, -2, 88, -63, 3, 1, -48, 105, 120, 5, -74, 39, -126, -102, 20, 79, 69, 53, -17, 52, -14, 97, -33, -85, -10, 8, -79, -21, -102, -85, 28, 6, -45, 74, 72, -30, -83, 15, -51, -30, 83, -7, -120, -17, -53, -20, 99, 108, 33, -35, 79, -97, 56, -69, 121, -74, 15, 78, -96, 29, -104, 43, -27, 30, -108, 47, 3, 115, -33, -119, 79, -115, -96, 62, 63, 76, 101, 112, 119, -86, 59, -99, 27, -98, 81, -3, -9, 64, -40, -15, 59, -27, 20, -106, -20, 98, 43, 120, 55, -37, -93, -105, 97, 18, 96, -14, -74, -55, 2, 48, -45, 116, -40, 39, -66, -23, -61, -91, 40, -35, 127, -38, -110, 114, -114, -106, 123, 55, -42, -27, -18, 70, 32, 63, -28, -115, -92, -104, -114, 88, -110, -48, 66, -57, -125, -103, 79, 61, -120, 49, 20, -46, 89, -47, 121, -107, 109, -110, 48, -45, 126, 72, 48, 35, -120, 124, -46, 17, -85, -6, -95, -53, -125, -15, -3, -75, -17, -102, 104, -36, -59, 111, -37, -101, 31, 24, 80, 69, 87, -11, 26, -62, 2, 80, 101, -92, 33, -76, -98, 32, -58, -67, 105, 92, -95, 29, 32, -29, 34, 112, 44, 11, -97, -65, -127, 101, 3, 116, 39, 27, 13, -121, -56, 100, -55, -49, 37, 65, 90, -80, 53, 53, 24, -3, 109, 38, 120, -50, 127, 11, -9, 78, 59, -109, 13, -117, 111, -108, -110, -104, -6, -41, -35, 108, 70, 108, -86, 110, -90, 53, -21, -99, -90, 58, 30, 112, -5, -87, 80, 68, 30, 123, -25, -106, 112, 66, -49, -112, -15, 63, 104, 28, 80, -39, -91, -72, -23, 98, 36, -3, 13, 0, 14, -72, 43, 18, 10, -24, -15, 74, -73, 52, 32, -107, 47, -60, 105, 103, 98, -49, 57, -81, -81, 97, -125, -88, 95, -89, -115, 34, -29, -21, 97, -29, -64, -106, 83, 16, -19, 45, -46, -48, -108, -111, 125, 77, 57, 56, -44, 88, 18, 35, 111, -28, 118, 28, -16, 111, 68, -15, -41, 92, -106, -100, -113, 103, 27, 81, 87, 126, -78, -117, 40, -24, -42, -22, 92, -82, 91, 49, 105, -17, 19, -23, 40, 16, -47, 96, 104, 123, 124, -51, -3, 18, 24, -121, 85, -42, -78, -27, 61, 24, -22, -119, 16, -93, -88, 44, 93, 85, -23, -117, 80, 9, -78, 57, 76, 25, -55, 98, -80, -66, 95, -117, 118, 28, -29, 108, 116, -64, 14, -101, 73, -114, 98, -84, -43, -13, 58, -68, -26, -12, -114, 38, 92, 6, -118, -117, -96, 27, 36, 82, 54, 79, 70, -29, 2, -89, -39, 20, -98, 120, 45, 74, 80, 5, -108, 55, -92, 49, 29, 53, -5, -47, 1, 4, 47, 76, -40, -47, -103, -28, -13, -5, -33, -24, -24, 96, 114, -78, 91, 73, 12, -107, 24, -59, 11, -105, -38, 72, -44, -102, 37, 73, -31, 68, -2, -125, -20, -60, -44, 103, -58, 119, -7, 27, -109, 103, 81, -119, -102, -113, -83, 18, -120, 113, -119, -53, 35, -50, -128, -53, -104, -51, -23, -124, 120, 60, -106, 77, 125, 91, 31, 91, 7, -118, -41, -121, 16, 77, 91, -98, 5, 104, -82, 103, -18, -83, -99, 63, -81, 45, -102, 20, -61, 79, -57, -6, -10, -69, -49, -60, -48, -125, 60, -25, 57, 7, 21, -98, -43, 66, -60, 33, -7, -72, -34, -50, -20, -85, -101, -116, 46, -89, -83, 47, -37, 7, 124, 22, 81, 85, -109, 37, -61, -81, 33, 52, 65, -114, -17, -94, -6, -113, -52, 121, -106, -50, -74, -87, -59, 19, -57, 113, -115, 38, 48, 38, 4, -62, 78, 27, -110, -75, -22, -99, 121, -38, -47, -87, 111, -14, -3, -12, 111, -94, 103, 89, 2, 78, 77, 36, 105, 79, 69, -93, -114, 5, -49, -53, 2, -80, -57, 14, -6, 25, -113, 1, 23, 1, 10, 107, 39, -72, -94, 67, -113, -114, -4, -51, -79, -81, 77, 3, 21, 14, 18, -13, 31, -105, -118, -39, 68, -27, -8, 17, -52, -47, -57, -16, -92, -92, -3, -56, 41, -101, 78, 49, -79, -120, -74, 20, 54, -67, 62, -54, -6, -59, 3, -12, 121, -98, -96, 97, -11, -39, 86, 107, 86, -61, -104, -116, -18, 73, 35, -62, 117, 10, -109, 11, 91, 107, 101, -103, 34, 24, 25, -12, 32, 41, -32, 72, -102, -44, 70, -26, 2, -24, 32, -61, -29, -22, 64, 18, -45, -7, 16, -34, -59, -88, 4, -125, -93, 53, -18, -64, -14, -76, 45, 56, -47, -74, -128, 17, -100, 101, 53, -99, 122, -45, 89, 84, -13, -45, 8, -8, 71, -62, 104, -8, -75, -52, -19, -116, -96, -120, 75, 97, 39, 88, 92, 21, 107, 43, 7, 40, -82, 115, 1, -86, -61, 62, 80, 20, 76, 30, 97, 101, -37, 51, -43, -52, 89, -1, -48, -40, 11, 42, 30, 9, 46, 31, -102, 29, 95, 12, 34, 32, -21, -111, 71, 89, 20, 48, -73, 18, 61, 3, 81, 32, 9, -30, 21, 86, -107, -128, -69, -125, -50, -123, -51, 120, 6, -7, -57, -69, 108, 31, 97, 58, 35, 73, -90, -90, -14, -107, 78, -108, -93, -54, 52, 74, 29, -22, 27, 82, -40, -61, 103, -13, -49, 39, 56, -17, 4, 43, -39, 109, -7, -17, -103, -67, -68, -106, -120, -105, -80, -65, 27, -86, 29, 82, -52, -123, -79, 101, 54, 125, -10, -19, 47, 3, 55, 67, -12, 43, -126, -53, 73, -83, 125, 76, 92, 104, 43, 106, -64, 52, -100, -31, 49, 71, 38, -117, -103, 96, 10, -9, 78, 86, -74, 90, -48, -20, 71, 47, 32, 73, -60, 69, -27, -1, -112, -55, 118, -20, 35, 42, -15, 44, 10, -109, 10, 23, -74, -4, -114, 25, -68, 67, 54, 126, 88, 24, -6, -106, 44};

    public static void initHandshake() {
        pHandshake = new BigInteger(dhpKeyStr, 16);
        gHandshake = BigInteger.valueOf(2L);
        RequestConnectHandshakeCryptoSingleton.init();
    }

    public static byte[] generateServerHandshake(Client client, byte[] byArray, int n, int n2, boolean bl) {
        byte[] byArray2 = new byte[1536];
        try {
            int n3;
            long l = System.currentTimeMillis();
            Random random = new Random(l);
            random.nextBytes(byArray2);
            byArray2[0] = (byte)(l >> 24 & 0x7FL);
            byArray2[1] = (byte)(l >> 16 & 0xFFL);
            byArray2[2] = (byte)(l >> 8 & 0xFFL);
            byArray2[3] = (byte)(l >> 0 & 0xFFL);
            byArray2[4] = 3;
            byArray2[5] = 0;
            byArray2[6] = 2;
            byArray2[7] = 1;
            if (bl) {
                try {
                    n3 = RequestConnectHandshake.getMagicDHOffset1(byArray2, 0);
                    int n4 = n2 <= 0 ? RequestConnectHandshake.getMagicDHOffset2(byArray, n) : RequestConnectHandshake.getMagicDHOffset1(byArray, n);
                    byte[] byArray3 = null;
                    byte[] byArray4 = null;
                    KeyPairGenerator keyPairGenerator = null;
                    KeyPair keyPair = null;
                    DHParameterSpec dHParameterSpec = new DHParameterSpec(pHandshake, gHandshake, 1023);
                    keyPairGenerator = KeyPairGenerator.getInstance(DHMETHOD);
                    keyPairGenerator.initialize(dHParameterSpec);
                    keyPair = keyPairGenerator.genKeyPair();
                    Object object = (DHPublicKey)keyPair.getPublic();
                    Object object2 = BufferUtils.decodeHexString(object.getY().toString(16));
                    if (object2 != null) {
                        if (((byte[])object2).length < 128) {
                            byArray3 = new byte[128];
                            System.arraycopy(object2, 0, byArray3, 128 - ((byte[])object2).length, ((byte[])object2).length);
                        } else {
                            byArray3 = object2;
                        }
                        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
                        int n5 = 0;
                        while (byArray[n + n4 + n5] == 0) {
                            ++n5;
                        }
                        byArray4 = new byte[128 - n5];
                        System.arraycopy(byArray, n + n4 + n5, byArray4, 0, byArray4.length);
                        object = KeyFactory.getInstance(DHMETHOD);
                        object2 = new DHPublicKeySpec(new BigInteger(BufferUtils.encodeHexString(byArray4), 16), pHandshake, gHandshake);
                        DHPublicKey dHPublicKey = (DHPublicKey)((KeyFactory)object).generatePublic((KeySpec)object2);
                        KeyAgreement keyAgreement = KeyAgreement.getInstance(DHMETHOD);
                        keyAgreement.init(keyPair.getPrivate());
                        keyAgreement.doPhase(dHPublicKey, true);
                        byte[] byArray5 = keyAgreement.generateSecret();
                        if (byArray4.length != 128) {
                            byArray4 = new byte[128];
                            System.arraycopy(byArray, n + n4, byArray4, 0, byArray4.length);
                        }
                        RequestConnectHandshake.calculateEncryptionKeys(client, byArray4, byArray3, byArray5);
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.generateServerHandshake: " + exception.toString());
                }
            }
            n3 = RequestConnectHandshake.getMagicDigestOffset(byArray2, 0);
            byte[] byArray6 = RequestConnectHandshake.getHandshakeDigest(byArray2, 0, magicStrServer, n3);
            System.arraycopy(byArray6, 0, byArray2, n3, byArray6.length);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.generateServerHandshake: " + exception.toString());
        }
        return byArray2;
    }

    public static byte[] calculateEncryptionKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            Mac mac = Mac.getInstance(HANDSHAKESIZEHMACMETHOD);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, HANDSHAKESIZEHMACMETHOD);
            mac.init(secretKeySpec);
            mac.update(byArray);
            byArray3 = mac.doFinal();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.calculateEncryptionKey: " + exception.toString());
        }
        return byArray3;
    }

    public static void calculateEncryptionKeys(Client client, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            byte[] byArray4 = RequestConnectHandshake.calculateEncryptionKey(byArray2, byArray3);
            RC4 rC4 = new RC4();
            rC4.setKey(byArray4, 0, 16);
            client.setRTMPEncryptHandlerIn(rC4);
            byte[] byArray5 = RequestConnectHandshake.calculateEncryptionKey(byArray, byArray3);
            RC4 rC42 = new RC4();
            rC42.setKey(byArray5, 0, 16);
            byte[] byArray6 = new byte[1536];
            rC42.encrypt(byArray6, 0, byArray6.length);
            client.setRTMPEncryptHandlerOut(rC42);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.calculateEncryptionKeys: " + exception.toString());
        }
    }

    public static byte[] getHandshakeDigest(byte[] byArray, int n, String string, int n2) {
        byte[] byArray2 = null;
        try {
            byte[] byArray3 = new byte[1504];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            System.arraycopy(byArray, n + n2 + 32, byArray3, n2, 1504 - n2);
            Mac mac = Mac.getInstance(HANDSHAKESIZEHMACMETHOD);
            SecretKeySpec secretKeySpec = new SecretKeySpec(string.getBytes(), HANDSHAKESIZEHMACMETHOD);
            mac.init(secretKeySpec);
            mac.update(byArray3);
            byArray2 = mac.doFinal();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.signClientMessage: " + exception.toString());
        }
        return byArray2;
    }

    public static int getMagicDHOffset1(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 1532; i <= 1535; ++i) {
            n2 += byArray[n + i] & 0xFF;
        }
        n2 %= 632;
        return n2 += 772;
    }

    public static int getMagicDHOffset2(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 768; i <= 771; ++i) {
            n2 += byArray[n + i] & 0xFF;
        }
        n2 %= 632;
        return n2 += 8;
    }

    public static int getMagicDigestOffset(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 8; i <= 11; ++i) {
            n2 += byArray[n + i] & 0xFF;
        }
        n2 %= 728;
        return n2 += 12;
    }

    public static int getMagicStartOffset(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 8; i <= 11; ++i) {
            n2 += byArray[n + i] & 0xFF;
        }
        n2 %= 728;
        n2 += 12;
        n2 = 412;
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signClientHandshake(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 8; i <= 11; ++i) {
            n2 += byArray[n + i] & 0xFF;
        }
        n2 %= 728;
        byte[] byArray2 = new byte[1504];
        int n3 = 0;
        System.arraycopy(byArray, n, byArray2, n3, n2 += 12);
        System.arraycopy(byArray, n + n2 + 32, byArray2, n3 += n2, 1504 - n2);
        RequestConnectHandshakeCrypto requestConnectHandshakeCrypto = RequestConnectHandshakeCryptoSingleton.getCrypto();
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(clientHandshakeSignKey, HANDSHAKESIZEHMACMETHOD);
            requestConnectHandshakeCrypto.mac2.init(secretKeySpec);
            requestConnectHandshakeCrypto.mac2.update(byArray2);
            requestConnectHandshakeCrypto.mac2.doFinal(byArray, n + n2);
            requestConnectHandshakeCrypto.mac2.reset();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.signClientHandshake: " + exception.toString());
        }
        finally {
            if (requestConnectHandshakeCrypto != null) {
                RequestConnectHandshakeCryptoSingleton.releaseCrypto(requestConnectHandshakeCrypto);
            }
            requestConnectHandshakeCrypto = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateClientHandshake(byte[] byArray, int n) {
        byte[] byArray2 = new byte[1536];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(byArray2);
        int n2 = 0;
        for (int i = 8; i <= 11; ++i) {
            n2 += byArray[n + i] & 0xFF;
        }
        n2 %= 728;
        n2 += 12;
        RequestConnectHandshakeCrypto requestConnectHandshakeCrypto = RequestConnectHandshakeCryptoSingleton.getCrypto();
        try {
            requestConnectHandshakeCrypto.clientMac1.init(requestConnectHandshakeCrypto.clientKey1);
            requestConnectHandshakeCrypto.clientMac1.update(byArray, n + n2, 32);
            byte[] byArray3 = requestConnectHandshakeCrypto.clientMac1.doFinal();
            requestConnectHandshakeCrypto.clientMac1.reset();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, HANDSHAKESIZEHMACMETHOD);
            requestConnectHandshakeCrypto.mac2.init(secretKeySpec);
            requestConnectHandshakeCrypto.mac2.update(byArray2, 0, 1504);
            requestConnectHandshakeCrypto.mac2.doFinal(byArray2, 1504);
            requestConnectHandshakeCrypto.mac2.reset();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.generateClientHandshake: " + exception.toString());
        }
        finally {
            if (requestConnectHandshakeCrypto != null) {
                RequestConnectHandshakeCryptoSingleton.releaseCrypto(requestConnectHandshakeCrypto);
            }
            requestConnectHandshakeCrypto = null;
        }
        return byArray2;
    }

    public static int getClientHandshakeLocation(byte[] byArray, int n) {
        int n2;
        try {
            Mac mac = Mac.getInstance(HANDSHAKESIZEHMACMETHOD);
            SecretKeySpec secretKeySpec = new SecretKeySpec(magicStrPlayer.getBytes(), HANDSHAKESIZEHMACMETHOD);
            mac.init(secretKeySpec);
            for (n2 = 0; n2 < 2; ++n2) {
                int n3;
                int n4 = 0;
                if (n2 == 0) {
                    for (n3 = 772; n3 <= 775; ++n3) {
                        n4 += byArray[n + n3] & 0xFF;
                    }
                    n4 %= 728;
                    n4 += 776;
                } else {
                    for (n3 = 8; n3 <= 11; ++n3) {
                        n4 += byArray[n + n3] & 0xFF;
                    }
                    n4 %= 728;
                    n4 += 12;
                }
                mac.update(byArray, n, n4);
                mac.update(byArray, n + n4 + 32, 1504 - n4);
                byte[] byArray2 = mac.doFinal();
                byte[] byArray3 = new byte[32];
                System.arraycopy(byArray, n + n4, byArray3, 0, byArray3.length);
                if (!Arrays.equals(byArray2, byArray3)) {
                    mac.reset();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.getClientHandshakeLocation: " + exception.toString());
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateServerHandshake(byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        byte[] byArray2 = new byte[1536];
        if (bl) {
            Random random = new Random(System.currentTimeMillis());
            random.nextBytes(byArray2);
        } else {
            System.arraycopy(wowzaServerHandshake, 0, byArray2, 0, byArray2.length);
        }
        int n4 = 0;
        if (n2 <= 0) {
            for (n3 = 772; n3 <= 775; ++n3) {
                n4 += byArray[n + n3] & 0xFF;
            }
            n4 %= 728;
            n4 += 776;
        } else {
            for (n3 = 8; n3 <= 11; ++n3) {
                n4 += byArray[n + n3] & 0xFF;
            }
            n4 %= 728;
            n4 += 12;
        }
        RequestConnectHandshakeCrypto requestConnectHandshakeCrypto = RequestConnectHandshakeCryptoSingleton.getCrypto();
        try {
            requestConnectHandshakeCrypto.serverMac1.init(requestConnectHandshakeCrypto.serverKey1);
            requestConnectHandshakeCrypto.serverMac1.update(byArray, n + n4, 32);
            byte[] byArray3 = requestConnectHandshakeCrypto.serverMac1.doFinal();
            requestConnectHandshakeCrypto.serverMac1.reset();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, HANDSHAKESIZEHMACMETHOD);
            requestConnectHandshakeCrypto.mac2.init(secretKeySpec);
            requestConnectHandshakeCrypto.mac2.update(byArray2, 0, 1504);
            requestConnectHandshakeCrypto.mac2.doFinal(byArray2, 1504);
            requestConnectHandshakeCrypto.mac2.reset();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestConnectHandshake.class).error("RequestConnectHandshake.generateServerHandshake: " + exception.toString());
        }
        finally {
            if (requestConnectHandshakeCrypto != null) {
                RequestConnectHandshakeCryptoSingleton.releaseCrypto(requestConnectHandshakeCrypto);
            }
            requestConnectHandshakeCrypto = null;
        }
        return byArray2;
    }
}

