/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.request;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.amf.AMFObjChunk;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;

public class RequestProcessData {
    public static final long TIMEROLLOVERSLOP = 250L;

    private static void killConnection(IVHost iVHost, Client client) {
        WMSLoggerFactory.getLogger(RequestProcessData.class).error("Data format incorrect, killing client connection.");
        if (iVHost != null && client != null) {
            iVHost.removeClient(client.getClientId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processNextRequest(IVHost iVHost, Client client, ByteBuffer byteBuffer, int n, int n2, List list) {
        boolean bl = false;
        try {
            Object object2;
            ContentChunk[] contentChunkArray;
            byte[] byArray = client.getLeftOverData();
            int n3 = client.getLeftOverMissing();
            client.clearLeftOverData();
            byteBuffer.position(0);
            int n4 = n;
            byte[] byArray2 = byteBuffer.array();
            if (byArray != null) {
                if (n3 > 0 && n3 <= n2) {
                    contentChunkArray = new ContentChunk[n3 < n2 ? 2 : 1];
                    contentChunkArray[0] = new ContentChunk();
                    contentChunkArray[0].myDataLen = byArray.length + n3;
                    contentChunkArray[0].myData = new byte[contentChunkArray[0].myDataLen];
                    System.arraycopy(byArray, 0, contentChunkArray[0].myData, 0, byArray.length);
                    System.arraycopy(byArray2, n4, contentChunkArray[0].myData, byArray.length, n3);
                    if (contentChunkArray.length > 1) {
                        contentChunkArray[1] = new ContentChunk();
                        contentChunkArray[1].myDataLen = n4 + n2;
                        contentChunkArray[1].myData = byArray2;
                        contentChunkArray[1].index = n4 + n3;
                    }
                } else {
                    contentChunkArray = new ContentChunk[]{new ContentChunk()};
                    contentChunkArray[0].myDataLen = byArray.length + n2;
                    contentChunkArray[0].myData = new byte[contentChunkArray[0].myDataLen];
                    System.arraycopy(byArray, 0, contentChunkArray[0].myData, 0, byArray.length);
                    System.arraycopy(byArray2, n4, contentChunkArray[0].myData, byArray.length, n2);
                }
            } else {
                contentChunkArray = new ContentChunk[]{new ContentChunk()};
                contentChunkArray[0].myDataLen = n4 + n2;
                contentChunkArray[0].myData = byArray2;
                contentChunkArray[0].index = n4;
            }
            HashMap hashMap = new HashMap();
            Map map = client.getPartialFunctions();
            for (Object object2 : map.keySet()) {
                hashMap.put(object2, map.get(object2));
                list.add(map.get(object2));
            }
            client.clearPartialFunctions();
            object2 = client.getReqAMFObjs();
            IApplicationInstance iApplicationInstance = client.getAppInstance();
            MediaStreamMap mediaStreamMap = null;
            if (iApplicationInstance != null) {
                mediaStreamMap = iApplicationInstance.getStreams();
            }
            int n5 = client.getReceiveChunkSize();
            IMediaStream iMediaStream = null;
            int n6 = -1;
            AMFObj aMFObj = null;
            int n7 = -1;
            int n8 = -1;
            int n9 = 0;
            for (int i = 0; i < contentChunkArray.length; ++i) {
                int n10;
                int n11 = contentChunkArray[i].index;
                byte[] byArray3 = contentChunkArray[i].myData;
                int n12 = contentChunkArray[i].myDataLen;
                do {
                    boolean bl2;
                    Object object3;
                    int n13;
                    Object object4;
                    List<AMFObjChunk> list2;
                    int n14;
                    int n15;
                    int n16;
                    n8 = n11;
                    n9 = 0;
                    int n17 = 1;
                    switch (byArray3[n11] & 0xC0) {
                        case 0: {
                            n17 = 12;
                            break;
                        }
                        case 64: {
                            n17 = 8;
                            break;
                        }
                        case 128: {
                            n17 = 4;
                            break;
                        }
                        case 192: {
                            n17 = 1;
                            break;
                        }
                        default: {
                            String string = client.getFlashVer();
                            if (string == null) {
                                string = "unknown";
                            }
                            String string2 = "";
                            if (n8 >= 0) {
                                n16 = 128;
                                if (n16 > n12 - n8) {
                                    n16 = n12 - n8;
                                }
                                if (n16 > 0) {
                                    string2 = BufferUtils.encodeHexString(byArray3, n8, n16);
                                }
                            }
                            WMSLoggerFactory.getLogger(RequestProcessData.class).error("Bad header (client:" + client.getClientId() + ":" + string + "): (" + (byArray3[n11] & 0xC0) + ") " + string2);
                            if (!bl) {
                                bl = true;
                            }
                            RequestProcessData.killConnection(iVHost, client);
                        }
                    }
                    int n18 = 0;
                    int n19 = byArray3[n11] & 0x3F;
                    if (n19 <= 1) {
                        if (++n11 + (n18 += n19 + 1) > n12) {
                            n11 = n8;
                            break;
                        }
                        n16 = BufferUtils.byteArrayToInt(byArray3, n11, n18, true);
                        n19 = 64 + n16;
                        n11 += n18 - 1;
                    }
                    if (n7 != n19) {
                        AMFObj aMFObj2 = aMFObj = n19 < object2.size() ? (AMFObj)object2.get(n19) : null;
                        if (aMFObj == null) {
                            aMFObj = new AMFObj(n19, client.getObjectEncoding());
                            while (object2.size() <= n19) {
                                object2.add(null);
                            }
                            object2.set(n19, aMFObj);
                        }
                        n7 = n19;
                    }
                    if (n11 + n17 + n18 > n12) {
                        n11 = n8;
                        break;
                    }
                    ++n11;
                    long l = -1L;
                    if (n17 >= 4) {
                        l = BufferUtils.byteArrayToInt(byArray3, n11, 3, false);
                        aMFObj.setLongTimecode(l == 0xFFFFFFL);
                        n11 += 3;
                    }
                    if (n17 >= 8) {
                        n15 = BufferUtils.byteArrayToInt(byArray3, n11, 3, false);
                        aMFObj.setSize(n15);
                        aMFObj.setType(0xFF & byArray3[n11 += 3]);
                        ++n11;
                    }
                    if (n17 == 12) {
                        aMFObj.setSrc(BufferUtils.byteArrayToInt(byArray3, n11, 4, true));
                        n11 += 4;
                    }
                    if (aMFObj.isLongTimecode()) {
                        if (n11 + 4 > n12) {
                            n11 = n8;
                            break;
                        }
                        l = BufferUtils.byteArrayToLong(byArray3, n11, 4, false);
                        n11 += 4;
                    }
                    n15 = aMFObj.getSrc();
                    int n20 = aMFObj.getType();
                    n10 = n5;
                    if (n17 >= 4) {
                        aMFObj.clearByteContainer();
                    }
                    if ((n14 = aMFObj.getSize() - aMFObj.getByteContainerLevel()) < 0) {
                        list2 = client.getFlashVer();
                        if (list2 == null) {
                            list2 = "unknown";
                        }
                        object4 = "";
                        if (n8 >= 0) {
                            n13 = 128;
                            if (n13 > n12 - n8) {
                                n13 = n12 - n8;
                            }
                            if (n13 > 0) {
                                object4 = BufferUtils.encodeHexString(byArray3, n8, n13);
                            }
                        }
                        WMSLoggerFactory.getLogger(RequestProcessData.class).error("Bad block size (client:" + client.getClientId() + ":" + (String)((Object)list2) + "):" + n17 + ":" + aMFObj.getByteContainerLevel() + ":" + (String)object4);
                        if (!bl) {
                            bl = true;
                        }
                        RequestProcessData.killConnection(iVHost, client);
                        n14 = 0;
                    }
                    if (n10 > n14) {
                        n10 = n14;
                    }
                    if (n11 + n10 > n12) {
                        n9 = n10 - (n12 - n11);
                        n11 = n8;
                        break;
                    }
                    if (l == -1L) {
                        l = aMFObj.getTimecode();
                    } else if (n17 < 12 && !aMFObj.isLongTimecode()) {
                        aMFObj.setTimecode(l);
                    }
                    if (aMFObj.isByteContainerEmpty()) {
                        long l2 = aMFObj.getAbsTimecode();
                        String string = "";
                        if (aMFObj.isLongTimecode()) {
                            aMFObj.setAbsTimecodeLong(l);
                            string = "long";
                        } else if (n17 == 12) {
                            long l3 = aMFObj.getAbsTimecode();
                            long l4 = l3 & 0xFFFFFFFFFF000000L;
                            long l5 = l3 & 0xFFFFFFL;
                            if (l4 > 0L && l5 <= 250L && l >= 0xFFFF06L) {
                                long l6 = l4 - 0x1000000L + l;
                                aMFObj.setAbsTimecodeLong(l6);
                                string = "weird";
                                WMSLoggerFactory.getLogger(RequestProcessData.class).warn("RequestProcessData: timecode backtrack: ovfl:" + l4 + " short:" + l5 + " new:" + l + " adj:" + l6);
                            } else {
                                aMFObj.setAbsTimecodeShort(l);
                                if (l2 == 0L) {
                                    aMFObj.setTimecode(l);
                                }
                                string = "short";
                            }
                        } else {
                            aMFObj.incAbsTimecode(l);
                            string = "inc";
                        }
                    }
                    list2 = null;
                    object4 = null;
                    aMFObj.addChunk(byArray3, n11, n10);
                    aMFObj.incByteContainerLevel(n10);
                    n13 = aMFObj.isByteContainerFull() ? 1 : 0;
                    if (n13 != 0) {
                        list2 = aMFObj.getChunks();
                        if (list2.size() > 0) {
                            object4 = (AMFObjChunk)list2.get(0);
                        }
                        aMFObj.clearByteContainer();
                        aMFObj.setLongTimecode(false);
                    }
                    if (n13 == 0) continue;
                    if ((n20 == 8 || n20 == 9 || n20 == 18 || n20 == 15) && n15 > 0) {
                        IClient iClient;
                        if (n15 != n6) {
                            iMediaStream = mediaStreamMap.getStream(client, n15);
                        }
                        if (iMediaStream != null && (iClient = iMediaStream.getClient()) != null && iClient.getClientId() != client.getClientId()) {
                            iMediaStream = null;
                        }
                        if (iMediaStream != null) {
                            n6 = n15;
                            int n21 = aMFObj.getSize();
                            if (n20 == 8) {
                                iMediaStream.setAudioSize(n21);
                                iMediaStream.setAudioTC(aMFObj.getAbsTimecode());
                                iMediaStream.setHeaderSize(n17);
                                iMediaStream.startAudioPacket();
                                for (AMFObjChunk aMFObjChunk : list2) {
                                    iMediaStream.addAudioData(aMFObjChunk.buffer, aMFObjChunk.offset, aMFObjChunk.len);
                                }
                            } else if (n20 == 9) {
                                iMediaStream.setVideoSize(n21);
                                iMediaStream.setVideoTC(aMFObj.getAbsTimecode());
                                iMediaStream.setHeaderSize(n17);
                                iMediaStream.startVideoPacket();
                                for (AMFObjChunk aMFObjChunk : list2) {
                                    iMediaStream.addVideoData(aMFObjChunk.buffer, aMFObjChunk.offset, aMFObjChunk.len);
                                }
                            } else if (n20 == 18 || n20 == 15) {
                                iMediaStream.setDataType(n20);
                                iMediaStream.setDataSize(n21);
                                iMediaStream.setDataTC(aMFObj.getAbsTimecode());
                                iMediaStream.setHeaderSize(n17);
                                iMediaStream.startDataPacket();
                                for (AMFObjChunk aMFObjChunk : list2) {
                                    iMediaStream.addDataData(aMFObjChunk.buffer, aMFObjChunk.offset, aMFObjChunk.len);
                                }
                            }
                            int n22 = n21 + n17 + n21 / n5;
                            client.incrementMediaInBytes(n22);
                            iMediaStream.incrementMediaInBytes(n22);
                        } else {
                            n6 = -1;
                        }
                    }
                    if (n20 == 8 || n20 == 9) continue;
                    if (n20 == 1) {
                        if (object4 != null) {
                            n5 = BufferUtils.byteArrayToInt(((AMFObjChunk)object4).buffer, ((AMFObjChunk)object4).offset);
                        }
                        client.setReceiveChunkSize(n5);
                        continue;
                    }
                    if (n20 == 3) {
                        int n23 = 0;
                        if (object4 == null) continue;
                        n23 = BufferUtils.byteArrayToInt(((AMFObjChunk)object4).buffer, ((AMFObjChunk)object4).offset);
                        continue;
                    }
                    if (n20 == 4) {
                        int n24 = 0;
                        if (object4 != null) {
                            n24 = BufferUtils.byteArrayToInt(((AMFObjChunk)object4).buffer, ((AMFObjChunk)object4).offset, 2);
                        }
                        if (n24 == 3) {
                            int n25 = 0;
                            int n26 = 0;
                            if (object4 != null) {
                                n25 = BufferUtils.byteArrayToInt(((AMFObjChunk)object4).buffer, ((AMFObjChunk)object4).offset + 2, 4);
                                n26 = BufferUtils.byteArrayToInt(((AMFObjChunk)object4).buffer, ((AMFObjChunk)object4).offset + 6, 4);
                            }
                            if (n25 == 0) {
                                client.setBufferTime(n26);
                                continue;
                            }
                            object3 = new AMFDataList();
                            ((AMFDataList)object3).add(new AMFDataItem("setBufferTime"));
                            ((AMFDataList)object3).add(new AMFDataItem(0.0));
                            ((AMFDataList)object3).add(new AMFDataItem());
                            ((AMFDataList)object3).add(new AMFDataItem((double)n26));
                            byte[] byArray4 = ((AMFDataList)object3).serialize();
                            RequestFunction requestFunction = new RequestFunction();
                            requestFunction.setSize(byArray4.length);
                            requestFunction.setSrc(n25);
                            requestFunction.setType(20);
                            requestFunction.setTimecode(aMFObj.getAbsTimecode());
                            requestFunction.setWmsNumber(n19);
                            requestFunction.addData(byArray4, 0, byArray4.length);
                            list.add(requestFunction);
                            continue;
                        }
                        if (n24 == 6) {
                            int n27 = 0;
                            if (object4 != null) {
                                n27 = BufferUtils.byteArrayToInt(((AMFObjChunk)object4).buffer, ((AMFObjChunk)object4).offset + 2, 4);
                            }
                            byte[] byArray5 = new byte[]{2, 0, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 7, (byte)(0xFF & n27 >> 24), (byte)(0xFF & n27 >> 16), (byte)(0xFF & n27 >> 8), (byte)(0xFF & n27)};
                            object3 = new ResponseFunction(client);
                            ((ResponseFunction)object3).addBytes(byArray5);
                            client.getRespFunctions().add((ResponseFunction)object3);
                            continue;
                        }
                        if (n24 != 7) continue;
                        int n28 = 0;
                        if (object4 != null) {
                            n28 = BufferUtils.byteArrayToInt(((AMFObjChunk)object4).buffer, ((AMFObjChunk)object4).offset + 2, 4);
                        }
                        client.handlePingResult(n28, true);
                        continue;
                    }
                    if (n20 != 20 && n20 != 17 && n20 != 18 && n20 != 15 && n20 != 19 && n20 != 16) continue;
                    Integer n29 = new Integer(n19);
                    RequestFunction requestFunction = (RequestFunction)hashMap.get(n29);
                    if (aMFObj.getSize() <= 0) {
                        String string = client.getFlashVer();
                        if (string == null) {
                            string = "unknown";
                        }
                        object3 = "";
                        boolean bl3 = false;
                        if (n8 >= 0 && object4 != null) {
                            object3 = BufferUtils.encodeHexString(((AMFObjChunk)object4).buffer, ((AMFObjChunk)object4).offset, ((AMFObjChunk)object4).len);
                        }
                        WMSLoggerFactory.getLogger(RequestProcessData.class).error("Zero sized function (client:" + client.getClientId() + ":" + string + "): type:" + n20 + " size:" + aMFObj.getSize() + ":" + (String)object3);
                        if (!bl) {
                            bl = true;
                        }
                    }
                    boolean bl4 = bl2 = requestFunction == null;
                    if (!bl2) {
                        bl2 = true;
                    }
                    if (bl2) {
                        requestFunction = new RequestFunction();
                        requestFunction.setSize(aMFObj.getSize());
                        requestFunction.setSrc(aMFObj.getSrc());
                        requestFunction.setType(n20);
                        requestFunction.setTimecode(aMFObj.getAbsTimecode());
                        requestFunction.setWmsNumber(n19);
                        requestFunction.setHeaderSize(n17);
                        hashMap.put(n29, requestFunction);
                        if (aMFObj.getSize() > 0) {
                            list.add(requestFunction);
                        }
                    }
                    if (requestFunction != null) {
                        for (AMFObjChunk aMFObjChunk : list2) {
                            requestFunction.addData(aMFObjChunk.buffer, aMFObjChunk.offset, aMFObjChunk.len);
                        }
                        if (n13 == 0) continue;
                        hashMap.remove(n29);
                        continue;
                    }
                    WMSLoggerFactory.getLogger(RequestProcessData.class).error("Function missing");
                    if (bl) continue;
                    bl = true;
                } while ((n11 += n10) < n12);
                if (n11 >= n12) continue;
                client.setLeftOverData(byArray3, n11, n12 - n11, n9);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RequestFunction requestFunction = (RequestFunction)iterator.next();
                if (!requestFunction.isPartial()) continue;
                client.addPartialFunction(new Integer(requestFunction.getWmsNumber()), requestFunction);
                iterator.remove();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RequestProcessData.class).error("processNextRequest: error: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            byteBuffer.release();
        }
    }

    public static class ContentChunk {
        public byte[] myData = null;
        public int myDataLen = 0;
        public int index = 0;
    }
}

