/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.response;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataContextSerialize;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.stream.IMediaStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ResponseFunction {
    private AMFDataList message = null;
    private byte[] messageBytes = null;
    private ByteBuffer bytes = null;
    private long timecode = 0L;
    private int src = 0;
    private int type = 20;
    private int retAMFNumber = 3;
    public boolean doBreak = false;
    private AMFObj amfObj = null;
    private IClient client = null;
    private INetConnection netConnection = null;
    private boolean forceAMF0 = false;

    public ResponseFunction(IClient iClient) {
        this.client = iClient;
    }

    public ResponseFunction(INetConnection iNetConnection) {
        this.netConnection = iNetConnection;
    }

    public ResponseFunction(INetConnection iNetConnection, AMFObj aMFObj) {
        this.doBreak = false;
        this.amfObj = aMFObj;
        this.retAMFNumber = aMFObj.getId();
        this.netConnection = iNetConnection;
    }

    public ResponseFunction(IClient iClient, AMFObj aMFObj) {
        this.doBreak = false;
        this.amfObj = aMFObj;
        this.retAMFNumber = aMFObj.getId();
        this.client = iClient;
    }

    public ResponseFunction(IMediaStream iMediaStream, AMFObj aMFObj) {
        this.doBreak = false;
        this.amfObj = aMFObj;
        this.retAMFNumber = aMFObj.getId();
        if (iMediaStream.getClient() != null) {
            this.client = iMediaStream.getClient();
        } else if (iMediaStream.getNetConnection() != null) {
            this.netConnection = iMediaStream.getNetConnection();
        }
    }

    public void setSrc(int n) {
        this.src = n;
    }

    public void createDefaultMessage(String string, double d) {
        this.message = new AMFDataList();
        this.message.add(new AMFDataItem(string));
        this.message.add(new AMFDataItem(d));
        this.message.add(new AMFDataItem());
        if (this.isHandlerAMF0(string)) {
            this.setForceAMF0(true);
        }
    }

    public void createConnectMessage(String string, double d) {
        this.message = new AMFDataList();
        this.message.add(new AMFDataItem(string));
        this.message.add(new AMFDataItem(d));
        if (this.isHandlerAMF0(string)) {
            this.setForceAMF0(true);
        }
    }

    public void createSeekMessage(String string) {
        this.message = new AMFDataList();
        this.message.add(new AMFDataItem(string));
        if (this.isHandlerAMF0(string)) {
            this.setForceAMF0(true);
        }
    }

    public void createPlayStatusMessage(String string) {
        this.message = new AMFDataList();
        this.message.add(new AMFDataItem(string));
        if (this.isHandlerAMF0(string)) {
            this.setForceAMF0(true);
        }
    }

    public void setMessageBytes(byte[] byArray) {
        this.messageBytes = byArray;
    }

    public void createBroadcastMessage(ByteBuffer byteBuffer) {
        this.messageBytes = byteBuffer.array();
    }

    public void createSOMessage(byte[] byArray, int n) {
        this.messageBytes = byArray;
        this.src = 0;
        this.type = n == 0 ? 19 : 16;
        this.timecode = 0L;
        this.retAMFNumber = 4;
    }

    public void createEnhancedSeekMessage(byte[] byArray, int n, int n2) {
        this.messageBytes = byArray;
        this.src = n;
        this.type = 9;
        this.timecode = n2;
        this.retAMFNumber = 3;
    }

    public void addBody(AMFData aMFData) {
        this.message.add(aMFData);
    }

    public void setBody(int n, AMFData aMFData) {
        this.message.set(n, aMFData);
    }

    public void addBytes(byte[] byArray) {
        this.bytes = ByteBuffer.wrap(byArray);
    }

    public void setRetAMFNumber(int n) {
        this.retAMFNumber = n;
    }

    public long getTimecode() {
        return this.timecode;
    }

    public void setTimecode(long l) {
        this.timecode = l;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public int write(OutputStream outputStream, int n) {
        return this.write(outputStream, false, n);
    }

    public boolean isForceAMF0() {
        return this.forceAMF0;
    }

    public void setForceAMF0(boolean bl) {
        this.forceAMF0 = bl;
    }

    private boolean isHandlerAMF0(String string) {
        return string.equals("onStatus") || string.equals("onPlayStatus") || string.equals("|RtmpSampleAccess");
    }

    /*
     * WARNING - void declaration
     */
    public int write(OutputStream outputStream, boolean bl, int n) {
        int n2 = 0;
        try {
            if (this.bytes != null) {
                byte[] byArray = this.bytes.array();
                outputStream.write(byArray);
                n2 += byArray.length;
            } else if (this.message != null || this.messageBytes != null) {
                byte[] byArray;
                int n3;
                int n4;
                int n5;
                int n6;
                AMFDataList aMFDataList = this.message;
                long l = this.timecode;
                int n7 = this.amfObj == null ? this.retAMFNumber : this.amfObj.getId();
                int n8 = this.src;
                int n9 = this.getType();
                int n10 = 0;
                byte[] byArray2 = null;
                if (this.messageBytes != null) {
                    byArray2 = this.messageBytes;
                    n10 = byArray2.length;
                } else if (aMFDataList != null) {
                    int n11 = 0;
                    if (!this.isForceAMF0()) {
                        if (this.client != null) {
                            n11 = this.client.getObjectEncoding();
                        } else if (this.netConnection != null) {
                            n11 = this.netConnection.getObjectEncoding();
                        } else if (this.amfObj != null) {
                            n11 = this.amfObj.getObjectEncoding();
                        }
                    }
                    byte[] byArray3 = null;
                    AMFDataContextSerialize object = AMFData.createContextSerialize(0);
                    if (n11 > 0) {
                        if (n9 == 20) {
                            n9 = 17;
                            byArray3 = new byte[]{0};
                            object.setTargetEncoding(n11);
                        } else if (n9 == 19) {
                            n9 = 16;
                            byArray3 = new byte[]{0};
                            object.setTargetEncoding(n11);
                        }
                    }
                    byArray2 = aMFDataList.serialize(object, byArray3);
                    n10 = byArray2.length;
                }
                byte[] byArray4 = new byte[12];
                boolean bl2 = false;
                if (this.amfObj != null) {
                    int n12 = this.amfObj.isNew();
                    n6 = n12 | bl;
                    this.amfObj.setNew(false);
                    n5 = 1;
                    byArray4[0] = (byte)(0xFF & n7);
                    if (n6 != 0 || this.amfObj.getSrc() != n8) {
                        byArray4[8] = (byte)(0xFF & n8);
                        byArray4[9] = (byte)(0xFF & n8 >> 8);
                        byArray4[10] = (byte)(0xFF & n8 >> 16);
                        byArray4[11] = (byte)(0xFF & n8 >> 24);
                        this.amfObj.setSrc(n8);
                        n5 += 4;
                        n6 = 1;
                    }
                    if (n6 != 0 || this.amfObj.getSize() != n10 || this.amfObj.getType() != n9) {
                        byArray4[4] = (byte)(0xFF & n10 >> 16);
                        byArray4[5] = (byte)(0xFF & n10 >> 8);
                        byArray4[6] = (byte)(0xFF & n10);
                        byArray4[7] = (byte)n9;
                        this.amfObj.setSize(n10);
                        this.amfObj.setType(n9);
                        n5 += 4;
                        n6 = 1;
                    }
                    if (n6 != 0 || this.amfObj.getTimecode() != l) {
                        if (l >= 0xFFFFFFL) {
                            byArray4[1] = -1;
                            byArray4[2] = -1;
                            byArray4[3] = -1;
                            bl2 = true;
                        } else {
                            byArray4[1] = (byte)(0xFFL & l >> 16);
                            byArray4[2] = (byte)(0xFFL & l >> 8);
                            byArray4[3] = (byte)(0xFFL & l);
                        }
                        this.amfObj.setTimecode(l);
                        n5 += 3;
                        n6 = 1;
                    }
                    if (n7 >= 64) {
                        n4 = n7 - 64;
                        n3 = n4 > 255 ? 3 : 2;
                        byArray = new byte[n3];
                        switch (n5) {
                            case 12: {
                                byArray[0] = (byte)(0 + (n3 - 2));
                                break;
                            }
                            case 8: {
                                byArray[0] = (byte)(64 + (n3 - 2));
                                break;
                            }
                            case 4: {
                                byArray[0] = (byte)(128 + (n3 - 2));
                                break;
                            }
                            case 1: {
                                byArray[0] = (byte)(192 + (n3 - 2));
                            }
                        }
                        byArray[1] = (byte)(0xFF & n4);
                        if (n3 == 3) {
                            byArray[2] = (byte)(0xFF & n4 >> 8);
                        }
                        outputStream.write(byArray, 0, n3);
                        outputStream.write(byArray4, 1, n5 - 1);
                        n2 += n5 - 1 + n3;
                    } else {
                        switch (n5) {
                            case 12: {
                                break;
                            }
                            case 8: {
                                byArray4[0] = (byte)(byArray4[0] | 0x40);
                                break;
                            }
                            case 4: {
                                byArray4[0] = (byte)(byArray4[0] | 0x80);
                                break;
                            }
                            case 1: {
                                byArray4[0] = (byte)(byArray4[0] | 0xC0);
                            }
                        }
                        outputStream.write(byArray4, 0, n5);
                        n2 += n5;
                    }
                    if (bl2) {
                        byArray4[0] = (byte)(0xFFL & l >> 24);
                        byArray4[1] = (byte)(0xFFL & l >> 16);
                        byArray4[2] = (byte)(0xFFL & l >> 8);
                        byArray4[3] = (byte)(0xFFL & l);
                        outputStream.write(byArray4, 0, 4);
                        n2 = 4;
                    }
                } else {
                    void var15_23;
                    Object n13 = null;
                    if (this.client != null) {
                        AMFObj aMFObj = this.client.getResponseAMFObj(n7);
                    } else if (this.netConnection != null) {
                        AMFObj aMFObj = this.netConnection.getResponseAMFObj(n7);
                    }
                    if (var15_23 != null) {
                        var15_23.setSrc(n8);
                        var15_23.setSize(n10);
                        var15_23.setType(n9);
                        var15_23.setTimecode(l);
                    }
                    if (l >= 0xFFFFFFL) {
                        byArray4[1] = -1;
                        byArray4[2] = -1;
                        byArray4[3] = -1;
                        bl2 = true;
                    } else {
                        byArray4[1] = (byte)(0xFFL & l >> 16);
                        byArray4[2] = (byte)(0xFFL & l >> 8);
                        byArray4[3] = (byte)(0xFFL & l);
                    }
                    byArray4[4] = (byte)(0xFF & n10 >> 16);
                    byArray4[5] = (byte)(0xFF & n10 >> 8);
                    byArray4[6] = (byte)(0xFF & n10);
                    byArray4[7] = (byte)(n9 & 0xFF);
                    byArray4[8] = (byte)(0xFF & n8);
                    byArray4[9] = (byte)(0xFF & n8 >> 8);
                    byArray4[10] = (byte)(0xFF & n8 >> 16);
                    byArray4[11] = (byte)(0xFF & n8 >> 24);
                    if (n7 >= 64) {
                        n6 = n7 - 64;
                        n5 = n6 > 255 ? 3 : 2;
                        byte[] byArray3 = new byte[n5];
                        byArray3[0] = (byte)(0 + (n5 - 2));
                        byArray3[1] = (byte)(0xFF & n6);
                        if (n5 == 3) {
                            byArray3[2] = (byte)(0xFF & n6 >> 8);
                        }
                        outputStream.write(byArray3, 0, n5);
                        outputStream.write(byArray4, 1, byArray4.length - 1);
                        n2 += byArray4.length - 1 + n5;
                    } else {
                        byArray4[0] = (byte)(0xFF & n7);
                        outputStream.write(byArray4);
                        n2 += byArray4.length;
                    }
                    if (bl2) {
                        byArray4[0] = (byte)(0xFFL & l >> 24);
                        byArray4[1] = (byte)(0xFFL & l >> 16);
                        byArray4[2] = (byte)(0xFFL & l >> 8);
                        byArray4[3] = (byte)(0xFFL & l);
                        outputStream.write(byArray4, 0, 4);
                        n2 = 4;
                    }
                }
                int n11 = byArray2.length;
                n6 = 0;
                n5 = 0;
                do {
                    if (n6 > 0) {
                        if (n7 >= 64) {
                            n4 = n7 - 64;
                            n3 = n4 > 255 ? 3 : 2;
                            byArray = new byte[n3];
                            byArray[0] = (byte)(192 + (n3 - 2));
                            byArray[1] = (byte)(0xFF & n4);
                            if (n3 == 3) {
                                byArray[2] = (byte)(0xFF & n4 >> 8);
                            }
                            outputStream.write(byArray, 0, n3);
                            n2 += n3;
                        } else {
                            byte[] byArray5 = new byte[]{(byte)(0xFF & n7 | 0xC0)};
                            outputStream.write(byArray5);
                            n2 += byArray5.length;
                        }
                        if (bl2) {
                            byArray4[0] = (byte)(0xFFL & l >> 24);
                            byArray4[1] = (byte)(0xFFL & l >> 16);
                            byArray4[2] = (byte)(0xFFL & l >> 8);
                            byArray4[3] = (byte)(0xFFL & l);
                            outputStream.write(byArray4, 0, 4);
                            n2 = 4;
                        }
                    }
                    if ((n5 = n) > n11 - n6) {
                        n5 = n11 - n6;
                    }
                    outputStream.write(byArray2, n6, n5);
                    n2 += n5;
                } while ((n6 += n5) != n11);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ResponseFunction.class).error("write " + exception.toString());
            exception.printStackTrace();
        }
        return n2;
    }
}

