/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BitReader;
import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.RolloverLong;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.RTCPEventHandlerGeneric;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerAudioBase;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerMPEG4AAC;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.util.RTPUtils;
import java.net.SocketAddress;

public class RTPDePacketizerMPEG4LATM
extends RTPDePacketizerAudioBase
implements IRTPDePacketizer,
IRTPTimecodeProvider {
    private boolean isFirstPacket = true;
    private RTCPEventHandlerGeneric rtcpEventHandler = new RTCPEventHandlerGeneric();
    private RTPSequence seq = new RTPSequence();
    private long lastTimecode = -1L;
    private boolean haveConfig = false;
    private boolean emptyConfig = false;
    private StreamMuxConfig streamMuxConfig = null;
    private RolloverLong timecode = new RolloverLong(32);

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerMPEG4LATM.init");
        }
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        String string;
        return rTPTrack.isAudio() && (string = rTPTrack.getSampleType()) != null && string.toLowerCase().startsWith("mp4a-latm");
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtcp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTCPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.rtcpHandler.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    private int latmGetValue(BitReader bitReader) {
        int n = bitReader.getInt(2);
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            n2 <<= 8;
            n2 += bitReader.getInt(8);
        }
        return n2;
    }

    private GASpecificConfig parseGASpecificConfig(BitReader bitReader, AudioSpecificConfig audioSpecificConfig) {
        GASpecificConfig gASpecificConfig = new GASpecificConfig();
        try {
            gASpecificConfig.frameLengthFlag = bitReader.getInt(1);
            gASpecificConfig.dependsOnCoreCoder = bitReader.getInt(1);
            if (gASpecificConfig.dependsOnCoreCoder == 1) {
                gASpecificConfig.coreCoderDelay = bitReader.getInt(14);
            }
            gASpecificConfig.extensionFlag = bitReader.getInt(1);
            if (audioSpecificConfig.channelConfiguration == 0) {
                WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseGASpecificConfig: Unsupported audioObjectType: audioSpec.channelConfiguration=0");
            }
            if (audioSpecificConfig.audioObjectType == 6 || audioSpecificConfig.audioObjectType == 20) {
                gASpecificConfig.layerNr = bitReader.getInt(3);
            }
            if (gASpecificConfig.extensionFlag == 1) {
                WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseGASpecificConfig: Unsupported audioObjectType: ret.extensionFlag=1");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseGASpecificConfig: " + exception.toString());
            exception.printStackTrace();
        }
        return gASpecificConfig;
    }

    private AudioSpecificConfig parseAudioSpecificConfig(BitReader bitReader) {
        AudioSpecificConfig audioSpecificConfig = new AudioSpecificConfig();
        try {
            audioSpecificConfig.audioObjectType = bitReader.getInt(5);
            if (audioSpecificConfig.audioObjectType == 31) {
                audioSpecificConfig.audioObjectType = 32 + bitReader.getInt(6);
            }
            audioSpecificConfig.samplingFrequencyIndex = bitReader.getInt(4);
            audioSpecificConfig.samplingFrequency = audioSpecificConfig.samplingFrequencyIndex == 15 ? bitReader.getInt(24) : AACUtils.AAC_SAMPLERATES[audioSpecificConfig.samplingFrequencyIndex];
            audioSpecificConfig.channelConfiguration = bitReader.getInt(4);
            if (audioSpecificConfig.audioObjectType == 5) {
                audioSpecificConfig.extensionAudioObjectType = audioSpecificConfig.audioObjectType;
                audioSpecificConfig.sbrPresentFlag = 1;
                audioSpecificConfig.extensionSamplingFrequencyIndex = bitReader.getInt(4);
                audioSpecificConfig.extensionSamplingFrequency = audioSpecificConfig.extensionSamplingFrequencyIndex == 15 ? bitReader.getInt(24) : AACUtils.AAC_SAMPLERATES[audioSpecificConfig.extensionSamplingFrequencyIndex];
                audioSpecificConfig.audioObjectType = bitReader.getInt(5);
                if (audioSpecificConfig.audioObjectType == 31) {
                    audioSpecificConfig.audioObjectType = 32 + bitReader.getInt(6);
                }
            }
            switch (audioSpecificConfig.audioObjectType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    audioSpecificConfig.gaConfig = this.parseGASpecificConfig(bitReader, audioSpecificConfig);
                    break;
                }
                default: {
                    WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseAudioSpecificConfig: Unsupported audioObjectType: " + audioSpecificConfig.audioObjectType);
                }
            }
            switch (audioSpecificConfig.audioObjectType) {
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseAudioSpecificConfig: Unsupported epConfig");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseAudioSpecificConfig: " + exception.toString());
            exception.printStackTrace();
        }
        return audioSpecificConfig;
    }

    private StreamMuxConfig parseStreamMuxConfig(BitReader bitReader) {
        StreamMuxConfig streamMuxConfig;
        block15: {
            streamMuxConfig = new StreamMuxConfig();
            try {
                streamMuxConfig.audioMuxVersion = bitReader.getInt(1);
                streamMuxConfig.audioMuxVersionA = 0;
                if (streamMuxConfig.audioMuxVersion == 1) {
                    streamMuxConfig.audioMuxVersionA = bitReader.getInt(1);
                }
                streamMuxConfig.taraBufferFullness = 0;
                if (streamMuxConfig.audioMuxVersionA != 0) break block15;
                if (streamMuxConfig.audioMuxVersion == 1) {
                    streamMuxConfig.taraBufferFullness = this.latmGetValue(bitReader);
                }
                boolean bl = streamMuxConfig.allStreamsSameTimeFraming = bitReader.getInt(1) == 1;
                if (!streamMuxConfig.allStreamsSameTimeFraming) {
                    WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseConfig: Unsupported config values: allStreamsSameTimeFraming==" + streamMuxConfig.allStreamsSameTimeFraming);
                }
                streamMuxConfig.numSubFrames = bitReader.getInt(6);
                streamMuxConfig.numPrograms = bitReader.getInt(4);
                for (int i = 0; i <= streamMuxConfig.numPrograms; ++i) {
                    int n = bitReader.getInt(3);
                    for (int j = 0; j <= n; ++j) {
                        boolean bl2 = false;
                        if (i > 0 || j > 0) {
                            boolean bl3 = bl2 = bitReader.getInt(1) == 1;
                        }
                        if (!bl2) {
                            if (streamMuxConfig.audioMuxVersion == 0) {
                                streamMuxConfig.audioSpecificConfig = this.parseAudioSpecificConfig(bitReader);
                            } else {
                                WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseConfig: Unsupported config values: audioMuxVersion==1");
                            }
                        }
                        streamMuxConfig.frameLengthType = bitReader.getInt(3);
                        if (streamMuxConfig.frameLengthType == 0) {
                            streamMuxConfig.latmBufferFullness = bitReader.getInt(8);
                        } else if (streamMuxConfig.frameLengthType == 1) {
                            streamMuxConfig.frameLength = bitReader.getInt(9);
                        } else {
                            WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseConfig: Unsupported config values: frameLengthType==" + streamMuxConfig.frameLengthType);
                        }
                        if (n <= 0) continue;
                        WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseConfig: Unsupported config values: numLayers==" + n);
                        break;
                    }
                    if (streamMuxConfig.numPrograms <= 0) continue;
                    WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseConfig: Unsupported config values: numPrograms==" + streamMuxConfig.numPrograms);
                    break;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseStreamMuxConfig: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return streamMuxConfig;
    }

    private boolean parseConfig(RTPTrack rTPTrack) {
        boolean bl;
        block3: {
            byte[] byArray;
            bl = false;
            String string = rTPTrack.getTrackInfo("config");
            if (string == null || (byArray = BufferUtils.decodeHexString(string)) == null) break block3;
            BitReader bitReader = new BitReader(byArray);
            try {
                this.streamMuxConfig = this.parseStreamMuxConfig(bitReader);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerMPEG4LATM.parseConfig: " + exception.toString());
                break block3;
            }
            if (this.streamMuxConfig != null) {
                WMSLoggerFactory.getLogger(null).debug("streamMuxConfig: " + this.streamMuxConfig.toString());
                byte[] byArray2 = this.streamMuxConfig.getCodecConfig();
                rTPTrack.setCodecConfig(byArray2);
                bl = true;
            }
        }
        return bl;
    }

    public byte[] getFakeCodecConfig(int n, int n2) {
        byte[] byArray = new byte[2];
        byArray[0] = 16;
        byArray[0] = (byte)(byArray[0] + (n >> 1));
        byArray[1] = 0;
        byArray[1] = (byte)(byArray[1] + (n << 7));
        byArray[1] = (byte)(byArray[1] + (n2 << 3));
        return byArray;
    }

    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
        long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
        this.timecode.set(l);
        this.setAudioCodecId(rTPTrack, 10);
        if (!this.haveConfig) {
            this.haveConfig = this.parseConfig(rTPTrack);
            if (!this.haveConfig) {
                this.streamMuxConfig = new StreamMuxConfig();
                this.haveConfig = true;
                this.emptyConfig = true;
            }
        }
        try {
            boolean bl = (byArray[n + 1] >> 7 & 1) == 1;
            int n4 = this.skipRTPExtensions(byArray, n, n2, 12);
            if (this.haveConfig) {
                int n5 = rTPTrack.getTimescale();
                boolean bl2 = this.rtcpHandler.isTimeSyncReady(rTPTrack, this.timecode.get());
                if (!bl2) {
                    if (!bl2) {
                        this.checkRTCPMissingWarning();
                    }
                } else if (this.streamMuxConfig.frameLengthType <= 1) {
                    int n6;
                    int n7 = 0;
                    int n8 = n2 - n4;
                    do {
                        Object object;
                        Object object2;
                        n6 = 0;
                        if (this.streamMuxConfig.frameLengthType == 0) {
                            int n9;
                            do {
                                n9 = byArray[n + n4 + n7] & 0xFF;
                                ++n7;
                            } while (n9 == 255 && (n6 += n9) <= --n8 && n8 > 0);
                        } else if (this.streamMuxConfig.frameLengthType == 1) {
                            n6 = this.streamMuxConfig.frameLength;
                        }
                        if (n6 > n8) {
                            WMSLoggerFactory.getLogger(null).error("RTPDePacketizerMPEG4LATM.handleRTPPacket: Bad packet length: " + n6 + ":" + n8);
                            break;
                        }
                        long l2 = this.rtcpHandler.convertTimeSyncTimecode(this.timecode.get(), n5);
                        if (this.isFirstPacket) {
                            object2 = rTPTrack.getCodecConfig();
                            if (object2 != null) {
                                if (this.debugLog) {
                                    WMSLoggerFactory.getLogger(null).debug("  codecConfig: " + DebugUtils.formatBytesShort(object2));
                                    object = AACUtils.decodeAACCodecConfig(object2, 0);
                                    if (object != null) {
                                        WMSLoggerFactory.getLogger(null).debug("  codecConfigInfo: " + ((AACFrame)object).toString());
                                    }
                                }
                                RTPUtils.writeCodecConfig(rTPTrack, l2, object2);
                            }
                            this.isFirstPacket = false;
                        }
                        object2 = new RTPPacket();
                        object2.setType(8);
                        object2.setCodec(10);
                        object2.setFrameType(15);
                        object2.setTimecode(this.timecode.get());
                        object = new RTPPacketFragment(byArray, n + n4 + n7, n6);
                        object2.addFragment((RTPPacketFragment)object);
                        if (this.debugLog) {
                            object2.setDebugLog(true);
                        }
                        object2.write(rTPTrack, l2);
                        long l3 = this.timecode.get() + (long)rTPTrack.getSamplesPerFrame();
                        this.timecode.setAbs(l3);
                        n7 += n6;
                    } while ((n8 -= n6) > 0);
                }
            }
            this.lastTimecode = this.timecode.get();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPDePacketizerMPEG4AAC.class).warn("RTPDePacketizerMPEG4LATM.handleRTPPacket: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void startup(RTPTrack rTPTrack) {
        this.rtcpEventHandler.setTimecodeProvider(this);
        this.rtcpHandler.addEventListener(this.rtcpEventHandler);
        this.setupAppInstanceRTCPEventHandler(this, this.rtcpHandler, rTPTrack);
    }

    public void shutdown(RTPTrack rTPTrack) {
    }

    public long getAdjTimecode(RTPTrack rTPTrack) {
        if (this.lastTimecode != -1L && this.rtcpHandler.isTimeSyncReady(rTPTrack, this.lastTimecode)) {
            long l = this.rtcpHandler.convertTimeSyncTimecode(this.lastTimecode, rTPTrack.getTimescale());
            return l;
        }
        return -1L;
    }

    class AudioSpecificConfig {
        int audioObjectType = 0;
        int extensionAudioObjectType = 0;
        int samplingFrequencyIndex = 0;
        int samplingFrequency = 0;
        int extensionSamplingFrequencyIndex = 0;
        int extensionSamplingFrequency = 0;
        int channelConfiguration = 0;
        int sbrPresentFlag = 0;
        int syncExtensionType = 0;
        GASpecificConfig gaConfig = null;

        AudioSpecificConfig() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{AudioSpecificConfig: ");
            stringBuffer.append("audioObjectType: " + this.audioObjectType);
            stringBuffer.append(", extensionAudioObjectType: " + this.extensionAudioObjectType);
            stringBuffer.append(", samplingFrequencyIndex: " + this.samplingFrequencyIndex);
            stringBuffer.append(", samplingFrequency: " + this.samplingFrequency);
            stringBuffer.append(", extensionSamplingFrequencyIndex: " + this.extensionSamplingFrequencyIndex);
            stringBuffer.append(", extensionSamplingFrequency: " + this.extensionSamplingFrequency);
            stringBuffer.append(", channelConfiguration: " + this.channelConfiguration);
            stringBuffer.append(", sbrPresentFlag: " + this.sbrPresentFlag);
            stringBuffer.append(", syncExtensionType: " + this.syncExtensionType);
            stringBuffer.append(", gaConfig: " + (this.gaConfig == null ? "null" : this.gaConfig.toString()));
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    class GASpecificConfig {
        int frameLengthFlag = 0;
        int dependsOnCoreCoder = 0;
        int coreCoderDelay = 0;
        int extensionFlag = 0;
        int layerNr = 0;

        GASpecificConfig() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{GASpecificConfig: ");
            stringBuffer.append("frameLengthFlag: " + this.frameLengthFlag);
            stringBuffer.append(", dependsOnCoreCoder: " + this.dependsOnCoreCoder);
            stringBuffer.append(", coreCoderDelay: " + this.coreCoderDelay);
            stringBuffer.append(", extensionFlag: " + this.extensionFlag);
            stringBuffer.append(", layerNr: " + this.layerNr);
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    class StreamMuxConfig {
        int audioMuxVersion = 0;
        int audioMuxVersionA = 0;
        int taraBufferFullness = 0;
        boolean allStreamsSameTimeFraming = false;
        int numSubFrames = 0;
        int numPrograms = 0;
        int frameLengthType = 0;
        int frameLength = 0;
        int latmBufferFullness = 0;
        AudioSpecificConfig audioSpecificConfig = null;

        StreamMuxConfig() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{StreamMuxConfig: ");
            stringBuffer.append("audioMuxVersion: " + this.audioMuxVersion);
            stringBuffer.append(", audioMuxVersionA: " + this.audioMuxVersionA);
            stringBuffer.append(", taraBufferFullness: " + this.taraBufferFullness);
            stringBuffer.append(", allStreamsSameTimeFraming: " + this.allStreamsSameTimeFraming);
            stringBuffer.append(", numSubFrames: " + this.numSubFrames);
            stringBuffer.append(", numPrograms: " + this.numPrograms);
            stringBuffer.append(", frameLengthType: " + this.frameLengthType);
            stringBuffer.append(", frameLength: " + this.frameLength);
            stringBuffer.append(", latmBufferFullness: " + this.latmBufferFullness);
            stringBuffer.append(", audioSpecificConfig: " + (this.audioSpecificConfig == null ? "null" : this.audioSpecificConfig.toString()));
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        public int getNumberSubFrames() {
            return this.numSubFrames;
        }

        public byte[] getCodecConfig() {
            byte[] byArray = new byte[2];
            int n = this.audioSpecificConfig == null ? 5 : this.audioSpecificConfig.samplingFrequencyIndex;
            int n2 = this.audioSpecificConfig == null ? 2 : this.audioSpecificConfig.channelConfiguration;
            byArray[0] = 16;
            byArray[0] = (byte)(byArray[0] + (n >> 1));
            byArray[1] = 0;
            byArray[1] = (byte)(byArray[1] + (n << 7));
            byArray[1] = (byte)(byArray[1] + (n2 << 3));
            return byArray;
        }
    }
}

