/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizerWrapper;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtsp.RTSPCore;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.TreeMap;

public class RTPDePacketizerWrapperPacketSorter
implements IRTPDePacketizerWrapper {
    private IRTPDePacketizer rtpDePacketizer = null;
    private WMSProperties properties = new WMSProperties();
    private int rtpDePacketizerPacketSorterBufferTime = 500;
    private int rtpDePacketizerPacketSorterFlushTime = 10;
    private int rtpDePacketizerPacketSorterLostTime = -1;
    private int rtpDePacketizerPacketSorterLostMaxPackets = 30;
    private boolean rtpDePacketizerPacketSorterLogPacketLoss = false;
    private String contextStr = "";
    private boolean initContext = true;
    private PacketSender packetSender = null;
    private Object lock = new Object();
    private LinkedList<SortedRTPPacket> packetQueue = new LinkedList();
    private SortedMap<Integer, SortedRTPPacket> packetMap = new TreeMap<Integer, SortedRTPPacket>();
    private LinkedList<LostPacket> lostQueue = new LinkedList();
    private SortedMap<Integer, LostPacket> lostMap = new TreeMap<Integer, LostPacket>();

    public void setDePacketizer(IRTPDePacketizer iRTPDePacketizer) {
        this.rtpDePacketizer = iRTPDePacketizer;
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        return this.rtpDePacketizer.canHandle(rTPTrack);
    }

    public void setProperties(WMSProperties wMSProperties) {
        this.rtpDePacketizer.setProperties(wMSProperties);
        this.properties.putAll(wMSProperties);
    }

    public WMSProperties getProperties() {
        return this.properties;
    }

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        this.rtpDePacketizer.init(rTPContext, rTPDePacketizerItem);
        this.rtpDePacketizerPacketSorterBufferTime = this.properties.getPropertyInt("rtpDePacketizerPacketSorterBufferTime", this.rtpDePacketizerPacketSorterBufferTime);
        this.rtpDePacketizerPacketSorterFlushTime = this.properties.getPropertyInt("rtpDePacketizerPacketSorterFlushTime", this.rtpDePacketizerPacketSorterFlushTime);
        this.rtpDePacketizerPacketSorterLogPacketLoss = this.properties.getPropertyBoolean("rtpDePacketizerPacketSorterLogPacketLoss", this.rtpDePacketizerPacketSorterLogPacketLoss);
        this.rtpDePacketizerPacketSorterLostTime = this.rtpDePacketizerPacketSorterBufferTime * 3;
        this.rtpDePacketizerPacketSorterLostTime = this.properties.getPropertyInt("rtpDePacketizerPacketSorterLostTime", this.rtpDePacketizerPacketSorterLostTime);
        this.rtpDePacketizerPacketSorterLostMaxPackets = this.properties.getPropertyInt("rtpDePacketizerPacketSorterLostMaxPackets", this.rtpDePacketizerPacketSorterLostMaxPackets);
        WMSLoggerFactory.getLogger(null).info("RTPDePacketizerWrapperPacketSorter.init: rtpDePacketizerPacketSorterBufferTime: " + this.rtpDePacketizerPacketSorterBufferTime);
        WMSLoggerFactory.getLogger(null).info("RTPDePacketizerWrapperPacketSorter.init: rtpDePacketizerPacketSorterFlushTime: " + this.rtpDePacketizerPacketSorterFlushTime);
        WMSLoggerFactory.getLogger(null).info("RTPDePacketizerWrapperPacketSorter.init: rtpDePacketizerPacketSorterLogPacketLoss: " + this.rtpDePacketizerPacketSorterLogPacketLoss);
    }

    public void startup(RTPTrack rTPTrack) {
        this.rtpDePacketizer.startup(rTPTrack);
    }

    public void shutdown(RTPTrack rTPTrack) {
        this.rtpDePacketizer.shutdown(rTPTrack);
        if (this.packetSender != null) {
            this.packetSender.quit();
        }
        this.packetSender = null;
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        this.rtpDePacketizer.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        int n3;
        Object object;
        long l = System.currentTimeMillis();
        if (this.initContext) {
            IApplicationInstance iApplicationInstance;
            object = rTPTrack.getStream();
            if (object != null && (iApplicationInstance = ((RTPStream)object).getAppInstance()) != null) {
                this.contextStr = iApplicationInstance.getContextStr() + "/" + ((RTPStream)object).getStreamName();
                this.initContext = false;
            }
            if (this.packetSender == null) {
                this.packetSender = new PacketSender();
                this.packetSender.setDaemon(true);
                this.packetSender.setName("RTPDePacketizerWrapperPacketSorter");
                this.packetSender.start();
            }
        }
        object = new SortedRTPPacket();
        ((SortedRTPPacket)object).sequence = n3 = BufferUtils.byteArrayToInt(byArray, n + 2, 2);
        ((SortedRTPPacket)object).socketAddr = socketAddress;
        ((SortedRTPPacket)object).rtpTrack = rTPTrack;
        ((SortedRTPPacket)object).bytes = byArray;
        ((SortedRTPPacket)object).offset = n;
        ((SortedRTPPacket)object).len = n2;
        ((SortedRTPPacket)object).systime = l;
        Object object2 = this.lock;
        synchronized (object2) {
            Integer n4 = new Integer(n3);
            if (this.lostMap.remove(n4) == null) {
                this.packetQueue.add((SortedRTPPacket)object);
                this.packetMap.put(n4, (SortedRTPPacket)object);
            }
        }
    }

    class LostPacket {
        int sequence = 0;
        long systime = 0L;

        public LostPacket(int n, long l) {
            this.sequence = n;
            this.systime = l;
        }
    }

    class PacketSender
    extends Thread {
        private boolean running = true;
        private boolean quit = false;
        private int nextSequence = -1;

        PacketSender() {
        }

        public synchronized void quit() {
            this.quit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            while (true) {
                try {
                    block9: while (true) {
                        long l = System.currentTimeMillis();
                        long l2 = l - (long)RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterBufferTime;
                        long l3 = l - (long)RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterLostTime;
                        Object object = RTPDePacketizerWrapperPacketSorter.this.lock;
                        synchronized (object) {
                            Object object2;
                            Object var10_9 = null;
                            if (this.nextSequence < 0) {
                                SortedMap sortedMap = RTPDePacketizerWrapperPacketSorter.this.packetMap;
                            } else {
                                SortedMap sortedMap = RTPDePacketizerWrapperPacketSorter.this.packetMap.tailMap(this.nextSequence);
                                if (sortedMap.size() <= 0) {
                                    SortedMap sortedMap2 = RTPDePacketizerWrapperPacketSorter.this.packetMap;
                                }
                            }
                            if (RTPDePacketizerWrapperPacketSorter.this.lostQueue.size() > 0) {
                                while (RTPDePacketizerWrapperPacketSorter.this.lostQueue.size() > 0 && ((LostPacket)((RTPDePacketizerWrapperPacketSorter)RTPDePacketizerWrapperPacketSorter.this).lostQueue.peek()).systime <= l3) {
                                    object2 = (LostPacket)RTPDePacketizerWrapperPacketSorter.this.lostQueue.remove();
                                    RTPDePacketizerWrapperPacketSorter.this.lostMap.remove(new Integer(((LostPacket)object2).sequence));
                                }
                            }
                            while (true) {
                                void var10_14;
                                block25: {
                                    block26: {
                                        block23: {
                                            block24: {
                                                if (RTPDePacketizerWrapperPacketSorter.this.packetQueue.size() <= 0 || ((SortedRTPPacket)((RTPDePacketizerWrapperPacketSorter)RTPDePacketizerWrapperPacketSorter.this).packetQueue.peek()).systime > l2 || var10_14.size() <= 0) break block23;
                                                object2 = (SortedRTPPacket)var10_14.remove(var10_14.firstKey());
                                                RTPDePacketizerWrapperPacketSorter.this.packetQueue.remove(object2);
                                                arrayList2.add(object2);
                                                if (this.nextSequence >= 0) break block24;
                                                this.nextSequence = ((SortedRTPPacket)object2).sequence;
                                                break block25;
                                            }
                                            if (this.nextSequence == ((SortedRTPPacket)object2).sequence) break block25;
                                            if (!RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterLogPacketLoss) break block26;
                                            arrayList.add("RTPDePacketizerWrapperPacketSorter.packetLoss[" + RTPDePacketizerWrapperPacketSorter.this.contextStr + ":" + ((SortedRTPPacket)object2).rtpTrack.getTrackId() + "]: last:" + this.nextSequence + " curr:" + ((SortedRTPPacket)object2).sequence);
                                            break block26;
                                        }
                                        // MONITOREXIT @DISABLED, blocks:[0, 4, 8, 9, 11] lbl39 : MonitorExitStatement: MONITOREXIT : var9_7
                                        if (arrayList2.size() > 0) {
                                            for (SortedRTPPacket sortedRTPPacket : arrayList2) {
                                                RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizer.handleRTPPacket(sortedRTPPacket.socketAddr, sortedRTPPacket.rtpTrack, sortedRTPPacket.bytes, sortedRTPPacket.offset, sortedRTPPacket.len);
                                            }
                                            arrayList2.clear();
                                        }
                                        if (arrayList.size() > 0) {
                                            for (String string : arrayList) {
                                                WMSLoggerFactory.getLogger(RTSPCore.class).warn(string);
                                            }
                                            arrayList.clear();
                                        }
                                        object = this;
                                        synchronized (object) {
                                            if (this.quit) {
                                                this.running = false;
                                                return;
                                            }
                                        }
                                        PacketSender.sleep(RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterFlushTime);
                                        object = this;
                                        synchronized (object) {
                                            if (this.quit) {
                                                this.running = false;
                                                return;
                                            }
                                            continue block9;
                                        }
                                    }
                                    int n = this.nextSequence;
                                    int n2 = 0;
                                    do {
                                        LostPacket lostPacket = new LostPacket(n, l);
                                        RTPDePacketizerWrapperPacketSorter.this.lostMap.put(new Integer(n), lostPacket);
                                        RTPDePacketizerWrapperPacketSorter.this.lostQueue.add(lostPacket);
                                    } while ((n = (((SortedRTPPacket)object2).sequence + 1) % 65536) != ((SortedRTPPacket)object2).sequence && ++n2 <= RTPDePacketizerWrapperPacketSorter.this.rtpDePacketizerPacketSorterLostMaxPackets);
                                }
                                this.nextSequence = (((SortedRTPPacket)object2).sequence + 1) % 65536;
                                if (var10_14.size() > 0) continue;
                                SortedMap sortedMap = RTPDePacketizerWrapperPacketSorter.this.packetMap;
                            }
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).error("RTPDePacketizerWrapperPacketSorter.PacketSender.run[" + RTPDePacketizerWrapperPacketSorter.this.contextStr + "]: " + exception.toString());
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class SortedRTPPacket {
        int sequence = 0;
        SocketAddress socketAddr = null;
        RTPTrack rtpTrack = null;
        byte[] bytes = null;
        int offset = 0;
        int len = 0;
        long systime = 0L;

        SortedRTPPacket() {
        }
    }
}

