/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.io.WowzaRandomAccessFile;
import com.wowza.util.BufferUtils;
import com.wowza.util.FileUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizerWrapper;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.stream.IMediaStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.SocketAddress;

public class RTPDePacketizerWrapperPortRecorder
implements IRTPDePacketizerWrapper {
    private IRTPDePacketizer rtpDePacketizer = null;
    private File outFile = null;
    private RandomAccessFile fileWriter = null;
    private Object lock = new Object();
    private long startTime = -1L;

    public WMSProperties getProperties() {
        return this.rtpDePacketizer.getProperties();
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        return this.rtpDePacketizer.canHandle(rTPTrack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        this.rtpDePacketizer.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
        if (this.fileWriter != null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    long l = System.currentTimeMillis();
                    if (this.startTime == -1L) {
                        this.startTime = l;
                    }
                    long l2 = l - this.startTime;
                    String string = "rtcp";
                    this.fileWriter.write(string.getBytes());
                    this.fileWriter.write(BufferUtils.longToByteArray(n2));
                    this.fileWriter.write(BufferUtils.longToByteArray(l2));
                    this.fileWriter.write(byArray, n, n2);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).error("RTPDePacketizerWrapperPortRecorder.handleRTPPacket[" + this.outFile + "]: " + exception.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        this.rtpDePacketizer.handleRTPPacket(socketAddress, rTPTrack, byArray, n, n2);
        if (this.fileWriter != null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    long l = System.currentTimeMillis();
                    if (this.startTime == -1L) {
                        this.startTime = l;
                    }
                    long l2 = l - this.startTime;
                    String string = "rtp ";
                    this.fileWriter.write(string.getBytes());
                    this.fileWriter.write(BufferUtils.longToByteArray(n2));
                    this.fileWriter.write(BufferUtils.longToByteArray(l2));
                    this.fileWriter.write(byArray, n, n2);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).error("RTPDePacketizerWrapperPortRecorder.handleRTPPacket[" + this.outFile + "]: " + exception.toString());
                }
            }
        }
    }

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        this.rtpDePacketizer.init(rTPContext, rTPDePacketizerItem);
    }

    public void setProperties(WMSProperties wMSProperties) {
        this.rtpDePacketizer.setProperties(wMSProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(RTPTrack rTPTrack) {
        this.rtpDePacketizer.shutdown(rTPTrack);
        if (this.fileWriter != null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.fileWriter.close();
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).error("RTPDePacketizerWrapperPortRecorder.shutdown[" + this.outFile + "]: " + exception.toString());
                }
                this.fileWriter = null;
            }
            WMSLoggerFactory.getLogger(null).info("RTPDePacketizerWrapperPortRecorder.shutdown: " + this.outFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(RTPTrack rTPTrack) {
        block8: {
            IApplicationInstance iApplicationInstance;
            this.rtpDePacketizer.startup(rTPTrack);
            RTPStream rTPStream = rTPTrack.getStream();
            if (rTPStream == null || (iApplicationInstance = rTPStream.getAppInstance()) == null) break block8;
            IMediaStream iMediaStream = rTPStream.getStream();
            String string = rTPStream.getStreamName() + "_" + rTPTrack.getRTPInPortNum();
            this.outFile = iApplicationInstance.getStreamFileMapper().streamToFileForWrite(iMediaStream, string, "ts", null);
            if (this.outFile != null) {
                try {
                    if (this.outFile.exists()) {
                        FileUtils.versionFile(this.outFile);
                    }
                    Object object = this.lock;
                    synchronized (object) {
                        this.fileWriter = new WowzaRandomAccessFile(this.outFile, "rw");
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).error("RTPDePacketizerWrapperPortRecorder.startup[" + this.outFile + "]: " + exception.toString());
                }
                WMSLoggerFactory.getLogger(null).info("RTPDePacketizerWrapperPortRecorder.startup: " + this.outFile);
            }
        }
    }

    public void setDePacketizer(IRTPDePacketizer iRTPDePacketizer) {
        this.rtpDePacketizer = iRTPDePacketizer;
    }
}

