/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.NetworkUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerFactory;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerList;
import com.wowza.wms.rtp.model.IRTPMessageHandler;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPDestination;
import com.wowza.wms.rtp.model.RTPPort;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSSRCGeneratorSingleton;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtsp.RTSPCore;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPTrack {
    public static final String STREAMINFO_SAMPLETYPE = "sample-type";
    public static final String STREAMINFO_TIMESCALE = "timescale";
    public static final String STREAMINFO_CHANNELCOUNT = "channel-count";
    public static final String STREAMINFO_PARAMETERSETS = "sprop-parameter-sets";
    public static final String STREAMINFO_CLIPRECT = "cliprect";
    public static final String STREAMINFO_CONFIG = "config";
    public static final String STREAMINFO_CONFIGURATION = "configuration";
    public static final String STREAMINFO_PROFILELEVELID = "profile-level-id";
    public static final String STREAMINFO_SESSIONCONNECTIONDATA = "connectiondata";
    public static final String STREAMINFO_AUXILIARYDATASIZELENGTH = "auxiliarydatasizelength";
    public static final String STREAMINFO_CONSTANTSIZE = "constantsize";
    public static final String STREAMINFO_CONSTANTDURATION = "constantduration";
    public static final String STREAMINFO_MAXDISPLACEMENT = "maxdisplacement";
    public static final String STREAMINFO_DEINTERLEAVEBUFFERSIZE = "de-interleavebuffersize";
    public static final String STREAMINFO_SIZELENGTH = "sizelength";
    public static final String STREAMINFO_INDEXLENGTH = "indexlength";
    public static final String STREAMINFO_INDEXDELTALENGTH = "indexdeltalength";
    public static final String STREAMINFO_CTSDELTALENGTH = "ctsdeltalength";
    public static final String STREAMINFO_DTSDELTALENGTH = "dtsdeltalength";
    public static final String STREAMINFO_RANDOMACCESSINDICATION = "randomaccessindication";
    public static final String STREAMINFO_STREAMSTATEINDICATION = "streamstateindication";
    public static final int SAMPLES_PERFRAME = 1024;
    public static final int RTPMAPTYPE_MP3 = 14;
    public static final int RTPMAPTYPE_H264 = 96;
    public static final int RTPMAPTYPE_AAC = 97;
    private String trackId = "unknown";
    private RTPStream rtpStream = null;
    private Map<String, String> trackInfo = new HashMap<String, String>();
    private int trackType = 0;
    private int width = 0;
    private int height = 0;
    private HandleRTPMessage rtpMessageHandler = new HandleRTPMessage(this);
    private HandleRTCPMessage rtcpMessageHandler = new HandleRTCPMessage(this);
    private IRTPDePacketizer rtpDePacketizer = null;
    private String rtpDePacketizerName = null;
    private int timescale = 0;
    private int channelCount = 0;
    private String sampleType = "";
    private String announceData = "";
    private boolean isInterleaved = false;
    private boolean isAutoInterleaved = false;
    private byte[] codecConfig = null;
    private byte[] sps = null;
    private List<byte[]> ppss = null;
    private int samplesPerFrame = 1024;
    private boolean waitForFirstEnd = true;
    private String host = null;
    private String outHost = null;
    private long ssrc = 0L;
    private int maxPacketSize = 1438;
    private int rtpMapType = -1;
    private int bitrate = -1;
    private boolean reportRTPTransportError = true;
    private boolean reportRTCPTransportError = true;
    private RTPPort rtpInPort = null;
    private RTPPort rtcpInPort = null;
    private int rtpOutPortNum = -1;
    private int rtcpOutPortNum = -1;
    private int rtpInPortNum = -1;
    private int rtcpInPortNum = -1;
    private int rtpTTL = 63;
    private int rtcpTTL = 63;
    private int rtpAddressCount = 1;
    private int rtcpAddressCount = 1;
    private boolean isRTCP = true;
    private boolean isRTPWrapped = true;
    private boolean isRTPDestinationHandled = false;
    private InetSocketAddress rtpOutAddress = null;
    private InetSocketAddress rtcpOutAddress = null;
    private IRTPPacketizer rtpPacketizer = null;

    public RTPTrack(String string) {
        this.trackId = string;
        this.ssrc = RTPSSRCGeneratorSingleton.getInstance().getNextSSRC();
    }

    public String getTrackId() {
        return this.trackId;
    }

    public void setTrackId(String string) {
        this.trackId = string;
    }

    public RTPStream getStream() {
        return this.rtpStream;
    }

    public void setStream(RTPStream rTPStream) {
        this.rtpStream = rTPStream;
    }

    public String getOutHost() {
        return this.outHost == null ? this.rtpStream.getOutHost() : this.outHost;
    }

    public void setOutHost(String string) {
        this.outHost = string;
    }

    public String getHost() {
        return this.host == null ? this.rtpStream.getHost() : this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStreamTrack() {
        Object object;
        boolean bl = false;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            bl = this.trackType == 0;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAudio() {
        Object object;
        boolean bl = false;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            bl = this.trackType == 8;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVideo() {
        Object object;
        boolean bl = false;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            bl = this.trackType == 9;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackType() {
        Object object;
        int n = 0;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            n = this.trackType;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackType(int n) {
        Object object;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            this.trackType = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTrackInfoKeys() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            arrayList.addAll(this.trackInfo.keySet());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrackInfo(String string, String string2) {
        Object object;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            this.trackInfo.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackInfo(String string) {
        Object object;
        String string2 = null;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            string2 = this.trackInfo.get(string);
        }
        return string2;
    }

    private void extractWidthHeight() {
        block0: {
            H264CodecConfigInfo h264CodecConfigInfo;
            byte[] byArray;
            if (!this.isVideo() || (byArray = this.codecConfig) == null || (h264CodecConfigInfo = H264Utils.decodeAVCC(byArray)) == null) break block0;
            this.width = h264CodecConfigInfo.width;
            this.height = h264CodecConfigInfo.height;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object;
        int n = 0;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            if (this.width <= 0) {
                this.extractWidthHeight();
            }
            n = this.width;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWidth(int n) {
        Object object;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            this.width = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object;
        int n = 0;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            if (this.height <= 0) {
                this.extractWidthHeight();
            }
            n = this.height;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeight(int n) {
        Object object;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            this.height = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCodecConfig() {
        Object object;
        boolean bl = false;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            bl = this.codecConfig != null;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSPS() {
        Object object;
        byte[] byArray = null;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            byArray = this.sps;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getPPS() {
        Object object;
        List<byte[]> list = null;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            list = this.ppss;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCodecConfig() {
        Object object;
        byte[] byArray = null;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            byArray = this.codecConfig;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodecConfig(byte[] byArray) {
        Object object;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            H264CodecConfigParts h264CodecConfigParts;
            this.codecConfig = byArray;
            this.ppss = null;
            this.sps = null;
            if (this.codecConfig != null && (h264CodecConfigParts = H264Utils.breakApartAVCC(this.codecConfig, 0, this.codecConfig.length)) != null) {
                this.ppss = h264CodecConfigParts.ppss;
                this.sps = h264CodecConfigParts.sps;
            }
        }
    }

    public void extractCodecConfigFromTrackInfo() {
        block29: {
            String string;
            String string2;
            block30: {
                String[] stringArray;
                Object object;
                String string3;
                byte[] byArray = null;
                byte[] byArray2 = null;
                ArrayList<byte[]> arrayList = null;
                if (this.isVideo()) {
                    if (byArray == null && (string3 = this.getTrackInfo(STREAMINFO_PARAMETERSETS)) != null) {
                        object = string3.split("[,]");
                        int n = 0;
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            byte[] byArray3;
                            stringArray = object[i].trim();
                            if (stringArray.length() <= 0 || (byArray3 = Base64.decode(object[i].trim())) == null) continue;
                            int n2 = byArray3[0] & 0x1F;
                            if (n2 == 7) {
                                byArray2 = byArray3;
                                continue;
                            }
                            if (n2 != 8) continue;
                            if (arrayList == null) {
                                arrayList = new ArrayList<byte[]>();
                            }
                            arrayList.add(byArray3);
                            ++n;
                        }
                        if (byArray2 != null && n > 0) {
                            try {
                                byte[] byArray4 = null;
                                stringArray = this.getTrackInfo(STREAMINFO_PROFILELEVELID);
                                if (stringArray != null) {
                                    byArray4 = BufferUtils.decodeHexString((String)stringArray);
                                }
                                byArray = RTPUtils.formatH264CodecConfig(byArray2, (List<byte[]>)arrayList, byArray4);
                            }
                            catch (Exception exception) {
                                WMSLoggerFactory.getLogger(RTPTrack.class).warn("RTPTrack.getCodecConfig(video): " + exception.toString());
                            }
                        } else {
                            if (byArray2 == null) {
                                WMSLoggerFactory.getLogger(RTPTrack.class).warn("RTPTrack.getCodecConfig(video): Missing NAL SPS(7)");
                            }
                            if (arrayList == null) {
                                WMSLoggerFactory.getLogger(RTPTrack.class).warn("RTPTrack.getCodecConfig(video): Missing NAL PPS(8)");
                            } else if (arrayList.size() == 0) {
                                WMSLoggerFactory.getLogger(RTPTrack.class).warn("RTPTrack.getCodecConfig(video): Missing NAL PPS(8)");
                            }
                        }
                    }
                } else if (this.isAudio()) {
                    string3 = this.getTrackInfo(STREAMINFO_SAMPLETYPE);
                    if (string3 != null && string3.equalsIgnoreCase("vorbis") && (object = this.getTrackInfo(STREAMINFO_CONFIGURATION)) != null) {
                        byArray = Base64.decode((String)object);
                    }
                    if ((string3 = this.getTrackInfo(STREAMINFO_CONFIG)) != null) {
                        byArray = BufferUtils.decodeHexString(string3);
                    }
                }
                if (byArray != null) {
                    this.codecConfig = byArray;
                }
                if (this.isVideo()) {
                    this.sps = byArray2;
                    this.ppss = arrayList;
                }
                if ((string3 = this.getTrackInfo(STREAMINFO_SESSIONCONNECTIONDATA)) == null) {
                    string3 = this.getStream().getStreamInfo(STREAMINFO_SESSIONCONNECTIONDATA);
                }
                if (string3 == null || ((String[])(object = string3.split("[ ]"))).length < 3) break block29;
                string2 = object[2];
                string = null;
                if (string2.indexOf("/") < 0) break block30;
                stringArray = string2.split("/");
                if (stringArray.length > 0) {
                    this.host = string = stringArray[0];
                }
                if (stringArray.length > 1) {
                    int n = -1;
                    try {
                        n = Integer.parseInt(stringArray[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n >= 0) {
                        this.rtpTTL = n;
                        this.rtcpTTL = n;
                    }
                }
                if (stringArray.length <= 2) break block29;
                int n = -1;
                try {
                    n = Integer.parseInt(stringArray[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n >= 0) {
                    this.rtpAddressCount = n;
                    this.rtcpAddressCount = n;
                }
                break block29;
            }
            this.host = string = string2;
        }
    }

    public synchronized int getRTPOutPortNum() {
        return this.rtpOutPortNum;
    }

    public synchronized void setRTPOutPortNum(int n) {
        this.rtpOutPortNum = n;
    }

    public synchronized int getRTCPOutPortNum() {
        return this.rtcpOutPortNum;
    }

    public synchronized void setRTCPOutPortNum(int n) {
        this.rtcpOutPortNum = n;
    }

    public IVHost getVHost() {
        return this.rtpStream.getVHost();
    }

    public RTPContext getRTPContext() {
        return this.rtpStream.getVHost().getRTPContext();
    }

    public void bind() {
        IRTPPacketizer iRTPPacketizer = this.getRTPPacketizer();
        if (iRTPPacketizer != null) {
            iRTPPacketizer.setRTPWrapped(this.isRTPWrapped);
        }
        if (!this.isRTPDestinationHandled && !this.isInterleaved) {
            int n;
            String string = this.getBindHost();
            String string2 = this.getOutHost();
            if (string2 == null) {
                string2 = this.getRTPStream().getOutHost();
            }
            boolean bl = false;
            bl = this.getRTPStream().isModePublish() ? NetworkUtils.isAddressMulticast(string) : NetworkUtils.isAddressMulticast(string2);
            if (!bl && this.rtpInPortNum < 0) {
                n = -1;
                RTPContext rTPContext = this.getRTPContext();
                this.rtpInPortNum = n = rTPContext.acquireUDPPortPair();
                this.rtcpInPortNum = n + 1;
            }
            int n2 = n = this.getRTPStream().isModePublish() ? 1 : 2;
            if (this.rtpInPort == null) {
                this.rtpInPort = new RTPPort(string, this.rtpInPortNum, string2, this.rtpOutPortNum, bl);
                this.rtpInPort.setTrack(this);
            }
            if (this.rtpInPort != null) {
                this.rtpInPort.setHandler(this.rtpMessageHandler);
                this.rtpInPort.setTTL(this.rtpTTL);
                this.rtpInPort.setAddressCount(this.rtpAddressCount);
                this.rtpInPort.bind(n);
            }
            if (this.isRTCP()) {
                if (this.rtcpInPort == null) {
                    this.rtcpInPort = new RTPPort(string, this.rtcpInPortNum, string2, this.rtcpOutPortNum, bl);
                    this.rtcpInPort.setTrack(this);
                }
                if (this.rtcpInPort != null) {
                    this.rtcpInPort.setHandler(this.rtcpMessageHandler);
                    this.rtcpInPort.setTTL(this.rtcpTTL);
                    this.rtcpInPort.setAddressCount(this.rtcpAddressCount);
                    this.rtcpInPort.bind(n);
                }
            }
        }
        this.reportRTPTransportError = true;
        this.reportRTCPTransportError = true;
    }

    public void unbind() {
        if (this.rtpInPort != null) {
            this.rtpInPort.shutdown();
        }
        this.rtpInPort = null;
        if (this.rtcpInPort != null) {
            this.rtcpInPort.shutdown();
        }
        this.rtcpInPort = null;
        if (this.rtpInPortNum > 0) {
            RTPContext rTPContext = this.getRTPContext();
            if (this.rtpInPortNum % 2 == 0 && this.rtpInPortNum + 1 == this.rtcpInPortNum) {
                rTPContext.releaseUDPPortPair(this.rtpInPortNum);
            } else {
                rTPContext.releaseUDPPortPair(this.rtpInPortNum);
                rTPContext.releaseUDPPortPair(this.rtcpInPortNum);
            }
        }
        this.rtpInPortNum = -1;
        this.rtcpInPortNum = -1;
    }

    public void shutdown(RTPRequestStatus rTPRequestStatus) {
        this.unbind();
        if (this.rtpDePacketizer != null) {
            this.rtpDePacketizer.shutdown(this);
        }
        this.rtpDePacketizer = null;
    }

    private String getBindHost() {
        String string = null;
        boolean bl = false;
        String string2 = this.getHost();
        if (string2 != null && string2.length() > 0) {
            bl = NetworkUtils.isAddressMulticast(string2);
        }
        string = !bl && this.rtpStream.isRTSP() ? this.rtpStream.getRTSPBindIpAddress() : this.getHost();
        return string;
    }

    public void addPorts() {
        if (this.rtpInPortNum <= 0 && this.rtcpInPortNum <= 0) {
            int n = -1;
            RTPContext rTPContext = this.getRTPContext();
            this.rtpInPortNum = n = rTPContext.acquireUDPPortPair();
            this.rtcpInPortNum = n + 1;
        }
    }

    public void setRTPInPortNum(int n) {
        this.rtpInPortNum = n;
    }

    public void setRTCPInPortNum(int n) {
        this.rtcpInPortNum = n;
    }

    public int getRTPInPortNum() {
        return this.rtpInPortNum;
    }

    public int getRTCPInPortNum() {
        return this.rtcpInPortNum;
    }

    public RTPPort getRTPPort() {
        return this.rtpInPort;
    }

    public RTPPort getRTCPPort() {
        return this.rtcpInPort;
    }

    public void attachToWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        if (this.isInterleaved) {
            rtmpSessionInfo.addRTPInterleaveHandler(this.rtpOutPortNum, this.rtpMessageHandler);
            rtmpSessionInfo.addRTPInterleaveHandler(this.rtcpOutPortNum, this.rtcpMessageHandler);
        }
    }

    public void detachFromWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        rtmpSessionInfo.clearRTPInterleaveHandler();
    }

    public void record(RTPRequestStatus rTPRequestStatus, boolean bl) {
        if (!bl) {
            this.bind();
        }
    }

    public void play(RTPRequestStatus rTPRequestStatus, boolean bl) {
        if (!bl) {
            this.bind();
        }
    }

    public void pause(RTPRequestStatus rTPRequestStatus) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimescale() {
        Object object;
        int n = 0;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            n = this.timescale;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimescale(int n) {
        Object object;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            this.timescale = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelCount() {
        Object object;
        int n = 0;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            n = this.channelCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelCount(int n) {
        Object object;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            this.channelCount = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSampleType() {
        Object object;
        String string = null;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            string = this.sampleType;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSampleType(String string) {
        Object object;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            this.sampleType = string;
        }
    }

    public RTPStream getRTPStream() {
        return this.rtpStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPorts() {
        Object object;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            this.rtpInPort = null;
            this.rtcpInPort = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(RTPRequestStatus rTPRequestStatus, String string) {
        try {
            Object object;
            Object object2;
            String[] stringArray;
            Object object3 = null;
            boolean bl = false;
            if (string != null) {
                stringArray = this.getRTPStream().transportFindBestMatch(string).split("[;]");
                for (int i = 0; i < stringArray.length; ++i) {
                    int n;
                    object2 = stringArray[i].trim();
                    if (((String)object2).length() <= 0) continue;
                    if (i == 0) {
                        object3 = object2;
                    }
                    if (((String)object2).startsWith("multicast")) {
                        bl = true;
                        continue;
                    }
                    if (((String)object2).startsWith("unicast")) {
                        bl = false;
                        continue;
                    }
                    if (((String)object2).startsWith("client_port=")) {
                        int n2;
                        n = ((String)object2).indexOf(",");
                        if (n >= 0) {
                            object2 = ((String)object2).substring(0, n);
                        }
                        if ((n2 = ((String)object2).indexOf("=")) < 0) {
                            n2 = ((String)object2).indexOf(":");
                        }
                        if (n2 < 0) continue;
                        object = ((String)object2).substring(n2 + 1);
                        String[] stringArray2 = object.split("[-]");
                        if (stringArray2.length >= 2) {
                            try {
                                this.rtpOutPortNum = Integer.parseInt(stringArray2[0]);
                                this.rtcpOutPortNum = Integer.parseInt(stringArray2[1]);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (stringArray2.length < 1) continue;
                        try {
                            this.rtpOutPortNum = Integer.parseInt(stringArray2[0]);
                            this.setRTCP(false);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (((String)object2).startsWith("ttl=")) {
                        n = ((String)object2).indexOf("=");
                        if (n < 0) continue;
                        String string2 = ((String)object2).substring(n + 1);
                        int n3 = -1;
                        try {
                            n3 = Integer.parseInt(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n3 <= 0) continue;
                        this.rtpTTL = n3;
                        this.rtcpTTL = n3;
                        continue;
                    }
                    if (!((String)object2).startsWith("interleaved=")) continue;
                    this.isInterleaved = true;
                    n = ((String)object2).indexOf("=");
                    if (n < 0) {
                        n = ((String)object2).indexOf(":");
                    }
                    if (n < 0) continue;
                    String string3 = ((String)object2).substring(n + 1);
                    object = string3.split("[-]");
                    if (((String[])object).length >= 2) {
                        try {
                            this.rtpOutPortNum = Integer.parseInt(object[0]);
                            this.rtcpOutPortNum = Integer.parseInt(object[1]);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (((String[])object).length < 1) continue;
                    try {
                        this.rtpOutPortNum = Integer.parseInt(object[0]);
                        this.setRTCP(false);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            stringArray = this.getRTPStream().getRTPContext();
            try {
                Object object4;
                object2 = object4 = this.rtpStream.getStreamLock();
                synchronized (object2) {
                    if (this.getRTPStream().isModePublish()) {
                        RTPDePacketizerList rTPDePacketizerList = stringArray.getDePacketizerList();
                        RTPDePacketizerItem rTPDePacketizerItem = rTPDePacketizerList.getDePacketizerItem(this.rtpDePacketizerName);
                        object = this.getRTPStream().getAppInstance();
                        if (rTPDePacketizerItem != null) {
                            this.rtpDePacketizer = RTPDePacketizerFactory.createInstance((RTPContext)stringArray, rTPDePacketizerItem, (IApplicationInstance)object);
                        } else {
                            WMSLoggerFactory.getLogger(RTPTrack.class).warn("Failed to find an appropriate depacketizer for this track (" + this.getSampleType() + ")");
                        }
                        if (this.rtpDePacketizer != null) {
                            this.rtpDePacketizer.startup(this);
                        }
                    } else if (object3 != null) {
                        RTPStream rTPStream = this.getRTPStream();
                        RTPDestination rTPDestination = rTPStream.getRTPDestination();
                        if (rTPDestination != null) {
                            if (bl == rTPDestination.isMulticast()) {
                                this.isRTPDestinationHandled = true;
                                if (rTPDestination.isMulticast()) {
                                    this.getRTPPort().setTTL(rTPDestination.getTTL());
                                    this.getRTCPPort().setTTL(rTPDestination.getTTL());
                                }
                            } else {
                                rTPStream.setRTPDestination(null);
                            }
                        }
                        if (!this.isRTPDestinationHandled) {
                            if (rTPStream.isMPEGTSOut()) {
                                if (((String)object3).startsWith("MP2T/H2221")) {
                                    this.isRTPWrapped = false;
                                } else if (((String)object3).startsWith("MP2T/AVP")) {
                                    this.isRTPWrapped = true;
                                }
                            }
                            if (((String)object3).endsWith("/TCP") && !this.isInterleaved) {
                                int n = this.getRTPStream().getAutoAllocateInterleavePorts();
                                this.isInterleaved = true;
                                this.isAutoInterleaved = true;
                                this.rtpOutPortNum = n;
                                this.rtcpOutPortNum = n + 1;
                            }
                        }
                    }
                    if (!this.isRTPDestinationHandled && !this.isInterleaved) {
                        boolean bl2 = false;
                        String string4 = this.getHost();
                        if (string4 != null && string4.length() > 0) {
                            bl2 = NetworkUtils.isAddressMulticast(string4);
                        }
                        if (!bl2 && this.rtpStream.isRTSP() && !this.rtpStream.isRTSPAlwaysUseSDPPorts()) {
                            this.rtpInPortNum = 0;
                            this.rtcpInPortNum = 0;
                        }
                        this.addPorts();
                    }
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTPTrack.setup: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public String getAnnounceData() {
        return this.announceData;
    }

    public void setAnnounceData(String string) {
        this.announceData = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRTPDePacketizer getRTPDePacketizer() {
        Object object;
        IRTPDePacketizer iRTPDePacketizer = null;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            iRTPDePacketizer = this.rtpDePacketizer;
        }
        return iRTPDePacketizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRTPDePacketizerName() {
        Object object;
        String string = null;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            string = this.rtpDePacketizerName;
        }
        return string;
    }

    public void setRTPDePacketizerName(String string) {
        this.rtpDePacketizerName = string;
    }

    public void announce(RTPRequestStatus rTPRequestStatus) {
        try {
            if (this.rtpDePacketizerName == null) {
                this.rtpDePacketizerName = this.getRTPStream().getRTPContext().getDePacketizerName(this);
            }
            if (this.rtpDePacketizerName == null) {
                RTSPStatics.setStatus(rTPRequestStatus, 461, "Missing DePacketizer");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTPTrack.announce: " + exception.toString());
        }
    }

    public String getTransportStr(String string) {
        RTPStream rTPStream = this.getRTPStream();
        String string2 = rTPStream.transportFindBestMatch(string);
        if (this.isRTPDestinationHandled) {
            RTPDestination rTPDestination = rTPStream.getRTPDestination();
            if (rTPDestination != null) {
                String string3;
                String string4 = rTPDestination.isStream() ? rTPDestination.getHost() : (string3 = this.isVideo() ? rTPDestination.getVideoHost() : rTPDestination.getAudioHost());
                int n = rTPDestination.isStream() ? rTPDestination.getStreamPort() : (this.isVideo() ? rTPDestination.getVideoPort() : rTPDestination.getAudioPort());
                string2 = string2 + ";destination=" + string3 + ";port=" + n + "-" + (n + 1) + ";ttl=" + rTPDestination.getTTL();
            }
        } else if (this.isAutoInterleaved) {
            string2 = string2 + ";interleaved=" + this.rtpOutPortNum + (this.isRTCP() ? "-" + this.rtcpOutPortNum : "");
        } else if (!this.isInterleaved) {
            String string5 = this.getStream().getRTSPConnectionIpAddress();
            if (string5 == null) {
                string5 = this.getHost();
            } else if (string5.equals("0.0.0.0")) {
                string5 = this.getHost();
            }
            string2 = string2 + ";source=" + string5 + ";server_port=" + this.getRTPInPortNum() + (this.isRTCP() ? "-" + this.getRTCPInPortNum() : "");
        }
        WMSLoggerFactory.getLogger(RTSPCore.class).debug("RTPTrack.getTransportStr: " + string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterleaved(boolean bl) {
        Object object;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            this.isInterleaved = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterleaved() {
        Object object;
        boolean bl = false;
        Object object2 = object = this.rtpStream.getStreamLock();
        synchronized (object2) {
            bl = this.isInterleaved;
        }
        return bl;
    }

    public int getSamplesPerFrame() {
        return this.samplesPerFrame;
    }

    public void setSamplesPerFrame(int n) {
        this.samplesPerFrame = n;
    }

    public boolean isWaitForFirstEnd() {
        return this.waitForFirstEnd;
    }

    public void setWaitForFirstEnd(boolean bl) {
        this.waitForFirstEnd = bl;
    }

    public void checkSendMetadata(long l) {
        this.rtpStream.checkSendMetadata(l);
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public void setSSRC(long l) {
        this.ssrc = l;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int n) {
        this.maxPacketSize = n;
    }

    public IRTPPacketizer getRTPPacketizer() {
        return this.rtpPacketizer;
    }

    public void setRTPPacketizer(IRTPPacketizer iRTPPacketizer) {
        this.rtpPacketizer = iRTPPacketizer;
    }

    public int getRTPMapType() {
        return this.rtpMapType;
    }

    public void setRTPMapType(int n) {
        this.rtpMapType = n;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(int n) {
        this.bitrate = n;
    }

    public InetSocketAddress getRTPOutAddress() {
        if (this.rtpOutAddress == null) {
            String string = this.getRTPStream().getOutHost();
            int n = this.getRTPOutPortNum();
            if (n > 0) {
                this.rtpOutAddress = new InetSocketAddress(string, n);
            }
        }
        return this.rtpOutAddress;
    }

    public InetSocketAddress getRTCPOutAddress() {
        if (this.rtcpOutAddress == null) {
            String string = this.getRTPStream().getOutHost();
            int n = this.getRTCPOutPortNum();
            if (n > 0) {
                this.rtcpOutAddress = new InetSocketAddress(string, n);
            }
        }
        return this.rtcpOutAddress;
    }

    public void sendRTPMessage(OutputStream outputStream, byte[] byArray, int n, int n2) {
        Object object;
        if (this.isInterleaved) {
            try {
                object = new byte[4];
                object[0] = 36;
                object[1] = (byte)(this.rtpOutPortNum & 0x7F);
                BufferUtils.intToByteArray(n2, (byte[])object, 2, 2);
                outputStream.write((byte[])object, 0, ((Object)object).length);
                outputStream.write(byArray, n, n2);
            }
            catch (Exception exception) {
                if (this.reportRTPTransportError) {
                    WMSLoggerFactory.getLogger(RTSPCore.class).error("RTPTrack.sendRTPMessage: " + exception.toString());
                }
                this.reportRTPTransportError = false;
            }
        } else {
            object = this.getRTPOutAddress();
            if (object != null) {
                this.getRTPPort().sendResponse(byArray, n, n2, (SocketAddress)object);
            }
        }
        this.rtpStream.getSession().getIOPerformanceCounter().incrementMessagesIn(n2, 1L);
        object = this.rtpStream.getStream();
        if (object != null) {
            object.getMediaIOPerformance().incrementMessagesOut(n2, 1L);
        }
    }

    public int sendRCTPMessage(OutputStream outputStream, byte[] byArray, int n, int n2) {
        Object object;
        int n3 = 0;
        if (this.isInterleaved) {
            try {
                object = new byte[4];
                object[0] = 36;
                object[1] = (byte)(this.rtcpOutPortNum & 0x7F);
                BufferUtils.intToByteArray(n2, (byte[])object, 2, 2);
                outputStream.write((byte[])object, 0, ((Object)object).length);
                outputStream.write(byArray, n, n2);
                n3 += ((Object)object).length + n2;
            }
            catch (Exception exception) {
                if (this.reportRTCPTransportError) {
                    WMSLoggerFactory.getLogger(RTSPCore.class).error("RTPTrack.sendRCTPMessage: " + exception.toString());
                }
                this.reportRTCPTransportError = false;
            }
        } else {
            object = this.getRTCPOutAddress();
            if (object != null) {
                this.getRTCPPort().sendResponse(byArray, n, n2, (SocketAddress)object);
            }
        }
        this.rtpStream.getSession().getIOPerformanceCounter().incrementMessagesIn(n2, 1L);
        object = this.rtpStream.getStream();
        if (object != null) {
            object.getMediaIOPerformance().incrementMessagesOut(n2, 1L);
        }
        return n3;
    }

    public IRTPMessageHandler getRTPMessageHandler() {
        return this.rtpMessageHandler;
    }

    public IRTPMessageHandler getRTCPMessageHandler() {
        return this.rtcpMessageHandler;
    }

    public boolean isRTCP() {
        return this.isRTCP;
    }

    public void setRTCP(boolean bl) {
        this.isRTCP = bl;
    }

    public boolean isRTPWrapped() {
        return this.isRTPWrapped;
    }

    public void setRTPWrapped(boolean bl) {
        this.isRTPWrapped = bl;
    }

    public void setPublishVideoCodecId(int n) {
        block0: {
            IMediaStream iMediaStream;
            RTPStream rTPStream = this.getRTPStream();
            if (rTPStream == null || (iMediaStream = rTPStream.getStream()) == null) break block0;
            iMediaStream.setPublishVideoCodecId(n);
        }
    }

    public void setPublishAudioCodecId(int n) {
        block0: {
            IMediaStream iMediaStream;
            RTPStream rTPStream = this.getRTPStream();
            if (rTPStream == null || (iMediaStream = rTPStream.getStream()) == null) break block0;
            iMediaStream.setPublishAudioCodecId(n);
        }
    }

    public int getRTPTTL() {
        return this.rtpTTL;
    }

    public void setRTPTTL(int n) {
        this.rtpTTL = n;
    }

    public int getRTCPTTL() {
        return this.rtcpTTL;
    }

    public void setRTCPTTL(int n) {
        this.rtcpTTL = n;
    }

    class HandleRTCPMessage
    implements IRTPMessageHandler {
        RTPTrack rtpTrack = null;

        public HandleRTCPMessage(RTPTrack rTPTrack2) {
            this.rtpTrack = rTPTrack2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(SocketAddress socketAddress, byte[] byArray, int n, int n2) {
            Object object;
            RTPStream rTPStream = this.rtpTrack.getRTPStream();
            Object object2 = object = rTPStream.getStreamLock();
            synchronized (object2) {
                rTPStream.touch();
                if (RTPTrack.this.rtpDePacketizer != null) {
                    RTPTrack.this.rtpDePacketizer.handleRTCPPacket(socketAddress, this.rtpTrack, byArray, n, n2);
                }
            }
            rTPStream.getSession().getIOPerformanceCounter().incrementMessagesIn(n2, 1L);
            object2 = rTPStream.getStream();
            if (object2 != null) {
                object2.getMediaIOPerformance().incrementMessagesIn(n2, 1L);
                if (((MediaStream)object2).isSendDirectMessages()) {
                    Object object3 = object;
                    synchronized (object3) {
                        ((MediaStream)object2).processSendDirectMessages();
                    }
                }
            }
        }
    }

    class HandleRTPMessage
    implements IRTPMessageHandler {
        private RTPTrack rtpTrack = null;

        public HandleRTPMessage(RTPTrack rTPTrack2) {
            this.rtpTrack = rTPTrack2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(SocketAddress socketAddress, byte[] byArray, int n, int n2) {
            Object object;
            RTPStream rTPStream = this.rtpTrack.getRTPStream();
            Object object2 = object = rTPStream.getStreamLock();
            synchronized (object2) {
                rTPStream.touch();
                if (RTPTrack.this.rtpDePacketizer != null) {
                    RTPTrack.this.rtpDePacketizer.handleRTPPacket(socketAddress, this.rtpTrack, byArray, n, n2);
                }
            }
            rTPStream.getSession().getIOPerformanceCounter().incrementMessagesIn(n2, 1L);
            object2 = rTPStream.getStream();
            if (object2 != null) {
                object2.getMediaIOPerformance().incrementMessagesIn(n2, 1L);
                if (((MediaStream)object2).isSendDirectMessages()) {
                    Object object3 = object;
                    synchronized (object3) {
                        ((MediaStream)object2).processSendDirectMessages();
                    }
                }
            }
        }
    }
}

