/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class RTPMulticastGroup
implements Runnable {
    private String ipAddress = null;
    private int port = 0;
    private long packetCount = 0L;
    private IUDPMessageHandler handler = null;
    private boolean running = false;
    private List<MulticastMessage> messages = new ArrayList<MulticastMessage>();

    public RTPMulticastGroup(String string, int n, IUDPMessageHandler iUDPMessageHandler) {
        this.ipAddress = string;
        this.port = n;
        this.handler = iUDPMessageHandler;
    }

    public long incPacketCount() {
        return ++this.packetCount;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public IUDPMessageHandler getHandler() {
        return this.handler;
    }

    public synchronized void handleMessage(Executor executor, SocketAddress socketAddress, Object object) {
        this.messages.add(new MulticastMessage(socketAddress, object));
        if (!this.running) {
            executor.equals(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            MulticastMessage multicastMessage = null;
            RTPMulticastGroup rTPMulticastGroup = this;
            synchronized (rTPMulticastGroup) {
                if (this.messages.size() <= 0) {
                    this.running = false;
                    break;
                }
                multicastMessage = this.messages.remove(0);
            }
            if (multicastMessage == null) continue;
            this.handler.handleMessage(multicastMessage.socketAddr, multicastMessage.message);
        }
    }

    class MulticastMessage {
        public SocketAddress socketAddr = null;
        public Object message = null;

        public MulticastMessage(SocketAddress socketAddress, Object object) {
            this.socketAddr = socketAddress;
            this.message = object;
        }
    }
}

