/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.RTPMulticastTransportSession;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import com.wowza.wms.rtp.transport.UDPRunner;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.common.ByteBuffer;

public class RTPMulticastListener
extends Thread {
    private boolean running = true;
    private boolean quit = false;
    private MulticastSocket multicastSocket = null;
    private RTPUDPDatagramConfig datagramConfig = null;
    private IUDPMessageHandler handler = null;
    private String ipAddress = null;
    private int port = 0;
    private AtomicLong packetCount = new AtomicLong();
    private int timeToLive = 63;
    private List<SendMessage> messages = new ArrayList<SendMessage>();
    private UDPRunner runner = new UDPRunner();
    private int direction = 1;
    private InetAddress addressObj = null;
    private InetAddress interfaceAddress = null;

    public synchronized boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unbind() {
        try {
            if (this.multicastSocket != null) {
                this.multicastSocket.leaveGroup(InetAddress.getByName(this.ipAddress));
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPMulticastListener.unbind: " + exception.toString());
        }
        finally {
            this.quit = true;
        }
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int n) {
        this.timeToLive = n;
    }

    public synchronized void bind(RTPUDPDatagramConfig rTPUDPDatagramConfig, Executor executor, IUDPMessageHandler iUDPMessageHandler, String string, int n, int n2) {
        try {
            this.datagramConfig = rTPUDPDatagramConfig;
            this.handler = iUDPMessageHandler;
            this.ipAddress = string;
            this.port = n;
            this.direction = n2;
            this.runner.setExecutor(executor);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPMulticastListener.bind: " + exception.toString());
        }
    }

    private void init() {
        try {
            String string;
            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("MulticastTransport.bind: " + this.ipAddress + "/" + this.port);
            this.addressObj = InetAddress.getByName(this.ipAddress);
            this.multicastSocket = null;
            if (this.direction == 2) {
                if (this.multicastSocket == null) {
                    try {
                        this.multicastSocket = new MulticastSocket();
                    }
                    catch (Exception exception) {}
                }
            } else {
                if (this.datagramConfig.isMulticastBindToAddress() && this.multicastSocket == null) {
                    try {
                        this.multicastSocket = new MulticastSocket(new InetSocketAddress(this.addressObj, this.port));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.multicastSocket == null) {
                    try {
                        this.multicastSocket = new MulticastSocket(this.port);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.multicastSocket.setTrafficClass(this.datagramConfig.getTrafficClass());
            this.multicastSocket.setReceiveBufferSize(this.datagramConfig.getReceiveBufferSize());
            this.multicastSocket.setReuseAddress(this.datagramConfig.isReuseAddress());
            this.multicastSocket.setSoTimeout(this.datagramConfig.getMulticastTimeout());
            this.multicastSocket.setTimeToLive(this.timeToLive);
            if (this.interfaceAddress != null) {
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("MulticastTransport.bind: multicastInterfaceAddress: " + this.interfaceAddress.toString());
                this.multicastSocket.setInterface(this.interfaceAddress);
            }
            if ((string = this.datagramConfig.getMulticastInterfaceAddress()) != null) {
                NetworkInterface networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(string));
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.addressObj, this.port);
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).debug("MulticastTransport.bind.joinGroup: multicastInterfaceAddress: " + inetSocketAddress.toString() + ":" + networkInterface.toString());
                this.multicastSocket.joinGroup(inetSocketAddress, networkInterface);
            } else {
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).debug("MulticastTransport.bind.joinGroup: multicastInterfaceAddress: " + this.addressObj.toString());
                this.multicastSocket.joinGroup(this.addressObj);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPMulticastListener.init: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2, SocketAddress socketAddress) {
        SendMessage sendMessage = new SendMessage();
        sendMessage.buffer = byArray;
        sendMessage.offset = n;
        sendMessage.len = n2;
        sendMessage.destination = socketAddress;
        List<SendMessage> list = this.messages;
        synchronized (list) {
            this.messages.add(sendMessage);
            this.messages.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessages() {
        ArrayList<SendMessage> arrayList = null;
        List<SendMessage> list = this.messages;
        synchronized (list) {
            if (this.messages.size() > 0) {
                arrayList = new ArrayList<SendMessage>();
                arrayList.addAll(this.messages);
                this.messages.clear();
            }
        }
        if (arrayList == null) {
            return;
        }
        for (SendMessage sendMessage : arrayList) {
            try {
                DatagramPacket datagramPacket = new DatagramPacket(sendMessage.buffer, sendMessage.offset, sendMessage.len, this.addressObj, this.port);
                this.multicastSocket.send(datagramPacket);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.init();
        RTPMulticastTransportSession rTPMulticastTransportSession = new RTPMulticastTransportSession();
        rTPMulticastTransportSession.init(this);
        this.handler.sessionOpened(rTPMulticastTransportSession);
        if (this.multicastSocket == null) {
            RTPMulticastListener rTPMulticastListener = this;
            synchronized (rTPMulticastListener) {
                this.running = false;
            }
        } else {
            if (this.direction == 2) {
                while (true) {
                    try {
                        List<SendMessage> list = this.messages;
                        synchronized (list) {
                            if (this.messages.size() <= 0) {
                                this.messages.wait(1000L);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sendMessages();
                }
            }
            int n = this.datagramConfig.getDatagramMaximumPacketSize();
            block18: while (true) {
                Object object;
                try {
                    while (true) {
                        Object object2;
                        byte[] byArray = new byte[n];
                        object = new DatagramPacket(byArray, n);
                        this.multicastSocket.receive((DatagramPacket)object);
                        int n2 = ((DatagramPacket)object).getLength();
                        if (n2 > 0) {
                            object2 = ByteBuffer.wrap((byte[])byArray, (int)0, (int)n2);
                            this.runner.handleMessage(((DatagramPacket)object).getSocketAddress(), this.handler, object2);
                            long l = this.packetCount.incrementAndGet();
                            if (l == 1L) {
                                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("MulticastTransport.firstPacket: " + this.ipAddress + "/" + this.port);
                            }
                        }
                        this.sendMessages();
                        object2 = this;
                        synchronized (object2) {
                            if (this.quit) {
                                this.running = false;
                                break block18;
                            }
                        }
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.sendMessages();
                    object = this;
                    synchronized (object) {
                        if (this.quit) {
                            this.running = false;
                            break;
                        }
                        continue;
                    }
                }
                catch (Exception exception) {
                    object = this;
                    synchronized (object) {
                        if (this.quit) {
                            this.running = false;
                            break;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        try {
            if (rTPMulticastTransportSession != null) {
                this.handler.sessionClosed(rTPMulticastTransportSession);
            }
            rTPMulticastTransportSession = null;
            if (this.multicastSocket != null) {
                this.multicastSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        WMSLoggerFactory.getLogger(RTPMulticastListener.class).info("RTPMulticastListener.run(stop)");
    }

    public InetAddress getInterfaceAddress() {
        return this.interfaceAddress;
    }

    public void setInterfaceAddress(InetAddress inetAddress) {
        this.interfaceAddress = inetAddress;
    }

    class SendMessage {
        public byte[] buffer = null;
        public int offset = 0;
        public int len = 0;
        public SocketAddress destination = null;

        SendMessage() {
        }
    }
}

