/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.transport.IUDPTransport;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;

public class UDPTransportBase {
    protected RTPContext rtpContext = null;
    protected int timeToLive = 63;
    protected InetAddress multicastInterfaceAddress = null;
    protected String loggingContextStr = "";

    public void copyContext(IUDPTransport iUDPTransport) {
        this.rtpContext = ((UDPTransportBase)((Object)iUDPTransport)).rtpContext;
        this.timeToLive = ((UDPTransportBase)((Object)iUDPTransport)).timeToLive;
        this.multicastInterfaceAddress = ((UDPTransportBase)((Object)iUDPTransport)).multicastInterfaceAddress;
        this.loggingContextStr = ((UDPTransportBase)((Object)iUDPTransport)).loggingContextStr;
    }

    public RTPContext getRTPContext() {
        return this.rtpContext;
    }

    public void setRTPContext(RTPContext rTPContext) {
        this.rtpContext = rTPContext;
    }

    public void setTimeToLive(int n) {
        this.timeToLive = n;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    protected Executor getExecutor() {
        return this.rtpContext.getVHost().getTransportThreadPool().getExecutor();
    }

    protected Object getSocketLock() {
        Object object = null;
        if (this.rtpContext != null) {
            object = this.rtpContext.getLock();
        }
        return object;
    }

    protected boolean acquireSocketAddress(SocketAddress socketAddress) {
        boolean bl = true;
        if (this.rtpContext != null) {
            bl = this.rtpContext.acquireSocketAddress(socketAddress);
        }
        return bl;
    }

    protected boolean releaseSocketAddress(SocketAddress socketAddress) {
        boolean bl = true;
        if (this.rtpContext != null) {
            bl = this.rtpContext.releaseSocketAddress(socketAddress);
        }
        return bl;
    }

    public void setMulticastInterfaceAddress(InetAddress inetAddress) {
        this.multicastInterfaceAddress = inetAddress;
    }

    public String getLoggingContextStr() {
        return this.loggingContextStr;
    }

    public void setLoggingContextStr(String string) {
        this.loggingContextStr = string;
    }

    public InetAddress getMulticastInterfaceAddress() {
        return this.multicastInterfaceAddress;
    }
}

