/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtsp;

import com.wowza.util.DebugUtils;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTSPRequestMessage {
    public static final int METHOD_UNKNOWN = 0;
    public static final int METHOD_DESCRIBE = 1;
    public static final int METHOD_ANNOUNCE = 2;
    public static final int METHOD_GET_PARAMETER = 3;
    public static final int METHOD_OPTIONS = 4;
    public static final int METHOD_PAUSE = 5;
    public static final int METHOD_PLAY = 6;
    public static final int METHOD_RECORD = 7;
    public static final int METHOD_REDIRECT = 8;
    public static final int METHOD_SETUP = 9;
    public static final int METHOD_SET_PARAMETER = 10;
    public static final int METHOD_TEARDOWN = 11;
    public static final int METHOD_GET = 12;
    private Map<String, String> headerMap = new HashMap<String, String>();
    private String reqURI = "";
    private int method = 0;
    private int headerLength = 0;
    private int contentLength = 0;
    private String userAgent = "";
    private String contentType = "";
    private byte[] body = null;
    private int bodyOffset = 0;
    private int bodyLen = 0;
    private RtmpRequestMessage req = null;
    private boolean defer = false;
    private boolean lastDefer = false;

    public RTSPRequestMessage(RtmpRequestMessage rtmpRequestMessage, byte[] byArray, int n, int n2) {
        this.req = rtmpRequestMessage;
        this.body = byArray;
        this.bodyOffset = n;
        this.bodyLen = n2;
        this.parseRequest(byArray, n, n2);
    }

    public void parseRequest(byte[] byArray, int n, int n2) {
        this.parseHeader(byArray, n, n2);
    }

    public IVHost getVHost() {
        return this.req.getVHost();
    }

    public String getHeader(String string) {
        return this.headerMap.get(string);
    }

    public int methodNameToType(String string) {
        int n = 0;
        if (string.equals("DESCRIBE")) {
            n = 1;
        } else if (string.equals("ANNOUNCE")) {
            n = 2;
        } else if (string.equals("GET_PARAMETER")) {
            n = 3;
        } else if (string.equals("OPTIONS")) {
            n = 4;
        } else if (string.equals("PAUSE")) {
            n = 5;
        } else if (string.equals("PLAY")) {
            n = 6;
        } else if (string.equals("RECORD")) {
            n = 7;
        } else if (string.equals("REDIRECT")) {
            n = 8;
        } else if (string.equals("SETUP")) {
            n = 9;
        } else if (string.equals("SET_PARAMETER")) {
            n = 10;
        } else if (string.equals("TEARDOWN")) {
            n = 11;
        } else if (string.equals("GET")) {
            n = 12;
        }
        return n;
    }

    public static Map<String, String> fullParseHeader(byte[] byArray, int n, int n2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(RTSPRequestMessage.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        String string = null;
        String[] stringArray = null;
        try {
            string = new String(byArray, n, n2, "UTF-8");
            string = string.replace("\r\n", "\n").replace("\r", "\n");
            stringArray = string.split("\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPRequestMessage.class).error("RTSPRequestMessage.parseHeader: convert: " + exception.toString() + "\n" + DebugUtils.formatBytes(byArray));
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                if (stringArray[i].length() == 0) continue;
                if (i == 0) {
                    try {
                        stringArray2 = stringArray[i].split(" ");
                        hashMap.put("uri", stringArray[i]);
                        hashMap.put("method", stringArray2[0].toUpperCase());
                        hashMap.put("context", stringArray2.length > 1 ? stringArray2[1].substring(1) : "");
                        hashMap.put("protocol", stringArray2.length > 2 ? stringArray2[2] : "");
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(RTSPRequestMessage.class).error("RTSPRequestMessage.parseHeader: context (" + stringArray[i] + "): " + exception.toString());
                    }
                    continue;
                }
                try {
                    stringArray2 = stringArray[i].split(": ");
                    if (stringArray2.length != 2) {
                        stringArray2 = stringArray[i].split(":");
                    }
                    if (stringArray2.length != 2) continue;
                    hashMap.put(stringArray2[0].toLowerCase(), stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTSPRequestMessage.class).error("RTSPRequestMessage.parseHeader: token (" + stringArray[i] + "): " + exception.toString());
                }
            }
        }
        return hashMap;
    }

    public static int[] quickParseHeader(byte[] byArray, int n, int n2) {
        int[] nArray;
        block8: {
            nArray = null;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n2 - 3; ++i) {
                if (byArray[n + i] != 13 || byArray[n + i] != 13 || byArray[n + i + 1] != 10 || byArray[n + i + 2] != 13 || byArray[n + i + 3] != 10) continue;
                n3 = i + 4;
                break;
            }
            if (n3 <= 0) break block8;
            String string = null;
            String[] stringArray = null;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n, byArray2, 0, n3);
            try {
                string = new String(byArray2, "UTF-8");
                string = string.replace("\r\n", "\n").replace("\r", "\n");
                stringArray = string.split("\n");
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPRequestMessage.class).error("RTSPRequestMessage.quickParseHeader: convert: " + exception.toString() + "\n" + DebugUtils.formatBytes(byArray2));
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].length() == 0 || i <= 0) continue;
                    try {
                        String[] stringArray2 = stringArray[i].split(": ");
                        if (stringArray2.length != 2) {
                            stringArray2 = stringArray[i].split(":");
                        }
                        if (stringArray2.length != 2 || !stringArray2[0].equalsIgnoreCase("Content-Length")) continue;
                        n4 = Integer.parseInt(stringArray2[1]);
                        break;
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(RTSPRequestMessage.class).error("RTSPRequestMessage.quickParseHeader: token (" + stringArray[i] + "): " + exception.toString());
                    }
                }
            }
            nArray = new int[]{n3, n4};
        }
        return nArray;
    }

    private void parseHeader(byte[] byArray, int n, int n2) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(RTSPRequestMessage.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        this.headerLength = 0;
        this.contentLength = 0;
        for (int i = 0; i < n2 - 3; ++i) {
            if (byArray[n + i] != 13 || byArray[n + i] != 13 || byArray[n + i + 1] != 10 || byArray[n + i + 2] != 13 || byArray[n + i + 3] != 10) continue;
            this.headerLength = i + 4;
            break;
        }
        if (this.headerLength <= 0) {
            return;
        }
        String string = null;
        String[] stringArray = null;
        byte[] byArray2 = new byte[this.headerLength];
        System.arraycopy(byArray, n, byArray2, 0, this.headerLength);
        try {
            string = new String(byArray2, "UTF-8");
            stringArray = string.split("\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPRequestMessage.class).error("RTSPRequestMessage.parseHeader: convert: " + exception.toString() + "\n" + DebugUtils.formatBytes(byArray2));
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                if (stringArray[i].length() == 0) continue;
                if (i == 0) {
                    try {
                        stringArray2 = stringArray[i].split(" ");
                        if (stringArray2.length >= 3) {
                            String string2 = stringArray2[0].toUpperCase();
                            this.headerMap.put("uri", stringArray[i]);
                            this.headerMap.put("method", string2);
                            this.headerMap.put("context", stringArray2[1]);
                            this.headerMap.put("protocol", stringArray2[2]);
                            this.method = this.methodNameToType(string2);
                            if (wMSLogger != null) {
                                wMSLogger.debug("  uri: " + stringArray[i]);
                                wMSLogger.debug("  method: " + string2);
                                wMSLogger.debug("  context: " + stringArray2[1]);
                                wMSLogger.debug("  protocol: " + stringArray2[2]);
                            }
                            this.reqURI = stringArray2[1];
                            continue;
                        }
                        WMSLoggerFactory.getLogger(RTSPRequestMessage.class).error("RTSPRequestMessage.parseHeader: missing parameters: " + stringArray[i]);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(RTSPRequestMessage.class).error("RTSPRequestMessage.parseHeader: context (" + stringArray[i] + "): " + exception.toString());
                    }
                    continue;
                }
                try {
                    stringArray2 = stringArray[i].split(": ");
                    if (stringArray2.length != 2) {
                        stringArray2 = stringArray[i].split(":");
                    }
                    if (stringArray2.length != 2) continue;
                    this.headerMap.put(stringArray2[0].toLowerCase(), stringArray2[1]);
                    if (wMSLogger != null) {
                        wMSLogger.debug("  " + stringArray2[0].toLowerCase() + ": " + stringArray2[1]);
                    }
                    if (stringArray2[0].equalsIgnoreCase("Content-Length")) {
                        this.contentLength = Integer.parseInt(stringArray2[1]);
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("User-Agent")) {
                        this.userAgent = stringArray2[1];
                        continue;
                    }
                    if (!stringArray2[0].equalsIgnoreCase("Content-Type")) continue;
                    this.contentType = stringArray2[1];
                    continue;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTSPRequestMessage.class).error("RTSPRequestMessage.parseHeader: token (" + stringArray[i] + "): " + exception.toString());
                }
            }
        }
    }

    public int getContentLength() {
        int n = 0;
        String string = this.headerMap.get("content-length");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public String getMethodString() {
        String string = this.headerMap.get("method");
        return string == null ? "unknown" : string;
    }

    public int getCSeq() {
        int n = 0;
        String string = this.headerMap.get("cseq");
        if (string != null) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    public int getMethod() {
        return this.method;
    }

    public String getTrackId() {
        String[] stringArray;
        String string = null;
        String string2 = this.headerMap.get("context");
        if (string2 != null && (stringArray = string2.split("/")).length > 0) {
            string = stringArray[stringArray.length - 1];
        }
        return string;
    }

    public String getBodyAsString() {
        String string = "";
        int n = this.getContentLength();
        if (n > 0) {
            try {
                byte[] byArray = new byte[n];
                int n2 = this.headerLength;
                System.arraycopy(this.body, this.bodyOffset + n2, byArray, 0, n);
                string = new String(byArray, "UTF-8");
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPRequestMessage.class).error("RTSPRequestMessage: getBodyAsString: convert: " + exception.toString());
            }
        }
        return string;
    }

    public String getSessionId() {
        String string = null;
        RtmpSessionInfo rtmpSessionInfo = this.req.getSessionInfo();
        if (rtmpSessionInfo != null) {
            string = rtmpSessionInfo.getRTSPSessionId();
        }
        return string;
    }

    public void setSessionId(String string) {
        RtmpSessionInfo rtmpSessionInfo = this.req.getSessionInfo();
        if (rtmpSessionInfo != null) {
            rtmpSessionInfo.setRTSPSessionId(string);
        }
    }

    public RtmpSessionInfo getWMSSessionInfo() {
        return this.req.getSessionInfo();
    }

    public String getIp() {
        return this.req.getSessionInfo().getIpAddress();
    }

    public HostPort getHostPort() {
        return this.req.getHostPort();
    }

    public String toString() {
        String[] stringArray = new String[]{"uri", "method", "context", "protocol"};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.headerMap.get("uri") + "\n");
        for (String string : this.headerMap.keySet()) {
            if (arrayList.contains(string)) continue;
            stringBuffer.append(string + ": " + this.headerMap.get(string) + "\n");
        }
        int n = this.getContentLength();
        if (n > 0) {
            stringBuffer.append("---- body start ----\n" + this.getBodyAsString() + "\n---- body end ----\n");
        }
        return stringBuffer.toString();
    }

    public boolean isLastDefer() {
        return this.lastDefer;
    }

    public void setLastDefer(boolean bl) {
        this.lastDefer = bl;
    }

    public boolean isDefer() {
        return this.defer;
    }

    public void setDefer(boolean bl) {
        this.defer = bl;
    }
}

