/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.server;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.VHostWatchdog;

public class ServerWatchdog
extends Thread {
    private int checkFreq = 500;
    private boolean isRunning = true;
    private IServer server = null;
    private boolean debuglog = false;

    public ServerWatchdog(IServer iServer, int n) {
        super("serverWatchdog");
        this.server = iServer;
        this.checkFreq = n;
    }

    public synchronized void halt() {
        if (this.debuglog) {
            WMSLoggerFactory.getLogger(VHostWatchdog.class).info("ServerWatchdog: halt");
        }
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.debuglog) {
            WMSLoggerFactory.getLogger(VHostWatchdog.class).info("ServerWatchdog: start");
        }
        block4: while (true) {
            try {
                while (true) {
                    if (this.debuglog) {
                        WMSLoggerFactory.getLogger(VHostWatchdog.class).info("ServerWatchdog: run: " + this.server);
                    }
                    if (this.server != null) {
                        ((Server)this.server).doWatchdog();
                    }
                    if (this.debuglog) {
                        WMSLoggerFactory.getLogger(VHostWatchdog.class).info("ServerWatchdog: beforeWait: " + this.checkFreq);
                    }
                    Thread.currentThread();
                    Thread.sleep(this.checkFreq);
                    if (this.debuglog) {
                        WMSLoggerFactory.getLogger(VHostWatchdog.class).info("ServerWatchdog: afterWait: " + this.isRunning);
                    }
                    ServerWatchdog serverWatchdog = this;
                    synchronized (serverWatchdog) {
                        if (!this.isRunning) {
                            break block4;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                if (!this.debuglog) continue;
                WMSLoggerFactory.getLogger(VHostWatchdog.class).error("ServerWatchdog: exception: " + interruptedException.toString());
                continue;
            }
            break;
        }
        if (this.debuglog) {
            WMSLoggerFactory.getLogger(VHostWatchdog.class).info("ServerWatchdog: stop");
        }
    }
}

