/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream;

import com.wowza.io.IRandomAccessReader;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaIndexItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MediaIndexCacheSingleton {
    public static final long TIMEOUT = 14400000L;
    private static MediaIndexCacheSingleton instance = null;
    private Map indexMap = new HashMap();
    private Map pendingMap = new HashMap();

    public static MediaIndexCacheSingleton getInstance() {
        if (instance == null) {
            instance = new MediaIndexCacheSingleton();
        }
        return instance;
    }

    public static String toCacheId(String string, IRandomAccessReader iRandomAccessReader) {
        return string + "|" + (iRandomAccessReader == null ? "**missing**" : iRandomAccessReader.getPath());
    }

    public static String toChecksum(IRandomAccessReader iRandomAccessReader) {
        return iRandomAccessReader == null ? "**missing**" : (iRandomAccessReader.exists() ? iRandomAccessReader.length() + "|" + iRandomAccessReader.lastModified() : "**missing**");
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map map = this.indexMap;
        synchronized (map) {
            this.indexMap.clear();
        }
        this.indexMap = null;
        map = this.pendingMap;
        synchronized (map) {
            this.pendingMap.clear();
        }
        this.pendingMap = null;
    }

    public void doWatchdog() {
        this.removeOld();
        this.resolvePending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debug() {
        ArrayList arrayList = new ArrayList();
        Map map = this.indexMap;
        synchronized (map) {
            arrayList.addAll(this.indexMap.keySet());
        }
        long l = System.currentTimeMillis();
        for (String string : arrayList) {
            Map map2 = this.indexMap;
            synchronized (map2) {
                IMediaIndexItem iMediaIndexItem = (IMediaIndexItem)this.indexMap.get(string);
                this.debugItem("debug: ", string, iMediaIndexItem);
            }
        }
    }

    private void debugItem(String string, String string2, IMediaIndexItem iMediaIndexItem) {
        long l = System.currentTimeMillis();
        long l2 = l - iMediaIndexItem.getLastAccessed();
        String string3 = string;
        string3 = string3 + "cacheId:" + string2 + "{";
        string3 = string3 + "time=" + l2;
        string3 = string3 + " checksum=" + iMediaIndexItem.getChecksum();
        string3 = string3 + " extent=" + iMediaIndexItem.getExtent();
        string3 = string3 + " isHitEnd=" + iMediaIndexItem.isHitEnd();
        string3 = string3 + "}";
        WMSLoggerFactory.getLogger(MediaIndexCacheSingleton.class).debug(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOld() {
        ArrayList arrayList = new ArrayList();
        Map map = this.indexMap;
        synchronized (map) {
            arrayList.addAll(this.indexMap.keySet());
        }
        long l = System.currentTimeMillis();
        for (String string : arrayList) {
            Map map2 = this.indexMap;
            synchronized (map2) {
                IMediaIndexItem iMediaIndexItem = (IMediaIndexItem)this.indexMap.get(string);
                if (l - iMediaIndexItem.getLastAccessed() > 14400000L) {
                    this.indexMap.remove(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolvePending() {
        HashMap hashMap = null;
        Map map = this.pendingMap;
        synchronized (map) {
            hashMap = new HashMap(this.pendingMap);
            this.pendingMap.clear();
        }
        for (String string : hashMap.keySet()) {
            IMediaIndexItem iMediaIndexItem = (IMediaIndexItem)hashMap.get(string);
            IMediaIndexItem iMediaIndexItem2 = null;
            IMediaIndexItem iMediaIndexItem3 = null;
            Object object = this.indexMap;
            synchronized (object) {
                iMediaIndexItem2 = (IMediaIndexItem)this.indexMap.get(string);
            }
            object = iMediaIndexItem;
            synchronized (object) {
                if (iMediaIndexItem2 != null) {
                    if (!iMediaIndexItem.getChecksum().equals(iMediaIndexItem2.getChecksum())) {
                        iMediaIndexItem2 = null;
                    } else if (iMediaIndexItem.getExtent() > iMediaIndexItem2.getExtent()) {
                        iMediaIndexItem2 = null;
                    }
                }
                if (iMediaIndexItem2 == null) {
                    iMediaIndexItem3 = iMediaIndexItem.clone();
                }
            }
            if (iMediaIndexItem3 == null) continue;
            object = iMediaIndexItem3;
            synchronized (object) {
                iMediaIndexItem3.setLastAccessed(System.currentTimeMillis());
            }
            object = this.indexMap;
            synchronized (object) {
                this.indexMap.put(string, iMediaIndexItem3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(String string, IRandomAccessReader iRandomAccessReader, IMediaIndexItem iMediaIndexItem) {
        Object object = iMediaIndexItem;
        synchronized (object) {
            iMediaIndexItem.setChecksum(iRandomAccessReader);
        }
        object = this.pendingMap;
        synchronized (object) {
            this.pendingMap.put(MediaIndexCacheSingleton.toCacheId(string, iRandomAccessReader), iMediaIndexItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaIndexItem get(String string, IRandomAccessReader iRandomAccessReader) {
        IMediaIndexItem iMediaIndexItem = null;
        Object object = this.indexMap;
        synchronized (object) {
            iMediaIndexItem = (IMediaIndexItem)this.indexMap.get(MediaIndexCacheSingleton.toCacheId(string, iRandomAccessReader));
            if (iMediaIndexItem != null) {
                String string2 = MediaIndexCacheSingleton.toChecksum(iRandomAccessReader);
                if (!iMediaIndexItem.getChecksum().equals(string2) || string2.equals("**missing**")) {
                    iMediaIndexItem = null;
                }
            }
        }
        if (iMediaIndexItem != null) {
            object = iMediaIndexItem;
            synchronized (object) {
                iMediaIndexItem.setLastAccessed(System.currentTimeMillis());
            }
            this.debugItem("MediaIndexCacheSingleton.get(" + MediaIndexCacheSingleton.toCacheId(string, iRandomAccessReader) + "): ", MediaIndexCacheSingleton.toCacheId(string, iRandomAccessReader), iMediaIndexItem);
        } else {
            WMSLoggerFactory.getLogger(MediaIndexCacheSingleton.class).debug("MediaIndexCacheSingleton.get(" + MediaIndexCacheSingleton.toCacheId(string, iRandomAccessReader) + "): null");
        }
        return iMediaIndexItem;
    }
}

