/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;

public class MediaStreamFactory {
    public static IMediaStream createStream(String string, MediaStreamMap mediaStreamMap, int n) {
        IMediaStream iMediaStream;
        block8: {
            iMediaStream = null;
            IApplicationInstance iApplicationInstance = mediaStreamMap.getAppInstance();
            StreamList streamList = iApplicationInstance.getVHost().getStreamTypes();
            StreamItem streamItem = streamList.getStreamDef(string);
            if (streamItem != null) {
                try {
                    Class<?> clazz = Class.forName(streamItem.getBaseClass());
                    if (clazz == null) {
                        WMSLoggerFactory.getLogger(MediaStream.class).error("createStream: missing WMSStream class: " + streamItem.getBaseClass());
                        break block8;
                    }
                    iMediaStream = (IMediaStream)clazz.newInstance();
                    if (iMediaStream == null) {
                        WMSLoggerFactory.getLogger(MediaStream.class).error("createStream: error creating WMSStream instance: " + streamItem.getBaseClass());
                        break block8;
                    }
                    iMediaStream.setStreamType(string);
                    iMediaStream.setLiveStreamPacketizerList(iApplicationInstance.getLiveStreamPacketizerList());
                    iMediaStream.init(mediaStreamMap, n, streamItem.getProperties());
                    String string2 = streamItem.getPlayClass();
                    if (string2 == null || string2.length() == 0) break block8;
                    Class<?> clazz2 = Class.forName(string2);
                    if (clazz2 == null) {
                        WMSLoggerFactory.getLogger(MediaStream.class).error("createStream: missing WMSStreamPlay class: " + string2);
                        break block8;
                    }
                    IMediaStreamPlay iMediaStreamPlay = (IMediaStreamPlay)clazz2.newInstance();
                    if (iMediaStreamPlay == null) {
                        WMSLoggerFactory.getLogger(MediaStream.class).error("createStream: error creating WMSStreamPlay instance: " + string2);
                        break block8;
                    }
                    iMediaStreamPlay.init(iMediaStream, mediaStreamMap);
                    iMediaStream.setPlayer(iMediaStreamPlay);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(MediaStream.class).error("createStream: (" + string + "): " + exception.toString());
                    exception.printStackTrace();
                }
            } else {
                WMSLoggerFactory.getLogger(MediaStream.class).error("stream type not found: " + string);
            }
        }
        return iMediaStream;
    }
}

