/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transport.udp;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.transport.udp.IUDPTransportIncoming;
import com.wowza.wms.transport.udp.IUDPTransportIncomingConnection;
import com.wowza.wms.transport.udp.MulticastIncomingConnection;
import com.wowza.wms.transport.udp.MulticastListener;
import com.wowza.wms.transport.udp.UnicastOutgoing;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class MulticastIncoming
implements IUDPTransportIncoming {
    private IVHost vhost = null;
    private int processorCount = -1;
    private List<MulticastIncomingConnection> connections = new ArrayList<MulticastIncomingConnection>();
    private Object lock = new Object();
    private Executor executor = null;
    private long connectionCount = 0L;

    public void init(int n, IVHost iVHost) {
        this.vhost = iVHost;
        this.executor = this.vhost.getTransportThreadPool().getExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUDPTransportIncomingConnection bind(RTPUDPDatagramConfig rTPUDPDatagramConfig, IUDPMessageHandler iUDPMessageHandler, String string, int n) {
        MulticastIncomingConnection multicastIncomingConnection = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                MulticastListener multicastListener = new MulticastListener();
                multicastListener.bind(rTPUDPDatagramConfig, this.executor, iUDPMessageHandler, string, n);
                multicastIncomingConnection = new MulticastIncomingConnection(this, multicastListener);
                this.connections.add(multicastIncomingConnection);
                ++this.connectionCount;
                multicastListener.setDaemon(true);
                multicastListener.setPriority(10);
                multicastListener.start();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(UnicastOutgoing.class).error("UnicastOutgoing.bind: " + exception.toString());
            exception.printStackTrace();
        }
        return multicastIncomingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(IUDPTransportIncomingConnection iUDPTransportIncomingConnection) {
        block9: {
            MulticastIncomingConnection multicastIncomingConnection = null;
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (iUDPTransportIncomingConnection instanceof MulticastIncomingConnection && this.connections.contains(iUDPTransportIncomingConnection)) {
                        multicastIncomingConnection = (MulticastIncomingConnection)iUDPTransportIncomingConnection;
                        --this.connectionCount;
                        this.connections.remove(multicastIncomingConnection);
                    }
                }
                if (multicastIncomingConnection == null) break block9;
                object = multicastIncomingConnection;
                synchronized (object) {
                    multicastIncomingConnection.isOpen = false;
                    multicastIncomingConnection.listener.unbind();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(UnicastOutgoing.class).error("UnicastOutgoing.unbind: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionCount;
        }
    }
}

