/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transport.udp;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.IUDPTransportSession;
import com.wowza.wms.rtp.transport.RTPMulticastTransport;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import com.wowza.wms.rtp.transport.UDPRunner;
import com.wowza.wms.rtp.transport.UDPTransportShared;
import com.wowza.wms.server.IServer;
import com.wowza.wms.transport.udp.UDPPortManager;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public class UDPPortSharingManager {
    private UDPPortManager udpPortManager = null;
    private Map<InetSocketAddress, SharedPort> sharedPorts = new HashMap<InetSocketAddress, SharedPort>();
    private Object plock = new Object();

    public void init(IServer iServer) {
        this.udpPortManager = iServer.getUDPPortManager();
    }

    public void shutdown() {
    }

    public boolean isPortAutoAssigned(int n) {
        return this.udpPortManager.isPortAutoAssigned(n);
    }

    public IUDPTransport getTransport(boolean bl) {
        UDPTransportShared uDPTransportShared = new UDPTransportShared();
        uDPTransportShared.init(this, bl);
        return uDPTransportShared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(UDPTransportShared uDPTransportShared, InetSocketAddress inetSocketAddress, IUDPMessageHandler iUDPMessageHandler, Executor executor, RTPUDPDatagramConfig rTPUDPDatagramConfig) {
        SharedPort sharedPort = null;
        Object object = this.plock;
        synchronized (object) {
            sharedPort = this.sharedPorts.get(inetSocketAddress);
            if (sharedPort == null) {
                sharedPort = new SharedPort();
                try {
                    if (uDPTransportShared.isMulticast()) {
                        sharedPort.udpTransport = new RTPMulticastTransport();
                    } else {
                        sharedPort.udpTransport = new RTPUDPTransportMina();
                    }
                    sharedPort.udpTransport.copyContext(uDPTransportShared);
                    sharedPort.udpTransport.bind(rTPUDPDatagramConfig, sharedPort, inetSocketAddress.getHostName(), inetSocketAddress.getPort(), null, -1, 1);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(UDPPortSharingManager.class).error("UDPPortSharingManager.bind[" + uDPTransportShared.getLoggingContextStr() + ":" + (sharedPort != null) + "]: " + inetSocketAddress.toString() + ": " + exception.toString());
                }
                this.sharedPorts.put(inetSocketAddress, sharedPort);
            }
            sharedPort.addHandler(uDPTransportShared, iUDPMessageHandler, executor);
        }
        iUDPMessageHandler.sessionOpened(sharedPort);
        WMSLoggerFactory.getLogger(UDPPortSharingManager.class).info("UDPPortSharingManager.bind[" + uDPTransportShared.getLoggingContextStr() + ":" + (sharedPort != null) + "]: " + inetSocketAddress.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(UDPTransportShared uDPTransportShared, InetSocketAddress inetSocketAddress) {
        SharedPort sharedPort = null;
        SharedHandler sharedHandler = null;
        Object object = this.plock;
        synchronized (object) {
            sharedPort = this.sharedPorts.get(inetSocketAddress);
            if (sharedPort != null) {
                sharedHandler = sharedPort.removeHandler(uDPTransportShared);
                if (sharedPort.isEmpty()) {
                    this.sharedPorts.remove(inetSocketAddress);
                    try {
                        sharedPort.udpTransport.unbind(inetSocketAddress);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(UDPPortSharingManager.class).error("UDPPortSharingManager.unbind[" + uDPTransportShared.getLoggingContextStr() + ":" + (sharedPort != null) + "]: " + inetSocketAddress.toString() + ": " + exception.toString());
                    }
                }
            }
        }
        if (sharedHandler != null) {
            sharedHandler.handler.sessionClosed(sharedPort);
        }
        WMSLoggerFactory.getLogger(UDPPortSharingManager.class).info("UDPPortSharingManager.unbind[" + uDPTransportShared.getLoggingContextStr() + ":" + (sharedPort != null) + "]: " + inetSocketAddress.toString());
    }

    class SharedHandler {
        UDPTransportShared udpPortShared = null;
        IUDPMessageHandler handler = null;
        UDPRunner runner = new UDPRunner();

        public SharedHandler(UDPTransportShared uDPTransportShared, IUDPMessageHandler iUDPMessageHandler, Executor executor) {
            this.udpPortShared = uDPTransportShared;
            this.handler = iUDPMessageHandler;
            this.runner.setExecutor(executor);
        }
    }

    class SharedPort
    implements IUDPMessageHandler,
    IUDPTransportSession {
        private IUDPTransport udpTransport = null;
        private Map<UDPTransportShared, SharedHandler> handlers = new HashMap<UDPTransportShared, SharedHandler>();
        private AtomicReference<SharedHandler[]> handlerArr = new AtomicReference<SharedHandler[]>(new SharedHandler[0]);
        private Object slock = new Object();

        SharedPort() {
        }

        public void handleMessage(SocketAddress socketAddress, Object object) {
            SharedHandler[] sharedHandlerArray = this.handlerArr.get();
            if (sharedHandlerArray != null) {
                for (int i = 0; i < sharedHandlerArray.length; ++i) {
                    sharedHandlerArray[i].runner.handleMessage(socketAddress, sharedHandlerArray[i].handler, object);
                }
            }
        }

        private void updateHandlerArr() {
            SharedHandler[] sharedHandlerArray = this.handlers.values().toArray(new SharedHandler[0]);
            this.handlerArr.set(sharedHandlerArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addHandler(UDPTransportShared uDPTransportShared, IUDPMessageHandler iUDPMessageHandler, Executor executor) {
            Object object = this.slock;
            synchronized (object) {
                this.handlers.put(uDPTransportShared, new SharedHandler(uDPTransportShared, iUDPMessageHandler, executor));
                this.updateHandlerArr();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.slock;
            synchronized (object) {
                return this.handlers.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedHandler removeHandler(UDPTransportShared uDPTransportShared) {
            SharedHandler sharedHandler = null;
            Object object = this.slock;
            synchronized (object) {
                sharedHandler = this.handlers.remove(uDPTransportShared);
                this.updateHandlerArr();
            }
            return sharedHandler;
        }

        public void sessionOpened(IUDPTransportSession iUDPTransportSession) {
        }

        public void sessionClosed(IUDPTransportSession iUDPTransportSession) {
        }

        public void write(byte[] byArray, int n, int n2, SocketAddress socketAddress) {
        }
    }
}

