/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transport.udp;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPHandler;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import com.wowza.wms.transport.udp.IUDPTransportIncoming;
import com.wowza.wms.transport.udp.IUDPTransportIncomingConnection;
import com.wowza.wms.transport.udp.UnicastIncomingConnection;
import com.wowza.wms.transport.udp.UnicastOutgoing;
import com.wowza.wms.vhost.IVHost;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.filter.executor.ExecutorExecutor;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;

public class UnicastIncoming
implements IUDPTransportIncoming {
    public static int MINCONNECTIONS = 20;
    private IVHost vhost = null;
    private int processorCount = -1;
    private ConnectorHolder[] connectors = null;
    private List<UnicastIncomingConnection> connections = new ArrayList<UnicastIncomingConnection>();
    private Object lock = new Object();
    private Executor executor = null;
    private long connectionCount = 0L;

    public void init(int n, IVHost iVHost) {
        this.processorCount = n;
        this.connectors = new ConnectorHolder[n];
        this.vhost = iVHost;
        this.executor = this.vhost.getTransportThreadPool().getExecutor();
    }

    private int getNextConnector() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.connectors.length; ++i) {
            if (this.connectors[i] == null) {
                this.connectors[i] = new ConnectorHolder(new DatagramAcceptor(this.executor));
                n = i;
                break;
            }
            if (this.connectors[i].count < MINCONNECTIONS) {
                n = i;
                break;
            }
            if (this.connectors[i].count >= n2) continue;
            n2 = this.connectors[i].count;
            n = i;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUDPTransportIncomingConnection bind(RTPUDPDatagramConfig rTPUDPDatagramConfig, IUDPMessageHandler iUDPMessageHandler, String string, int n) {
        UnicastIncomingConnection unicastIncomingConnection = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                Object object2;
                int n2 = this.getNextConnector();
                ConnectorHolder connectorHolder = this.connectors[n2];
                InetSocketAddress inetSocketAddress = string == null ? new InetSocketAddress(n) : new InetSocketAddress(string, n);
                DatagramAcceptorConfig datagramAcceptorConfig = new DatagramAcceptorConfig();
                datagramAcceptorConfig.setThreadModel(ThreadModel.MANUAL);
                datagramAcceptorConfig.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)new ExecutorExecutor(this.executor)));
                IoSessionConfig ioSessionConfig = datagramAcceptorConfig.getSessionConfig();
                if (rTPUDPDatagramConfig != null && ioSessionConfig instanceof DatagramSessionConfig) {
                    object2 = (DatagramSessionConfig)ioSessionConfig;
                    rTPUDPDatagramConfig.configureSessionConfig((DatagramSessionConfig)object2);
                }
                object2 = new RTPUDPHandler(iUDPMessageHandler, inetSocketAddress, null);
                boolean bl = false;
                String string2 = "Cause unknown";
                try {
                    connectorHolder.acceptor.bind((SocketAddress)inetSocketAddress, (IoHandler)object2, (IoServiceConfig)datagramAcceptorConfig);
                    bl = true;
                }
                catch (Exception exception) {
                    string2 = exception.toString();
                }
                if (!bl && inetSocketAddress.getAddress() != null) {
                    inetSocketAddress = new InetSocketAddress(inetSocketAddress.getPort());
                    object2 = new RTPUDPHandler(iUDPMessageHandler, inetSocketAddress, null);
                    try {
                        connectorHolder.acceptor.bind((SocketAddress)inetSocketAddress, (IoHandler)object2, (IoServiceConfig)datagramAcceptorConfig);
                        bl = true;
                    }
                    catch (Exception exception) {
                        string2 = exception.toString();
                    }
                }
                if (bl) {
                    WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("UnicastIncoming.bind: " + inetSocketAddress.toString());
                } else {
                    WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).warn("UnicastIncoming.bind: Failure to bind to address[" + inetSocketAddress.toString() + "]: " + string2);
                }
                unicastIncomingConnection = new UnicastIncomingConnection(this, connectorHolder.acceptor, n2, (RTPUDPHandler)((Object)object2));
                this.connections.add(unicastIncomingConnection);
                ++connectorHolder.count;
                ++this.connectionCount;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(UnicastOutgoing.class).error("UnicastOutgoing.bind: " + exception.toString());
            exception.printStackTrace();
        }
        return unicastIncomingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(IUDPTransportIncomingConnection iUDPTransportIncomingConnection) {
        block9: {
            UnicastIncomingConnection unicastIncomingConnection = null;
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (iUDPTransportIncomingConnection instanceof UnicastIncomingConnection && this.connections.contains(iUDPTransportIncomingConnection)) {
                        unicastIncomingConnection = (UnicastIncomingConnection)iUDPTransportIncomingConnection;
                        int n = unicastIncomingConnection.connectorIndex;
                        ConnectorHolder connectorHolder = this.connectors[n];
                        --connectorHolder.count;
                        --this.connectionCount;
                        this.connections.remove(unicastIncomingConnection);
                    }
                }
                if (unicastIncomingConnection == null) break block9;
                object = unicastIncomingConnection;
                synchronized (object) {
                    unicastIncomingConnection.handlerAdapter.unbind();
                    unicastIncomingConnection.acceptor.unbind((SocketAddress)unicastIncomingConnection.getAddress());
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(UnicastOutgoing.class).error("UnicastOutgoing.unbind: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getConnectionCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionCount;
        }
    }

    class ConnectorHolder {
        public DatagramAcceptor acceptor = null;
        public int count = 0;

        public ConnectorHolder(DatagramAcceptor datagramAcceptor) {
            this.acceptor = datagramAcceptor;
        }
    }
}

