/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.model.HTTPStreamerItem;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.util.MediaCasterUtils;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTTPStreamerUtils {
    public static HTTPStreamerItem loadHTTStreamerItem(Element element) {
        HTTPStreamerItem hTTPStreamerItem;
        block13: {
            hTTPStreamerItem = null;
            try {
                Element element2 = element;
                Node node = XMLUtils.getNodeByTagName(element2, "Name");
                Node node2 = XMLUtils.getNodeByTagName(element2, "Description");
                Node node3 = XMLUtils.getNodeByTagName(element2, "BaseClass");
                Node node4 = XMLUtils.getNodeByTagName(element2, "ApplicationContextClass");
                Node node5 = XMLUtils.getNodeByTagName(element2, "IdleFrequency");
                Node node6 = XMLUtils.getNodeByTagName(element2, "RequestFilters");
                Node node7 = XMLUtils.getNodeByTagName(element2, "LiveStreamPacketizer");
                Node node8 = XMLUtils.getNodeByTagName(element2, "LiveStreamRepeater");
                XPathFactory xPathFactory = XMLUtils.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                String string = "Properties/Property";
                XPathExpression xPathExpression = xPath.compile(string);
                if (node != null && node3 != null) {
                    String string2 = XMLUtils.getNodeValue(node);
                    String string3 = XMLUtils.getNodeValue(node2);
                    String string4 = XMLUtils.getNodeValue(node3);
                    String string5 = XMLUtils.getNodeValue(node4);
                    String string6 = XMLUtils.getNodeValue(node6);
                    String string7 = XMLUtils.getNodeValue(node7);
                    String string8 = XMLUtils.getNodeValue(node8);
                    String string9 = XMLUtils.getNodeValue(node5);
                    hTTPStreamerItem = new HTTPStreamerItem(string2, string4);
                    if (string5 != null) {
                        hTTPStreamerItem.setApplicationContextClass(string5);
                    }
                    if (string3 != null) {
                        hTTPStreamerItem.setDescription(string3);
                    }
                    if (string6 != null) {
                        hTTPStreamerItem.setRequestFilter(string6);
                    }
                    if (string7 != null) {
                        hTTPStreamerItem.setLiveStreamPacketizer(string7);
                    }
                    if (string8 != null) {
                        hTTPStreamerItem.setLiveStreamRepeater(string8);
                    }
                    if (string9 != null) {
                        int n = -1;
                        try {
                            n = Integer.parseInt(string9);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n > 0) {
                            hTTPStreamerItem.setIdleFrequency(n);
                        }
                    }
                    WMSProperties wMSProperties = hTTPStreamerItem.getProperties();
                    NodeList nodeList = (NodeList)xPathExpression.evaluate(element2, XPathConstants.NODESET);
                    if (nodeList != null) {
                        XMLUtils.loadConfigProperies(nodeList, wMSProperties);
                    }
                    WMSLoggerFactory.getLogger(MediaCasterUtils.class).debug(hTTPStreamerItem.toString());
                    break block13;
                }
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("HTTPStreamerUtils.loadHTTStreamerItem: Error parsing server properties: Name, BaseClass and StreamType required.");
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaCasterUtils.class).error("HTTPStreamerUtils.loadHTTStreamerItem: Error parsing properties: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return hTTPStreamerItem;
    }

    public static void loadHTTPStreamerList(Element element, String string, IVHost iVHost) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    HTTPStreamerItem hTTPStreamerItem = HTTPStreamerUtils.loadHTTStreamerItem(element2);
                    iVHost.getHTTPStreamerList().getHTTPStreamerDefs().put(hTTPStreamerItem.getName(), hTTPStreamerItem);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("HTTPStreamerUtils.loadHTTPStreamerList: Error load HTTPStreamerList: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(IVHost iVHost, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                String string2 = "/Root/HTTPStreamers/HTTPStreamer";
                HTTPStreamerUtils.loadHTTPStreamerList(element, string2, iVHost);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPUtils.class).error("HTTPStreamerUtils.loadConfigFile: Error parsing HTTPStreamer config file (" + string + "): " + exception.toString());
            exception.printStackTrace();
        }
    }
}

