/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.SystemUtils;
import com.wowza.util.XMLUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.vhost.VHostItem;
import com.wowza.wms.vhost.VHostList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VHostListUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfigFile(VHostList vHostList, String string) {
        block13: {
            WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading VHosts.xml: " + string);
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(string);
                XPathFactory xPathFactory = XMLUtils.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                Map<String, VHostItem> map = vHostList.getVHostMap();
                if (document == null) break block13;
                Element element = document.getDocumentElement();
                String string2 = "/Root/VHosts/VHost";
                XPathExpression xPathExpression = xPath.compile(string2);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (nodeList == null) break block13;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    Node node2 = XMLUtils.getNodeByTagName(element2, "Name");
                    Node node3 = XMLUtils.getNodeByTagName(element2, "ConfigDir");
                    Node node4 = XMLUtils.getNodeByTagName(element2, "ConnectionLimit");
                    if (node2 != null && node3 != null) {
                        String string3 = XMLUtils.getNodeValue(node2);
                        String string4 = XMLUtils.getNodeValue(node3);
                        String string5 = null;
                        if (node4 != null) {
                            string5 = XMLUtils.getNodeValue(node4);
                        }
                        boolean bl = false;
                        VHostItem vHostItem = null;
                        Map<String, VHostItem> map2 = map;
                        synchronized (map2) {
                            vHostItem = map.get(string3);
                            if (vHostItem == null) {
                                bl = true;
                                vHostItem = new VHostItem();
                                map.put(string3, vHostItem);
                            }
                        }
                        if (vHostItem != null) {
                            vHostItem.reset();
                            vHostItem.setVisited(true);
                            vHostItem.setName(string3);
                            if (string5 != null) {
                                vHostItem.setConnectionLimit(Integer.parseInt(string5));
                            }
                            vHostItem.setConfigDir(SystemUtils.expandEnvironmentVariables(string4));
                            if (bl) {
                                vHostList.notifyVHostItemCreate(vHostItem);
                            } else {
                                vHostList.notifyVHostItemUpdate(vHostItem);
                            }
                        }
                        WMSLoggerFactory.getLogger(StreamUtils.class).debug(vHostItem.toString());
                        continue;
                    }
                    WMSLoggerFactory.getLogger(VHostListUtils.class).error("loadConfigFile: error parsing vhosts config file: (" + string + ") : error <Name> and <ConfigDir> required.");
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(VHostListUtils.class).error("loadConfigFile: error parsing vhosts config file: (" + string + ") error: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }
}

